/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.math.AbsNodeGen;
import com.oracle.truffle.js.builtins.math.AcosNodeGen;
import com.oracle.truffle.js.builtins.math.AcoshNodeGen;
import com.oracle.truffle.js.builtins.math.AsinNodeGen;
import com.oracle.truffle.js.builtins.math.AsinhNodeGen;
import com.oracle.truffle.js.builtins.math.Atan2NodeGen;
import com.oracle.truffle.js.builtins.math.AtanNodeGen;
import com.oracle.truffle.js.builtins.math.AtanhNodeGen;
import com.oracle.truffle.js.builtins.math.CbrtNodeGen;
import com.oracle.truffle.js.builtins.math.CeilNodeGen;
import com.oracle.truffle.js.builtins.math.Clz32NodeGen;
import com.oracle.truffle.js.builtins.math.CosNodeGen;
import com.oracle.truffle.js.builtins.math.CoshNodeGen;
import com.oracle.truffle.js.builtins.math.ExpNodeGen;
import com.oracle.truffle.js.builtins.math.Expm1NodeGen;
import com.oracle.truffle.js.builtins.math.F16roundNodeGen;
import com.oracle.truffle.js.builtins.math.FloorNodeGen;
import com.oracle.truffle.js.builtins.math.FroundNodeGen;
import com.oracle.truffle.js.builtins.math.HypotNodeGen;
import com.oracle.truffle.js.builtins.math.ImulNode;
import com.oracle.truffle.js.builtins.math.Log10NodeGen;
import com.oracle.truffle.js.builtins.math.Log1pNodeGen;
import com.oracle.truffle.js.builtins.math.Log2NodeGen;
import com.oracle.truffle.js.builtins.math.LogNodeGen;
import com.oracle.truffle.js.builtins.math.MaxNodeGen;
import com.oracle.truffle.js.builtins.math.MinNodeGen;
import com.oracle.truffle.js.builtins.math.PowNodeGen;
import com.oracle.truffle.js.builtins.math.RandomNodeGen;
import com.oracle.truffle.js.builtins.math.RoundNode;
import com.oracle.truffle.js.builtins.math.SignNodeGen;
import com.oracle.truffle.js.builtins.math.SinNodeGen;
import com.oracle.truffle.js.builtins.math.SinhNodeGen;
import com.oracle.truffle.js.builtins.math.SqrtNodeGen;
import com.oracle.truffle.js.builtins.math.TanNodeGen;
import com.oracle.truffle.js.builtins.math.TanhNodeGen;
import com.oracle.truffle.js.builtins.math.TruncNodeGen;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSMath;
import java.util.EnumSet;

public class MathBuiltins
extends JSBuiltinsContainer.SwitchEnum<Math> {
    public static final JSBuiltinsContainer BUILTINS = new MathBuiltins();

    protected MathBuiltins() {
        super(JSMath.CLASS_NAME, Math.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, Math builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return AbsNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return AcosNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return AsinNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return Atan2NodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 4: {
                return AtanNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 5: {
                return CeilNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 6: {
                return CosNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 7: {
                return ExpNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 8: {
                return FloorNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 9: {
                return LogNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 10: {
                return MaxNodeGen.create(context, builtin, MathBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case 11: {
                return MinNodeGen.create(context, builtin, MathBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case 12: {
                return PowNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 13: {
                return RandomNodeGen.create(context, builtin, MathBuiltins.args().createArgumentNodes(context));
            }
            case 14: {
                return RoundNode.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 15: {
                return SinNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 16: {
                return SqrtNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 17: {
                return TanNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 18: {
                return ImulNode.create(context, builtin, MathBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 19: {
                return SignNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 20: {
                return TruncNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 21: {
                return CbrtNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 22: {
                return Expm1NodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 23: {
                return HypotNodeGen.create(context, builtin, MathBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case 24: {
                return Log2NodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 25: {
                return Log10NodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 26: {
                return Log1pNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 27: {
                return Clz32NodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 28: {
                return CoshNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 29: {
                return SinhNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 30: {
                return TanhNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 31: {
                return AcoshNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 32: {
                return AsinhNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 33: {
                return AtanhNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 34: {
                return FroundNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 35: {
                return F16roundNodeGen.create(context, builtin, MathBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum Math implements BuiltinEnum<Math>
    {
        abs(1),
        acos(1),
        asin(1),
        atan2(2),
        atan(1),
        ceil(1),
        cos(1),
        exp(1),
        floor(1),
        log(1),
        max(2),
        min(2),
        pow(2),
        random(0),
        round(1),
        sin(1),
        sqrt(1),
        tan(1),
        imul(2),
        sign(1),
        trunc(1),
        cbrt(1),
        expm1(1),
        hypot(2),
        log2(1),
        log10(1),
        log1p(1),
        clz32(1),
        cosh(1),
        sinh(1),
        tanh(1),
        acosh(1),
        asinh(1),
        atanh(1),
        fround(1),
        f16round(1);

        private final int length;

        private Math(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.range(imul, fround).contains(this)) {
                return 6;
            }
            if (f16round == this) {
                return 16;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }
}

