// CheckStyle: start generated
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSComplementNode#doInteger}
 *     Activation probability: 0.27381
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSComplementNode#doSafeInteger}
 *     Activation probability: 0.23095
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSComplementNode#doDouble}
 *     Activation probability: 0.18810
 *     With/without class size: 7/4 bytes
 *   Specialization {@link JSComplementNode#doBigInt}
 *     Activation probability: 0.14524
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSComplementNode#doOverloaded}
 *     Activation probability: 0.10238
 *     With/without class size: 6/4 bytes
 *   Specialization {@link JSComplementNode#doGeneric}
 *     Activation probability: 0.05952
 *     With/without class size: 5/8 bytes
 * </pre> */
@GeneratedBy(JSComplementNode.class)
@SuppressWarnings("javadoc")
public final class JSComplementNodeGen extends JSComplementNode {

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSComplementNode#doInteger}
     *   1: SpecializationActive {@link JSComplementNode#doGeneric}
     *   2: SpecializationActive {@link JSComplementNode#doSafeInteger}
     *   3: SpecializationActive {@link JSComplementNode#doDouble}
     *   4: SpecializationActive {@link JSComplementNode#doBigInt}
     *   5: SpecializationActive {@link JSComplementNode#doOverloaded}
     *   6-8: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSComplementNode#doDouble}
     *   Parameter: {@link JSToInt32Node} toInt32Node</pre> */
    @Child private JSToInt32Node double_toInt32Node_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSComplementNode#doOverloaded}
     *   Parameter: {@link JSOverloadedUnaryNode} overloadedOperatorNode</pre> */
    @Child private JSOverloadedUnaryNode overloaded_overloadedOperatorNode_;
    @Child private GenericData generic_cache;

    private JSComplementNodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    public Object execute(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111) != 0 /* is SpecializationActive[JSComplementNode.doInteger(int)] || SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] || SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] || SpecializationActive[JSComplementNode.doBigInt(BigInt)] || SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] || SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSComplementNode.doInteger(int)] */ && operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (int) operandNodeValue;
                return doInteger(operandNodeValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] */ && operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_ = (SafeInteger) operandNodeValue;
                return doSafeInteger(operandNodeValue_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue)) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue);
                {
                    JSToInt32Node toInt32Node__ = this.double_toInt32Node_;
                    if (toInt32Node__ != null) {
                        return doDouble(operandNodeValue_, toInt32Node__);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSComplementNode.doBigInt(BigInt)] */ && operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt) operandNodeValue;
                return doBigInt(operandNodeValue_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */ && operandNodeValue instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject) operandNodeValue;
                {
                    JSOverloadedUnaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                    if (overloadedOperatorNode__ != null) {
                        return doOverloaded(operandNodeValue_, overloadedOperatorNode__);
                    }
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */) {
                GenericData s5_ = this.generic_cache;
                if (s5_ != null) {
                    if ((!(hasOverloadedOperators(operandNodeValue)))) {
                        return doGeneric(operandNodeValue, s5_.toNumericNode_, s5_.recursive_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111110) == 0 /* only-active SpecializationActive[JSComplementNode.doInteger(int)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSComplementNode.doBigInt(BigInt)] && SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */)) {
            return execute_int0(state_0, frameValue);
        } else if ((state_0 & 0b110111) == 0 /* only-active SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSComplementNode.doBigInt(BigInt)] && SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */)) {
            return execute_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSComplementNode.doInteger(int)] */;
        return doInteger(operandNodeValue_);
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSComplementNode.doBigInt(BigInt)] && SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSComplementNode.doBigInt(BigInt)] && SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */;
        {
            JSToInt32Node toInt32Node__ = this.double_toInt32Node_;
            if (toInt32Node__ != null) {
                return doDouble(operandNodeValue_, toInt32Node__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSComplementNode.doBigInt(BigInt)] && SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */) ? (Object) operandNodeValue_int : (Object) operandNodeValue_));
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b111111) != 0 /* is SpecializationActive[JSComplementNode.doInteger(int)] || SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] || SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] || SpecializationActive[JSComplementNode.doBigInt(BigInt)] || SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] || SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSComplementNode.doInteger(int)] */ && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (int) operandNodeValue_;
                return doInteger(operandNodeValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] */ && operandNodeValue_ instanceof SafeInteger) {
                SafeInteger operandNodeValue__ = (SafeInteger) operandNodeValue_;
                return doSafeInteger(operandNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                {
                    JSToInt32Node toInt32Node__ = this.double_toInt32Node_;
                    if (toInt32Node__ != null) {
                        return doDouble(operandNodeValue__, toInt32Node__);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSComplementNode.doBigInt(BigInt)] */ && operandNodeValue_ instanceof BigInt) {
                BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
                return doBigInt(operandNodeValue__);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */ && operandNodeValue_ instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue__ = (JSOverloadedOperatorsObject) operandNodeValue_;
                {
                    JSOverloadedUnaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                    if (overloadedOperatorNode__ != null) {
                        return doOverloaded(operandNodeValue__, overloadedOperatorNode__);
                    }
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */) {
                GenericData s5_ = this.generic_cache;
                if (s5_ != null) {
                    if ((!(hasOverloadedOperators(operandNodeValue_)))) {
                        return doGeneric(operandNodeValue_, s5_.toNumericNode_, s5_.recursive_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b100010) != 0 /* is SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] || SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        if ((state_0 & 0b1100) == 0 /* only-active SpecializationActive[JSComplementNode.doInteger(int)] */ && ((state_0 & 0b1101) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */)) {
            return executeInt_int3(state_0, frameValue);
        } else if ((state_0 & 0b101) == 0 /* only-active SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */ && ((state_0 & 0b1101) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */)) {
            return executeInt_double4(state_0, frameValue);
        } else {
            return executeInt_generic5(state_0, frameValue);
        }
    }

    private int executeInt_int3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSComplementNode.doInteger(int)] */;
        return doInteger(operandNodeValue_);
    }

    private int executeInt_double4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSComplementNode.doBigInt(BigInt)] && SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSComplementNode.doBigInt(BigInt)] && SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */;
        {
            JSToInt32Node toInt32Node__ = this.double_toInt32Node_;
            if (toInt32Node__ != null) {
                return doDouble(operandNodeValue_, toInt32Node__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSComplementNode.doBigInt(BigInt)] && SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */) ? (Object) operandNodeValue_int : (Object) operandNodeValue_)));
    }

    private int executeInt_generic5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b1101) != 0 /* is SpecializationActive[JSComplementNode.doInteger(int)] || SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] || SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSComplementNode.doInteger(int)] */ && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (int) operandNodeValue_;
                return doInteger(operandNodeValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] */ && operandNodeValue_ instanceof SafeInteger) {
                SafeInteger operandNodeValue__ = (SafeInteger) operandNodeValue_;
                return doSafeInteger(operandNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                {
                    JSToInt32Node toInt32Node__ = this.double_toInt32Node_;
                    if (toInt32Node__ != null) {
                        return doDouble(operandNodeValue__, toInt32Node__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b110010) == 0 /* only-active SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSComplementNode.doInteger(int)] && SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSComplementNode.doBigInt(BigInt)] && SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */)) {
                this.executeInt(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */ && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (int) operandNodeValue;
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSComplementNode.doInteger(int)] */;
            this.state_0_ = state_0;
            return doInteger(operandNodeValue_);
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */ && operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_ = (SafeInteger) operandNodeValue;
            state_0 = state_0 | 0b100 /* add SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)] */;
            this.state_0_ = state_0;
            return doSafeInteger(operandNodeValue_);
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */) {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                JSToInt32Node toInt32Node__ = this.insert((JSToInt32Node.create()));
                Objects.requireNonNull(toInt32Node__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.double_toInt32Node_ = toInt32Node__;
                state_0 = (state_0 | (doubleCast0 << 6) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b1000 /* add SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)] */;
                this.state_0_ = state_0;
                return doDouble(operandNodeValue_, toInt32Node__);
            }
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */ && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt) operandNodeValue;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[JSComplementNode.doBigInt(BigInt)] */;
            this.state_0_ = state_0;
            return doBigInt(operandNodeValue_);
        }
        if (operandNodeValue instanceof JSOverloadedOperatorsObject) {
            JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject) operandNodeValue;
            JSOverloadedUnaryNode overloadedOperatorNode__ = this.insert((JSOverloadedUnaryNodeGen.create(getOverloadedOperatorName())));
            Objects.requireNonNull(overloadedOperatorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.overloaded_overloadedOperatorNode_ = overloadedOperatorNode__;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSComplementNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */;
            this.state_0_ = state_0;
            return doOverloaded(operandNodeValue_, overloadedOperatorNode__);
        }
        if ((!(hasOverloadedOperators(operandNodeValue)))) {
            GenericData s5_ = this.insert(new GenericData());
            JSToNumericNode toNumericNode__ = s5_.insert((JSToNumericNode.create()));
            Objects.requireNonNull(toNumericNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s5_.toNumericNode_ = toNumericNode__;
            s5_.recursive_ = s5_.insert((JSComplementNode.createInner()));
            VarHandle.storeStoreFence();
            this.generic_cache = s5_;
            this.double_toInt32Node_ = null;
            state_0 = state_0 & 0xffffffe2 /* remove SpecializationActive[JSComplementNode.doInteger(int)], SpecializationActive[JSComplementNode.doSafeInteger(SafeInteger)], SpecializationActive[JSComplementNode.doDouble(double, JSToInt32Node)], SpecializationActive[JSComplementNode.doBigInt(BigInt)] */;
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSComplementNode.doGeneric(Object, JSToNumericNode, JSComplementNode)] */;
            this.state_0_ = state_0;
            return doGeneric(operandNodeValue, toNumericNode__, s5_.recursive_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.operandNode}, operandNodeValue);
    }

    @NeverDefault
    public static JSComplementNode create(JavaScriptNode operand) {
        return new JSComplementNodeGen(operand);
    }

    @GeneratedBy(JSComplementNode.class)
    @DenyReplace
    private static final class GenericData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link JSComplementNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} toNumericNode</pre> */
        @Child JSToNumericNode toNumericNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSComplementNode#doGeneric}
         *   Parameter: {@link JSComplementNode} recursive</pre> */
        @Child JSComplementNode recursive_;

        GenericData() {
        }

    }
}
