// CheckStyle: start generated
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;

/**
 * Debug Info: <pre>
 *   Specialization {@link SignNode#sign(int)}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link SignNode#sign(double)}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link SignNode#sign(Object)}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre> */
@GeneratedBy(SignNode.class)
@SuppressWarnings("javadoc")
public final class SignNodeGen extends SignNode {

    @Child private JavaScriptNode arguments0_;
    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link SignNode#sign(int)}
     *   1: SpecializationActive {@link SignNode#sign(double)}
     *   2: SpecializationActive {@link SignNode#sign(Object)}
     *   3-5: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;

    private SignNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[] {this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0 /* only-active SpecializationActive[SignNode.sign(int)] */ && ((state_0 & 0b111) != 0  /* is-not SpecializationActive[SignNode.sign(int)] && SpecializationActive[SignNode.sign(double)] && SpecializationActive[SignNode.sign(Object)] */)) {
            return execute_int0(state_0, frameValue);
        } else if ((state_0 & 0b101) == 0 /* only-active SpecializationActive[SignNode.sign(double)] */ && ((state_0 & 0b111) != 0  /* is-not SpecializationActive[SignNode.sign(int)] && SpecializationActive[SignNode.sign(double)] && SpecializationActive[SignNode.sign(Object)] */)) {
            return execute_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[SignNode.sign(int)] */;
        return SignNode.sign(arguments0Value_);
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_int = 0;
        double arguments0Value_;
        try {
            if ((state_0 & 0b110000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111) != 0  /* is-not SpecializationActive[SignNode.sign(int)] && SpecializationActive[SignNode.sign(double)] && SpecializationActive[SignNode.sign(Object)] */)) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else if ((state_0 & 0b101000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111) != 0  /* is-not SpecializationActive[SignNode.sign(int)] && SpecializationActive[SignNode.sign(double)] && SpecializationActive[SignNode.sign(Object)] */)) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000) >>> 3 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[SignNode.sign(double)] */;
        return SignNode.sign(arguments0Value_);
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state_0 & 0b111) != 0 /* is SpecializationActive[SignNode.sign(int)] || SpecializationActive[SignNode.sign(double)] || SpecializationActive[SignNode.sign(Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[SignNode.sign(int)] */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return SignNode.sign(arguments0Value__);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[SignNode.sign(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000) >>> 3 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000) >>> 3 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                return SignNode.sign(arguments0Value__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[SignNode.sign(Object)] */) {
                return sign(arguments0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arguments0Value_);
    }

    private Object executeAndSpecialize(Object arguments0Value) {
        int state_0 = this.state_0_;
        if (arguments0Value instanceof Integer) {
            int arguments0Value_ = (int) arguments0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[SignNode.sign(int)] */;
            this.state_0_ = state_0;
            return SignNode.sign(arguments0Value_);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state_0 = (state_0 | (doubleCast0 << 3) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b10 /* add SpecializationActive[SignNode.sign(double)] */;
                this.state_0_ = state_0;
                return SignNode.sign(arguments0Value_);
            }
        }
        state_0 = state_0 | 0b100 /* add SpecializationActive[SignNode.sign(Object)] */;
        this.state_0_ = state_0;
        return sign(arguments0Value);
    }

    @NeverDefault
    public static SignNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new SignNodeGen(context, builtin, arguments);
    }

}
