// CheckStyle: start generated
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.runtime.JSConfig;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(InteropFunction.class)
@SuppressWarnings("javadoc")
public final class InteropFunctionGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(InteropFunction.class, new InteropLibraryExports());
    }

    private InteropFunctionGen() {
    }

    @GeneratedBy(InteropFunction.class)
    public static class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, InteropFunction.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof InteropFunction;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof InteropFunction;
            return new Cached(receiver);
        }

        @GeneratedBy(InteropFunction.class)
        public static class Cached extends InteropLibrary {

            private final Class<? extends InteropFunction> receiverClass_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link InteropFunction#isIdenticalOrUndefined(InteropFunction, Object, InteropLibrary, InteropLibrary)}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InteropFunction#isIdenticalOrUndefined(InteropFunction, Object, InteropLibrary, InteropLibrary)}
             *   Parameter: {@link InteropLibrary} thisLib</pre> */
            @Child private InteropLibrary thisLib_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InteropFunction#isIdenticalOrUndefined(InteropFunction, Object, InteropLibrary, InteropLibrary)}
             *   Parameter: {@link InteropLibrary} otherLib</pre> */
            @Child private InteropLibrary otherLib_;

            protected Cached(Object receiver) {
                InteropFunction castReceiver = ((InteropFunction) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link InteropFunction#isIdenticalOrUndefined(InteropFunction, Object, InteropLibrary, InteropLibrary)}
             *     Activation probability: 1.00000
             *     With/without class size: 28/8 bytes
             * </pre> */
            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[InteropFunction.isIdenticalOrUndefined(InteropFunction, Object, InteropLibrary, InteropLibrary)] */) {
                    {
                        InteropLibrary thisLib__ = this.thisLib_;
                        if (thisLib__ != null) {
                            InteropLibrary otherLib__ = this.otherLib_;
                            if (otherLib__ != null) {
                                return arg0Value.isIdenticalOrUndefined(arg1Value, thisLib__, otherLib__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private TriState executeAndSpecialize(InteropFunction arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                InteropLibrary thisLib__ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                Objects.requireNonNull(thisLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.thisLib_ = thisLib__;
                InteropLibrary otherLib__ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                Objects.requireNonNull(otherLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.otherLib_ = otherLib__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[InteropFunction.isIdenticalOrUndefined(InteropFunction, Object, InteropLibrary, InteropLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.isIdenticalOrUndefined(arg1Value, thisLib__, otherLib__);
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).identityHashCode();
            }

        }
        @GeneratedBy(InteropFunction.class)
        public static class Uncached extends InteropLibrary implements UnadoptableNode {

            private final Class<? extends InteropFunction> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((InteropFunction) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @TruffleBoundary
            @Override
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = ((InteropFunction) arg0Value_);
                return arg0Value.isIdenticalOrUndefined(arg1Value, (INTEROP_LIBRARY_.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropFunction) receiver) .identityHashCode();
            }

        }
    }
}
