/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalCalendarDateFromFieldsNode
extends JavaScriptBaseNode {
    protected TemporalCalendarDateFromFieldsNode() {
    }

    public abstract JSTemporalPlainDateObject execute(TruffleString var1, Object var2, TemporalUtil.Overflow var3);

    @Specialization
    public JSTemporalPlainDateObject calendarDateFromFields(TruffleString calendar, Object fieldsParam, TemporalUtil.Overflow overflow, @Cached JSToIntegerOrInfinityNode toIntegerOrInfinity, @Cached InlinedBranchProfile errorBranch) {
        JSContext context = this.getJSContext();
        JSObject fields = TemporalUtil.prepareTemporalFields(context, fieldsParam, TemporalUtil.listDMMCY, TemporalUtil.listYD);
        TemporalUtil.isoResolveMonth(context, fields, toIntegerOrInfinity);
        ISODateRecord result = TemporalUtil.isoDateFromFields(fields, overflow);
        return JSTemporalPlainDate.create(context, this.getRealm(), result.year(), result.month(), result.day(), calendar, this, errorBranch);
    }
}

