/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;

@GenerateUncached
@ImportStatic(value={Strings.class})
public abstract class ToTemporalCalendarIdentifierNode
extends JavaScriptBaseNode {
    protected ToTemporalCalendarIdentifierNode() {
    }

    @NeverDefault
    public static ToTemporalCalendarIdentifierNode create() {
        return ToTemporalCalendarIdentifierNodeGen.create();
    }

    @NeverDefault
    public static ToTemporalCalendarIdentifierNode getUncached() {
        return ToTemporalCalendarIdentifierNodeGen.getUncached();
    }

    public abstract TruffleString executeString(Object var1);

    @Specialization
    public TruffleString doString(TruffleString calendarSlotValue) {
        return calendarSlotValue;
    }

    @Specialization(guards={"!isString(calendarSlotValue)"})
    public TruffleString doNonString(Object calendarSlotValue, @Cached(value="create(ID_PROPERTY_NAME, getJSContext())", uncached="getNullNode()") PropertyGetNode getIdNode, @Cached InlinedBranchProfile errorBranch) {
        Object identifier;
        Object object = identifier = getIdNode != null ? getIdNode.getValue(calendarSlotValue) : JSRuntime.get(calendarSlotValue, Strings.ID_PROPERTY_NAME);
        if (identifier instanceof TruffleString) {
            TruffleString stringIdentifier = (TruffleString)identifier;
            return stringIdentifier;
        }
        errorBranch.enter((Node)this);
        throw Errors.createTypeErrorNotAString(identifier);
    }
}

