/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.module.CreateImportMetaNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import com.oracle.truffle.js.runtime.objects.CyclicModuleRecord;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSModuleData;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JSModuleRecord
extends CyclicModuleRecord {
    private final JSModuleData parsedModule;
    private final JSModuleLoader moduleLoader;
    private JSObject importMeta;

    public JSModuleRecord(JSModuleData parsedModule, JSModuleLoader moduleLoader) {
        this(parsedModule, moduleLoader, null);
    }

    public JSModuleRecord(JSModuleData parsedModule, JSModuleLoader moduleLoader, Object hostDefined) {
        super(parsedModule.getContext(), parsedModule.getSource(), hostDefined, parsedModule.isTopLevelAsync());
        this.parsedModule = parsedModule;
        this.moduleLoader = moduleLoader;
    }

    public Module getModule() {
        return this.parsedModule.getModule();
    }

    public JSModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public JSFunctionData getFunctionData() {
        return this.parsedModule.getFunctionData();
    }

    @Override
    public FrameDescriptor getFrameDescriptor() {
        return this.parsedModule.getFrameDescriptor();
    }

    public JSModuleData getModuleData() {
        return this.parsedModule;
    }

    public JSObject getImportMetaOrNull() {
        return this.importMeta;
    }

    public JSObject getImportMeta(CreateImportMetaNode createImportMeta) {
        JSObject metaObj = this.importMeta;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (metaObj == null ? 1 : 0) != 0)) {
            this.importMeta = metaObj = createImportMeta.execute(this);
        }
        return metaObj;
    }

    @CompilerDirectives.TruffleBoundary
    public String getURL() {
        return this.getSource().getURI().toString();
    }

    @Override
    public Object getModuleSource() {
        throw Errors.createSyntaxError("Source phase import is not available for Source Text Module");
    }

    @Override
    public Collection<TruffleString> getExportedNames(Set<JSModuleRecord> exportStarSet) {
        CompilerAsserts.neverPartOfCompilation();
        if (exportStarSet.contains(this)) {
            return Collections.emptySortedSet();
        }
        exportStarSet.add(this);
        HashSet<TruffleString> exportedNames = new HashSet<TruffleString>();
        for (Module.ExportEntry exportEntry : this.getModule().getLocalExportEntries()) {
            exportedNames.add(exportEntry.getExportName());
        }
        for (Module.ExportEntry exportEntry : this.getModule().getIndirectExportEntries()) {
            exportedNames.add(exportEntry.getExportName());
        }
        for (Module.ExportEntry exportEntry : this.getModule().getStarExportEntries()) {
            AbstractModuleRecord requestedModule = this.getImportedModule(exportEntry.getModuleRequest());
            Collection<TruffleString> starNames = requestedModule.getExportedNames(exportStarSet);
            for (TruffleString starName : starNames) {
                if (starName.equals((Object)Module.DEFAULT_NAME) || exportedNames.contains(starName)) continue;
                exportedNames.add(starName);
            }
        }
        return exportedNames;
    }

    @Override
    public ExportResolution resolveExport(TruffleString exportName, Set<Pair<? extends AbstractModuleRecord, TruffleString>> resolveSet) {
        CompilerAsserts.neverPartOfCompilation();
        Pair<JSModuleRecord, TruffleString> resolved = new Pair<JSModuleRecord, TruffleString>(this, exportName);
        if (resolveSet.contains(resolved)) {
            return ExportResolution.notFound();
        }
        resolveSet.add(resolved);
        for (Module.ExportEntry exportEntry : this.getModule().getLocalExportEntries()) {
            if (!exportEntry.getExportName().equals((Object)exportName)) continue;
            return ExportResolution.resolved(this, exportEntry.getLocalName());
        }
        for (Module.ExportEntry exportEntry : this.getModule().getIndirectExportEntries()) {
            if (!exportEntry.getExportName().equals((Object)exportName)) continue;
            AbstractModuleRecord importedModule = this.getImportedModule(exportEntry.getModuleRequest());
            if (exportEntry.getImportName().equals((Object)Module.STAR_NAME)) {
                return ExportResolution.resolved(importedModule, Module.NAMESPACE_EXPORT_BINDING_NAME);
            }
            return importedModule.resolveExport(exportEntry.getImportName(), resolveSet);
        }
        if (exportName.equals((Object)Module.DEFAULT_NAME)) {
            return ExportResolution.notFound();
        }
        ExportResolution starResolution = ExportResolution.notFound();
        for (Module.ExportEntry exportEntry : this.getModule().getStarExportEntries()) {
            AbstractModuleRecord importedModule = this.getImportedModule(exportEntry.getModuleRequest());
            ExportResolution resolution = importedModule.resolveExport(exportName, resolveSet);
            if (resolution.isAmbiguous()) {
                return resolution;
            }
            if (resolution.isNull()) continue;
            if (starResolution.isNull()) {
                starResolution = resolution;
                continue;
            }
            if (resolution.equals(starResolution)) continue;
            return ExportResolution.ambiguous();
        }
        return starResolution;
    }

    @Override
    public List<Module.ModuleRequest> getRequestedModules() {
        return this.getModule().getRequestedModules();
    }

    @Override
    public JSPromiseObject loadRequestedModules(JSRealm realm, Object hostDefinedArg) {
        return this.context.getEvaluator().loadRequestedModules(realm, this, hostDefinedArg);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void initializeEnvironment(JSRealm realm) {
        assert (this.getStatus() == CyclicModuleRecord.Status.Linking) : this.getStatus();
        Module module = this.getModule();
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            ExportResolution resolution = this.resolveExport(exportEntry.getExportName());
            if (!resolution.isNull() && !resolution.isAmbiguous()) continue;
            throw Errors.createSyntaxError("Could not resolve indirect export entry");
        }
        JSFunctionObject moduleFunction = JSFunction.create(realm, this.getFunctionData());
        Object[] arguments = JSArguments.create((Object)Undefined.instance, (Object)moduleFunction, this);
        JSFunction.getConstructTarget(moduleFunction).call(arguments);
    }

    @Override
    public Object executeModule(JSRealm realm, PromiseCapabilityRecord capability) {
        JSFunctionObject moduleFunction = JSFunction.create(realm, this.getFunctionData());
        if (!this.hasTLA()) {
            assert (capability == null);
            return JSFunction.call(JSArguments.create((Object)Undefined.instance, (Object)moduleFunction, this));
        }
        assert (capability != null);
        return JSFunction.call(JSArguments.create((Object)Undefined.instance, (Object)moduleFunction, this, capability));
    }

    @Override
    public void rememberImportedModuleSource(TruffleString moduleSpecifier, Source moduleSource) {
        this.parsedModule.rememberImportedModuleSource(moduleSpecifier, moduleSource);
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "SourceTextModule@" + Integer.toHexString(System.identityHashCode(this)) + "[status=" + String.valueOf((Object)this.getStatus()) + ", source=" + String.valueOf(this.getSource()) + "]";
    }
}

