// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSExponentiateNode#doDouble}
 *     Activation probability: 0.23929
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSExponentiateNode#doBigIntNegativeExponent}
 *     Activation probability: 0.20714
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSExponentiateNode#doBigIntZero}
 *     Activation probability: 0.17500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSExponentiateNode#doBigIntZeroPowZero}
 *     Activation probability: 0.14286
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSExponentiateNode#doBigInt}
 *     Activation probability: 0.11071
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSExponentiateNode#doOverloaded}
 *     Activation probability: 0.07857
 *     With/without class size: 5/4 bytes
 *   Specialization {@link JSExponentiateNode#doGeneric}
 *     Activation probability: 0.04643
 *     With/without class size: 5/13 bytes
 * </pre> */
@GeneratedBy(JSExponentiateNode.class)
@SuppressWarnings("javadoc")
public final class JSExponentiateNodeGen extends JSExponentiateNode {

    private static final StateField GENERIC_JS_EXPONENTIATE_NODE_GENERIC_STATE_0_UPDATER = StateField.create(GenericData.lookup_(), "generic_state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSExponentiateNode#doGeneric}
     *   Parameter: {@link InlinedBranchProfile} mixedNumericTypes
     *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
    private static final InlinedBranchProfile INLINED_GENERIC_MIXED_NUMERIC_TYPES_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, GENERIC_JS_EXPONENTIATE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(0, 1)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSExponentiateNode#doDouble}
     *   1: SpecializationActive {@link JSExponentiateNode#doGeneric}
     *   2: SpecializationActive {@link JSExponentiateNode#doBigIntNegativeExponent}
     *   3: SpecializationActive {@link JSExponentiateNode#doBigIntZero}
     *   4: SpecializationActive {@link JSExponentiateNode#doBigIntZeroPowZero}
     *   5: SpecializationActive {@link JSExponentiateNode#doBigInt}
     *   6: SpecializationActive {@link JSExponentiateNode#doOverloaded}
     *   7-9: ImplicitCast[type=double, index=0]
     *   10-12: ImplicitCast[type=double, index=1]
     * </pre> */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSExponentiateNode#doOverloaded}
     *   Parameter: {@link JSOverloadedBinaryNode} overloadedOperatorNode</pre> */
    @Child private JSOverloadedBinaryNode overloaded_overloadedOperatorNode_;
    @Child private GenericData generic_cache;

    private JSExponentiateNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    @Override
    public Object execute(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111111) != 0 /* is SpecializationActive[JSExponentiateNode.doDouble(double, double)] || SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSExponentiateNode.doDouble(double, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue)) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue);
                if (JSTypesGen.isImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue)) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue);
                    return doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b111100) != 0 /* is SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] */ && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt) leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] */) {
                        if ((JSGuards.isBigIntNegativeVal(rightNodeValue_))) {
                            return doBigIntNegativeExponent(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] */) {
                        if ((JSGuards.isBigIntZero(leftNodeValue_)) && (!(JSGuards.isBigIntZero(rightNodeValue_))) && (!(JSGuards.isBigIntNegativeVal(rightNodeValue_)))) {
                            return doBigIntZero(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] */) {
                        if ((JSGuards.isBigIntZero(rightNodeValue_))) {
                            return doBigIntZeroPowZero(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] */) {
                        if ((!(JSGuards.isBigIntZero(leftNodeValue_))) && (!(JSGuards.isBigIntZero(rightNodeValue_))) && (!(JSGuards.isBigIntNegativeVal(rightNodeValue_)))) {
                            return doBigInt(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
            }
            if ((state_0 & 0b1000010) != 0 /* is SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */) {
                    {
                        JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                        if (overloadedOperatorNode__ != null) {
                            if ((hasOverloadedOperators(leftNodeValue) || hasOverloadedOperators(rightNodeValue))) {
                                return doOverloaded(leftNodeValue, rightNodeValue, overloadedOperatorNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                    GenericData s6_ = this.generic_cache;
                    if (s6_ != null) {
                        if ((!(hasOverloadedOperators(leftNodeValue))) && (!(hasOverloadedOperators(rightNodeValue)))) {
                            Node node__ = (s6_);
                            return JSExponentiateNode.doGeneric(leftNodeValue, rightNodeValue, node__, s6_.nestedExponentiateNode_, s6_.toNumeric1Node_, s6_.toNumeric2Node_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111110) == 0 /* only-active SpecializationActive[JSExponentiateNode.doDouble(double, double)] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
            return execute_double_double0(state_0, frameValue);
        } else {
            return execute_generic1(state_0, frameValue);
        }
    }

    private Object execute_double_double0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_int = 0;
        double leftNodeValue_;
        try {
            if ((state_0 & 0b1100000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else if ((state_0 & 0b1010000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0b1100000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0b1010000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(((state_0 & 0b1010000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSExponentiateNode.doDouble(double, double)] */;
        return doDouble(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state_0 & 0b1111111) != 0 /* is SpecializationActive[JSExponentiateNode.doDouble(double, double)] || SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSExponentiateNode.doDouble(double, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_)) {
                double leftNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_);
                if (JSTypesGen.isImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_)) {
                    double rightNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_);
                    return doDouble(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b111100) != 0 /* is SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] */ && leftNodeValue_ instanceof BigInt) {
                BigInt leftNodeValue__ = (BigInt) leftNodeValue_;
                if (rightNodeValue_ instanceof BigInt) {
                    BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] */) {
                        if ((JSGuards.isBigIntNegativeVal(rightNodeValue__))) {
                            return doBigIntNegativeExponent(leftNodeValue__, rightNodeValue__);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] */) {
                        if ((JSGuards.isBigIntZero(leftNodeValue__)) && (!(JSGuards.isBigIntZero(rightNodeValue__))) && (!(JSGuards.isBigIntNegativeVal(rightNodeValue__)))) {
                            return doBigIntZero(leftNodeValue__, rightNodeValue__);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] */) {
                        if ((JSGuards.isBigIntZero(rightNodeValue__))) {
                            return doBigIntZeroPowZero(leftNodeValue__, rightNodeValue__);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] */) {
                        if ((!(JSGuards.isBigIntZero(leftNodeValue__))) && (!(JSGuards.isBigIntZero(rightNodeValue__))) && (!(JSGuards.isBigIntNegativeVal(rightNodeValue__)))) {
                            return doBigInt(leftNodeValue__, rightNodeValue__);
                        }
                    }
                }
            }
            if ((state_0 & 0b1000010) != 0 /* is SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */) {
                    {
                        JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                        if (overloadedOperatorNode__ != null) {
                            if ((hasOverloadedOperators(leftNodeValue_) || hasOverloadedOperators(rightNodeValue_))) {
                                return doOverloaded(leftNodeValue_, rightNodeValue_, overloadedOperatorNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                    GenericData s6_ = this.generic_cache;
                    if (s6_ != null) {
                        if ((!(hasOverloadedOperators(leftNodeValue_))) && (!(hasOverloadedOperators(rightNodeValue_)))) {
                            Node node__ = (s6_);
                            return JSExponentiateNode.doGeneric(leftNodeValue_, rightNodeValue_, node__, s6_.nestedExponentiateNode_, s6_.toNumeric1Node_, s6_.toNumeric2Node_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1000110) != 0 /* is SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] || SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        int leftNodeValue_int = 0;
        double leftNodeValue_;
        try {
            if ((state_0 & 0b1100000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else if ((state_0 & 0b1010000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0b1100000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0b1010000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(((state_0 & 0b1010000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ex.getResult()));
        }
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSExponentiateNode.doDouble(double, double)] */) {
            return doDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(((state_0 & 0b1010000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ((state_0 & 0b1010000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) rightNodeValue_int : (Object) rightNodeValue_)));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b1111110) == 0 /* only-active SpecializationActive[JSExponentiateNode.doDouble(double, double)] */ && ((state_0 & 0b1111111) != 0  /* is-not SpecializationActive[JSExponentiateNode.doDouble(double, double)] && SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                this.executeDouble(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int doubleCast1;
                if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state_0 = (state_0 | (doubleCast0 << 7) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = (state_0 | (doubleCast1 << 10) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b1 /* add SpecializationActive[JSExponentiateNode.doDouble(double, double)] */;
                    this.state_0_ = state_0;
                    return doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if (leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt) leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                if ((JSGuards.isBigIntNegativeVal(rightNodeValue_))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[JSExponentiateNode.doBigIntNegativeExponent(BigInt, BigInt)] */;
                    this.state_0_ = state_0;
                    return doBigIntNegativeExponent(leftNodeValue_, rightNodeValue_);
                }
                if ((JSGuards.isBigIntZero(leftNodeValue_)) && (!(JSGuards.isBigIntZero(rightNodeValue_))) && (!(JSGuards.isBigIntNegativeVal(rightNodeValue_)))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[JSExponentiateNode.doBigIntZero(BigInt, BigInt)] */;
                    this.state_0_ = state_0;
                    return doBigIntZero(leftNodeValue_, rightNodeValue_);
                }
                if ((JSGuards.isBigIntZero(rightNodeValue_))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[JSExponentiateNode.doBigIntZeroPowZero(BigInt, BigInt)] */;
                    this.state_0_ = state_0;
                    return doBigIntZeroPowZero(leftNodeValue_, rightNodeValue_);
                }
                if ((!(JSGuards.isBigIntZero(leftNodeValue_))) && (!(JSGuards.isBigIntZero(rightNodeValue_))) && (!(JSGuards.isBigIntNegativeVal(rightNodeValue_)))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[JSExponentiateNode.doBigInt(BigInt, BigInt)] */;
                    this.state_0_ = state_0;
                    return doBigInt(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((hasOverloadedOperators(leftNodeValue) || hasOverloadedOperators(rightNodeValue))) {
            JSOverloadedBinaryNode overloadedOperatorNode__ = this.insert((JSOverloadedBinaryNode.createNumeric(getOverloadedOperatorName())));
            Objects.requireNonNull(overloadedOperatorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.overloaded_overloadedOperatorNode_ = overloadedOperatorNode__;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSExponentiateNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */;
            this.state_0_ = state_0;
            return doOverloaded(leftNodeValue, rightNodeValue, overloadedOperatorNode__);
        }
        {
            Node node__ = null;
            if ((!(hasOverloadedOperators(leftNodeValue))) && (!(hasOverloadedOperators(rightNodeValue)))) {
                GenericData s6_ = this.insert(new GenericData());
                node__ = (s6_);
                s6_.nestedExponentiateNode_ = s6_.insert((JSExponentiateNode.create()));
                JSToNumericNode toNumeric1Node__ = s6_.insert((JSToNumericNode.create()));
                Objects.requireNonNull(toNumeric1Node__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s6_.toNumeric1Node_ = toNumeric1Node__;
                JSToNumericNode toNumeric2Node__ = s6_.insert((JSToNumericNode.create()));
                Objects.requireNonNull(toNumeric2Node__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s6_.toNumeric2Node_ = toNumeric2Node__;
                VarHandle.storeStoreFence();
                this.generic_cache = s6_;
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSExponentiateNode.doDouble(double, double)] */;
                state_0 = state_0 | 0b10 /* add SpecializationActive[JSExponentiateNode.doGeneric(Object, Object, Node, JSExponentiateNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */;
                this.state_0_ = state_0;
                return JSExponentiateNode.doGeneric(leftNodeValue, rightNodeValue, node__, s6_.nestedExponentiateNode_, toNumeric1Node__, toNumeric2Node__, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.leftNode, super.rightNode}, leftNodeValue, rightNodeValue);
    }

    @NeverDefault
    public static JSExponentiateNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSExponentiateNodeGen(left, right);
    }

    @GeneratedBy(JSExponentiateNode.class)
    @DenyReplace
    private static final class GenericData extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0: InlinedCache
         *        Specialization: {@link JSExponentiateNode#doGeneric}
         *        Parameter: {@link InlinedBranchProfile} mixedNumericTypes
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre> */
        @CompilationFinal @UnsafeAccessedField private int generic_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSExponentiateNode#doGeneric}
         *   Parameter: {@link JSExponentiateNode} nestedExponentiateNode</pre> */
        @Child JSExponentiateNode nestedExponentiateNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSExponentiateNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} toNumeric1Node</pre> */
        @Child JSToNumericNode toNumeric1Node_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSExponentiateNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} toNumeric2Node</pre> */
        @Child JSToNumericNode toNumeric2Node_;

        GenericData() {
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
}
