/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.intl.PluralRulesFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.PluralRulesPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRulesObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.graalvm.shadowed.com.ibm.icu.number.FormattedNumber;
import org.graalvm.shadowed.com.ibm.icu.number.FormattedNumberRange;
import org.graalvm.shadowed.com.ibm.icu.number.LocalizedNumberFormatter;
import org.graalvm.shadowed.com.ibm.icu.number.LocalizedNumberRangeFormatter;
import org.graalvm.shadowed.com.ibm.icu.number.NumberRangeFormatter;
import org.graalvm.shadowed.com.ibm.icu.text.PluralRules;

public final class JSPluralRules
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("PluralRules");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("PluralRules.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Intl.PluralRules");
    public static final JSPluralRules INSTANCE = new JSPluralRules();

    private JSPluralRules() {
    }

    public static boolean isJSPluralRules(Object obj) {
        return obj instanceof JSPluralRulesObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject pluralRulesPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(pluralRulesPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, pluralRulesPrototype, PluralRulesPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(pluralRulesPrototype, TO_STRING_TAG);
        return pluralRulesPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, PluralRulesFunctionBuiltins.BUILTINS);
    }

    public static JSPluralRulesObject create(JSContext context, JSRealm realm, JSDynamicObject proto) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context.getPluralRulesFactory();
        Shape shape = factory.getShape(realm, proto);
        JSPluralRulesObject newObj = factory.initProto(new JSPluralRulesObject(shape, proto, state), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static PluralRules getPluralRulesProperty(JSPluralRulesObject obj) {
        return obj.getInternalState().getPluralRules();
    }

    public static LocalizedNumberFormatter getNumberFormatter(JSPluralRulesObject obj) {
        return obj.getInternalState().getNumberFormatter();
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString select(JSPluralRulesObject pluralRulesObj, double number) {
        PluralRules pluralRules = JSPluralRules.getPluralRulesProperty(pluralRulesObj);
        LocalizedNumberFormatter numberFormatter = JSPluralRules.getNumberFormatter(pluralRulesObj);
        FormattedNumber formattedNumber = numberFormatter.format(number);
        return Strings.fromJavaString(pluralRules.select(formattedNumber));
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString selectRange(JSPluralRulesObject pluralRulesObj, double x, double y) {
        PluralRules pluralRules = JSPluralRules.getPluralRulesProperty(pluralRulesObj);
        LocalizedNumberRangeFormatter rangeFormatter = pluralRulesObj.getInternalState().getNumberRangeFormatter();
        FormattedNumberRange formattedRange = rangeFormatter.formatRange(x, y);
        return Strings.fromJavaString(pluralRules.select(formattedRange));
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject resolvedOptions(JSContext context, JSRealm realm, JSPluralRulesObject pluralRulesObj) {
        InternalState state = pluralRulesObj.getInternalState();
        return state.toResolvedOptionsObject(context, realm);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getPluralRulesPrototype();
    }

    public static class InternalState
    extends JSNumberFormat.BasicInternalState {
        private static final List<String> CATEGORIES = List.of("zero", "one", "two", "few", "many", "other");
        private LocalizedNumberFormatter numberFormatter;
        private LocalizedNumberRangeFormatter numberRangeFormatter;
        private String type;
        private PluralRules pluralRules;
        private final List<TruffleString> pluralCategories = new LinkedList<TruffleString>();

        @Override
        void fillResolvedOptions(JSContext context, JSRealm realm, JSDynamicObject result) {
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_LOCALE, Strings.fromJavaString(this.getLocale()), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_TYPE, Strings.fromJavaString(this.type), JSAttributes.getDefault());
            super.fillBasicResolvedOptions(result);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_PLURAL_CATEGORIES, (Object)JSRuntime.createArrayFromList(realm.getContext(), realm, this.pluralCategories), JSAttributes.getDefault());
            super.fillRoundingResolvedOptions(result);
        }

        @CompilerDirectives.TruffleBoundary
        public void initializePluralRules() {
            this.pluralRules = PluralRules.forLocale((Locale)this.getJavaLocale(), (PluralRules.PluralType)("ordinal".equals(this.type) ? PluralRules.PluralType.ORDINAL : PluralRules.PluralType.CARDINAL));
            Set keywords = this.pluralRules.getKeywords();
            for (String category : CATEGORIES) {
                if (!keywords.contains(category)) continue;
                this.pluralCategories.add(Strings.fromJavaString(category));
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void initializeNumberFormatter() {
            super.initializeNumberFormatter();
            this.numberFormatter = this.getUnlocalizedFormatter().locale(this.getJavaLocale());
            this.numberRangeFormatter = (LocalizedNumberRangeFormatter)NumberRangeFormatter.withLocale((Locale)this.getJavaLocale()).numberFormatterBoth(this.getUnlocalizedFormatter());
        }

        public PluralRules getPluralRules() {
            return this.pluralRules;
        }

        public LocalizedNumberFormatter getNumberFormatter() {
            return this.numberFormatter;
        }

        public LocalizedNumberRangeFormatter getNumberRangeFormatter() {
            return this.numberRangeFormatter;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

