// CheckStyle: start generated
package com.oracle.truffle.js.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ArrayBufferLibrary.class)
final class ArrayBufferLibraryGen extends LibraryFactory<ArrayBufferLibrary> {

    private static final Class<ArrayBufferLibrary> LIBRARY_CLASS = ArrayBufferLibraryGen.lazyLibraryClass();
    private static final Message IS_ARRAY_BUFFER = new MessageImpl("isArrayBuffer", 0, false, boolean.class, Object.class);
    private static final Message GET_CONTENTS = new MessageImpl("getContents", 1, false, ByteBuffer.class, Object.class);
    private static final Message GET_BYTE_LENGTH = new MessageImpl("getByteLength", 2, false, int.class, Object.class);
    private static final ArrayBufferLibraryGen INSTANCE = new ArrayBufferLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(ArrayBufferLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(ArrayBufferLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private ArrayBufferLibraryGen() {
        super(ArrayBufferLibraryGen.LIBRARY_CLASS, List.of(ArrayBufferLibraryGen.IS_ARRAY_BUFFER, ArrayBufferLibraryGen.GET_CONTENTS, ArrayBufferLibraryGen.GET_BYTE_LENGTH));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return ArrayBufferLibrary.class;
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected ArrayBufferLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected ArrayBufferLibrary createDelegate(ArrayBufferLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        ArrayBufferLibrary lib = (ArrayBufferLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.isArrayBuffer(receiver);
            case 1 :
                return lib.getContents(receiver);
            case 2 :
                return lib.getByteLength(receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected ArrayBufferLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected ArrayBufferLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<ArrayBufferLibrary> lazyLibraryClass() {
        try {
            return (Class<ArrayBufferLibrary>) Class.forName("com.oracle.truffle.js.api.ArrayBufferLibrary", false, ArrayBufferLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(ArrayBufferLibrary.class)
    private static final class Default extends LibraryExport<ArrayBufferLibrary> {

        private Default() {
            super(ArrayBufferLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected ArrayBufferLibrary createUncached(Object receiver) {
            ArrayBufferLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected ArrayBufferLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(ArrayBufferLibrary.class)
        private static final class Cached extends ArrayBufferLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isArrayBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public ByteBuffer getContents(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getContents((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public int getByteLength(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getByteLength((dynamicDispatch_.cast(receiver)));
            }

        }
        @GeneratedBy(ArrayBufferLibrary.class)
        @DenyReplace
        private static final class Uncached extends ArrayBufferLibrary implements UnadoptableNode {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public boolean isArrayBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer(receiver);
            }

            @TruffleBoundary
            @Override
            public ByteBuffer getContents(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getContents(receiver);
            }

            @TruffleBoundary
            @Override
            public int getByteLength(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getByteLength(receiver);
            }

        }
    }
    @GeneratedBy(ArrayBufferLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(ArrayBufferLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(ArrayBufferLibrary.class)
    private static final class Proxy extends ArrayBufferLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, ArrayBufferLibraryGen.IS_ARRAY_BUFFER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            try {
                return (ByteBuffer) lib.send(receiver_, ArrayBufferLibraryGen.GET_CONTENTS);
            } catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            try {
                return (int) lib.send(receiver_, ArrayBufferLibraryGen.GET_BYTE_LENGTH);
            } catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(ArrayBufferLibrary.class)
    private static final class Delegate extends ArrayBufferLibrary {

        @Child private ArrayBufferLibrary delegateLibrary;

        Delegate(ArrayBufferLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isArrayBuffer(delegate);
            } else {
                return this.delegateLibrary.isArrayBuffer(receiver_);
            }
        }

        @Override
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getContents(delegate);
            } else {
                return this.delegateLibrary.getContents(receiver_);
            }
        }

        @Override
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getByteLength(delegate);
            } else {
                return this.delegateLibrary.getByteLength(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(ArrayBufferLibrary.class)
    private static final class CachedToUncachedDispatch extends ArrayBufferLibrary {

        @TruffleBoundary
        @Override
        public boolean isArrayBuffer(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isArrayBuffer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getContents(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getByteLength(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(ArrayBufferLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends ArrayBufferLibrary implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public boolean isArrayBuffer(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isArrayBuffer(receiver_);
        }

        @TruffleBoundary
        @Override
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            return INSTANCE.getUncached(receiver_).getContents(receiver_);
        }

        @TruffleBoundary
        @Override
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            return INSTANCE.getUncached(receiver_).getByteLength(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(ArrayBufferLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(ArrayBufferLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

    }
    @GeneratedBy(ArrayBufferLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(ArrayBufferLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

    }
    @GeneratedBy(ArrayBufferLibrary.class)
    private abstract static class CachedDispatch extends ArrayBufferLibrary {

        @Child ArrayBufferLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(ArrayBufferLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public boolean isArrayBuffer(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    ArrayBufferLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isArrayBuffer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            do {
                CachedDispatch current = this;
                do {
                    ArrayBufferLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getContents(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            do {
                CachedDispatch current = this;
                do {
                    ArrayBufferLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getByteLength(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                ArrayBufferLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        ArrayBufferLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
