// CheckStyle: start generated
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.EqualNode;
import com.oracle.truffle.api.strings.TruffleString.FromByteArrayNode;
import com.oracle.truffle.api.strings.TruffleString.FromJavaStringNode;
import com.oracle.truffle.api.strings.TruffleString.ReadCharUTF16Node;
import com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins.ArraySpeciesConstructorNode;
import com.oracle.truffle.js.builtins.Uint8ArrayBuiltins.SetFromBase64Node;
import com.oracle.truffle.js.builtins.Uint8ArrayBuiltins.SetFromHexNode;
import com.oracle.truffle.js.builtins.Uint8ArrayBuiltins.ToBase64Node;
import com.oracle.truffle.js.builtins.Uint8ArrayBuiltins.ToHexNode;
import com.oracle.truffle.js.builtins.Uint8ArrayBuiltins.Uint8ArrayBaseNode;
import com.oracle.truffle.js.builtins.Uint8ArrayBuiltins.Uint8ArrayFromBase64Node;
import com.oracle.truffle.js.builtins.Uint8ArrayBuiltins.Uint8ArrayFromHexNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNodeGen;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(Uint8ArrayBuiltins.class)
@SuppressWarnings({"javadoc", "unused"})
public final class Uint8ArrayBuiltinsFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link SetFromBase64Node#doUint8Array}
     *     Activation probability: 0.48333
     *     With/without class size: 21/20 bytes
     *   Specialization {@link SetFromBase64Node#doNotString}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link SetFromBase64Node#doNotUint8Array}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre> */
    @GeneratedBy(SetFromBase64Node.class)
    @SuppressWarnings("javadoc")
    public static final class SetFromBase64NodeGen extends SetFromBase64Node {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @Child private JavaScriptNode arguments2_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link SetFromBase64Node#doUint8Array}
         *   1: SpecializationActive {@link SetFromBase64Node#doNotString}
         *   2: SpecializationActive {@link SetFromBase64Node#doNotUint8Array}
         * </pre> */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link SetFromBase64Node#doUint8Array}
         *   Parameter: {@link GetOptionsObjectNode} getOptionsObjectNode</pre> */
        @Child private GetOptionsObjectNode uint8Array_getOptionsObjectNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link SetFromBase64Node#doUint8Array}
         *   Parameter: {@link PropertyGetNode} getAlphabetNode</pre> */
        @Child private PropertyGetNode uint8Array_getAlphabetNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link SetFromBase64Node#doUint8Array}
         *   Parameter: {@link PropertyGetNode} getLastChunkHandlingNode</pre> */
        @Child private PropertyGetNode uint8Array_getLastChunkHandlingNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link SetFromBase64Node#doUint8Array}
         *   Parameter: {@link ReadCharUTF16Node} charAtNode</pre> */
        @Child private ReadCharUTF16Node uint8Array_charAtNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link SetFromBase64Node#doUint8Array}
         *   Parameter: {@link EqualNode} equalNode</pre> */
        @Child private EqualNode uint8Array_equalNode_;

        private SetFromBase64NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            if (arguments0Value instanceof JSTypedArrayObject) {
                if (arguments1Value instanceof TruffleString) {
                    JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                    if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_))) {
                        return false;
                    }
                }
                {
                    JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                    if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_)) && (!(JSGuards.isString(arguments1Value)))) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state_0 != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doUint8Array(JSTypedArrayObject, TruffleString, Object, GetOptionsObjectNode, PropertyGetNode, PropertyGetNode, ReadCharUTF16Node, EqualNode)] || SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doNotString(JSTypedArrayObject, Object, Object)] || SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doNotUint8Array(Object, Object, Object)] */) {
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doUint8Array(JSTypedArrayObject, TruffleString, Object, GetOptionsObjectNode, PropertyGetNode, PropertyGetNode, ReadCharUTF16Node, EqualNode)] || SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doNotString(JSTypedArrayObject, Object, Object)] */ && arguments0Value_ instanceof JSTypedArrayObject) {
                    JSTypedArrayObject arguments0Value__ = (JSTypedArrayObject) arguments0Value_;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doUint8Array(JSTypedArrayObject, TruffleString, Object, GetOptionsObjectNode, PropertyGetNode, PropertyGetNode, ReadCharUTF16Node, EqualNode)] */ && arguments1Value_ instanceof TruffleString) {
                        TruffleString arguments1Value__ = (TruffleString) arguments1Value_;
                        {
                            GetOptionsObjectNode getOptionsObjectNode__ = this.uint8Array_getOptionsObjectNode_;
                            if (getOptionsObjectNode__ != null) {
                                PropertyGetNode getAlphabetNode__ = this.uint8Array_getAlphabetNode_;
                                if (getAlphabetNode__ != null) {
                                    PropertyGetNode getLastChunkHandlingNode__ = this.uint8Array_getLastChunkHandlingNode_;
                                    if (getLastChunkHandlingNode__ != null) {
                                        ReadCharUTF16Node charAtNode__ = this.uint8Array_charAtNode_;
                                        if (charAtNode__ != null) {
                                            EqualNode equalNode__ = this.uint8Array_equalNode_;
                                            if (equalNode__ != null) {
                                                if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value__))) {
                                                    return doUint8Array(arguments0Value__, arguments1Value__, arguments2Value_, getOptionsObjectNode__, getAlphabetNode__, getLastChunkHandlingNode__, charAtNode__, equalNode__);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doNotString(JSTypedArrayObject, Object, Object)] */) {
                        if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value__)) && (!(JSGuards.isString(arguments1Value_)))) {
                            return SetFromBase64Node.doNotString(arguments0Value__, arguments1Value_, arguments2Value_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doNotUint8Array(Object, Object, Object)] */) {
                    if (fallbackGuard_(arguments0Value_, arguments1Value_, arguments2Value_)) {
                        return SetFromBase64Node.doNotUint8Array(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof JSTypedArrayObject) {
                JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                if (arguments1Value instanceof TruffleString) {
                    TruffleString arguments1Value_ = (TruffleString) arguments1Value;
                    if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_))) {
                        GetOptionsObjectNode getOptionsObjectNode__ = this.insert((GetOptionsObjectNodeGen.create(getContext())));
                        Objects.requireNonNull(getOptionsObjectNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.uint8Array_getOptionsObjectNode_ = getOptionsObjectNode__;
                        PropertyGetNode getAlphabetNode__ = this.insert((PropertyGetNode.create(Strings.ALPHABET, getContext())));
                        Objects.requireNonNull(getAlphabetNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.uint8Array_getAlphabetNode_ = getAlphabetNode__;
                        PropertyGetNode getLastChunkHandlingNode__ = this.insert((PropertyGetNode.create(Strings.LAST_CHUNK_HANDLING, getContext())));
                        Objects.requireNonNull(getLastChunkHandlingNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.uint8Array_getLastChunkHandlingNode_ = getLastChunkHandlingNode__;
                        ReadCharUTF16Node charAtNode__ = this.insert((ReadCharUTF16Node.create()));
                        Objects.requireNonNull(charAtNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.uint8Array_charAtNode_ = charAtNode__;
                        EqualNode equalNode__ = this.insert((EqualNode.create()));
                        Objects.requireNonNull(equalNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.uint8Array_equalNode_ = equalNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doUint8Array(JSTypedArrayObject, TruffleString, Object, GetOptionsObjectNode, PropertyGetNode, PropertyGetNode, ReadCharUTF16Node, EqualNode)] */;
                        this.state_0_ = state_0;
                        return doUint8Array(arguments0Value_, arguments1Value_, arguments2Value, getOptionsObjectNode__, getAlphabetNode__, getLastChunkHandlingNode__, charAtNode__, equalNode__);
                    }
                }
                if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_)) && (!(JSGuards.isString(arguments1Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doNotString(JSTypedArrayObject, Object, Object)] */;
                    this.state_0_ = state_0;
                    return SetFromBase64Node.doNotString(arguments0Value_, arguments1Value, arguments2Value);
                }
            }
            state_0 = state_0 | 0b100 /* add SpecializationActive[Uint8ArrayBuiltins.SetFromBase64Node.doNotUint8Array(Object, Object, Object)] */;
            this.state_0_ = state_0;
            return SetFromBase64Node.doNotUint8Array(arguments0Value, arguments1Value, arguments2Value);
        }

        @NeverDefault
        public static SetFromBase64Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new SetFromBase64NodeGen(context, builtin, arguments);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Uint8ArrayFromBase64Node#doString}
     *     Activation probability: 0.65000
     *     With/without class size: 30/24 bytes
     *   Specialization {@link Uint8ArrayFromBase64Node#doNotString}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre> */
    @GeneratedBy(Uint8ArrayFromBase64Node.class)
    @SuppressWarnings("javadoc")
    public static final class Uint8ArrayFromBase64NodeGen extends Uint8ArrayFromBase64Node {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link Uint8ArrayFromBase64Node#doString}
         *   1: SpecializationActive {@link Uint8ArrayFromBase64Node#doNotString}
         * </pre> */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Uint8ArrayFromBase64Node#doString}
         *   Parameter: {@link GetOptionsObjectNode} getOptionsObjectNode</pre> */
        @Child private GetOptionsObjectNode string_getOptionsObjectNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Uint8ArrayFromBase64Node#doString}
         *   Parameter: {@link PropertyGetNode} getAlphabetNode</pre> */
        @Child private PropertyGetNode string_getAlphabetNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Uint8ArrayFromBase64Node#doString}
         *   Parameter: {@link PropertyGetNode} getLastChunkHandlingNode</pre> */
        @Child private PropertyGetNode string_getLastChunkHandlingNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Uint8ArrayFromBase64Node#doString}
         *   Parameter: {@link ArraySpeciesConstructorNode} constructTypedArrayNode</pre> */
        @Child private ArraySpeciesConstructorNode string_constructTypedArrayNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Uint8ArrayFromBase64Node#doString}
         *   Parameter: {@link ReadCharUTF16Node} charAtNode</pre> */
        @Child private ReadCharUTF16Node string_charAtNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Uint8ArrayFromBase64Node#doString}
         *   Parameter: {@link EqualNode} equalNode</pre> */
        @Child private EqualNode string_equalNode_;

        private Uint8ArrayFromBase64NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arguments0Value, Object arguments1Value) {
            if (!((state_0 & 0b1) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromBase64Node.doString(TruffleString, Object, GetOptionsObjectNode, PropertyGetNode, PropertyGetNode, ArraySpeciesConstructorNode, ReadCharUTF16Node, EqualNode)] */) && arguments0Value instanceof TruffleString) {
                return false;
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 /* is SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromBase64Node.doString(TruffleString, Object, GetOptionsObjectNode, PropertyGetNode, PropertyGetNode, ArraySpeciesConstructorNode, ReadCharUTF16Node, EqualNode)] || SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromBase64Node.doNotString(Object, Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromBase64Node.doString(TruffleString, Object, GetOptionsObjectNode, PropertyGetNode, PropertyGetNode, ArraySpeciesConstructorNode, ReadCharUTF16Node, EqualNode)] */ && arguments0Value_ instanceof TruffleString) {
                    TruffleString arguments0Value__ = (TruffleString) arguments0Value_;
                    {
                        GetOptionsObjectNode getOptionsObjectNode__ = this.string_getOptionsObjectNode_;
                        if (getOptionsObjectNode__ != null) {
                            PropertyGetNode getAlphabetNode__ = this.string_getAlphabetNode_;
                            if (getAlphabetNode__ != null) {
                                PropertyGetNode getLastChunkHandlingNode__ = this.string_getLastChunkHandlingNode_;
                                if (getLastChunkHandlingNode__ != null) {
                                    ArraySpeciesConstructorNode constructTypedArrayNode__ = this.string_constructTypedArrayNode_;
                                    if (constructTypedArrayNode__ != null) {
                                        ReadCharUTF16Node charAtNode__ = this.string_charAtNode_;
                                        if (charAtNode__ != null) {
                                            EqualNode equalNode__ = this.string_equalNode_;
                                            if (equalNode__ != null) {
                                                return doString(arguments0Value__, arguments1Value_, getOptionsObjectNode__, getAlphabetNode__, getLastChunkHandlingNode__, constructTypedArrayNode__, charAtNode__, equalNode__);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromBase64Node.doNotString(Object, Object)] */) {
                    if (fallbackGuard_(state_0, arguments0Value_, arguments1Value_)) {
                        return Uint8ArrayFromBase64Node.doNotString(arguments0Value_, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof TruffleString) {
                TruffleString arguments0Value_ = (TruffleString) arguments0Value;
                GetOptionsObjectNode getOptionsObjectNode__ = this.insert((GetOptionsObjectNodeGen.create(getContext())));
                Objects.requireNonNull(getOptionsObjectNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_getOptionsObjectNode_ = getOptionsObjectNode__;
                PropertyGetNode getAlphabetNode__ = this.insert((PropertyGetNode.create(Strings.ALPHABET, getContext())));
                Objects.requireNonNull(getAlphabetNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_getAlphabetNode_ = getAlphabetNode__;
                PropertyGetNode getLastChunkHandlingNode__ = this.insert((PropertyGetNode.create(Strings.LAST_CHUNK_HANDLING, getContext())));
                Objects.requireNonNull(getLastChunkHandlingNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_getLastChunkHandlingNode_ = getLastChunkHandlingNode__;
                ArraySpeciesConstructorNode constructTypedArrayNode__ = this.insert((ArraySpeciesConstructorNode.create(getContext(), true)));
                Objects.requireNonNull(constructTypedArrayNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_constructTypedArrayNode_ = constructTypedArrayNode__;
                ReadCharUTF16Node charAtNode__ = this.insert((ReadCharUTF16Node.create()));
                Objects.requireNonNull(charAtNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_charAtNode_ = charAtNode__;
                EqualNode equalNode__ = this.insert((EqualNode.create()));
                Objects.requireNonNull(equalNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_equalNode_ = equalNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromBase64Node.doString(TruffleString, Object, GetOptionsObjectNode, PropertyGetNode, PropertyGetNode, ArraySpeciesConstructorNode, ReadCharUTF16Node, EqualNode)] */;
                this.state_0_ = state_0;
                return doString(arguments0Value_, arguments1Value, getOptionsObjectNode__, getAlphabetNode__, getLastChunkHandlingNode__, constructTypedArrayNode__, charAtNode__, equalNode__);
            }
            state_0 = state_0 | 0b10 /* add SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromBase64Node.doNotString(Object, Object)] */;
            this.state_0_ = state_0;
            return Uint8ArrayFromBase64Node.doNotString(arguments0Value, arguments1Value);
        }

        @NeverDefault
        public static Uint8ArrayFromBase64Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new Uint8ArrayFromBase64NodeGen(context, builtin, arguments);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link SetFromHexNode#doUint8Array}
     *     Activation probability: 0.48333
     *     With/without class size: 13/4 bytes
     *   Specialization {@link SetFromHexNode#doNotString}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link SetFromHexNode#doNotUint8Array}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre> */
    @GeneratedBy(SetFromHexNode.class)
    @SuppressWarnings("javadoc")
    public static final class SetFromHexNodeGen extends SetFromHexNode {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link SetFromHexNode#doUint8Array}
         *   1: SpecializationActive {@link SetFromHexNode#doNotString}
         *   2: SpecializationActive {@link SetFromHexNode#doNotUint8Array}
         * </pre> */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link SetFromHexNode#doUint8Array}
         *   Parameter: {@link ReadCharUTF16Node} charAtNode</pre> */
        @Child private ReadCharUTF16Node uint8Array_charAtNode_;

        private SetFromHexNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(Object arguments0Value, Object arguments1Value) {
            if (arguments0Value instanceof JSTypedArrayObject) {
                if (arguments1Value instanceof TruffleString) {
                    JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                    if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_))) {
                        return false;
                    }
                }
                {
                    JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                    if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_)) && (!(JSGuards.isString(arguments1Value)))) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doUint8Array(JSTypedArrayObject, TruffleString, ReadCharUTF16Node)] || SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doNotString(JSTypedArrayObject, Object)] || SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doNotUint8Array(Object, Object)] */) {
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doUint8Array(JSTypedArrayObject, TruffleString, ReadCharUTF16Node)] || SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doNotString(JSTypedArrayObject, Object)] */ && arguments0Value_ instanceof JSTypedArrayObject) {
                    JSTypedArrayObject arguments0Value__ = (JSTypedArrayObject) arguments0Value_;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doUint8Array(JSTypedArrayObject, TruffleString, ReadCharUTF16Node)] */ && arguments1Value_ instanceof TruffleString) {
                        TruffleString arguments1Value__ = (TruffleString) arguments1Value_;
                        {
                            ReadCharUTF16Node charAtNode__ = this.uint8Array_charAtNode_;
                            if (charAtNode__ != null) {
                                if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value__))) {
                                    return doUint8Array(arguments0Value__, arguments1Value__, charAtNode__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doNotString(JSTypedArrayObject, Object)] */) {
                        if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value__)) && (!(JSGuards.isString(arguments1Value_)))) {
                            return SetFromHexNode.doNotString(arguments0Value__, arguments1Value_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doNotUint8Array(Object, Object)] */) {
                    if (fallbackGuard_(arguments0Value_, arguments1Value_)) {
                        return SetFromHexNode.doNotUint8Array(arguments0Value_, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof JSTypedArrayObject) {
                JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                if (arguments1Value instanceof TruffleString) {
                    TruffleString arguments1Value_ = (TruffleString) arguments1Value;
                    if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_))) {
                        ReadCharUTF16Node charAtNode__ = this.insert((ReadCharUTF16Node.create()));
                        Objects.requireNonNull(charAtNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.uint8Array_charAtNode_ = charAtNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doUint8Array(JSTypedArrayObject, TruffleString, ReadCharUTF16Node)] */;
                        this.state_0_ = state_0;
                        return doUint8Array(arguments0Value_, arguments1Value_, charAtNode__);
                    }
                }
                if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_)) && (!(JSGuards.isString(arguments1Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doNotString(JSTypedArrayObject, Object)] */;
                    this.state_0_ = state_0;
                    return SetFromHexNode.doNotString(arguments0Value_, arguments1Value);
                }
            }
            state_0 = state_0 | 0b100 /* add SpecializationActive[Uint8ArrayBuiltins.SetFromHexNode.doNotUint8Array(Object, Object)] */;
            this.state_0_ = state_0;
            return SetFromHexNode.doNotUint8Array(arguments0Value, arguments1Value);
        }

        @NeverDefault
        public static SetFromHexNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new SetFromHexNodeGen(context, builtin, arguments);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Uint8ArrayFromHexNode#doString}
     *     Activation probability: 0.65000
     *     With/without class size: 19/8 bytes
     *   Specialization {@link Uint8ArrayFromHexNode#doNotString}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre> */
    @GeneratedBy(Uint8ArrayFromHexNode.class)
    @SuppressWarnings("javadoc")
    public static final class Uint8ArrayFromHexNodeGen extends Uint8ArrayFromHexNode {

        @Child private JavaScriptNode arguments0_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link Uint8ArrayFromHexNode#doString}
         *   1: SpecializationActive {@link Uint8ArrayFromHexNode#doNotString}
         * </pre> */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Uint8ArrayFromHexNode#doString}
         *   Parameter: {@link ArraySpeciesConstructorNode} constructTypedArrayNode</pre> */
        @Child private ArraySpeciesConstructorNode string_constructTypedArrayNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link Uint8ArrayFromHexNode#doString}
         *   Parameter: {@link ReadCharUTF16Node} charAtNode</pre> */
        @Child private ReadCharUTF16Node string_charAtNode_;

        private Uint8ArrayFromHexNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arguments0Value) {
            if (!((state_0 & 0b1) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromHexNode.doString(TruffleString, ArraySpeciesConstructorNode, ReadCharUTF16Node)] */) && arguments0Value instanceof TruffleString) {
                return false;
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state_0 != 0 /* is SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromHexNode.doString(TruffleString, ArraySpeciesConstructorNode, ReadCharUTF16Node)] || SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromHexNode.doNotString(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromHexNode.doString(TruffleString, ArraySpeciesConstructorNode, ReadCharUTF16Node)] */ && arguments0Value_ instanceof TruffleString) {
                    TruffleString arguments0Value__ = (TruffleString) arguments0Value_;
                    {
                        ArraySpeciesConstructorNode constructTypedArrayNode__ = this.string_constructTypedArrayNode_;
                        if (constructTypedArrayNode__ != null) {
                            ReadCharUTF16Node charAtNode__ = this.string_charAtNode_;
                            if (charAtNode__ != null) {
                                return doString(arguments0Value__, constructTypedArrayNode__, charAtNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromHexNode.doNotString(Object)] */) {
                    if (fallbackGuard_(state_0, arguments0Value_)) {
                        return Uint8ArrayFromHexNode.doNotString(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof TruffleString) {
                TruffleString arguments0Value_ = (TruffleString) arguments0Value;
                ArraySpeciesConstructorNode constructTypedArrayNode__ = this.insert((ArraySpeciesConstructorNode.create(getContext(), true)));
                Objects.requireNonNull(constructTypedArrayNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_constructTypedArrayNode_ = constructTypedArrayNode__;
                ReadCharUTF16Node charAtNode__ = this.insert((ReadCharUTF16Node.create()));
                Objects.requireNonNull(charAtNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.string_charAtNode_ = charAtNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromHexNode.doString(TruffleString, ArraySpeciesConstructorNode, ReadCharUTF16Node)] */;
                this.state_0_ = state_0;
                return doString(arguments0Value_, constructTypedArrayNode__, charAtNode__);
            }
            state_0 = state_0 | 0b10 /* add SpecializationActive[Uint8ArrayBuiltins.Uint8ArrayFromHexNode.doNotString(Object)] */;
            this.state_0_ = state_0;
            return Uint8ArrayFromHexNode.doNotString(arguments0Value);
        }

        @NeverDefault
        public static Uint8ArrayFromHexNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new Uint8ArrayFromHexNodeGen(context, builtin, arguments);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ToBase64Node#doUint8Array}
     *     Activation probability: 0.65000
     *     With/without class size: 30/24 bytes
     *   Specialization {@link ToBase64Node#doNotUint8Array}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre> */
    @GeneratedBy(ToBase64Node.class)
    @SuppressWarnings("javadoc")
    public static final class ToBase64NodeGen extends ToBase64Node {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link ToBase64Node#doUint8Array}
         *   1: SpecializationActive {@link ToBase64Node#doNotUint8Array}
         * </pre> */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToBase64Node#doUint8Array}
         *   Parameter: {@link GetOptionsObjectNode} getOptionsObjectNode</pre> */
        @Child private GetOptionsObjectNode uint8Array_getOptionsObjectNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToBase64Node#doUint8Array}
         *   Parameter: {@link PropertyGetNode} getAlphabetNode</pre> */
        @Child private PropertyGetNode uint8Array_getAlphabetNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToBase64Node#doUint8Array}
         *   Parameter: {@link GetBooleanOptionNode} getOmitPaddingOptionNode</pre> */
        @Child private GetBooleanOptionNode uint8Array_getOmitPaddingOptionNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToBase64Node#doUint8Array}
         *   Parameter: {@link InteropLibrary} interop</pre> */
        @Child private InteropLibrary uint8Array_interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToBase64Node#doUint8Array}
         *   Parameter: {@link EqualNode} equalNode</pre> */
        @Child private EqualNode uint8Array_equalNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToBase64Node#doUint8Array}
         *   Parameter: {@link FromJavaStringNode} fromJavaStringNode</pre> */
        @Child private FromJavaStringNode uint8Array_fromJavaStringNode_;

        private ToBase64NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(Object arguments0Value, Object arguments1Value) {
            if (arguments0Value instanceof JSTypedArrayObject) {
                JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_))) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 /* is SpecializationActive[Uint8ArrayBuiltins.ToBase64Node.doUint8Array(JSTypedArrayObject, Object, GetOptionsObjectNode, PropertyGetNode, GetBooleanOptionNode, InteropLibrary, EqualNode, FromJavaStringNode)] || SpecializationActive[Uint8ArrayBuiltins.ToBase64Node.doNotUint8Array(Object, Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.ToBase64Node.doUint8Array(JSTypedArrayObject, Object, GetOptionsObjectNode, PropertyGetNode, GetBooleanOptionNode, InteropLibrary, EqualNode, FromJavaStringNode)] */ && arguments0Value_ instanceof JSTypedArrayObject) {
                    JSTypedArrayObject arguments0Value__ = (JSTypedArrayObject) arguments0Value_;
                    {
                        GetOptionsObjectNode getOptionsObjectNode__ = this.uint8Array_getOptionsObjectNode_;
                        if (getOptionsObjectNode__ != null) {
                            PropertyGetNode getAlphabetNode__ = this.uint8Array_getAlphabetNode_;
                            if (getAlphabetNode__ != null) {
                                GetBooleanOptionNode getOmitPaddingOptionNode__ = this.uint8Array_getOmitPaddingOptionNode_;
                                if (getOmitPaddingOptionNode__ != null) {
                                    InteropLibrary interop__ = this.uint8Array_interop_;
                                    if (interop__ != null) {
                                        EqualNode equalNode__ = this.uint8Array_equalNode_;
                                        if (equalNode__ != null) {
                                            FromJavaStringNode fromJavaStringNode__ = this.uint8Array_fromJavaStringNode_;
                                            if (fromJavaStringNode__ != null) {
                                                if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value__))) {
                                                    return doUint8Array(arguments0Value__, arguments1Value_, getOptionsObjectNode__, getAlphabetNode__, getOmitPaddingOptionNode__, interop__, equalNode__, fromJavaStringNode__);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.ToBase64Node.doNotUint8Array(Object, Object)] */) {
                    if (fallbackGuard_(arguments0Value_, arguments1Value_)) {
                        return ToBase64Node.doNotUint8Array(arguments0Value_, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof JSTypedArrayObject) {
                JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_))) {
                    GetOptionsObjectNode getOptionsObjectNode__ = this.insert((GetOptionsObjectNodeGen.create(getContext())));
                    Objects.requireNonNull(getOptionsObjectNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.uint8Array_getOptionsObjectNode_ = getOptionsObjectNode__;
                    PropertyGetNode getAlphabetNode__ = this.insert((PropertyGetNode.create(Strings.ALPHABET, getContext())));
                    Objects.requireNonNull(getAlphabetNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.uint8Array_getAlphabetNode_ = getAlphabetNode__;
                    GetBooleanOptionNode getOmitPaddingOptionNode__ = this.insert((GetBooleanOptionNode.create(getContext(), Strings.OMIT_PADDING, Boolean.FALSE)));
                    Objects.requireNonNull(getOmitPaddingOptionNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.uint8Array_getOmitPaddingOptionNode_ = getOmitPaddingOptionNode__;
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                    Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.uint8Array_interop_ = interop__;
                    EqualNode equalNode__ = this.insert((EqualNode.create()));
                    Objects.requireNonNull(equalNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.uint8Array_equalNode_ = equalNode__;
                    FromJavaStringNode fromJavaStringNode__ = this.insert((FromJavaStringNode.create()));
                    Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.uint8Array_fromJavaStringNode_ = fromJavaStringNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[Uint8ArrayBuiltins.ToBase64Node.doUint8Array(JSTypedArrayObject, Object, GetOptionsObjectNode, PropertyGetNode, GetBooleanOptionNode, InteropLibrary, EqualNode, FromJavaStringNode)] */;
                    this.state_0_ = state_0;
                    return doUint8Array(arguments0Value_, arguments1Value, getOptionsObjectNode__, getAlphabetNode__, getOmitPaddingOptionNode__, interop__, equalNode__, fromJavaStringNode__);
                }
            }
            state_0 = state_0 | 0b10 /* add SpecializationActive[Uint8ArrayBuiltins.ToBase64Node.doNotUint8Array(Object, Object)] */;
            this.state_0_ = state_0;
            return ToBase64Node.doNotUint8Array(arguments0Value, arguments1Value);
        }

        @NeverDefault
        public static ToBase64Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ToBase64NodeGen(context, builtin, arguments);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ToHexNode#doUint8Array}
     *     Activation probability: 0.65000
     *     With/without class size: 22/12 bytes
     *   Specialization {@link ToHexNode#doNotUint8Array}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre> */
    @GeneratedBy(ToHexNode.class)
    @SuppressWarnings("javadoc")
    public static final class ToHexNodeGen extends ToHexNode {

        @Child private JavaScriptNode arguments0_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link ToHexNode#doUint8Array}
         *   1: SpecializationActive {@link ToHexNode#doNotUint8Array}
         * </pre> */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToHexNode#doUint8Array}
         *   Parameter: {@link InteropLibrary} interop</pre> */
        @Child private InteropLibrary uint8Array_interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToHexNode#doUint8Array}
         *   Parameter: {@link FromByteArrayNode} fromByteArrayNode</pre> */
        @Child private FromByteArrayNode uint8Array_fromByteArrayNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToHexNode#doUint8Array}
         *   Parameter: {@link SwitchEncodingNode} switchEncodingNode</pre> */
        @Child private SwitchEncodingNode uint8Array_switchEncodingNode_;

        private ToHexNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(Object arguments0Value) {
            if (arguments0Value instanceof JSTypedArrayObject) {
                JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_))) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state_0 != 0 /* is SpecializationActive[Uint8ArrayBuiltins.ToHexNode.doUint8Array(JSTypedArrayObject, InteropLibrary, FromByteArrayNode, SwitchEncodingNode)] || SpecializationActive[Uint8ArrayBuiltins.ToHexNode.doNotUint8Array(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.ToHexNode.doUint8Array(JSTypedArrayObject, InteropLibrary, FromByteArrayNode, SwitchEncodingNode)] */ && arguments0Value_ instanceof JSTypedArrayObject) {
                    JSTypedArrayObject arguments0Value__ = (JSTypedArrayObject) arguments0Value_;
                    {
                        InteropLibrary interop__ = this.uint8Array_interop_;
                        if (interop__ != null) {
                            FromByteArrayNode fromByteArrayNode__ = this.uint8Array_fromByteArrayNode_;
                            if (fromByteArrayNode__ != null) {
                                SwitchEncodingNode switchEncodingNode__ = this.uint8Array_switchEncodingNode_;
                                if (switchEncodingNode__ != null) {
                                    if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value__))) {
                                        return doUint8Array(arguments0Value__, interop__, fromByteArrayNode__, switchEncodingNode__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[Uint8ArrayBuiltins.ToHexNode.doNotUint8Array(Object)] */) {
                    if (fallbackGuard_(arguments0Value_)) {
                        return ToHexNode.doNotUint8Array(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof JSTypedArrayObject) {
                JSTypedArrayObject arguments0Value_ = (JSTypedArrayObject) arguments0Value;
                if ((Uint8ArrayBaseNode.isUint8Array(arguments0Value_))) {
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                    Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.uint8Array_interop_ = interop__;
                    FromByteArrayNode fromByteArrayNode__ = this.insert((FromByteArrayNode.create()));
                    Objects.requireNonNull(fromByteArrayNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.uint8Array_fromByteArrayNode_ = fromByteArrayNode__;
                    SwitchEncodingNode switchEncodingNode__ = this.insert((SwitchEncodingNode.create()));
                    Objects.requireNonNull(switchEncodingNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.uint8Array_switchEncodingNode_ = switchEncodingNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[Uint8ArrayBuiltins.ToHexNode.doUint8Array(JSTypedArrayObject, InteropLibrary, FromByteArrayNode, SwitchEncodingNode)] */;
                    this.state_0_ = state_0;
                    return doUint8Array(arguments0Value_, interop__, fromByteArrayNode__, switchEncodingNode__);
                }
            }
            state_0 = state_0 | 0b10 /* add SpecializationActive[Uint8ArrayBuiltins.ToHexNode.doNotUint8Array(Object)] */;
            this.state_0_ = state_0;
            return ToHexNode.doNotUint8Array(arguments0Value);
        }

        @NeverDefault
        public static ToHexNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ToHexNodeGen(context, builtin, arguments);
        }

    }
}
