// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.JSOverloadedUnaryNode;
import com.oracle.truffle.js.nodes.unary.JSOverloadedUnaryNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSAddSubNumericUnitNode#doInt}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSAddSubNumericUnitNode#doDouble}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSAddSubNumericUnitNode#doBigInt}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSAddSubNumericUnitNode#doJavaNumber}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSAddSubNumericUnitNode#doOverloaded}
 *     Activation probability: 0.08000
 *     With/without class size: 5/4 bytes
 * </pre> */
@GeneratedBy(JSAddSubNumericUnitNode.class)
@SuppressWarnings("javadoc")
public final class JSAddSubNumericUnitNodeGen extends JSAddSubNumericUnitNode {

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSAddSubNumericUnitNode#doInt}
     *   1: SpecializationExcluded {@link JSAddSubNumericUnitNode#doInt}
     *   2: SpecializationActive {@link JSAddSubNumericUnitNode#doDouble}
     *   3: SpecializationActive {@link JSAddSubNumericUnitNode#doBigInt}
     *   4: SpecializationActive {@link JSAddSubNumericUnitNode#doJavaNumber}
     *   5: SpecializationActive {@link JSAddSubNumericUnitNode#doOverloaded}
     *   6-8: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSAddSubNumericUnitNode#doOverloaded}
     *   Parameter: {@link JSOverloadedUnaryNode} overloadedOperatorNode</pre> */
    @Child private JSOverloadedUnaryNode overloaded_overloadedOperatorNode_;

    private JSAddSubNumericUnitNodeGen(JavaScriptNode operand, boolean isAddition, boolean truncate) {
        super(operand, isAddition, truncate);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111100) == 0 /* only-active SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] && SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] && SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */)) {
            return execute_int0(state_0, frameValue);
        } else if ((state_0 & 0b111001) == 0 /* only-active SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] && SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] && SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */)) {
            return execute_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */;
        try {
            return doInt(operandNodeValue_);
        } catch (ArithmeticException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            state_0 = this.state_0_;
            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */;
            state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
            this.state_0_ = state_0;
            return executeAndSpecialize(operandNodeValue_);
        }
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] && SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] && SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] && SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] && SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] */;
        return doDouble(operandNodeValue_);
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b111101) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] || SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] || SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] || SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] || SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */ && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (int) operandNodeValue_;
                try {
                    return doInt(operandNodeValue__);
                } catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */;
                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return executeAndSpecialize(operandNodeValue__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                return doDouble(operandNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] */ && operandNodeValue_ instanceof BigInt) {
                BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
                return doBigInt(operandNodeValue__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] */) {
                if ((JSGuards.isJavaNumber(operandNodeValue_))) {
                    return doJavaNumber(operandNodeValue_);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */ && operandNodeValue_ instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue__ = (JSOverloadedOperatorsObject) operandNodeValue_;
                {
                    JSOverloadedUnaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                    if (overloadedOperatorNode__ != null) {
                        return doOverloaded(operandNodeValue__, overloadedOperatorNode__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        if ((state_0 & 0b10000) == 0 /* only-active SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] */ && ((state_0 & 0b10100) != 0  /* is-not SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] */)) {
            return executeDouble_double3(state_0, frameValue);
        } else {
            return executeDouble_generic4(state_0, frameValue);
        }
    }

    private double executeDouble_double3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] && SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] && SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] && SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] && SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult()));
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] */;
        return doDouble(operandNodeValue_);
    }

    private double executeDouble_generic4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b10100) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] || SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] */) {
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                return doDouble(operandNodeValue__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] */) {
                if ((JSGuards.isJavaNumber(operandNodeValue_))) {
                    return doJavaNumber(operandNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
        }
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */) {
            try {
                return doInt(operandNodeValue_);
            } catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */;
                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                this.state_0_ = state_0;
                return JSTypesGen.expectInteger(executeAndSpecialize(operandNodeValue_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b111100) == 0 /* only-active SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] && SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] && SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */)) {
                this.executeInt(frameValue);
                return;
            } else if ((state_0 & 0b101001) == 0 /* only-active SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] && SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] && SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] && SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] && SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */)) {
                this.executeDouble(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] */ && ((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */ && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (int) operandNodeValue;
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */;
            this.state_0_ = state_0;
            try {
                return doInt(operandNodeValue_);
            } catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */;
                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                this.state_0_ = state_0;
                return executeAndSpecialize(operandNodeValue_);
            }
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSAddSubNumericUnitNode.doInt(int)] */;
                state_0 = (state_0 | (doubleCast0 << 6) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b100 /* add SpecializationActive[JSAddSubNumericUnitNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return doDouble(operandNodeValue_);
            }
        }
        if (operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt) operandNodeValue;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[JSAddSubNumericUnitNode.doBigInt(BigInt)] */;
            this.state_0_ = state_0;
            return doBigInt(operandNodeValue_);
        }
        if ((JSGuards.isJavaNumber(operandNodeValue))) {
            state_0 = state_0 | 0b10000 /* add SpecializationActive[JSAddSubNumericUnitNode.doJavaNumber(Object)] */;
            this.state_0_ = state_0;
            return doJavaNumber(operandNodeValue);
        }
        if (operandNodeValue instanceof JSOverloadedOperatorsObject) {
            JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject) operandNodeValue;
            JSOverloadedUnaryNode overloadedOperatorNode__ = this.insert((JSOverloadedUnaryNodeGen.create(getOverloadedOperatorName())));
            Objects.requireNonNull(overloadedOperatorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.overloaded_overloadedOperatorNode_ = overloadedOperatorNode__;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSAddSubNumericUnitNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */;
            this.state_0_ = state_0;
            return doOverloaded(operandNodeValue_, overloadedOperatorNode__);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.operandNode}, operandNodeValue);
    }

    @NeverDefault
    public static JSAddSubNumericUnitNode create(JavaScriptNode operand, boolean isAddition, boolean truncate) {
        return new JSAddSubNumericUnitNodeGen(operand, isAddition, truncate);
    }

}
