// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.SafeInteger;

/**
 * Debug Info: <pre>
 *   Specialization {@link IsNumberNode#doInt}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link IsNumberNode#doSafeInteger}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link IsNumberNode#doDouble}
 *     Activation probability: 0.20500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link IsNumberNode#doOther}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre> */
@GeneratedBy(IsNumberNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class IsNumberNodeGen {

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * </ul> */
    @NeverDefault
    public static IsNumberNode inline(@RequiredField(bits = 7, value = StateField.class) InlineTarget target) {
        return new IsNumberNodeGen.Inlined(target);
    }

    @GeneratedBy(IsNumberNode.class)
    @DenyReplace
    private static final class Inlined extends IsNumberNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link IsNumberNode#doInt}
         *   1: SpecializationActive {@link IsNumberNode#doSafeInteger}
         *   2: SpecializationActive {@link IsNumberNode#doDouble}
         *   3: SpecializationActive {@link IsNumberNode#doOther}
         *   4-6: ImplicitCast[type=double, index=1]
         * </pre> */
        private final StateField state_0_;

        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(IsNumberNode.class);
            this.state_0_ = target.getState(0, 7);
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value) {
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[IsNumberNode.doDouble(double)] */
             && (state_0 & 0b1110000) == 0b1110000) && JSTypesGen.isImplicitDouble(arg1Value)) {
                return false;
            }
            return true;
        }

        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b1111) != 0 /* is SpecializationActive[IsNumberNode.doInt(int)] || SpecializationActive[IsNumberNode.doSafeInteger(SafeInteger)] || SpecializationActive[IsNumberNode.doDouble(double)] || SpecializationActive[IsNumberNode.doOther(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[IsNumberNode.doInt(int)] */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    return IsNumberNode.doInt(arg1Value_);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[IsNumberNode.doSafeInteger(SafeInteger)] */ && arg1Value instanceof SafeInteger) {
                    SafeInteger arg1Value_ = (SafeInteger) arg1Value;
                    return IsNumberNode.doSafeInteger(arg1Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[IsNumberNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                    return IsNumberNode.doDouble(arg1Value_);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IsNumberNode.doOther(Object)] */) {
                    if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IsNumberNode.doOther(arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[IsNumberNode.doInt(int)] */;
                this.state_0_.set(arg0Value, state_0);
                return IsNumberNode.doInt(arg1Value_);
            }
            if (arg1Value instanceof SafeInteger) {
                SafeInteger arg1Value_ = (SafeInteger) arg1Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[IsNumberNode.doSafeInteger(SafeInteger)] */;
                this.state_0_.set(arg0Value, state_0);
                return IsNumberNode.doSafeInteger(arg1Value_);
            }
            {
                int doubleCast1;
                if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                    state_0 = (state_0 | (doubleCast1 << 4) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b100 /* add SpecializationActive[IsNumberNode.doDouble(double)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return IsNumberNode.doDouble(arg1Value_);
                }
            }
            state_0 = state_0 | 0b1000 /* add SpecializationActive[IsNumberNode.doOther(Object)] */;
            this.state_0_.set(arg0Value, state_0);
            return IsNumberNode.doOther(arg1Value);
        }

    }
}
