// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.js.nodes.JSTypesGen;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSNumberToDoubleNode#doInt}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link JSNumberToDoubleNode#doDouble}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre> */
@GeneratedBy(JSNumberToDoubleNode.class)
@SuppressWarnings("javadoc")
public final class JSNumberToDoubleNodeGen {

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * </ul> */
    @NeverDefault
    public static JSNumberToDoubleNode inline(@RequiredField(bits = 5, value = StateField.class) InlineTarget target) {
        return new JSNumberToDoubleNodeGen.Inlined(target);
    }

    @GeneratedBy(JSNumberToDoubleNode.class)
    @DenyReplace
    private static final class Inlined extends JSNumberToDoubleNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link JSNumberToDoubleNode#doInt}
         *   1: SpecializationActive {@link JSNumberToDoubleNode#doDouble}
         *   2-4: ImplicitCast[type=double, index=1]
         * </pre> */
        private final StateField state_0_;

        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(JSNumberToDoubleNode.class);
            this.state_0_ = target.getState(0, 5);
        }

        @Override
        public double execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b11) != 0 /* is SpecializationActive[JSNumberToDoubleNode.doInt(int)] || SpecializationActive[JSNumberToDoubleNode.doDouble(double)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSNumberToDoubleNode.doInt(int)] */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    return JSNumberToDoubleNode.doInt(arg1Value_);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSNumberToDoubleNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                    return JSNumberToDoubleNode.doDouble(arg1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private double executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSNumberToDoubleNode.doInt(int)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSNumberToDoubleNode.doInt(arg1Value_);
            }
            {
                int doubleCast1;
                if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                    state_0 = (state_0 | (doubleCast1 << 2) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[JSNumberToDoubleNode.doDouble(double)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return JSNumberToDoubleNode.doDouble(arg1Value_);
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
        }

    }
}
