// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Symbol;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSToBooleanUnaryNode#doBoolean}
 *     Activation probability: 0.15909
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doNull}
 *     Activation probability: 0.14545
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doUndefined}
 *     Activation probability: 0.13182
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doInt}
 *     Activation probability: 0.11818
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doLong}
 *     Activation probability: 0.10455
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doDouble}
 *     Activation probability: 0.09091
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doBigInt}
 *     Activation probability: 0.07727
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doString}
 *     Activation probability: 0.06364
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doObject}
 *     Activation probability: 0.05000
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doSymbol}
 *     Activation probability: 0.03636
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToBooleanUnaryNode#doForeignObject}
 *     Activation probability: 0.02273
 *     With/without class size: 4/6 bytes
 * </pre> */
@GeneratedBy(JSToBooleanUnaryNode.class)
@SuppressWarnings("javadoc")
public final class JSToBooleanUnaryNodeGen extends JSToBooleanUnaryNode {

    private static final StateField FOREIGN_OBJECT_JS_TO_BOOLEAN_UNARY_NODE_FOREIGN_OBJECT_STATE_0_UPDATER = StateField.create(ForeignObjectData.lookup_(), "foreignObject_state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSToBooleanUnaryNode#doForeignObject}
     *   Parameter: {@link JSToBooleanNode} toBooleanNode
     *   Inline method: {@link JSToBooleanNodeGen#inline}</pre> */
    private static final JSToBooleanNode INLINED_FOREIGN_OBJECT_TO_BOOLEAN_NODE_ = JSToBooleanNodeGen.inline(InlineTarget.create(JSToBooleanNode.class, FOREIGN_OBJECT_JS_TO_BOOLEAN_UNARY_NODE_FOREIGN_OBJECT_STATE_0_UPDATER.subUpdater(0, 15), ReferenceField.create(ForeignObjectData.lookup_(), "foreignObject_toBooleanNode__field1_", Node.class)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSToBooleanUnaryNode#doBoolean}
     *   1: SpecializationActive {@link JSToBooleanUnaryNode#doNull}
     *   2: SpecializationActive {@link JSToBooleanUnaryNode#doUndefined}
     *   3: SpecializationActive {@link JSToBooleanUnaryNode#doInt}
     *   4: SpecializationActive {@link JSToBooleanUnaryNode#doLong}
     *   5: SpecializationActive {@link JSToBooleanUnaryNode#doDouble}
     *   6: SpecializationActive {@link JSToBooleanUnaryNode#doBigInt}
     *   7: SpecializationActive {@link JSToBooleanUnaryNode#doString}
     *   8: SpecializationActive {@link JSToBooleanUnaryNode#doObject}
     *   9: SpecializationActive {@link JSToBooleanUnaryNode#doSymbol}
     *   10: SpecializationActive {@link JSToBooleanUnaryNode#doForeignObject}
     *   11-13: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;
    @Child private ForeignObjectData foreignObject_cache;

    private JSToBooleanUnaryNodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111111110) == 0 /* only-active SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] */ && ((state_0 & 0b11111111111) != 0  /* is-not SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] && SpecializationActive[JSToBooleanUnaryNode.doNull(Object)] && SpecializationActive[JSToBooleanUnaryNode.doUndefined(Object)] && SpecializationActive[JSToBooleanUnaryNode.doInt(int)] && SpecializationActive[JSToBooleanUnaryNode.doLong(long)] && SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] && SpecializationActive[JSToBooleanUnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToBooleanUnaryNode.doString(TruffleString)] && SpecializationActive[JSToBooleanUnaryNode.doObject(Object)] && SpecializationActive[JSToBooleanUnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToBooleanUnaryNode.doForeignObject(Object, Node, JSToBooleanNode)] */)) {
            return executeBoolean_boolean0(state_0, frameValue);
        } else if ((state_0 & 0b11111110111) == 0 /* only-active SpecializationActive[JSToBooleanUnaryNode.doInt(int)] */ && ((state_0 & 0b11111111111) != 0  /* is-not SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] && SpecializationActive[JSToBooleanUnaryNode.doNull(Object)] && SpecializationActive[JSToBooleanUnaryNode.doUndefined(Object)] && SpecializationActive[JSToBooleanUnaryNode.doInt(int)] && SpecializationActive[JSToBooleanUnaryNode.doLong(long)] && SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] && SpecializationActive[JSToBooleanUnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToBooleanUnaryNode.doString(TruffleString)] && SpecializationActive[JSToBooleanUnaryNode.doObject(Object)] && SpecializationActive[JSToBooleanUnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToBooleanUnaryNode.doForeignObject(Object, Node, JSToBooleanNode)] */)) {
            return executeBoolean_int1(state_0, frameValue);
        } else if ((state_0 & 0b11111011111) == 0 /* only-active SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] */ && ((state_0 & 0b11111111111) != 0  /* is-not SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] && SpecializationActive[JSToBooleanUnaryNode.doNull(Object)] && SpecializationActive[JSToBooleanUnaryNode.doUndefined(Object)] && SpecializationActive[JSToBooleanUnaryNode.doInt(int)] && SpecializationActive[JSToBooleanUnaryNode.doLong(long)] && SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] && SpecializationActive[JSToBooleanUnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToBooleanUnaryNode.doString(TruffleString)] && SpecializationActive[JSToBooleanUnaryNode.doObject(Object)] && SpecializationActive[JSToBooleanUnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToBooleanUnaryNode.doForeignObject(Object, Node, JSToBooleanNode)] */)) {
            return executeBoolean_double2(state_0, frameValue);
        } else {
            return executeBoolean_generic3(state_0, frameValue);
        }
    }

    private boolean executeBoolean_boolean0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] */;
        return JSToBooleanUnaryNode.doBoolean(operandNodeValue_);
    }

    private boolean executeBoolean_int1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doInt(int)] */;
        return JSToBooleanUnaryNode.doInt(operandNodeValue_);
    }

    private boolean executeBoolean_double2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b11000000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111111111) != 0  /* is-not SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] && SpecializationActive[JSToBooleanUnaryNode.doNull(Object)] && SpecializationActive[JSToBooleanUnaryNode.doUndefined(Object)] && SpecializationActive[JSToBooleanUnaryNode.doInt(int)] && SpecializationActive[JSToBooleanUnaryNode.doLong(long)] && SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] && SpecializationActive[JSToBooleanUnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToBooleanUnaryNode.doString(TruffleString)] && SpecializationActive[JSToBooleanUnaryNode.doObject(Object)] && SpecializationActive[JSToBooleanUnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToBooleanUnaryNode.doForeignObject(Object, Node, JSToBooleanNode)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b10100000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111111111) != 0  /* is-not SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] && SpecializationActive[JSToBooleanUnaryNode.doNull(Object)] && SpecializationActive[JSToBooleanUnaryNode.doUndefined(Object)] && SpecializationActive[JSToBooleanUnaryNode.doInt(int)] && SpecializationActive[JSToBooleanUnaryNode.doLong(long)] && SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] && SpecializationActive[JSToBooleanUnaryNode.doBigInt(BigInt)] && SpecializationActive[JSToBooleanUnaryNode.doString(TruffleString)] && SpecializationActive[JSToBooleanUnaryNode.doObject(Object)] && SpecializationActive[JSToBooleanUnaryNode.doSymbol(Symbol)] && SpecializationActive[JSToBooleanUnaryNode.doForeignObject(Object, Node, JSToBooleanNode)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b100000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] */;
        return JSToBooleanUnaryNode.doDouble(operandNodeValue_);
    }

    private boolean executeBoolean_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b11111111111) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] || SpecializationActive[JSToBooleanUnaryNode.doNull(Object)] || SpecializationActive[JSToBooleanUnaryNode.doUndefined(Object)] || SpecializationActive[JSToBooleanUnaryNode.doInt(int)] || SpecializationActive[JSToBooleanUnaryNode.doLong(long)] || SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] || SpecializationActive[JSToBooleanUnaryNode.doBigInt(BigInt)] || SpecializationActive[JSToBooleanUnaryNode.doString(TruffleString)] || SpecializationActive[JSToBooleanUnaryNode.doObject(Object)] || SpecializationActive[JSToBooleanUnaryNode.doSymbol(Symbol)] || SpecializationActive[JSToBooleanUnaryNode.doForeignObject(Object, Node, JSToBooleanNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] */ && operandNodeValue_ instanceof Boolean) {
                boolean operandNodeValue__ = (boolean) operandNodeValue_;
                return JSToBooleanUnaryNode.doBoolean(operandNodeValue__);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doNull(Object)] || SpecializationActive[JSToBooleanUnaryNode.doUndefined(Object)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doNull(Object)] */) {
                    if ((JSGuards.isJSNull(operandNodeValue_))) {
                        return JSToBooleanUnaryNode.doNull(operandNodeValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doUndefined(Object)] */) {
                    if ((JSGuards.isUndefined(operandNodeValue_))) {
                        return JSToBooleanUnaryNode.doUndefined(operandNodeValue_);
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doInt(int)] */ && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (int) operandNodeValue_;
                return JSToBooleanUnaryNode.doInt(operandNodeValue__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doLong(long)] */ && operandNodeValue_ instanceof Long) {
                long operandNodeValue__ = (long) operandNodeValue_;
                return JSToBooleanUnaryNode.doLong(operandNodeValue__);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                return JSToBooleanUnaryNode.doDouble(operandNodeValue__);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doBigInt(BigInt)] */ && operandNodeValue_ instanceof BigInt) {
                BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
                return JSToBooleanUnaryNode.doBigInt(operandNodeValue__);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doString(TruffleString)] */ && operandNodeValue_ instanceof TruffleString) {
                TruffleString operandNodeValue__ = (TruffleString) operandNodeValue_;
                return JSToBooleanUnaryNode.doString(operandNodeValue__);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doObject(Object)] */) {
                if ((JSGuards.isJSObject(operandNodeValue_))) {
                    return JSToBooleanUnaryNode.doObject(operandNodeValue_);
                }
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doSymbol(Symbol)] */ && operandNodeValue_ instanceof Symbol) {
                Symbol operandNodeValue__ = (Symbol) operandNodeValue_;
                return JSToBooleanUnaryNode.doSymbol(operandNodeValue__);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSToBooleanUnaryNode.doForeignObject(Object, Node, JSToBooleanNode)] */) {
                ForeignObjectData s10_ = this.foreignObject_cache;
                if (s10_ != null) {
                    if ((JSGuards.isForeignObject(operandNodeValue_))) {
                        Node node__ = (s10_);
                        return JSToBooleanUnaryNode.doForeignObject(operandNodeValue_, node__, INLINED_FOREIGN_OBJECT_TO_BOOLEAN_NODE_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
        return;
    }

    private boolean executeAndSpecialize(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if (operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_ = (boolean) operandNodeValue;
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSToBooleanUnaryNode.doBoolean(boolean)] */;
            this.state_0_ = state_0;
            return JSToBooleanUnaryNode.doBoolean(operandNodeValue_);
        }
        if ((JSGuards.isJSNull(operandNodeValue))) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSToBooleanUnaryNode.doNull(Object)] */;
            this.state_0_ = state_0;
            return JSToBooleanUnaryNode.doNull(operandNodeValue);
        }
        if ((JSGuards.isUndefined(operandNodeValue))) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[JSToBooleanUnaryNode.doUndefined(Object)] */;
            this.state_0_ = state_0;
            return JSToBooleanUnaryNode.doUndefined(operandNodeValue);
        }
        if (operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (int) operandNodeValue;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[JSToBooleanUnaryNode.doInt(int)] */;
            this.state_0_ = state_0;
            return JSToBooleanUnaryNode.doInt(operandNodeValue_);
        }
        if (operandNodeValue instanceof Long) {
            long operandNodeValue_ = (long) operandNodeValue;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[JSToBooleanUnaryNode.doLong(long)] */;
            this.state_0_ = state_0;
            return JSToBooleanUnaryNode.doLong(operandNodeValue_);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                state_0 = (state_0 | (doubleCast0 << 11) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b100000 /* add SpecializationActive[JSToBooleanUnaryNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return JSToBooleanUnaryNode.doDouble(operandNodeValue_);
            }
        }
        if (operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt) operandNodeValue;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSToBooleanUnaryNode.doBigInt(BigInt)] */;
            this.state_0_ = state_0;
            return JSToBooleanUnaryNode.doBigInt(operandNodeValue_);
        }
        if (operandNodeValue instanceof TruffleString) {
            TruffleString operandNodeValue_ = (TruffleString) operandNodeValue;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSToBooleanUnaryNode.doString(TruffleString)] */;
            this.state_0_ = state_0;
            return JSToBooleanUnaryNode.doString(operandNodeValue_);
        }
        if ((JSGuards.isJSObject(operandNodeValue))) {
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSToBooleanUnaryNode.doObject(Object)] */;
            this.state_0_ = state_0;
            return JSToBooleanUnaryNode.doObject(operandNodeValue);
        }
        if (operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_ = (Symbol) operandNodeValue;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSToBooleanUnaryNode.doSymbol(Symbol)] */;
            this.state_0_ = state_0;
            return JSToBooleanUnaryNode.doSymbol(operandNodeValue_);
        }
        {
            Node node__ = null;
            if ((JSGuards.isForeignObject(operandNodeValue))) {
                ForeignObjectData s10_ = this.insert(new ForeignObjectData());
                node__ = (s10_);
                VarHandle.storeStoreFence();
                this.foreignObject_cache = s10_;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSToBooleanUnaryNode.doForeignObject(Object, Node, JSToBooleanNode)] */;
                this.state_0_ = state_0;
                return JSToBooleanUnaryNode.doForeignObject(operandNodeValue, node__, INLINED_FOREIGN_OBJECT_TO_BOOLEAN_NODE_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.operandNode}, operandNodeValue);
    }

    @NeverDefault
    public static JSToBooleanUnaryNode create(JavaScriptNode operand) {
        return new JSToBooleanUnaryNodeGen(operand);
    }

    @GeneratedBy(JSToBooleanUnaryNode.class)
    @DenyReplace
    private static final class ForeignObjectData extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0-14: InlinedCache
         *        Specialization: {@link JSToBooleanUnaryNode#doForeignObject}
         *        Parameter: {@link JSToBooleanNode} toBooleanNode
         *        Inline method: {@link JSToBooleanNodeGen#inline}
         * </pre> */
        @CompilationFinal @UnsafeAccessedField private int foreignObject_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSToBooleanUnaryNode#doForeignObject}
         *   Parameter: {@link JSToBooleanNode} toBooleanNode
         *   Inline method: {@link JSToBooleanNodeGen#inline}
         *   Inline field: {@link Node} field1</pre> */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node foreignObject_toBooleanNode__field1_;

        ForeignObjectData() {
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
}
