// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSToLengthNode#doInt}
 *     Activation probability: 0.32000
 *     With/without class size: 9/0 bytes
 *   Specialization {@link JSToLengthNode#doSafeInteger}
 *     Activation probability: 0.26000
 *     With/without class size: 8/0 bytes
 *   Specialization {@link JSToLengthNode#doDouble}
 *     Activation probability: 0.20000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSToLengthNode#doUndefined}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToLengthNode#doObject}
 *     Activation probability: 0.08000
 *     With/without class size: 5/4 bytes
 * </pre> */
@GeneratedBy(JSToLengthNode.class)
@SuppressWarnings("javadoc")
public final class JSToLengthNodeGen extends JSToLengthNode {

    private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSToLengthNode#doInt}
     *   Parameter: {@link InlinedBranchProfile} negativeBranch
     *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
    private static final InlinedBranchProfile INLINED_NEGATIVE_BRANCH = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(8, 1)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSToLengthNode#doDouble}
     *   Parameter: {@link InlinedBranchProfile} tooLargeBranch
     *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
    private static final InlinedBranchProfile INLINED_TOO_LARGE_BRANCH = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(9, 1)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSToLengthNode#doInt}
     *   1: SpecializationActive {@link JSToLengthNode#doSafeInteger}
     *   2: SpecializationActive {@link JSToLengthNode#doDouble}
     *   3: SpecializationActive {@link JSToLengthNode#doUndefined}
     *   4: SpecializationActive {@link JSToLengthNode#doObject}
     *   5-7: ImplicitCast[type=double, index=0]
     *   8: InlinedCache
     *        Specialization: {@link JSToLengthNode#doInt}
     *        Parameter: {@link InlinedBranchProfile} negativeBranch
     *        Inline method: {@link InlinedBranchProfile#inline}
     *   9: InlinedCache
     *        Specialization: {@link JSToLengthNode#doDouble}
     *        Parameter: {@link InlinedBranchProfile} tooLargeBranch
     *        Inline method: {@link InlinedBranchProfile#inline}
     * </pre> */
    @CompilationFinal @UnsafeAccessedField private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSToLengthNode#doObject}
     *   Parameter: {@link JSToNumberNode} toNumberNode</pre> */
    @Child private JSToNumberNode object_toNumberNode_;

    private JSToLengthNodeGen() {
    }

    @Override
    public long executeLong(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111) != 0 /* is SpecializationActive[JSToLengthNode.doInt(int, InlinedBranchProfile)] || SpecializationActive[JSToLengthNode.doSafeInteger(SafeInteger, InlinedBranchProfile)] || SpecializationActive[JSToLengthNode.doDouble(double, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[JSToLengthNode.doUndefined(Object)] || SpecializationActive[JSToLengthNode.doObject(Object, JSToNumberNode, InlinedBranchProfile, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSToLengthNode.doInt(int, InlinedBranchProfile)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return doInt(arg0Value_, INLINED_NEGATIVE_BRANCH);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSToLengthNode.doSafeInteger(SafeInteger, InlinedBranchProfile)] */ && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger) arg0Value;
                return doSafeInteger(arg0Value_, INLINED_NEGATIVE_BRANCH);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSToLengthNode.doDouble(double, InlinedBranchProfile, InlinedBranchProfile)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                return doDouble(arg0Value_, INLINED_NEGATIVE_BRANCH, INLINED_TOO_LARGE_BRANCH);
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[JSToLengthNode.doUndefined(Object)] || SpecializationActive[JSToLengthNode.doObject(Object, JSToNumberNode, InlinedBranchProfile, InlinedBranchProfile)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSToLengthNode.doUndefined(Object)] */) {
                    if ((JSGuards.isUndefined(arg0Value))) {
                        return JSToLengthNode.doUndefined(arg0Value);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSToLengthNode.doObject(Object, JSToNumberNode, InlinedBranchProfile, InlinedBranchProfile)] */) {
                    {
                        JSToNumberNode toNumberNode__ = this.object_toNumberNode_;
                        if (toNumberNode__ != null) {
                            return doObject(arg0Value, toNumberNode__, INLINED_NEGATIVE_BRANCH, INLINED_TOO_LARGE_BRANCH);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private long executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSToLengthNode.doInt(int, InlinedBranchProfile)] */;
            this.state_0_ = state_0;
            return doInt(arg0Value_, INLINED_NEGATIVE_BRANCH);
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSToLengthNode.doSafeInteger(SafeInteger, InlinedBranchProfile)] */;
            this.state_0_ = state_0;
            return doSafeInteger(arg0Value_, INLINED_NEGATIVE_BRANCH);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b100 /* add SpecializationActive[JSToLengthNode.doDouble(double, InlinedBranchProfile, InlinedBranchProfile)] */;
                this.state_0_ = state_0;
                return doDouble(arg0Value_, INLINED_NEGATIVE_BRANCH, INLINED_TOO_LARGE_BRANCH);
            }
        }
        if ((JSGuards.isUndefined(arg0Value))) {
            state_0 = state_0 | 0b1000 /* add SpecializationActive[JSToLengthNode.doUndefined(Object)] */;
            this.state_0_ = state_0;
            return JSToLengthNode.doUndefined(arg0Value);
        }
        JSToNumberNode toNumberNode__ = this.insert((JSToNumberNode.create()));
        Objects.requireNonNull(toNumberNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        VarHandle.storeStoreFence();
        this.object_toNumberNode_ = toNumberNode__;
        state_0 = state_0 | 0b10000 /* add SpecializationActive[JSToLengthNode.doObject(Object, JSToNumberNode, InlinedBranchProfile, InlinedBranchProfile)] */;
        this.state_0_ = state_0;
        return doObject(arg0Value, toNumberNode__, INLINED_NEGATIVE_BRANCH, INLINED_TOO_LARGE_BRANCH);
    }

    @NeverDefault
    public static JSToLengthNode create() {
        return new JSToLengthNodeGen();
    }

}
