/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.PromiseReactionRecord;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

public final class JSPromiseObject
extends JSNonProxyObject {
    private int promiseState;
    private boolean promiseIsHandled;
    private Object promiseResult;
    private SimpleArrayList<PromiseReactionRecord> promiseFulfillReactions;
    private SimpleArrayList<PromiseReactionRecord> promiseRejectReactions;

    protected JSPromiseObject(Shape shape, JSDynamicObject proto, int promiseState) {
        super(shape, proto);
        this.promiseState = promiseState;
    }

    public int getPromiseState() {
        return this.promiseState;
    }

    public void setPromiseState(int promiseState) {
        this.promiseState = promiseState;
    }

    public boolean isHandled() {
        return this.promiseIsHandled;
    }

    public void setIsHandled(boolean handled) {
        this.promiseIsHandled = handled;
    }

    public Object getPromiseResult() {
        return this.promiseResult;
    }

    public void setPromiseResult(Object promiseResult) {
        this.promiseResult = promiseResult;
    }

    public SimpleArrayList<PromiseReactionRecord> getPromiseFulfillReactions() {
        return this.promiseFulfillReactions;
    }

    public SimpleArrayList<PromiseReactionRecord> getPromiseRejectReactions() {
        return this.promiseRejectReactions;
    }

    public void allocatePromiseReactions() {
        this.promiseFulfillReactions = new SimpleArrayList();
        this.promiseRejectReactions = new SimpleArrayList();
    }

    public void clearPromiseReactions() {
        this.promiseFulfillReactions = null;
        this.promiseRejectReactions = null;
    }

    @Override
    public TruffleString getClassName() {
        return JSPromise.CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        return JSRuntime.objectToDisplayString(this, allowSideEffects, format, depth, JSPromise.CLASS_NAME, new TruffleString[]{Strings.PROMISE_STATUS, Strings.PROMISE_VALUE}, new Object[]{JSPromise.getStatus(this), JSPromise.getPromiseResult(this)});
    }

    public static JSPromiseObject create(Shape shape, JSDynamicObject proto, int promiseState) {
        return new JSPromiseObject(shape, proto, promiseState);
    }
}

