/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.nativemode;

import com.oracle.truffle.llvm.nativemode.NativeConfiguration;
import com.oracle.truffle.llvm.nativemode.runtime.SulongNativeOption;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.config.CommonLanguageOptions;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.ConfigurationFactory;
import java.util.List;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionValues;

public class NativeConfigurationFactory
implements ConfigurationFactory<Key> {
    public Key parseOptions(OptionValues options) {
        return new Key(options);
    }

    public int getPriority() {
        return 0;
    }

    public List<OptionDescriptor> getOptionDescriptors() {
        return SulongNativeOption.describeOptions();
    }

    public String getName() {
        return "native mode";
    }

    public String getHint() {
        return "enabled by default";
    }

    public Configuration createConfiguration(LLVMLanguage language, ContextExtension.Registry ctxExtRegistry, Key key) {
        return new NativeConfiguration(language, ctxExtRegistry, key);
    }

    public static final class Key
    extends CommonLanguageOptions {
        final boolean enableNFI;

        public Key(OptionValues options) {
            super(options);
            this.enableNFI = (Boolean)options.get(SulongNativeOption.ENABLE_NFI);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)((Object)o);
            return this.enableNFI == other.enableNFI && super.equals((Object)other);
        }

        public int hashCode() {
            int hash = super.hashCode();
            hash = 71 * hash + (this.enableNFI ? 1 : 0);
            return hash;
        }
    }
}

