/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.nativemode.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.nativemode.runtime.NFIContextExtensionFactory;
import com.oracle.truffle.llvm.nativemode.runtime.SulongNativeOption;
import com.oracle.truffle.llvm.nativemode.runtime.WellKnownNFIFunctionNodeGen;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeWrapper;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class NFIContextExtension
extends NativeContextExtension {
    private static final String SIGNATURE_SOURCE_NAME = "llvm-nfi-signature";
    private static final int WELL_KNOWN_CACHE_INITIAL_SIZE = 8;
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private Object defaultLibraryHandle;
    private boolean internalLibrariesAdded = false;
    private final List<Object> libraryHandles = new ArrayList<Object>();
    private final EconomicMap<String, CallTarget> visited = EconomicMap.create();
    private final TruffleLanguage.Env env;
    private final SignatureSourceCache signatureSourceCache;
    private final EconomicMap<String, SignatureSourceCache> altBackendSignatureSourceCache;
    private final EconomicMap<Source, Object> signatureCache = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    private NativeContextExtension.WellKnownNativeFunctionAndSignature[] wellKnownFunctionCache;

    private NFIContextExtension(TruffleLanguage.Env env, SignatureSourceCache signatureSourceCache, EconomicMap<String, SignatureSourceCache> altBackendSignatureSourceCache) {
        assert (((Boolean)env.getOptions().get(SulongNativeOption.ENABLE_NFI)).booleanValue());
        this.env = env;
        this.signatureSourceCache = signatureSourceCache;
        this.altBackendSignatureSourceCache = altBackendSignatureSourceCache;
        this.wellKnownFunctionCache = new NativeContextExtension.WellKnownNativeFunctionAndSignature[8];
    }

    private static TruffleFile locateLibsulongNative(LLVMContext context) {
        String sulongNative = NFIContextExtension.getNativeLibrary((String)"sulong-native");
        String home = context.getLanguage().getLLVMLanguageHome();
        if (home != null) {
            Path libPath = Path.of(home, "native", "lib", sulongNative);
            TruffleFile file = context.getEnv().getInternalTruffleFile(libPath.toString());
            try {
                if (file.exists(new LinkOption[0])) {
                    return file;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            TruffleFile resourceBase = context.getEnv().getInternalResource("libsulong-native");
            return resourceBase.resolve(sulongNative);
        }
        catch (IOException ex) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
        }
    }

    public void initialize(LLVMContext context) {
        assert (!this.isInitialized());
        if (!this.internalLibrariesAdded) {
            Object defaultLib;
            TruffleFile libsulongNative = NFIContextExtension.locateLibsulongNative(context);
            Object lib = this.loadLibrary(libsulongNative.getAbsoluteFile().getPath(), context);
            if (lib instanceof CallTarget) {
                this.libraryHandles.add(((CallTarget)lib).call(new Object[0]));
            }
            if ((defaultLib = this.loadDefaultLibrary()) instanceof CallTarget) {
                this.defaultLibraryHandle = ((CallTarget)defaultLib).call(new Object[0]);
            }
            this.internalLibrariesAdded = true;
        }
    }

    public boolean isInitialized() {
        return this.defaultLibraryHandle != null;
    }

    public NativeContextExtension.NativePointerIntoLibrary getNativeHandle(String name) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            NativeContextExtension.NativeLookupResult result = this.getNativeDataObjectOrNull(name);
            if (result != null) {
                long pointer = INTEROP.asPointer(result.getObject());
                return new NativeContextExtension.NativePointerIntoLibrary(pointer);
            }
            return null;
        }
        catch (UnsupportedMessageException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignatureSourceCache getSignatureSourceCache(String backend) {
        if (backend == null) {
            return this.signatureSourceCache;
        }
        NFIContextExtension nFIContextExtension = this;
        synchronized (nFIContextExtension) {
            if (!this.altBackendSignatureSourceCache.containsKey((Object)backend)) {
                this.altBackendSignatureSourceCache.put((Object)backend, (Object)new SignatureSourceCache(backend));
            }
        }
        return (SignatureSourceCache)this.altBackendSignatureSourceCache.get((Object)backend);
    }

    public CallTarget createNativeWrapperFactory(LLVMFunctionCode code, String backend) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            Source signatureSource = this.getSignatureSourceCache(backend).getSignatureSource(code.getLLVMFunction().getType());
            return NFIContextExtensionFactory.CreateClosureNodeGen.create(LLVMLanguage.get(null), signatureSource, new LLVMNativeWrapper(code)).getCallTarget();
        }
        catch (NativeContextExtension.UnsupportedNativeTypeException ex) {
            return null;
        }
    }

    public synchronized void addLibraryHandles(Object library) {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.libraryHandles.contains(library)) {
            this.libraryHandles.add(library);
        }
    }

    public synchronized CallTarget parseNativeLibrary(String path, LLVMContext context) throws UnsatisfiedLinkError {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.visited.containsKey((Object)path)) {
            Object callTarget = this.loadLibrary(path, context);
            if (callTarget != null) {
                this.visited.put((Object)path, (Object)((CallTarget)callTarget));
                return (CallTarget)callTarget;
            }
            throw new IllegalStateException("Native library call target is null.");
        }
        return (CallTarget)this.visited.get((Object)path);
    }

    public static String getNativeLibrarySuffix() {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return "dylib";
        }
        return "so";
    }

    public static String getNativeLibrarySuffixVersioned(int version) {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return version + ".dylib";
        }
        return "so." + version;
    }

    private Object loadLibrary(String path, LLVMContext context) {
        CompilerAsserts.neverPartOfCompilation();
        return this.loadLibrary(path, false, null, context);
    }

    private Object loadLibrary(String path, boolean optional, String flags, LLVMContext context) {
        LibraryLocator.traceLoadNative((LLVMContext)context, (Object)path);
        String loadExpression = flags == null ? String.format("load \"%s\"", path) : String.format("load(%s) \"%s\"", flags, path);
        Source source = Source.newBuilder((String)"nfi", (CharSequence)loadExpression, (String)("(load " + path + ")")).internal(true).build();
        try {
            return this.env.parseInternal(source, new String[0]);
        }
        catch (UnsatisfiedLinkError ex) {
            if (optional) {
                return null;
            }
            throw ex;
        }
    }

    private Object loadDefaultLibrary() {
        CompilerAsserts.neverPartOfCompilation();
        Source source = Source.newBuilder((String)"nfi", (CharSequence)"default", (String)"default").internal(true).build();
        try {
            return this.env.parseInternal(source, new String[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static Object getNativeFunctionOrNull(Object library, String name) {
        CompilerAsserts.neverPartOfCompilation();
        if (!INTEROP.isMemberReadable(library, name)) {
            return null;
        }
        try {
            return INTEROP.readMember(library, name);
        }
        catch (UnknownIdentifierException ex) {
            return null;
        }
        catch (InteropException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String getNativeType(Type type) throws NativeContextExtension.UnsupportedNativeTypeException {
        if (type instanceof FunctionType) {
            return NFIContextExtension.getNativeSignature((FunctionType)type, 0);
        }
        if (type instanceof PointerType) {
            PointerType ptr = (PointerType)type;
            if (!ptr.isOpaque() && ptr.getPointeeType() instanceof FunctionType) {
                FunctionType functionType = (FunctionType)ptr.getPointeeType();
                return NFIContextExtension.getNativeSignature(functionType, 0);
            }
            return "POINTER";
        }
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            PrimitiveType.PrimitiveKind kind = primitiveType.getPrimitiveKind();
            switch (kind) {
                case I1: 
                case I8: {
                    return "SINT8";
                }
                case I16: {
                    return "SINT16";
                }
                case I32: {
                    return "SINT32";
                }
                case I64: {
                    return "SINT64";
                }
                case FLOAT: {
                    return "FLOAT";
                }
                case DOUBLE: {
                    return "DOUBLE";
                }
                case X86_FP80: {
                    return "FP80";
                }
                case F128: {
                    return "FP128";
                }
            }
            throw new NativeContextExtension.UnsupportedNativeTypeException((Type)primitiveType);
        }
        if (type instanceof VoidType) {
            return "VOID";
        }
        throw new NativeContextExtension.UnsupportedNativeTypeException(type);
    }

    private static String[] getNativeArgumentTypes(FunctionType functionType, int skipArguments) throws NativeContextExtension.UnsupportedNativeTypeException {
        String[] types = new String[functionType.getNumberOfArguments() - skipArguments];
        for (int i = skipArguments; i < functionType.getNumberOfArguments(); ++i) {
            types[i - skipArguments] = NFIContextExtension.getNativeType(functionType.getArgumentType(i));
        }
        return types;
    }

    public synchronized NativeContextExtension.NativeLookupResult getNativeFunctionOrNull(String name) {
        CompilerAsserts.neverPartOfCompilation();
        Object[] cursor = this.libraryHandles.toArray();
        for (int i = 0; i < cursor.length; ++i) {
            Object symbol = NFIContextExtension.getNativeFunctionOrNull(cursor[i], name);
            if (symbol == null) continue;
            return new NativeContextExtension.NativeLookupResult(symbol);
        }
        Object symbol = NFIContextExtension.getNativeFunctionOrNull(this.defaultLibraryHandle, name);
        if (symbol != null) {
            assert (this.isInitialized());
            return new NativeContextExtension.NativeLookupResult(symbol);
        }
        return null;
    }

    private synchronized NativeContextExtension.NativeLookupResult getNativeDataObjectOrNull(String name) {
        CompilerAsserts.neverPartOfCompilation();
        Object[] cursor = this.libraryHandles.toArray();
        for (int i = 0; i < cursor.length; ++i) {
            Object symbol = NFIContextExtension.getNativeFunctionOrNull(cursor[i], name);
            if (symbol == null) continue;
            return new NativeContextExtension.NativeLookupResult(symbol);
        }
        Object symbol = NFIContextExtension.getNativeDataObjectOrNull(this.defaultLibraryHandle, name);
        if (symbol != null) {
            assert (this.isInitialized());
            return new NativeContextExtension.NativeLookupResult(symbol);
        }
        return null;
    }

    private static Object getNativeDataObjectOrNull(Object libraryHandle, String name) {
        try {
            Object symbol = INTEROP.readMember(libraryHandle, name);
            if (symbol != null && 0L != INTEROP.asPointer(symbol)) {
                return symbol;
            }
            return null;
        }
        catch (UnknownIdentifierException ex) {
            return null;
        }
        catch (InteropException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Object bindNativeFunction(Object symbol, String signature) {
        CompilerAsserts.neverPartOfCompilation();
        Source sigSource = Source.newBuilder((String)"nfi", (CharSequence)signature, (String)SIGNATURE_SOURCE_NAME).build();
        return SignatureLibrary.getUncached().bind(this.getCachedSignature(sigSource), symbol);
    }

    public Object getNativeFunction(String name, String signature) {
        CompilerAsserts.neverPartOfCompilation();
        NativeContextExtension.NativeLookupResult result = this.getNativeFunctionOrNull(name);
        if (result != null) {
            return this.bindNativeFunction(result.getObject(), signature);
        }
        throw new LLVMLinkerException(String.format("External function %s cannot be found.", name));
    }

    public NativeContextExtension.WellKnownNativeFunctionNode getWellKnownNativeFunction(String name, String signature) {
        CompilerAsserts.neverPartOfCompilation();
        WellKnownFunction fn = this.signatureSourceCache.getWellKnownFunction(name, signature);
        return WellKnownNFIFunctionNodeGen.create(fn);
    }

    @CompilerDirectives.TruffleBoundary
    public NativeContextExtension.WellKnownNativeFunctionAndSignature getWellKnownNativeFunctionAndSignature(String name, String signature) {
        WellKnownFunction fn = this.signatureSourceCache.getWellKnownFunction(name, signature);
        return this.getCachedWellKnownFunction(fn);
    }

    private NativeContextExtension.WellKnownNativeFunctionAndSignature createWellKnownFunction(WellKnownFunction fn) {
        CompilerAsserts.neverPartOfCompilation();
        NativeContextExtension.NativeLookupResult result = this.getNativeFunctionOrNull(fn.name);
        if (result != null) {
            CallTarget parsedSignature = this.env.parseInternal(fn.signatureSource, new String[0]);
            Object signature = parsedSignature.call(new Object[0]);
            Object boundSignature = SignatureLibrary.getUncached().bind(signature, result.getObject());
            return new NativeContextExtension.WellKnownNativeFunctionAndSignature(signature, result.getObject(), boundSignature);
        }
        throw new LLVMLinkerException(String.format("External function %s cannot be found.", fn.name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private NativeContextExtension.WellKnownNativeFunctionAndSignature getWellKnownFunctionSlowPath(WellKnownFunction fn) {
        NFIContextExtension nFIContextExtension = this;
        synchronized (nFIContextExtension) {
            NativeContextExtension.WellKnownNativeFunctionAndSignature ret;
            if (this.wellKnownFunctionCache.length <= fn.index) {
                int newLength;
                assert (fn.index < this.signatureSourceCache.nextIndex);
                for (newLength = this.wellKnownFunctionCache.length * 2; newLength < this.signatureSourceCache.nextIndex; newLength *= 2) {
                }
                this.wellKnownFunctionCache = Arrays.copyOf(this.wellKnownFunctionCache, newLength);
            }
            if ((ret = this.wellKnownFunctionCache[fn.index]) == null) {
                this.wellKnownFunctionCache[fn.index] = ret = this.createWellKnownFunction(fn);
            }
            return ret;
        }
    }

    NativeContextExtension.WellKnownNativeFunctionAndSignature getCachedWellKnownFunction(WellKnownFunction fn) {
        NativeContextExtension.WellKnownNativeFunctionAndSignature ret;
        if (fn.index < this.wellKnownFunctionCache.length && (ret = this.wellKnownFunctionCache[fn.index]) != null) {
            return ret;
        }
        return this.getWellKnownFunctionSlowPath(fn);
    }

    public Source getNativeSignatureSourceSkipStackArg(FunctionType type) throws NativeContextExtension.UnsupportedNativeTypeException {
        CompilerAsserts.neverPartOfCompilation();
        return this.signatureSourceCache.getSignatureSourceSkipStackArg(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Object createSignature(Source signatureSource) {
        EconomicMap<Source, Object> economicMap = this.signatureCache;
        synchronized (economicMap) {
            Object ret = this.signatureCache.get((Object)signatureSource);
            if (ret == null) {
                CallTarget createSignature = this.env.parseInternal(signatureSource, new String[0]);
                ret = createSignature.call(new Object[0]);
                this.signatureCache.put((Object)signatureSource, ret);
            }
            return ret;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private Object getCachedSignature(Source signatureSource) {
        Object ret = this.signatureCache.get((Object)signatureSource);
        if (ret == null) {
            ret = this.createSignature(signatureSource);
        }
        return ret;
    }

    public Object bindSignature(LLVMFunctionCode function, Source signatureSource) {
        CompilerAsserts.neverPartOfCompilation();
        Object nativeFunction = function.getNativeFunctionSlowPath();
        Object signature = this.getCachedSignature(signatureSource);
        return SignatureLibrary.getUncached().bind(signature, nativeFunction);
    }

    public Object bindSignature(long fnPtr, Source signatureSource) {
        CompilerAsserts.neverPartOfCompilation();
        Object signature = this.getCachedSignature(signatureSource);
        return SignatureLibrary.getUncached().bind(signature, (Object)LLVMNativePointer.create((long)fnPtr));
    }

    public String getNativeSignature(FunctionType type) {
        try {
            return NFIContextExtension.getNativeSignature(type, 0);
        }
        catch (NativeContextExtension.UnsupportedNativeTypeException e) {
            return null;
        }
    }

    private static String getNativeSignature(FunctionType type, int skipArguments) throws NativeContextExtension.UnsupportedNativeTypeException {
        CompilerAsserts.neverPartOfCompilation();
        String nativeRet = NFIContextExtension.getNativeType(type.getReturnType());
        String[] argTypes = NFIContextExtension.getNativeArgumentTypes(type, skipArguments);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int pos = 0; pos < argTypes.length; ++pos) {
            String a = argTypes[pos];
            if (pos == type.getFixedArgs()) {
                sb.append("...");
            }
            sb.append(a);
            sb.append(",");
        }
        if (argTypes.length > 0) {
            sb.setCharAt(sb.length() - 1, ')');
        } else {
            sb.append(')');
        }
        sb.append(":");
        sb.append(nativeRet);
        return sb.toString();
    }

    private static final class SignatureSourceCache {
        private final WeakHashMap<FunctionType, Source> sigCache = new WeakHashMap();
        private final WeakHashMap<FunctionType, Source> sigCacheSkipStackArg = new WeakHashMap();
        private final EconomicMap<String, WellKnownFunction> wellKnown = EconomicMap.create();
        private int nextIndex = 0;
        private final String backend;

        SignatureSourceCache() {
            this(null);
        }

        SignatureSourceCache(String backend) {
            this.backend = backend;
        }

        Source getSignatureSource(FunctionType type) throws NativeContextExtension.UnsupportedNativeTypeException {
            return this.getSignatureSource(type, this.sigCache, 0);
        }

        Source getSignatureSourceSkipStackArg(FunctionType type) throws NativeContextExtension.UnsupportedNativeTypeException {
            return this.getSignatureSource(type, this.sigCacheSkipStackArg, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Source getSignatureSource(FunctionType type, WeakHashMap<FunctionType, Source> map, int skipArgs) throws NativeContextExtension.UnsupportedNativeTypeException {
            WeakHashMap<FunctionType, Source> weakHashMap = map;
            synchronized (weakHashMap) {
                Source ret = map.get(type);
                if (ret == null) {
                    Object sig = NFIContextExtension.getNativeSignature(type, skipArgs);
                    if (this.backend != null) {
                        sig = "with " + this.backend + " " + (String)sig;
                    }
                    ret = Source.newBuilder((String)"nfi", (CharSequence)sig, (String)NFIContextExtension.SIGNATURE_SOURCE_NAME).build();
                    map.put(type, ret);
                }
                return ret;
            }
        }

        synchronized WellKnownFunction getWellKnownFunction(String name, String signature) {
            WellKnownFunction ret = (WellKnownFunction)this.wellKnown.get((Object)name);
            if (ret == null) {
                Source signatureSource = Source.newBuilder((String)"nfi", (CharSequence)signature, (String)NFIContextExtension.SIGNATURE_SOURCE_NAME).build();
                ret = new WellKnownFunction(this.nextIndex++, name, signatureSource);
                this.wellKnown.put((Object)name, (Object)ret);
            }
            return ret;
        }
    }

    static abstract class CreateClosureNode
    extends RootNode {
        private final ContextExtension.Key<NativeContextExtension> ctxExtKey;
        private final Source signatureSource;
        private final LLVMNativeWrapper nativeWrapper;

        CreateClosureNode(LLVMLanguage language, Source signatureSource, LLVMNativeWrapper nativeWrapper) {
            super((TruffleLanguage)language);
            this.ctxExtKey = language.lookupContextExtension(NativeContextExtension.class);
            this.signatureSource = signatureSource;
            this.nativeWrapper = nativeWrapper;
        }

        @Specialization
        Object doCreateClosure(@CachedLibrary(limit="1") SignatureLibrary signatureLibrary) {
            NFIContextExtension ctxExt = (NFIContextExtension)this.ctxExtKey.get(LLVMContext.get((Node)this));
            Object signature = ctxExt.getCachedSignature(this.signatureSource);
            return signatureLibrary.createClosure(signature, (Object)this.nativeWrapper);
        }
    }

    static final class WellKnownFunction {
        final int index;
        final String name;
        final Source signatureSource;

        WellKnownFunction(int index, String name, Source signatureSource) {
            this.index = index;
            this.name = name;
            this.signatureSource = signatureSource;
        }
    }

    public static final class Factory
    implements ContextExtension.Factory<NativeContextExtension> {
        private final SignatureSourceCache signatureSourceCache = new SignatureSourceCache();
        private final EconomicMap<String, SignatureSourceCache> altBackendSignatureSourceCache = EconomicMap.create();

        public NativeContextExtension create(TruffleLanguage.Env env) {
            return new NFIContextExtension(env, this.signatureSourceCache, this.altBackendSignatureSourceCache);
        }
    }
}

