/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.nativemode.runtime;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.nativemode.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;

abstract class WellKnownNFIFunctionNode
extends NativeContextExtension.WellKnownNativeFunctionNode {
    private final NFIContextExtension.WellKnownFunction function;
    private final ContextExtension.Key<NativeContextExtension> ctxExtKey;

    WellKnownNFIFunctionNode(NFIContextExtension.WellKnownFunction function) {
        this.function = function;
        this.ctxExtKey = LLVMLanguage.get(null).lookupContextExtension(NativeContextExtension.class);
    }

    Object getFunction() {
        NFIContextExtension ctxExt = (NFIContextExtension)this.ctxExtKey.get(this.getContext());
        return ctxExt.getCachedWellKnownFunction(this.function).getBoundSignature();
    }

    @Specialization(guards={"isSingleContext($node)"})
    @GenerateAOT.Exclude
    Object doCached(Object[] args, @Cached(value="getFunction()") Object cachedFunction, @CachedLibrary(value="cachedFunction") InteropLibrary interop) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
        return interop.execute(cachedFunction, args);
    }

    @Specialization(replaces={"doCached"})
    @GenerateAOT.Exclude
    Object doGeneric(Object[] args, @CachedLibrary(limit="3") InteropLibrary interop) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
        Object fn = this.getFunction();
        return interop.execute(fn, args);
    }
}

