// CheckStyle: start generated
package com.oracle.truffle.llvm.nfi;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.nfi.SulongNFISignature.SignatureBuilder;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureBuilderLibrary;

@GeneratedBy(SignatureBuilder.class)
final class SignatureBuilderGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(SignatureBuilder.class, new NFIBackendSignatureBuilderLibraryExports());
    }

    private SignatureBuilderGen() {
    }

    @GeneratedBy(SignatureBuilder.class)
    private static final class NFIBackendSignatureBuilderLibraryExports extends LibraryExport<NFIBackendSignatureBuilderLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private NFIBackendSignatureBuilderLibraryExports() {
            super(NFIBackendSignatureBuilderLibrary.class, SignatureBuilder.class, false, false, 0);
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createUncached(Object receiver) {
            assert receiver instanceof SignatureBuilder;
            NFIBackendSignatureBuilderLibrary uncached = NFIBackendSignatureBuilderLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createCached(Object receiver) {
            assert receiver instanceof SignatureBuilder;
            return NFIBackendSignatureBuilderLibraryExports.CACHE;
        }

        @GeneratedBy(SignatureBuilder.class)
        private static final class Cached extends NFIBackendSignatureBuilderLibrary {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SignatureBuilder) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SignatureBuilder;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public void setReturnType(Object receiver, Object type) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (((SignatureBuilder) receiver)).setReturnType(type);
                return;
            }

            @Override
            public void addArgument(Object receiver, Object type) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (((SignatureBuilder) receiver)).addArgument(type);
                return;
            }

            @Override
            public Object build(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((SignatureBuilder) receiver)).build();
            }

        }
        @GeneratedBy(SignatureBuilder.class)
        @DenyReplace
        private static final class Uncached extends NFIBackendSignatureBuilderLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SignatureBuilder) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SignatureBuilder;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void setReturnType(Object receiver, Object type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((SignatureBuilder) receiver) .setReturnType(type);
                return;
            }

            @TruffleBoundary
            @Override
            public void addArgument(Object receiver, Object type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((SignatureBuilder) receiver) .addArgument(type);
                return;
            }

            @TruffleBoundary
            @Override
            public Object build(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SignatureBuilder) receiver) .build();
            }

        }
    }
}
