/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.nfi.SulongNFI;

abstract class SulongNFIRootNode
extends RootNode {
    @Node.Child
    @Executed
    ParseSourceNode parseSource;

    SulongNFIRootNode(SulongNFI language, Source sulongSource) {
        super((TruffleLanguage)language);
        this.parseSource = new ParseSourceNode(sulongSource);
    }

    @Specialization(guards={"call.getCallTarget() == parsedSource"}, limit="3")
    Object doCached(CallTarget parsedSource, @Cached(parameters={"parsedSource"}) DirectCallNode call) {
        assert (call.getCallTarget() == parsedSource);
        return call.call(new Object[0]);
    }

    @Specialization(replaces={"doCached"})
    Object doGeneric(CallTarget parsedSource, @Cached IndirectCallNode call) {
        return call.call(parsedSource, new Object[0]);
    }

    static final class ParseSourceNode
    extends Node {
        private final Source source;

        ParseSourceNode(Source source) {
            this.source = source;
        }

        @CompilerDirectives.TruffleBoundary
        private CallTarget doParse(TruffleLanguage.Env env) {
            return env.parseInternal(this.source, new String[0]);
        }

        CallTarget execute() {
            TruffleLanguage.Env env = SulongNFI.getContext(this);
            return this.doParse(env);
        }
    }
}

