// CheckStyle: start generated
package com.oracle.truffle.llvm.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import java.lang.invoke.MethodHandles;
import java.util.Objects;

@GeneratedBy(SulongNFISignature.class)
@SuppressWarnings({"javadoc", "unused"})
final class SulongNFISignatureGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(SulongNFISignature.class, new NFIBackendSignatureLibraryExports());
    }

    private SulongNFISignatureGen() {
    }

    @GeneratedBy(SulongNFISignature.class)
    private static final class NFIBackendSignatureLibraryExports extends LibraryExport<NFIBackendSignatureLibrary> {

        private NFIBackendSignatureLibraryExports() {
            super(NFIBackendSignatureLibrary.class, SulongNFISignature.class, false, false, 0);
        }

        @Override
        protected NFIBackendSignatureLibrary createUncached(Object receiver) {
            assert receiver instanceof SulongNFISignature;
            NFIBackendSignatureLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFIBackendSignatureLibrary createCached(Object receiver) {
            assert receiver instanceof SulongNFISignature;
            return new Cached();
        }

        @GeneratedBy(SulongNFISignature.class)
        private static final class Cached extends NFIBackendSignatureLibrary {

            static final ReferenceField<Call0Data> CALL0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "call0_cache", Call0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SulongNFISignature#call}
             *   1: SpecializationActive {@link SulongNFISignature#call}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Call0Data call0_cache;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SulongNFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SulongNFISignature;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link SulongNFISignature#call}
             *     Activation probability: 0.65000
             *     With/without class size: 17/4 bytes
             *   Specialization {@link SulongNFISignature#call}
             *     Activation probability: 0.35000
             *     With/without class size: 8/0 bytes
             * </pre>
             */
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                SulongNFISignature arg0Value = ((SulongNFISignature) arg0Value_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[SulongNFISignature.call(SulongNFISignature, Object, Object[], InteropLibrary)] || SpecializationActive[SulongNFISignature.call(SulongNFISignature, Object, Object[], InteropLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[SulongNFISignature.call(SulongNFISignature, Object, Object[], InteropLibrary)] */) {
                        Call0Data s0_ = this.call0_cache;
                        if (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value))) {
                                return SulongNFISignature.call(arg0Value, arg1Value, arg2Value, s0_.interop_);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SulongNFISignature.call(SulongNFISignature, Object, Object[], InteropLibrary)] */) {
                        return this.callNode__Call1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object callNode__Call1Boundary(int state_0, SulongNFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                        return SulongNFISignature.call(arg0Value, arg1Value, arg2Value, interop__);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private Object executeAndSpecialize(SulongNFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[SulongNFISignature.call(SulongNFISignature, Object, Object[], InteropLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        Call0Data s0_ = CALL0_CACHE_UPDATER.getVolatile(this);
                        Call0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = null;
                            break;
                        }
                        if (s0_ == null && count0_ < 1) {
                            // assert (s0_.interop_.accepts(arg1Value));
                            s0_ = this.insert(new Call0Data());
                            InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.create(arg1Value)));
                            Objects.requireNonNull(interop__, "Specialization 'call(SulongNFISignature, Object, Object[], InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s0_.interop_ = interop__;
                            if (!CALL0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1 /* add SpecializationActive[SulongNFISignature.call(SulongNFISignature, Object, Object[], InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                        if (s0_ != null) {
                            return SulongNFISignature.call(arg0Value, arg1Value, arg2Value, s0_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                            this.call0_cache = null;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[SulongNFISignature.call(SulongNFISignature, Object, Object[], InteropLibrary)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[SulongNFISignature.call(SulongNFISignature, Object, Object[], InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return SulongNFISignature.call(arg0Value, arg1Value, arg2Value, interop__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Object createClosure(Object receiver, Object executable) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((SulongNFISignature) receiver)).createClosure(executable);
            }

            @GeneratedBy(SulongNFISignature.class)
            @DenyReplace
            private static final class Call0Data extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SulongNFISignature#call}
                 *   Parameter: {@link InteropLibrary} interop</pre>
                 */
                @Child InteropLibrary interop_;

                Call0Data() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
        @GeneratedBy(SulongNFISignature.class)
        @DenyReplace
        private static final class Uncached extends NFIBackendSignatureLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SulongNFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SulongNFISignature;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SulongNFISignature arg0Value = ((SulongNFISignature) arg0Value_);
                return SulongNFISignature.call(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
            }

            @TruffleBoundary
            @Override
            public Object createClosure(Object receiver, Object executable) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongNFISignature) receiver) .createClosure(executable);
            }

        }
    }
}
