/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.nfi.SulongNFIException;
import com.oracle.truffle.llvm.nfi.SulongNFIRootNodeGen;
import com.oracle.truffle.llvm.nfi.SulongNFISignature;
import com.oracle.truffle.nfi.backend.spi.NFIBackend;
import com.oracle.truffle.nfi.backend.spi.NFIBackendFactory;
import com.oracle.truffle.nfi.backend.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIState;
import com.oracle.truffle.nfi.backend.spi.types.NativeLibraryDescriptor;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import java.io.IOException;

@TruffleLanguage.Registration(id="internal/nfi-llvm", name="nfi-llvm", version="12.0.0", internal=true, interactive=false, services={NFIBackendFactory.class}, contextPolicy=TruffleLanguage.ContextPolicy.SHARED, dependentLanguages={"llvm"})
public final class SulongNFI
extends TruffleLanguage<TruffleLanguage.Env> {
    @CompilerDirectives.CompilationFinal
    private SulongNFIBackend backend;
    private static final TruffleLanguage.LanguageReference<SulongNFI> REFERENCE = TruffleLanguage.LanguageReference.create(SulongNFI.class);
    private static final TruffleLanguage.ContextReference<TruffleLanguage.Env> CONTEXT_REFERENCE = TruffleLanguage.ContextReference.create(SulongNFI.class);

    protected TruffleLanguage.Env createContext(TruffleLanguage.Env env) {
        env.registerService((Object)new NFIBackendFactory(){

            public String getBackendId() {
                return "llvm";
            }

            public NFIBackend createBackend(ContextThreadLocal<NFIState> state) {
                if (SulongNFI.this.backend == null) {
                    SulongNFI.this.backend = new SulongNFIBackend();
                }
                return SulongNFI.this.backend;
            }
        });
        return env;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) {
        return new RootNode(this){

            public Object execute(VirtualFrame frame) {
                throw CompilerDirectives.shouldNotReachHere((String)"illegal access to internal language");
            }
        }.getCallTarget();
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    static SulongNFI get(Node node) {
        return (SulongNFI)REFERENCE.get(node);
    }

    static TruffleLanguage.Env getContext(Node node) {
        return (TruffleLanguage.Env)CONTEXT_REFERENCE.get(node);
    }

    @ExportLibrary(value=NFIBackendLibrary.class)
    final class SulongNFIBackend
    implements NFIBackend {
        SulongNFIBackend() {
        }

        public CallTarget parse(NativeLibraryDescriptor descriptor) {
            TruffleLanguage.Env env = SulongNFI.getContext(null);
            if (descriptor.isDefaultLibrary()) {
                throw new SulongNFIException("default lib not implemented yet");
            }
            TruffleFile file = env.getInternalTruffleFile(descriptor.getFilename());
            try {
                Source source = Source.newBuilder((String)"llvm", (TruffleFile)file).build();
                return SulongNFIRootNodeGen.create(SulongNFI.this, source).getCallTarget();
            }
            catch (IOException ex) {
                throw new SulongNFIException(ex.getMessage());
            }
        }

        @ExportMessage
        Object getSimpleType(NativeSimpleType type) {
            switch (type) {
                case STRING: {
                    return null;
                }
            }
            return type;
        }

        @ExportMessage
        Object getArrayType(NativeSimpleType type) {
            return null;
        }

        @ExportMessage
        Object getEnvType() {
            return null;
        }

        @ExportMessage
        Object createSignatureBuilder() {
            return SulongNFISignature.BUILDER;
        }
    }
}

