// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link DebugExprArrayElementNode#doIntIndex}
 *     Activation probability: 0.65000
 *     With/without class size: 19/8 bytes
 *   Specialization {@link DebugExprArrayElementNode#doGeneric}
 *     Activation probability: 0.35000
 *     With/without class size: 12/8 bytes
 * </pre>
 */
@GeneratedBy(DebugExprArrayElementNode.class)
@SuppressWarnings("javadoc")
public final class DebugExprArrayElementNodeGen extends DebugExprArrayElementNode implements GenerateAOT.Provider {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @Child private LLVMExpressionNode base_;
    @Child private LLVMExpressionNode index_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link DebugExprArrayElementNode#doIntIndex}
     *   2: SpecializationActive {@link DebugExprArrayElementNode#doGeneric}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link DebugExprArrayElementNode#doIntIndex}
     *   Parameter: {@link InteropLibrary} library</pre>
     */
    @Child private InteropLibrary intIndex_library_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link DebugExprArrayElementNode#doIntIndex}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile intIndex_exception_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link DebugExprArrayElementNode#doGeneric}
     *   Parameter: {@link InteropLibrary} library</pre>
     */
    @Child private InteropLibrary generic_library_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link DebugExprArrayElementNode#doGeneric}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile generic_exception_;

    private DebugExprArrayElementNodeGen(DebugExprType type, LLVMExpressionNode base, LLVMExpressionNode index) {
        super(type);
        this.base_ = base;
        this.index_ = index;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[DebugExprArrayElementNode.doIntIndex(Object, int, InteropLibrary, BranchProfile)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[DebugExprArrayElementNode.doIntIndex(Object, int, InteropLibrary, BranchProfile)] && SpecializationActive[DebugExprArrayElementNode.doGeneric(Object, Object, InteropLibrary, BranchProfile)] */)) {
            return executeGeneric_int0(state_0, frameValue, baseValue_);
        } else {
            return executeGeneric_generic1(state_0, frameValue, baseValue_);
        }
    }

    private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue, Object baseValue_) {
        int state_0 = state_0__;
        int indexValue_;
        try {
            indexValue_ = this.index_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(baseValue_, indexValue_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprArrayElementNode.doIntIndex(Object, int, InteropLibrary, BranchProfile)] */;
        {
            InteropLibrary library__ = this.intIndex_library_;
            if (library__ != null) {
                BranchProfile exception__ = this.intIndex_exception_;
                if (exception__ != null) {
                    return doIntIndex(baseValue_, indexValue_, library__, exception__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(baseValue_, indexValue_);
    }

    private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue, Object baseValue_) {
        int state_0 = state_0__;
        Object indexValue_ = this.index_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(baseValue_, indexValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[DebugExprArrayElementNode.doIntIndex(Object, int, InteropLibrary, BranchProfile)] || SpecializationActive[DebugExprArrayElementNode.doGeneric(Object, Object, InteropLibrary, BranchProfile)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprArrayElementNode.doIntIndex(Object, int, InteropLibrary, BranchProfile)] */ && indexValue_ instanceof Integer) {
                int indexValue__ = (int) indexValue_;
                {
                    InteropLibrary library__ = this.intIndex_library_;
                    if (library__ != null) {
                        BranchProfile exception__ = this.intIndex_exception_;
                        if (exception__ != null) {
                            return doIntIndex(baseValue_, indexValue__, library__, exception__);
                        }
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprArrayElementNode.doGeneric(Object, Object, InteropLibrary, BranchProfile)] */) {
                {
                    InteropLibrary library__1 = this.generic_library_;
                    if (library__1 != null) {
                        BranchProfile exception__1 = this.generic_exception_;
                        if (exception__1 != null) {
                            return doGeneric(baseValue_, indexValue_, library__1, exception__1);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(baseValue_, indexValue_);
    }

    private Object executeAndSpecialize(Object baseValue, Object indexValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (indexValue instanceof Integer) {
            int indexValue_ = (int) indexValue;
            InteropLibrary library__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(library__, "Specialization 'doIntIndex(Object, int, InteropLibrary, BranchProfile)' cache 'library' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.intIndex_library_ = library__;
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "Specialization 'doIntIndex(Object, int, InteropLibrary, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.intIndex_exception_ = exception__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[DebugExprArrayElementNode.doIntIndex(Object, int, InteropLibrary, BranchProfile)] */;
            this.state_0_ = state_0;
            return doIntIndex(baseValue, indexValue_, library__, exception__);
        }
        InteropLibrary library__1 = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
        Objects.requireNonNull(library__1, "Specialization 'doGeneric(Object, Object, InteropLibrary, BranchProfile)' cache 'library' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.generic_library_ = library__1;
        BranchProfile exception__1 = (BranchProfile.create());
        Objects.requireNonNull(exception__1, "Specialization 'doGeneric(Object, Object, InteropLibrary, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.generic_exception_ = exception__1;
        state_0 = state_0 | 0b100 /* add SpecializationActive[DebugExprArrayElementNode.doGeneric(Object, Object, InteropLibrary, BranchProfile)] */;
        this.state_0_ = state_0;
        return doGeneric(baseValue, indexValue, library__1, exception__1);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static DebugExprArrayElementNode create(DebugExprType type, LLVMExpressionNode base, LLVMExpressionNode index) {
        return new DebugExprArrayElementNodeGen(type, base, index);
    }

}
