// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link DebugExprTernaryNode#doTernary(VirtualFrame, boolean)}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link DebugExprTernaryNode#doTernary(VirtualFrame, int)}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link DebugExprTernaryNode#doTernary(VirtualFrame, long)}
 *     Activation probability: 0.20500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link DebugExprTernaryNode#doError}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre>
 */
@GeneratedBy(DebugExprTernaryNode.class)
@SuppressWarnings("javadoc")
public final class DebugExprTernaryNodeGen extends DebugExprTernaryNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode condition_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link DebugExprTernaryNode#doTernary(VirtualFrame, boolean)}
     *   2: SpecializationActive {@link DebugExprTernaryNode#doTernary(VirtualFrame, int)}
     *   3: SpecializationActive {@link DebugExprTernaryNode#doTernary(VirtualFrame, long)}
     *   4: SpecializationActive {@link DebugExprTernaryNode#doError}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private DebugExprTernaryNodeGen(LLVMExpressionNode thenNode, LLVMExpressionNode elseNode, LLVMExpressionNode condition) {
        super(thenNode, elseNode);
        this.condition_ = condition;
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object conditionValue) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] */) && conditionValue instanceof Boolean) {
            return false;
        }
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] */) && conditionValue instanceof Integer) {
            return false;
        }
        if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] */) && conditionValue instanceof Long) {
            return false;
        }
        return true;
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object conditionValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, conditionValue);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] || SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] || SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] || SpecializationActive[DebugExprTernaryNode.doError(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] */ && conditionValue instanceof Boolean) {
                boolean conditionValue_ = (boolean) conditionValue;
                return doTernary(frameValue, conditionValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] */ && conditionValue instanceof Integer) {
                int conditionValue_ = (int) conditionValue;
                return doTernary(frameValue, conditionValue_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] */ && conditionValue instanceof Long) {
                long conditionValue_ = (long) conditionValue;
                return doTernary(frameValue, conditionValue_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[DebugExprTernaryNode.doError(Object)] */) {
                if (fallbackGuard_(state_0, conditionValue)) {
                    return doError(conditionValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, conditionValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] && SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] && SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] && SpecializationActive[DebugExprTernaryNode.doError(Object)] */)) {
            return executeGeneric_boolean0(state_0, frameValue);
        } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] && SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] && SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] && SpecializationActive[DebugExprTernaryNode.doError(Object)] */)) {
            return executeGeneric_int1(state_0, frameValue);
        } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] && SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] && SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] && SpecializationActive[DebugExprTernaryNode.doError(Object)] */)) {
            return executeGeneric_long2(state_0, frameValue);
        } else {
            return executeGeneric_generic3(state_0, frameValue);
        }
    }

    private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        boolean conditionValue_;
        try {
            conditionValue_ = this.condition_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, conditionValue_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] */;
        return doTernary(frameValue, conditionValue_);
    }

    private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int conditionValue_;
        try {
            conditionValue_ = this.condition_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, conditionValue_);
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] */;
        return doTernary(frameValue, conditionValue_);
    }

    private Object executeGeneric_long2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long conditionValue_;
        try {
            conditionValue_ = this.condition_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, conditionValue_);
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] */;
        return doTernary(frameValue, conditionValue_);
    }

    private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object conditionValue_ = this.condition_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, conditionValue_);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] || SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] || SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] || SpecializationActive[DebugExprTernaryNode.doError(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] */ && conditionValue_ instanceof Boolean) {
                boolean conditionValue__ = (boolean) conditionValue_;
                return doTernary(frameValue, conditionValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] */ && conditionValue_ instanceof Integer) {
                int conditionValue__ = (int) conditionValue_;
                return doTernary(frameValue, conditionValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] */ && conditionValue_ instanceof Long) {
                long conditionValue__ = (long) conditionValue_;
                return doTernary(frameValue, conditionValue__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[DebugExprTernaryNode.doError(Object)] */) {
                if (fallbackGuard_(state_0, conditionValue_)) {
                    return doError(conditionValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, conditionValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object conditionValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (conditionValue instanceof Boolean) {
            boolean conditionValue_ = (boolean) conditionValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] */;
            this.state_0_ = state_0;
            return doTernary(frameValue, conditionValue_);
        }
        if (conditionValue instanceof Integer) {
            int conditionValue_ = (int) conditionValue;
            state_0 = state_0 | 0b100 /* add SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] */;
            this.state_0_ = state_0;
            return doTernary(frameValue, conditionValue_);
        }
        if (conditionValue instanceof Long) {
            long conditionValue_ = (long) conditionValue;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] */;
            this.state_0_ = state_0;
            return doTernary(frameValue, conditionValue_);
        }
        state_0 = state_0 | 0b10000 /* add SpecializationActive[DebugExprTernaryNode.doError(Object)] */;
        this.state_0_ = state_0;
        return doError(conditionValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, boolean)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[DebugExprTernaryNode.doTernary(VirtualFrame, long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[DebugExprTernaryNode.doError(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static DebugExprTernaryNode create(LLVMExpressionNode thenNode, LLVMExpressionNode elseNode, LLVMExpressionNode condition) {
        return new DebugExprTernaryNodeGen(thenNode, elseNode, condition);
    }

}
