// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Clazz;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Method;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMInteropNonvirtualCallNode#doCached}
 *     Activation probability: 0.65000
 *     With/without class size: 27/16 bytes
 *   Specialization {@link LLVMInteropNonvirtualCallNode#doResolve}
 *     Activation probability: 0.35000
 *     With/without class size: 13/12 bytes
 * </pre>
 */
@GeneratedBy(LLVMInteropNonvirtualCallNode.class)
@SuppressWarnings("javadoc")
public final class LLVMInteropNonvirtualCallNodeGen extends LLVMInteropNonvirtualCallNode implements GenerateAOT.Provider {

    static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMInteropNonvirtualCallNode#doCached}
     *   2: SpecializationActive {@link LLVMInteropNonvirtualCallNode#doResolve}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private CachedData cached_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMInteropNonvirtualCallNode#doResolve}
     *   Parameter: {@link LLVMDynAccessSymbolNode} dynAccessSymbolNode</pre>
     */
    @Child private LLVMDynAccessSymbolNode resolve_dynAccessSymbolNode_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMInteropNonvirtualCallNode#doResolve}
     *   Parameter: {@link InteropLibrary} interop</pre>
     */
    @Child private InteropLibrary resolve_interop_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMInteropNonvirtualCallNode#doResolve}
     *   Parameter: {@link BranchProfile} notFound</pre>
     */
    @CompilationFinal private BranchProfile resolve_notFound_;

    private LLVMInteropNonvirtualCallNodeGen() {
    }

    @ExplodeLoop
    @Override
    Object execute(LLVMPointer arg0Value, Clazz arg1Value, String arg2Value, Method arg3Value, Object[] arg4Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMInteropNonvirtualCallNode.doCached(LLVMPointer, Clazz, String, Method, Object[], InteropLibrary, int, LLVMFunction, LLVMDynAccessSymbolNode)] || SpecializationActive[LLVMInteropNonvirtualCallNode.doResolve(LLVMPointer, Clazz, String, Method, Object[], LLVMDynAccessSymbolNode, InteropLibrary, BranchProfile)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMInteropNonvirtualCallNode.doCached(LLVMPointer, Clazz, String, Method, Object[], InteropLibrary, int, LLVMFunction, LLVMDynAccessSymbolNode)] */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((s0_.argCount_ == arg4Value.length)) {
                        assert DSLSupport.assertIdempotence((s0_.llvmFunction_ != null));
                        if ((arg2Value == arg3Value.getName()) && (arg1Value == arg3Value.getObjectClass()) && (arg1Value == LLVMInteropNonvirtualCallNode.asClazz(arg0Value))) {
                            return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.interop_, s0_.argCount_, s0_.llvmFunction_, s0_.accessSymbolNode_);
                        }
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMInteropNonvirtualCallNode.doResolve(LLVMPointer, Clazz, String, Method, Object[], LLVMDynAccessSymbolNode, InteropLibrary, BranchProfile)] */) {
                {
                    LLVMDynAccessSymbolNode dynAccessSymbolNode__ = this.resolve_dynAccessSymbolNode_;
                    if (dynAccessSymbolNode__ != null) {
                        InteropLibrary interop__ = this.resolve_interop_;
                        if (interop__ != null) {
                            BranchProfile notFound__ = this.resolve_notFound_;
                            if (notFound__ != null) {
                                return doResolve(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, dynAccessSymbolNode__, interop__, notFound__);
                            }
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    private Object executeAndSpecialize(LLVMPointer arg0Value, Clazz arg1Value, String arg2Value, Method arg3Value, Object[] arg4Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        while (true) {
            int count0_ = 0;
            CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
            CachedData s0_original = s0_;
            while (s0_ != null) {
                if ((s0_.argCount_ == arg4Value.length)) {
                    assert DSLSupport.assertIdempotence((s0_.llvmFunction_ != null));
                    if ((arg2Value == arg3Value.getName()) && (arg1Value == arg3Value.getObjectClass()) && (arg1Value == LLVMInteropNonvirtualCallNode.asClazz(arg0Value))) {
                        break;
                    }
                }
                count0_++;
                s0_ = s0_.next_;
            }
            if (s0_ == null) {
                {
                    LLVMFunction llvmFunction__ = (getLLVMFunctionUncached(arg3Value, arg1Value));
                    // assert (s0_.argCount_ == arg4Value.length);
                    if ((llvmFunction__ != null) && (arg2Value == arg3Value.getName()) && (arg1Value == arg3Value.getObjectClass()) && (arg1Value == LLVMInteropNonvirtualCallNode.asClazz(arg0Value)) && count0_ < (3)) {
                        s0_ = this.insert(new CachedData(s0_original));
                        InteropLibrary interop__1 = s0_.insert((INTEROP_LIBRARY_.createDispatched(5)));
                        Objects.requireNonNull(interop__1, "Specialization 'doCached(LLVMPointer, Clazz, String, Method, Object[], InteropLibrary, int, LLVMFunction, LLVMDynAccessSymbolNode)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.interop_ = interop__1;
                        s0_.argCount_ = (arg4Value.length);
                        s0_.llvmFunction_ = llvmFunction__;
                        LLVMDynAccessSymbolNode accessSymbolNode__ = s0_.insert((LLVMDynAccessSymbolNodeGen.create()));
                        Objects.requireNonNull(accessSymbolNode__, "Specialization 'doCached(LLVMPointer, Clazz, String, Method, Object[], InteropLibrary, int, LLVMFunction, LLVMDynAccessSymbolNode)' cache 'accessSymbolNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.accessSymbolNode_ = accessSymbolNode__;
                        if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMInteropNonvirtualCallNode.doCached(LLVMPointer, Clazz, String, Method, Object[], InteropLibrary, int, LLVMFunction, LLVMDynAccessSymbolNode)] */;
                        this.state_0_ = state_0;
                    }
                }
            }
            if (s0_ != null) {
                return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.interop_, s0_.argCount_, s0_.llvmFunction_, s0_.accessSymbolNode_);
            }
            break;
        }
        LLVMDynAccessSymbolNode dynAccessSymbolNode__ = this.insert((LLVMDynAccessSymbolNodeGen.create()));
        Objects.requireNonNull(dynAccessSymbolNode__, "Specialization 'doResolve(LLVMPointer, Clazz, String, Method, Object[], LLVMDynAccessSymbolNode, InteropLibrary, BranchProfile)' cache 'dynAccessSymbolNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.resolve_dynAccessSymbolNode_ = dynAccessSymbolNode__;
        InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(5)));
        Objects.requireNonNull(interop__, "Specialization 'doResolve(LLVMPointer, Clazz, String, Method, Object[], LLVMDynAccessSymbolNode, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.resolve_interop_ = interop__;
        BranchProfile notFound__ = (BranchProfile.create());
        Objects.requireNonNull(notFound__, "Specialization 'doResolve(LLVMPointer, Clazz, String, Method, Object[], LLVMDynAccessSymbolNode, InteropLibrary, BranchProfile)' cache 'notFound' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.resolve_notFound_ = notFound__;
        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMInteropNonvirtualCallNode.doResolve(LLVMPointer, Clazz, String, Method, Object[], LLVMDynAccessSymbolNode, InteropLibrary, BranchProfile)] */;
        this.state_0_ = state_0;
        return doResolve(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, dynAccessSymbolNode__, interop__, notFound__);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                CachedData s0_ = this.cached_cache;
                if ((s0_ == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMInteropNonvirtualCallNode create() {
        return new LLVMInteropNonvirtualCallNodeGen();
    }

    @NeverDefault
    public static LLVMInteropNonvirtualCallNode getUncached() {
        return LLVMInteropNonvirtualCallNodeGen.UNCACHED;
    }

    @GeneratedBy(LLVMInteropNonvirtualCallNode.class)
    @DenyReplace
    private static final class CachedData extends Node implements SpecializationDataNode {

        @Child CachedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropNonvirtualCallNode#doCached}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropNonvirtualCallNode#doCached}
         *   Parameter: int argCount</pre>
         */
        @CompilationFinal int argCount_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropNonvirtualCallNode#doCached}
         *   Parameter: {@link LLVMFunction} llvmFunction</pre>
         */
        @CompilationFinal LLVMFunction llvmFunction_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMInteropNonvirtualCallNode#doCached}
         *   Parameter: {@link LLVMDynAccessSymbolNode} accessSymbolNode</pre>
         */
        @Child LLVMDynAccessSymbolNode accessSymbolNode_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMInteropNonvirtualCallNode.class)
    @DenyReplace
    private static final class Uncached extends LLVMInteropNonvirtualCallNode {

        @TruffleBoundary
        @Override
        Object execute(LLVMPointer arg0Value, Clazz arg1Value, String arg2Value, Method arg3Value, Object[] arg4Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            // assert ((arg4Value.length) == arg4Value.length);
            if (((getLLVMFunctionUncached(arg3Value, arg1Value)) != null) && (arg2Value == arg3Value.getName()) && (arg1Value == arg3Value.getObjectClass()) && (arg1Value == LLVMInteropNonvirtualCallNode.asClazz(arg0Value))) {
                return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (INTEROP_LIBRARY_.getUncached()), (arg4Value.length), (getLLVMFunctionUncached(arg3Value, arg1Value)), (LLVMDynAccessSymbolNodeGen.getUncached()));
            }
            return doResolve(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (LLVMDynAccessSymbolNodeGen.getUncached()), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
