// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToAnyLLVM#fromInt}
 *     Activation probability: 0.13626
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToAnyLLVM#fromChar}
 *     Activation probability: 0.12637
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToAnyLLVM#fromLong}
 *     Activation probability: 0.11648
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToAnyLLVM#fromByte}
 *     Activation probability: 0.10659
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToAnyLLVM#fromShort}
 *     Activation probability: 0.09670
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToAnyLLVM#fromFloat}
 *     Activation probability: 0.08681
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToAnyLLVM#fromDouble}
 *     Activation probability: 0.07692
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToAnyLLVM#fromBoolean}
 *     Activation probability: 0.06703
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToAnyLLVM#fromString}
 *     Activation probability: 0.05714
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToAnyLLVM#fromPointer}
 *     Activation probability: 0.04725
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToAnyLLVM#fromUnknownObject}
 *     Activation probability: 0.03736
 *     With/without class size: 4/4 bytes
 *   Specialization {@link ToAnyLLVM#fromInternal}
 *     Activation probability: 0.02747
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToAnyLLVM#fromInteropType}
 *     Activation probability: 0.01758
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(ToAnyLLVM.class)
@SuppressWarnings("javadoc")
public final class ToAnyLLVMNodeGen extends ToAnyLLVM implements GenerateAOT.Provider {

    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link ToAnyLLVM#fromInt}
     *   2: SpecializationActive {@link ToAnyLLVM#fromChar}
     *   3: SpecializationActive {@link ToAnyLLVM#fromLong}
     *   4: SpecializationActive {@link ToAnyLLVM#fromByte}
     *   5: SpecializationActive {@link ToAnyLLVM#fromShort}
     *   6: SpecializationActive {@link ToAnyLLVM#fromFloat}
     *   7: SpecializationActive {@link ToAnyLLVM#fromDouble}
     *   8: SpecializationActive {@link ToAnyLLVM#fromBoolean}
     *   9: SpecializationActive {@link ToAnyLLVM#fromString}
     *   10: SpecializationActive {@link ToAnyLLVM#fromPointer}
     *   11: SpecializationActive {@link ToAnyLLVM#fromUnknownObject}
     *   12: SpecializationActive {@link ToAnyLLVM#fromInternal}
     *   13: SpecializationActive {@link ToAnyLLVM#fromInteropType}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToAnyLLVM#fromUnknownObject}
     *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
     */
    @Child private LLVMAsForeignLibrary fromUnknownObject_foreigns_;

    private ToAnyLLVMNodeGen() {
    }

    @Override
    public Object executeWithForeignToLLVMType(Object arg0Value, Structured type, ForeignToLLVMType ftlType) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b11111111111110) != 0 /* is SpecializationActive[ToAnyLLVM.fromInt(int)] || SpecializationActive[ToAnyLLVM.fromChar(char)] || SpecializationActive[ToAnyLLVM.fromLong(long)] || SpecializationActive[ToAnyLLVM.fromByte(byte)] || SpecializationActive[ToAnyLLVM.fromShort(short)] || SpecializationActive[ToAnyLLVM.fromFloat(float)] || SpecializationActive[ToAnyLLVM.fromDouble(double)] || SpecializationActive[ToAnyLLVM.fromBoolean(boolean)] || SpecializationActive[ToAnyLLVM.fromString(String)] || SpecializationActive[ToAnyLLVM.fromPointer(LLVMPointer)] || SpecializationActive[ToAnyLLVM.fromUnknownObject(Object, LLVMAsForeignLibrary)] || SpecializationActive[ToAnyLLVM.fromInternal(LLVMInternalTruffleObject)] || SpecializationActive[ToAnyLLVM.fromInteropType(LLVMInteropType)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToAnyLLVM.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToAnyLLVM.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToAnyLLVM.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToAnyLLVM.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToAnyLLVM.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromString(String)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return fromString(arg0Value_);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromPointer(LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return fromPointer(arg0Value_);
            }
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromUnknownObject(Object, LLVMAsForeignLibrary)] */) {
                {
                    LLVMAsForeignLibrary foreigns__ = this.fromUnknownObject_foreigns_;
                    if (foreigns__ != null) {
                        if ((foreigns__.isForeign(arg0Value))) {
                            return fromUnknownObject(arg0Value, foreigns__);
                        }
                    }
                }
            }
            if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromInternal(LLVMInternalTruffleObject)] */ && arg0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject) arg0Value;
                return fromInternal(arg0Value_);
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromInteropType(LLVMInteropType)] */ && arg0Value instanceof LLVMInteropType) {
                LLVMInteropType arg0Value_ = (LLVMInteropType) arg0Value;
                return fromInteropType(arg0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @Override
    public Object executeWithType(Object arg0Value, Structured type) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b11111111111110) != 0 /* is SpecializationActive[ToAnyLLVM.fromInt(int)] || SpecializationActive[ToAnyLLVM.fromChar(char)] || SpecializationActive[ToAnyLLVM.fromLong(long)] || SpecializationActive[ToAnyLLVM.fromByte(byte)] || SpecializationActive[ToAnyLLVM.fromShort(short)] || SpecializationActive[ToAnyLLVM.fromFloat(float)] || SpecializationActive[ToAnyLLVM.fromDouble(double)] || SpecializationActive[ToAnyLLVM.fromBoolean(boolean)] || SpecializationActive[ToAnyLLVM.fromString(String)] || SpecializationActive[ToAnyLLVM.fromPointer(LLVMPointer)] || SpecializationActive[ToAnyLLVM.fromUnknownObject(Object, LLVMAsForeignLibrary)] || SpecializationActive[ToAnyLLVM.fromInternal(LLVMInternalTruffleObject)] || SpecializationActive[ToAnyLLVM.fromInteropType(LLVMInteropType)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToAnyLLVM.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToAnyLLVM.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToAnyLLVM.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToAnyLLVM.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToAnyLLVM.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromString(String)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return fromString(arg0Value_);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromPointer(LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return fromPointer(arg0Value_);
            }
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromUnknownObject(Object, LLVMAsForeignLibrary)] */) {
                {
                    LLVMAsForeignLibrary foreigns__ = this.fromUnknownObject_foreigns_;
                    if (foreigns__ != null) {
                        if ((foreigns__.isForeign(arg0Value))) {
                            return fromUnknownObject(arg0Value, foreigns__);
                        }
                    }
                }
            }
            if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromInternal(LLVMInternalTruffleObject)] */ && arg0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject) arg0Value;
                return fromInternal(arg0Value_);
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromInteropType(LLVMInteropType)] */ && arg0Value instanceof LLVMInteropType) {
                LLVMInteropType arg0Value_ = (LLVMInteropType) arg0Value;
                return fromInteropType(arg0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b11111111111110) != 0 /* is SpecializationActive[ToAnyLLVM.fromInt(int)] || SpecializationActive[ToAnyLLVM.fromChar(char)] || SpecializationActive[ToAnyLLVM.fromLong(long)] || SpecializationActive[ToAnyLLVM.fromByte(byte)] || SpecializationActive[ToAnyLLVM.fromShort(short)] || SpecializationActive[ToAnyLLVM.fromFloat(float)] || SpecializationActive[ToAnyLLVM.fromDouble(double)] || SpecializationActive[ToAnyLLVM.fromBoolean(boolean)] || SpecializationActive[ToAnyLLVM.fromString(String)] || SpecializationActive[ToAnyLLVM.fromPointer(LLVMPointer)] || SpecializationActive[ToAnyLLVM.fromUnknownObject(Object, LLVMAsForeignLibrary)] || SpecializationActive[ToAnyLLVM.fromInternal(LLVMInternalTruffleObject)] || SpecializationActive[ToAnyLLVM.fromInteropType(LLVMInteropType)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToAnyLLVM.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return fromInt(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToAnyLLVM.fromChar(char)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return fromChar(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToAnyLLVM.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return fromLong(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToAnyLLVM.fromByte(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return fromByte(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToAnyLLVM.fromShort(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return fromShort(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromFloat(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return fromFloat(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromDouble(double)] */ && arg0Value instanceof Double) {
                double arg0Value_ = (double) arg0Value;
                return fromDouble(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromString(String)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return fromString(arg0Value_);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromPointer(LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return fromPointer(arg0Value_);
            }
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromUnknownObject(Object, LLVMAsForeignLibrary)] */) {
                {
                    LLVMAsForeignLibrary foreigns__ = this.fromUnknownObject_foreigns_;
                    if (foreigns__ != null) {
                        if ((foreigns__.isForeign(arg0Value))) {
                            return fromUnknownObject(arg0Value, foreigns__);
                        }
                    }
                }
            }
            if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromInternal(LLVMInternalTruffleObject)] */ && arg0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject) arg0Value;
                return fromInternal(arg0Value_);
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToAnyLLVM.fromInteropType(LLVMInteropType)] */ && arg0Value instanceof LLVMInteropType) {
                LLVMInteropType arg0Value_ = (LLVMInteropType) arg0Value;
                return fromInteropType(arg0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("unused")
    private Object executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[ToAnyLLVM.fromInt(int)] */;
            this.state_0_ = state_0;
            return fromInt(arg0Value_);
        }
        if (arg0Value instanceof Character) {
            char arg0Value_ = (char) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[ToAnyLLVM.fromChar(char)] */;
            this.state_0_ = state_0;
            return fromChar(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[ToAnyLLVM.fromLong(long)] */;
            this.state_0_ = state_0;
            return fromLong(arg0Value_);
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (byte) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[ToAnyLLVM.fromByte(byte)] */;
            this.state_0_ = state_0;
            return fromByte(arg0Value_);
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (short) arg0Value;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[ToAnyLLVM.fromShort(short)] */;
            this.state_0_ = state_0;
            return fromShort(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = (float) arg0Value;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToAnyLLVM.fromFloat(float)] */;
            this.state_0_ = state_0;
            return fromFloat(arg0Value_);
        }
        if (arg0Value instanceof Double) {
            double arg0Value_ = (double) arg0Value;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToAnyLLVM.fromDouble(double)] */;
            this.state_0_ = state_0;
            return fromDouble(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToAnyLLVM.fromBoolean(boolean)] */;
            this.state_0_ = state_0;
            return fromBoolean(arg0Value_);
        }
        if (arg0Value instanceof String) {
            String arg0Value_ = (String) arg0Value;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ToAnyLLVM.fromString(String)] */;
            this.state_0_ = state_0;
            return fromString(arg0Value_);
        }
        if (LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[ToAnyLLVM.fromPointer(LLVMPointer)] */;
            this.state_0_ = state_0;
            return fromPointer(arg0Value_);
        }
        {
            LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
            if ((foreigns__.isForeign(arg0Value))) {
                Objects.requireNonNull(this.insert(foreigns__), "Specialization 'fromUnknownObject(Object, LLVMAsForeignLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fromUnknownObject_foreigns_ = foreigns__;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[ToAnyLLVM.fromUnknownObject(Object, LLVMAsForeignLibrary)] */;
                this.state_0_ = state_0;
                return fromUnknownObject(arg0Value, foreigns__);
            }
        }
        if (arg0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject) arg0Value;
            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[ToAnyLLVM.fromInternal(LLVMInternalTruffleObject)] */;
            this.state_0_ = state_0;
            return fromInternal(arg0Value_);
        }
        if (arg0Value instanceof LLVMInteropType) {
            LLVMInteropType arg0Value_ = (LLVMInteropType) arg0Value;
            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[ToAnyLLVM.fromInteropType(LLVMInteropType)] */;
            this.state_0_ = state_0;
            return fromInteropType(arg0Value_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111111111110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11111111111110) & ((state_0 & 0b11111111111110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToAnyLLVM.fromInt(int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[ToAnyLLVM.fromChar(char)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToAnyLLVM.fromLong(long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[ToAnyLLVM.fromByte(byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[ToAnyLLVM.fromShort(short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[ToAnyLLVM.fromFloat(float)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[ToAnyLLVM.fromDouble(double)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[ToAnyLLVM.fromBoolean(boolean)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[ToAnyLLVM.fromString(String)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[ToAnyLLVM.fromPointer(LLVMPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[ToAnyLLVM.fromInternal(LLVMInternalTruffleObject)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000000000 /* add SpecializationActive[ToAnyLLVM.fromInteropType(LLVMInteropType)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static ToAnyLLVM create() {
        return new ToAnyLLVMNodeGen();
    }

}
