// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType.Structured;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToPointer#fromInt}
 *     Activation probability: 0.12714
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPointer#fromChar}
 *     Activation probability: 0.11857
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPointer#fromLong}
 *     Activation probability: 0.11000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPointer#fromByte}
 *     Activation probability: 0.10143
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPointer#fromShort}
 *     Activation probability: 0.09286
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPointer#fromFloat}
 *     Activation probability: 0.08429
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPointer#fromDouble}
 *     Activation probability: 0.07571
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToPointer#fromBoolean}
 *     Activation probability: 0.06714
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToPointer#fromString}
 *     Activation probability: 0.05857
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToPointer#fromPointer}
 *     Activation probability: 0.05000
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToPointer#fromTypedTruffleObjectNoAttachedType}
 *     Activation probability: 0.04143
 *     With/without class size: 4/8 bytes
 *   Specialization {@link ToPointer#fromNonTypedTruffleObject}
 *     Activation probability: 0.03286
 *     With/without class size: 4/8 bytes
 *   Specialization {@link ToPointer#fromInternal}
 *     Activation probability: 0.02429
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToPointer#fromInteropType}
 *     Activation probability: 0.01571
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(ToPointer.class)
@SuppressWarnings("javadoc")
public final class ToPointerNodeGen extends ToPointer implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);

    @Child private Dummy child0_;
    @Child private InteropTypeNode child1_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link ToPointer#fromInt}
     *   2: SpecializationActive {@link ToPointer#fromChar}
     *   3: SpecializationActive {@link ToPointer#fromLong}
     *   4: SpecializationActive {@link ToPointer#fromByte}
     *   5: SpecializationActive {@link ToPointer#fromShort}
     *   6: SpecializationActive {@link ToPointer#fromFloat}
     *   7: SpecializationActive {@link ToPointer#fromDouble}
     *   8: SpecializationActive {@link ToPointer#fromBoolean}
     *   9: SpecializationActive {@link ToPointer#fromString}
     *   10: SpecializationActive {@link ToPointer#fromPointer}
     *   11: SpecializationActive {@link ToPointer#fromTypedTruffleObjectNoAttachedType}
     *   12: SpecializationActive {@link ToPointer#fromNonTypedTruffleObject}
     *   13: SpecializationActive {@link ToPointer#fromInternal}
     *   14: SpecializationActive {@link ToPointer#fromInteropType}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private FromTypedTruffleObjectNoAttachedTypeData fromTypedTruffleObjectNoAttachedType_cache;
    @Child private FromNonTypedTruffleObjectData fromNonTypedTruffleObject_cache;

    private ToPointerNodeGen(Dummy child0, InteropTypeNode child1) {
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public Object executeWithForeignToLLVMType(Object child0Value, Structured child1Value, ForeignToLLVMType ftlType) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value, child1Value);
        }
        if ((state_0 & 0b111111111111110) != 0 /* is SpecializationActive[ToPointer.fromInt(int, Structured)] || SpecializationActive[ToPointer.fromChar(char, Structured)] || SpecializationActive[ToPointer.fromLong(long, Structured)] || SpecializationActive[ToPointer.fromByte(byte, Structured)] || SpecializationActive[ToPointer.fromShort(short, Structured)] || SpecializationActive[ToPointer.fromFloat(float, Structured)] || SpecializationActive[ToPointer.fromDouble(double, Structured)] || SpecializationActive[ToPointer.fromBoolean(boolean, Structured)] || SpecializationActive[ToPointer.fromString(String, Structured)] || SpecializationActive[ToPointer.fromPointer(LLVMPointer, Structured)] || SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] || SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] || SpecializationActive[ToPointer.fromInternal(LLVMInternalTruffleObject, Structured)] || SpecializationActive[ToPointer.fromInteropType(LLVMInteropType, Structured)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToPointer.fromInt(int, Structured)] */ && child0Value instanceof Integer) {
                int child0Value_ = (int) child0Value;
                return fromInt(child0Value_, child1Value);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToPointer.fromChar(char, Structured)] */ && child0Value instanceof Character) {
                char child0Value_ = (char) child0Value;
                return fromChar(child0Value_, child1Value);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToPointer.fromLong(long, Structured)] */ && child0Value instanceof Long) {
                long child0Value_ = (long) child0Value;
                return fromLong(child0Value_, child1Value);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToPointer.fromByte(byte, Structured)] */ && child0Value instanceof Byte) {
                byte child0Value_ = (byte) child0Value;
                return fromByte(child0Value_, child1Value);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToPointer.fromShort(short, Structured)] */ && child0Value instanceof Short) {
                short child0Value_ = (short) child0Value;
                return fromShort(child0Value_, child1Value);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToPointer.fromFloat(float, Structured)] */ && child0Value instanceof Float) {
                float child0Value_ = (float) child0Value;
                return fromFloat(child0Value_, child1Value);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToPointer.fromDouble(double, Structured)] */ && child0Value instanceof Double) {
                double child0Value_ = (double) child0Value;
                return fromDouble(child0Value_, child1Value);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToPointer.fromBoolean(boolean, Structured)] */ && child0Value instanceof Boolean) {
                boolean child0Value_ = (boolean) child0Value;
                return fromBoolean(child0Value_, child1Value);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToPointer.fromString(String, Structured)] */ && child0Value instanceof String) {
                String child0Value_ = (String) child0Value;
                return fromString(child0Value_, child1Value);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToPointer.fromPointer(LLVMPointer, Structured)] */ && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return fromPointer(child0Value_, child1Value);
            }
            if ((state_0 & 0b1100000000000) != 0 /* is SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] || SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */) {
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */) {
                    FromTypedTruffleObjectNoAttachedTypeData s10_ = this.fromTypedTruffleObjectNoAttachedType_cache;
                    if (s10_ != null) {
                        if ((s10_.foreigns_.isForeign(child0Value)) && (s10_.nativeTypes_.hasNativeType(child0Value) || child1Value == null)) {
                            return fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, s10_.nativeTypes_, s10_.foreigns_);
                        }
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */) {
                    FromNonTypedTruffleObjectData s11_ = this.fromNonTypedTruffleObject_cache;
                    if (s11_ != null) {
                        if ((s11_.foreigns_.isForeign(child0Value)) && (!(s11_.nativeTypes_.hasNativeType(child0Value))) && (child1Value != null)) {
                            return fromNonTypedTruffleObject(child0Value, child1Value, s11_.nativeTypes_, s11_.foreigns_);
                        }
                    }
                }
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToPointer.fromInternal(LLVMInternalTruffleObject, Structured)] */ && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject) child0Value;
                return fromInternal(child0Value_, child1Value);
            }
            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ToPointer.fromInteropType(LLVMInteropType, Structured)] */ && child0Value instanceof LLVMInteropType) {
                LLVMInteropType child0Value_ = (LLVMInteropType) child0Value;
                return fromInteropType(child0Value_, child1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value, child1Value);
    }

    @Override
    public Object executeWithType(Object child0Value, Structured child1Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value, child1Value);
        }
        if ((state_0 & 0b111111111111110) != 0 /* is SpecializationActive[ToPointer.fromInt(int, Structured)] || SpecializationActive[ToPointer.fromChar(char, Structured)] || SpecializationActive[ToPointer.fromLong(long, Structured)] || SpecializationActive[ToPointer.fromByte(byte, Structured)] || SpecializationActive[ToPointer.fromShort(short, Structured)] || SpecializationActive[ToPointer.fromFloat(float, Structured)] || SpecializationActive[ToPointer.fromDouble(double, Structured)] || SpecializationActive[ToPointer.fromBoolean(boolean, Structured)] || SpecializationActive[ToPointer.fromString(String, Structured)] || SpecializationActive[ToPointer.fromPointer(LLVMPointer, Structured)] || SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] || SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] || SpecializationActive[ToPointer.fromInternal(LLVMInternalTruffleObject, Structured)] || SpecializationActive[ToPointer.fromInteropType(LLVMInteropType, Structured)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToPointer.fromInt(int, Structured)] */ && child0Value instanceof Integer) {
                int child0Value_ = (int) child0Value;
                return fromInt(child0Value_, child1Value);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToPointer.fromChar(char, Structured)] */ && child0Value instanceof Character) {
                char child0Value_ = (char) child0Value;
                return fromChar(child0Value_, child1Value);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToPointer.fromLong(long, Structured)] */ && child0Value instanceof Long) {
                long child0Value_ = (long) child0Value;
                return fromLong(child0Value_, child1Value);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToPointer.fromByte(byte, Structured)] */ && child0Value instanceof Byte) {
                byte child0Value_ = (byte) child0Value;
                return fromByte(child0Value_, child1Value);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToPointer.fromShort(short, Structured)] */ && child0Value instanceof Short) {
                short child0Value_ = (short) child0Value;
                return fromShort(child0Value_, child1Value);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToPointer.fromFloat(float, Structured)] */ && child0Value instanceof Float) {
                float child0Value_ = (float) child0Value;
                return fromFloat(child0Value_, child1Value);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToPointer.fromDouble(double, Structured)] */ && child0Value instanceof Double) {
                double child0Value_ = (double) child0Value;
                return fromDouble(child0Value_, child1Value);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToPointer.fromBoolean(boolean, Structured)] */ && child0Value instanceof Boolean) {
                boolean child0Value_ = (boolean) child0Value;
                return fromBoolean(child0Value_, child1Value);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToPointer.fromString(String, Structured)] */ && child0Value instanceof String) {
                String child0Value_ = (String) child0Value;
                return fromString(child0Value_, child1Value);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToPointer.fromPointer(LLVMPointer, Structured)] */ && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return fromPointer(child0Value_, child1Value);
            }
            if ((state_0 & 0b1100000000000) != 0 /* is SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] || SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */) {
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */) {
                    FromTypedTruffleObjectNoAttachedTypeData s10_ = this.fromTypedTruffleObjectNoAttachedType_cache;
                    if (s10_ != null) {
                        if ((s10_.foreigns_.isForeign(child0Value)) && (s10_.nativeTypes_.hasNativeType(child0Value) || child1Value == null)) {
                            return fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, s10_.nativeTypes_, s10_.foreigns_);
                        }
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */) {
                    FromNonTypedTruffleObjectData s11_ = this.fromNonTypedTruffleObject_cache;
                    if (s11_ != null) {
                        if ((s11_.foreigns_.isForeign(child0Value)) && (!(s11_.nativeTypes_.hasNativeType(child0Value))) && (child1Value != null)) {
                            return fromNonTypedTruffleObject(child0Value, child1Value, s11_.nativeTypes_, s11_.foreigns_);
                        }
                    }
                }
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToPointer.fromInternal(LLVMInternalTruffleObject, Structured)] */ && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject) child0Value;
                return fromInternal(child0Value_, child1Value);
            }
            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ToPointer.fromInteropType(LLVMInteropType, Structured)] */ && child0Value instanceof LLVMInteropType) {
                LLVMInteropType child0Value_ = (LLVMInteropType) child0Value;
                return fromInteropType(child0Value_, child1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value, child1Value);
    }

    @Override
    public Object executeWithTarget(Object child0Value) {
        int state_0 = this.state_0_;
        Structured child1Value_ = this.child1_.execute();
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value, child1Value_);
        }
        if ((state_0 & 0b111111111111110) != 0 /* is SpecializationActive[ToPointer.fromInt(int, Structured)] || SpecializationActive[ToPointer.fromChar(char, Structured)] || SpecializationActive[ToPointer.fromLong(long, Structured)] || SpecializationActive[ToPointer.fromByte(byte, Structured)] || SpecializationActive[ToPointer.fromShort(short, Structured)] || SpecializationActive[ToPointer.fromFloat(float, Structured)] || SpecializationActive[ToPointer.fromDouble(double, Structured)] || SpecializationActive[ToPointer.fromBoolean(boolean, Structured)] || SpecializationActive[ToPointer.fromString(String, Structured)] || SpecializationActive[ToPointer.fromPointer(LLVMPointer, Structured)] || SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] || SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] || SpecializationActive[ToPointer.fromInternal(LLVMInternalTruffleObject, Structured)] || SpecializationActive[ToPointer.fromInteropType(LLVMInteropType, Structured)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToPointer.fromInt(int, Structured)] */ && child0Value instanceof Integer) {
                int child0Value_ = (int) child0Value;
                return fromInt(child0Value_, child1Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToPointer.fromChar(char, Structured)] */ && child0Value instanceof Character) {
                char child0Value_ = (char) child0Value;
                return fromChar(child0Value_, child1Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToPointer.fromLong(long, Structured)] */ && child0Value instanceof Long) {
                long child0Value_ = (long) child0Value;
                return fromLong(child0Value_, child1Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToPointer.fromByte(byte, Structured)] */ && child0Value instanceof Byte) {
                byte child0Value_ = (byte) child0Value;
                return fromByte(child0Value_, child1Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToPointer.fromShort(short, Structured)] */ && child0Value instanceof Short) {
                short child0Value_ = (short) child0Value;
                return fromShort(child0Value_, child1Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToPointer.fromFloat(float, Structured)] */ && child0Value instanceof Float) {
                float child0Value_ = (float) child0Value;
                return fromFloat(child0Value_, child1Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToPointer.fromDouble(double, Structured)] */ && child0Value instanceof Double) {
                double child0Value_ = (double) child0Value;
                return fromDouble(child0Value_, child1Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToPointer.fromBoolean(boolean, Structured)] */ && child0Value instanceof Boolean) {
                boolean child0Value_ = (boolean) child0Value;
                return fromBoolean(child0Value_, child1Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToPointer.fromString(String, Structured)] */ && child0Value instanceof String) {
                String child0Value_ = (String) child0Value;
                return fromString(child0Value_, child1Value_);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToPointer.fromPointer(LLVMPointer, Structured)] */ && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return fromPointer(child0Value_, child1Value_);
            }
            if ((state_0 & 0b1100000000000) != 0 /* is SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] || SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */) {
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */) {
                    FromTypedTruffleObjectNoAttachedTypeData s10_ = this.fromTypedTruffleObjectNoAttachedType_cache;
                    if (s10_ != null) {
                        if ((s10_.foreigns_.isForeign(child0Value)) && (s10_.nativeTypes_.hasNativeType(child0Value) || child1Value_ == null)) {
                            return fromTypedTruffleObjectNoAttachedType(child0Value, child1Value_, s10_.nativeTypes_, s10_.foreigns_);
                        }
                    }
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */) {
                    FromNonTypedTruffleObjectData s11_ = this.fromNonTypedTruffleObject_cache;
                    if (s11_ != null) {
                        if ((s11_.foreigns_.isForeign(child0Value)) && (!(s11_.nativeTypes_.hasNativeType(child0Value))) && (child1Value_ != null)) {
                            return fromNonTypedTruffleObject(child0Value, child1Value_, s11_.nativeTypes_, s11_.foreigns_);
                        }
                    }
                }
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ToPointer.fromInternal(LLVMInternalTruffleObject, Structured)] */ && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject) child0Value;
                return fromInternal(child0Value_, child1Value_);
            }
            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ToPointer.fromInteropType(LLVMInteropType, Structured)] */ && child0Value instanceof LLVMInteropType) {
                LLVMInteropType child0Value_ = (LLVMInteropType) child0Value;
                return fromInteropType(child0Value_, child1Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value, child1Value_);
    }

    @SuppressWarnings("unused")
    private Object executeAndSpecialize(Object child0Value, Structured child1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (child0Value instanceof Integer) {
            int child0Value_ = (int) child0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[ToPointer.fromInt(int, Structured)] */;
            this.state_0_ = state_0;
            return fromInt(child0Value_, child1Value);
        }
        if (child0Value instanceof Character) {
            char child0Value_ = (char) child0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[ToPointer.fromChar(char, Structured)] */;
            this.state_0_ = state_0;
            return fromChar(child0Value_, child1Value);
        }
        if (child0Value instanceof Long) {
            long child0Value_ = (long) child0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[ToPointer.fromLong(long, Structured)] */;
            this.state_0_ = state_0;
            return fromLong(child0Value_, child1Value);
        }
        if (child0Value instanceof Byte) {
            byte child0Value_ = (byte) child0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[ToPointer.fromByte(byte, Structured)] */;
            this.state_0_ = state_0;
            return fromByte(child0Value_, child1Value);
        }
        if (child0Value instanceof Short) {
            short child0Value_ = (short) child0Value;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[ToPointer.fromShort(short, Structured)] */;
            this.state_0_ = state_0;
            return fromShort(child0Value_, child1Value);
        }
        if (child0Value instanceof Float) {
            float child0Value_ = (float) child0Value;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToPointer.fromFloat(float, Structured)] */;
            this.state_0_ = state_0;
            return fromFloat(child0Value_, child1Value);
        }
        if (child0Value instanceof Double) {
            double child0Value_ = (double) child0Value;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToPointer.fromDouble(double, Structured)] */;
            this.state_0_ = state_0;
            return fromDouble(child0Value_, child1Value);
        }
        if (child0Value instanceof Boolean) {
            boolean child0Value_ = (boolean) child0Value;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToPointer.fromBoolean(boolean, Structured)] */;
            this.state_0_ = state_0;
            return fromBoolean(child0Value_, child1Value);
        }
        if (child0Value instanceof String) {
            String child0Value_ = (String) child0Value;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ToPointer.fromString(String, Structured)] */;
            this.state_0_ = state_0;
            return fromString(child0Value_, child1Value);
        }
        if (LLVMTypes.isPointer(child0Value)) {
            LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[ToPointer.fromPointer(LLVMPointer, Structured)] */;
            this.state_0_ = state_0;
            return fromPointer(child0Value_, child1Value);
        }
        {
            LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
            if ((foreigns__.isForeign(child0Value))) {
                NativeTypeLibrary nativeTypes__ = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
                if ((nativeTypes__.hasNativeType(child0Value) || child1Value == null)) {
                    FromTypedTruffleObjectNoAttachedTypeData s10_ = this.insert(new FromTypedTruffleObjectNoAttachedTypeData());
                    Objects.requireNonNull(s10_.insert(nativeTypes__), "Specialization 'fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s10_.nativeTypes_ = nativeTypes__;
                    Objects.requireNonNull(s10_.insert(foreigns__), "Specialization 'fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s10_.foreigns_ = foreigns__;
                    VarHandle.storeStoreFence();
                    this.fromTypedTruffleObjectNoAttachedType_cache = s10_;
                    state_0 = state_0 | 0b100000000000 /* add SpecializationActive[ToPointer.fromTypedTruffleObjectNoAttachedType(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */;
                    this.state_0_ = state_0;
                    return fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, nativeTypes__, foreigns__);
                }
            }
        }
        {
            LLVMAsForeignLibrary foreigns__1 = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
            if ((foreigns__1.isForeign(child0Value))) {
                NativeTypeLibrary nativeTypes__1 = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
                if ((!(nativeTypes__1.hasNativeType(child0Value))) && (child1Value != null)) {
                    FromNonTypedTruffleObjectData s11_ = this.insert(new FromNonTypedTruffleObjectData());
                    Objects.requireNonNull(s11_.insert(nativeTypes__1), "Specialization 'fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s11_.nativeTypes_ = nativeTypes__1;
                    Objects.requireNonNull(s11_.insert(foreigns__1), "Specialization 'fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s11_.foreigns_ = foreigns__1;
                    VarHandle.storeStoreFence();
                    this.fromNonTypedTruffleObject_cache = s11_;
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[ToPointer.fromNonTypedTruffleObject(Object, Structured, NativeTypeLibrary, LLVMAsForeignLibrary)] */;
                    this.state_0_ = state_0;
                    return fromNonTypedTruffleObject(child0Value, child1Value, nativeTypes__1, foreigns__1);
                }
            }
        }
        if (child0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject) child0Value;
            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[ToPointer.fromInternal(LLVMInternalTruffleObject, Structured)] */;
            this.state_0_ = state_0;
            return fromInternal(child0Value_, child1Value);
        }
        if (child0Value instanceof LLVMInteropType) {
            LLVMInteropType child0Value_ = (LLVMInteropType) child0Value;
            state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[ToPointer.fromInteropType(LLVMInteropType, Structured)] */;
            this.state_0_ = state_0;
            return fromInteropType(child0Value_, child1Value);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_, this.child1_}, child0Value, child1Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111111111110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b111111111111110) & ((state_0 & 0b111111111111110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToPointer.fromInt(int, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[ToPointer.fromChar(char, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToPointer.fromLong(long, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[ToPointer.fromByte(byte, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[ToPointer.fromShort(short, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[ToPointer.fromFloat(float, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[ToPointer.fromDouble(double, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[ToPointer.fromBoolean(boolean, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[ToPointer.fromString(String, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[ToPointer.fromPointer(LLVMPointer, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000000000 /* add SpecializationActive[ToPointer.fromInternal(LLVMInternalTruffleObject, Structured)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000000000 /* add SpecializationActive[ToPointer.fromInteropType(LLVMInteropType, Structured)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static ToPointer create(Dummy child0, InteropTypeNode child1) {
        return new ToPointerNodeGen(child0, child1);
    }

    @NeverDefault
    public static ToPointer getUncached() {
        return ToPointerNodeGen.UNCACHED;
    }

    @GeneratedBy(ToPointer.class)
    @DenyReplace
    private static final class FromTypedTruffleObjectNoAttachedTypeData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link ToPointer#fromTypedTruffleObjectNoAttachedType}
         *   Parameter: {@link NativeTypeLibrary} nativeTypes</pre>
         */
        @Child NativeTypeLibrary nativeTypes_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToPointer#fromTypedTruffleObjectNoAttachedType}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;

        FromTypedTruffleObjectNoAttachedTypeData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(ToPointer.class)
    @DenyReplace
    private static final class FromNonTypedTruffleObjectData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link ToPointer#fromNonTypedTruffleObject}
         *   Parameter: {@link NativeTypeLibrary} nativeTypes</pre>
         */
        @Child NativeTypeLibrary nativeTypes_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToPointer#fromNonTypedTruffleObject}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;

        FromNonTypedTruffleObjectData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(ToPointer.class)
    @DenyReplace
    private static final class Uncached extends ToPointer {

        @Override
        public Object executeWithForeignToLLVMType(Object child0Value, Structured child1Value, ForeignToLLVMType ftlType) {
            throw CompilerDirectives.shouldNotReachHere("This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
        }

        @TruffleBoundary
        @Override
        public Object executeWithType(Object child0Value, Structured child1Value) {
            if (child0Value instanceof Integer) {
                int child0Value_ = (int) child0Value;
                return fromInt(child0Value_, child1Value);
            }
            if (child0Value instanceof Character) {
                char child0Value_ = (char) child0Value;
                return fromChar(child0Value_, child1Value);
            }
            if (child0Value instanceof Long) {
                long child0Value_ = (long) child0Value;
                return fromLong(child0Value_, child1Value);
            }
            if (child0Value instanceof Byte) {
                byte child0Value_ = (byte) child0Value;
                return fromByte(child0Value_, child1Value);
            }
            if (child0Value instanceof Short) {
                short child0Value_ = (short) child0Value;
                return fromShort(child0Value_, child1Value);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = (float) child0Value;
                return fromFloat(child0Value_, child1Value);
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (double) child0Value;
                return fromDouble(child0Value_, child1Value);
            }
            if (child0Value instanceof Boolean) {
                boolean child0Value_ = (boolean) child0Value;
                return fromBoolean(child0Value_, child1Value);
            }
            if (child0Value instanceof String) {
                String child0Value_ = (String) child0Value;
                return fromString(child0Value_, child1Value);
            }
            if (LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return fromPointer(child0Value_, child1Value);
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()).isForeign(child0Value)) && ((NATIVE_TYPE_LIBRARY_.getUncached()).hasNativeType(child0Value) || child1Value == null)) {
                return fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, (NATIVE_TYPE_LIBRARY_.getUncached()), (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()));
            }
            if (((L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()).isForeign(child0Value)) && (!((NATIVE_TYPE_LIBRARY_.getUncached()).hasNativeType(child0Value))) && (child1Value != null)) {
                return fromNonTypedTruffleObject(child0Value, child1Value, (NATIVE_TYPE_LIBRARY_.getUncached()), (L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()));
            }
            if (child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject) child0Value;
                return fromInternal(child0Value_, child1Value);
            }
            if (child0Value instanceof LLVMInteropType) {
                LLVMInteropType child0Value_ = (LLVMInteropType) child0Value;
                return fromInteropType(child0Value_, child1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, child0Value, child1Value);
        }

        @Override
        public Object executeWithTarget(Object child0Value) {
            throw CompilerDirectives.shouldNotReachHere("This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
