// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMCopyTargetLibrary.class)
final class LLVMCopyTargetLibraryGen extends LibraryFactory<LLVMCopyTargetLibrary> {

    private static final Class<LLVMCopyTargetLibrary> LIBRARY_CLASS = LLVMCopyTargetLibraryGen.lazyLibraryClass();
    private static final Message CAN_COPY_FROM = new MessageImpl("canCopyFrom", 0, false, boolean.class, Object.class, Object.class, long.class);
    private static final Message COPY_FROM = new MessageImpl("copyFrom", 1, false, void.class, Object.class, Object.class, long.class);
    private static final LLVMCopyTargetLibraryGen INSTANCE = new LLVMCopyTargetLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LLVMCopyTargetLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(LLVMCopyTargetLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private LLVMCopyTargetLibraryGen() {
        super(LLVMCopyTargetLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(LLVMCopyTargetLibraryGen.CAN_COPY_FROM, LLVMCopyTargetLibraryGen.COPY_FROM)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return LLVMCopyTargetLibrary.class;
    }

    @Override
    protected LLVMCopyTargetLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected LLVMCopyTargetLibrary createDelegate(LLVMCopyTargetLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMCopyTargetLibrary lib = (LLVMCopyTargetLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.canCopyFrom(receiver, args[offset], (long) args[offset + 1]);
            case 1 :
                lib.copyFrom(receiver, args[offset], (long) args[offset + 1]);
                return null;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected LLVMCopyTargetLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected LLVMCopyTargetLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<LLVMCopyTargetLibrary> lazyLibraryClass() {
        try {
            return (Class<LLVMCopyTargetLibrary>) Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMCopyTargetLibrary", false, LLVMCopyTargetLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(LLVMCopyTargetLibrary.class)
    private static final class Default extends LibraryExport<LLVMCopyTargetLibrary> {

        private Default() {
            super(LLVMCopyTargetLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected LLVMCopyTargetLibrary createUncached(Object receiver) {
            LLVMCopyTargetLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected LLVMCopyTargetLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(LLVMCopyTargetLibrary.class)
        private static final class Cached extends LLVMCopyTargetLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean canCopyFrom(Object receiver, Object source, long length) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.canCopyFrom((dynamicDispatch_.cast(receiver)), source, length);
            }

            @Override
            public void copyFrom(Object receiver, Object source, long length) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.copyFrom((dynamicDispatch_.cast(receiver)), source, length);
                return;
            }

        }
        @GeneratedBy(LLVMCopyTargetLibrary.class)
        @DenyReplace
        private static final class Uncached extends LLVMCopyTargetLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean canCopyFrom(Object receiver, Object source, long length) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.canCopyFrom(receiver, source, length);
            }

            @TruffleBoundary
            @Override
            public void copyFrom(Object receiver, Object source, long length) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.copyFrom(receiver, source, length);
                return;
            }

        }
    }
    @GeneratedBy(LLVMCopyTargetLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(LLVMCopyTargetLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(LLVMCopyTargetLibrary.class)
    private static final class Proxy extends LLVMCopyTargetLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            try {
                return (boolean) lib.send(receiver_, LLVMCopyTargetLibraryGen.CAN_COPY_FROM, source, length);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void copyFrom(Object receiver_, Object source, long length) {
            try {
                lib.send(receiver_, LLVMCopyTargetLibraryGen.COPY_FROM, source, length);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(LLVMCopyTargetLibrary.class)
    private static final class Delegate extends LLVMCopyTargetLibrary {

        @Child private LLVMCopyTargetLibrary delegateLibrary;

        Delegate(LLVMCopyTargetLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).canCopyFrom(delegate, source, length);
            } else {
                return this.delegateLibrary.canCopyFrom(receiver_, source, length);
            }
        }

        @Override
        public void copyFrom(Object receiver_, Object source, long length) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).copyFrom(delegate, source, length);
                return;
            } else {
                this.delegateLibrary.copyFrom(receiver_, source, length);
                return;
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(LLVMCopyTargetLibrary.class)
    private static final class CachedToUncachedDispatch extends LLVMCopyTargetLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).canCopyFrom(receiver_, source, length);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void copyFrom(Object receiver_, Object source, long length) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).copyFrom(receiver_, source, length);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(LLVMCopyTargetLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends LLVMCopyTargetLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            return INSTANCE.getUncached(receiver_).canCopyFrom(receiver_, source, length);
        }

        @TruffleBoundary
        @Override
        public void copyFrom(Object receiver_, Object source, long length) {
            INSTANCE.getUncached(receiver_).copyFrom(receiver_, source, length);
            return;
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(LLVMCopyTargetLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(LLVMCopyTargetLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMCopyTargetLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch implements GenerateAOT.Provider {

        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMCopyTargetLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport<LLVMCopyTargetLibrary> export : INSTANCE.getAOTExports()) {
                LLVMCopyTargetLibrary exportLibrary = INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = insert(exportLibrary);
                } else {
                    this.next = insert(new CachedDispatchNext(exportLibrary, this.next));
                }
            }
            this.aot_ = true;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(LLVMCopyTargetLibrary.class)
    private abstract static class CachedDispatch extends LLVMCopyTargetLibrary {

        @Child LLVMCopyTargetLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(LLVMCopyTargetLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean value);

        @ExplodeLoop
        @Override
        public boolean canCopyFrom(Object receiver_, Object source, long length) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMCopyTargetLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.canCopyFrom(receiver_, source, length);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void copyFrom(Object receiver_, Object source, long length) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMCopyTargetLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.copyFrom(receiver_, source, length);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                if (isAOT()) {
                    this.library = null;
                    this.next = null;
                    setAOT(false);
                }
                CachedDispatch current = this;
                LLVMCopyTargetLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        LLVMCopyTargetLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
