// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.FallbackWrite;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.VirtualAlloc;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMManagedWriteLibrary.class)
final class LLVMManagedWriteLibraryGen extends LibraryFactory<LLVMManagedWriteLibrary> {

    private static final Class<LLVMManagedWriteLibrary> LIBRARY_CLASS = LLVMManagedWriteLibraryGen.lazyLibraryClass();
    private static final Message IS_WRITABLE = new MessageImpl("isWritable", 0, false, boolean.class, Object.class);
    private static final Message WRITE_I8 = new MessageImpl("writeI8", 1, false, void.class, Object.class, long.class, byte.class);
    private static final Message WRITE_I16 = new MessageImpl("writeI16", 2, false, void.class, Object.class, long.class, short.class);
    private static final Message WRITE_I32 = new MessageImpl("writeI32", 3, false, void.class, Object.class, long.class, int.class);
    private static final Message WRITE_FLOAT = new MessageImpl("writeFloat", 4, false, void.class, Object.class, long.class, float.class);
    private static final Message WRITE_I64 = new MessageImpl("writeI64", 5, false, void.class, Object.class, long.class, long.class);
    private static final Message WRITE_GENERIC_I64 = new MessageImpl("writeGenericI64", 6, false, void.class, Object.class, long.class, Object.class);
    private static final Message WRITE_DOUBLE = new MessageImpl("writeDouble", 7, false, void.class, Object.class, long.class, double.class);
    private static final Message WRITE_POINTER = new MessageImpl("writePointer", 8, false, void.class, Object.class, long.class, LLVMPointer.class);
    private static final LLVMManagedWriteLibraryGen INSTANCE = new LLVMManagedWriteLibraryGen();

    static  {
        LibraryFactory.register(LLVMManagedWriteLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private LLVMManagedWriteLibraryGen() {
        super(LLVMManagedWriteLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(LLVMManagedWriteLibraryGen.IS_WRITABLE, LLVMManagedWriteLibraryGen.WRITE_I8, LLVMManagedWriteLibraryGen.WRITE_I16, LLVMManagedWriteLibraryGen.WRITE_I32, LLVMManagedWriteLibraryGen.WRITE_FLOAT, LLVMManagedWriteLibraryGen.WRITE_I64, LLVMManagedWriteLibraryGen.WRITE_GENERIC_I64, LLVMManagedWriteLibraryGen.WRITE_DOUBLE, LLVMManagedWriteLibraryGen.WRITE_POINTER)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof byte[]) {
            return VirtualAlloc.class;
        } else {
            return FallbackWrite.class;
        }
    }

    @Override
    protected LLVMManagedWriteLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected LLVMManagedWriteLibrary createDelegate(LLVMManagedWriteLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMManagedWriteLibrary lib = (LLVMManagedWriteLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.isWritable(receiver);
            case 1 :
                lib.writeI8(receiver, (long) args[offset], (byte) args[offset + 1]);
                return null;
            case 2 :
                lib.writeI16(receiver, (long) args[offset], (short) args[offset + 1]);
                return null;
            case 3 :
                lib.writeI32(receiver, (long) args[offset], (int) args[offset + 1]);
                return null;
            case 4 :
                lib.writeFloat(receiver, (long) args[offset], (float) args[offset + 1]);
                return null;
            case 5 :
                lib.writeI64(receiver, (long) args[offset], (long) args[offset + 1]);
                return null;
            case 6 :
                lib.writeGenericI64(receiver, (long) args[offset], args[offset + 1]);
                return null;
            case 7 :
                lib.writeDouble(receiver, (long) args[offset], (double) args[offset + 1]);
                return null;
            case 8 :
                lib.writePointer(receiver, (long) args[offset], (LLVMPointer) args[offset + 1]);
                return null;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected LLVMManagedWriteLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected LLVMManagedWriteLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<LLVMManagedWriteLibrary> lazyLibraryClass() {
        try {
            return (Class<LLVMManagedWriteLibrary>) Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary", false, LLVMManagedWriteLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(LLVMManagedWriteLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(LLVMManagedWriteLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(LLVMManagedWriteLibrary.class)
    private static final class Proxy extends LLVMManagedWriteLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isWritable(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, LLVMManagedWriteLibraryGen.IS_WRITABLE);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeI8(Object receiver_, long offset, byte value) {
            try {
                lib.send(receiver_, LLVMManagedWriteLibraryGen.WRITE_I8, offset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeI16(Object receiver_, long offset, short value) {
            try {
                lib.send(receiver_, LLVMManagedWriteLibraryGen.WRITE_I16, offset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeI32(Object receiver_, long offset, int value) {
            try {
                lib.send(receiver_, LLVMManagedWriteLibraryGen.WRITE_I32, offset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeFloat(Object receiver_, long offset, float value) {
            try {
                lib.send(receiver_, LLVMManagedWriteLibraryGen.WRITE_FLOAT, offset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeI64(Object receiver_, long offset, long value) {
            try {
                lib.send(receiver_, LLVMManagedWriteLibraryGen.WRITE_I64, offset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeGenericI64(Object receiver_, long offset, Object value) {
            try {
                lib.send(receiver_, LLVMManagedWriteLibraryGen.WRITE_GENERIC_I64, offset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeDouble(Object receiver_, long offset, double value) {
            try {
                lib.send(receiver_, LLVMManagedWriteLibraryGen.WRITE_DOUBLE, offset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writePointer(Object receiver_, long offset, LLVMPointer value) {
            try {
                lib.send(receiver_, LLVMManagedWriteLibraryGen.WRITE_POINTER, offset, value);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(LLVMManagedWriteLibrary.class)
    private static final class Delegate extends LLVMManagedWriteLibrary {

        @Child private LLVMManagedWriteLibrary delegateLibrary;

        Delegate(LLVMManagedWriteLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isWritable(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isWritable(delegate);
            } else {
                return this.delegateLibrary.isWritable(receiver_);
            }
        }

        @Override
        public void writeI8(Object receiver_, long offset, byte value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeI8(delegate, offset, value);
                return;
            } else {
                this.delegateLibrary.writeI8(receiver_, offset, value);
                return;
            }
        }

        @Override
        public void writeI16(Object receiver_, long offset, short value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeI16(delegate, offset, value);
                return;
            } else {
                this.delegateLibrary.writeI16(receiver_, offset, value);
                return;
            }
        }

        @Override
        public void writeI32(Object receiver_, long offset, int value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 3)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeI32(delegate, offset, value);
                return;
            } else {
                this.delegateLibrary.writeI32(receiver_, offset, value);
                return;
            }
        }

        @Override
        public void writeFloat(Object receiver_, long offset, float value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 4)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeFloat(delegate, offset, value);
                return;
            } else {
                this.delegateLibrary.writeFloat(receiver_, offset, value);
                return;
            }
        }

        @Override
        public void writeI64(Object receiver_, long offset, long value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 5)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeI64(delegate, offset, value);
                return;
            } else {
                this.delegateLibrary.writeI64(receiver_, offset, value);
                return;
            }
        }

        @Override
        public void writeGenericI64(Object receiver_, long offset, Object value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 6)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeGenericI64(delegate, offset, value);
                return;
            } else {
                this.delegateLibrary.writeGenericI64(receiver_, offset, value);
                return;
            }
        }

        @Override
        public void writeDouble(Object receiver_, long offset, double value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 7)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeDouble(delegate, offset, value);
                return;
            } else {
                this.delegateLibrary.writeDouble(receiver_, offset, value);
                return;
            }
        }

        @Override
        public void writePointer(Object receiver_, long offset, LLVMPointer value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 8)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writePointer(delegate, offset, value);
                return;
            } else {
                this.delegateLibrary.writePointer(receiver_, offset, value);
                return;
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(LLVMManagedWriteLibrary.class)
    private static final class CachedToUncachedDispatch extends LLVMManagedWriteLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean isWritable(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isWritable(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeI8(Object receiver_, long offset, byte value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeI8(receiver_, offset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeI16(Object receiver_, long offset, short value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeI16(receiver_, offset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeI32(Object receiver_, long offset, int value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeI32(receiver_, offset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeFloat(Object receiver_, long offset, float value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeFloat(receiver_, offset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeI64(Object receiver_, long offset, long value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeI64(receiver_, offset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeGenericI64(Object receiver_, long offset, Object value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeGenericI64(receiver_, offset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeDouble(Object receiver_, long offset, double value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeDouble(receiver_, offset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writePointer(Object receiver_, long offset, LLVMPointer value) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writePointer(receiver_, offset, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(LLVMManagedWriteLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends LLVMManagedWriteLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean isWritable(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isWritable(receiver_);
        }

        @TruffleBoundary
        @Override
        public void writeI8(Object receiver_, long offset, byte value) {
            INSTANCE.getUncached(receiver_).writeI8(receiver_, offset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeI16(Object receiver_, long offset, short value) {
            INSTANCE.getUncached(receiver_).writeI16(receiver_, offset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeI32(Object receiver_, long offset, int value) {
            INSTANCE.getUncached(receiver_).writeI32(receiver_, offset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeFloat(Object receiver_, long offset, float value) {
            INSTANCE.getUncached(receiver_).writeFloat(receiver_, offset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeI64(Object receiver_, long offset, long value) {
            INSTANCE.getUncached(receiver_).writeI64(receiver_, offset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeGenericI64(Object receiver_, long offset, Object value) {
            INSTANCE.getUncached(receiver_).writeGenericI64(receiver_, offset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writeDouble(Object receiver_, long offset, double value) {
            INSTANCE.getUncached(receiver_).writeDouble(receiver_, offset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void writePointer(Object receiver_, long offset, LLVMPointer value) {
            INSTANCE.getUncached(receiver_).writePointer(receiver_, offset, value);
            return;
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(LLVMManagedWriteLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(LLVMManagedWriteLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMManagedWriteLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch implements GenerateAOT.Provider {

        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMManagedWriteLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport<LLVMManagedWriteLibrary> export : INSTANCE.getAOTExports()) {
                LLVMManagedWriteLibrary exportLibrary = INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = insert(exportLibrary);
                } else {
                    this.next = insert(new CachedDispatchNext(exportLibrary, this.next));
                }
            }
            this.aot_ = true;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(LLVMManagedWriteLibrary.class)
    private abstract static class CachedDispatch extends LLVMManagedWriteLibrary {

        @Child LLVMManagedWriteLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(LLVMManagedWriteLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean value);

        @ExplodeLoop
        @Override
        public boolean isWritable(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isWritable(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeI8(Object receiver_, long offset, byte value) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeI8(receiver_, offset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeI16(Object receiver_, long offset, short value) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeI16(receiver_, offset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeI32(Object receiver_, long offset, int value) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeI32(receiver_, offset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeFloat(Object receiver_, long offset, float value) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeFloat(receiver_, offset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeI64(Object receiver_, long offset, long value) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeI64(receiver_, offset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeGenericI64(Object receiver_, long offset, Object value) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeGenericI64(receiver_, offset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeDouble(Object receiver_, long offset, double value) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeDouble(receiver_, offset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writePointer(Object receiver_, long offset, LLVMPointer value) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writePointer(receiver_, offset, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                if (isAOT()) {
                    this.library = null;
                    this.next = null;
                    setAOT(false);
                }
                CachedDispatch current = this;
                LLVMManagedWriteLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        LLVMManagedWriteLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
