// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ToRegisterNode.LLVMI16ToR64;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ToRegisterNode.LLVMI32ToR64;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ToRegisterNode.LLVMI8ToR64;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMAMD64ToRegisterNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64ToRegisterNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI8ToR64#doI64(long, byte)}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMI8ToR64#doI64(long, short)}
     *     Activation probability: 0.29500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LLVMI8ToR64#doI64(long, int)}
     *     Activation probability: 0.20500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMI8ToR64#doI64(long, long)}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI8ToR64.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI8ToR64NodeGen extends LLVMI8ToR64 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode reg_;
        @Child private LLVMExpressionNode from_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI8ToR64#doI64(long, byte)}
         *   2: SpecializationActive {@link LLVMI8ToR64#doI64(long, short)}
         *   3: SpecializationActive {@link LLVMI8ToR64#doI64(long, int)}
         *   4: SpecializationActive {@link LLVMI8ToR64#doI64(long, long)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMI8ToR64NodeGen(int shift, LLVMExpressionNode reg, LLVMExpressionNode from) {
            super(shift);
            this.reg_ = reg;
            this.from_ = from;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long regValue_;
            try {
                regValue_ = this.reg_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object fromValue = this.from_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), fromValue);
            }
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */)) {
                return executeGeneric_byte0(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */)) {
                return executeGeneric_short1(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */)) {
                return executeGeneric_int2(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */)) {
                return executeGeneric_long3(state_0, frameValue, regValue_);
            } else {
                return executeGeneric_generic4(state_0, frameValue, regValue_);
            }
        }

        private Object executeGeneric_byte0(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] */;
            return doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_short1(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] */;
            return doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_int2(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] */;
            return doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_long3(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */;
            return doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] */ && fromValue_ instanceof Byte) {
                    byte fromValue__ = (byte) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] */ && fromValue_ instanceof Short) {
                    short fromValue__ = (short) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] */ && fromValue_ instanceof Integer) {
                    int fromValue__ = (int) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */ && fromValue_ instanceof Long) {
                    long fromValue__ = (long) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(regValue_, fromValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long regValue_;
            try {
                regValue_ = this.reg_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object fromValue = this.from_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), fromValue);
            }
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */)) {
                return executeI64_byte5(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */)) {
                return executeI64_short6(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */)) {
                return executeI64_int7(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */)) {
                return executeI64_long8(state_0, frameValue, regValue_);
            } else {
                return executeI64_generic9(state_0, frameValue, regValue_);
            }
        }

        private long executeI64_byte5(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] */;
            return doI64(regValue_, fromValue_);
        }

        private long executeI64_short6(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] */;
            return doI64(regValue_, fromValue_);
        }

        private long executeI64_int7(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] */;
            return doI64(regValue_, fromValue_);
        }

        private long executeI64_long8(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */;
            return doI64(regValue_, fromValue_);
        }

        private long executeI64_generic9(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] */ && fromValue_ instanceof Byte) {
                    byte fromValue__ = (byte) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] */ && fromValue_ instanceof Short) {
                    short fromValue__ = (short) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] */ && fromValue_ instanceof Integer) {
                    int fromValue__ = (int) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */ && fromValue_ instanceof Long) {
                    long fromValue__ = (long) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(regValue_, fromValue_);
        }

        private long executeAndSpecialize(Object regValue, Object fromValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (regValue instanceof Long) {
                long regValue_ = (long) regValue;
                if (fromValue instanceof Byte) {
                    byte fromValue_ = (byte) fromValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] */;
                    this.state_0_ = state_0;
                    return doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Short) {
                    short fromValue_ = (short) fromValue;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] */;
                    this.state_0_ = state_0;
                    return doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Integer) {
                    int fromValue_ = (int) fromValue;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] */;
                    this.state_0_ = state_0;
                    return doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Long) {
                    long fromValue_ = (long) fromValue;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */;
                    this.state_0_ = state_0;
                    return doI64(regValue_, fromValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.reg_, this.from_}, regValue, fromValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI8ToR64.doI64(long, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMI8ToR64 create(int shift, LLVMExpressionNode reg, LLVMExpressionNode from) {
            return new LLVMI8ToR64NodeGen(shift, reg, from);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI16ToR64#doI64(long, byte)}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMI16ToR64#doI64(long, short)}
     *     Activation probability: 0.29500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LLVMI16ToR64#doI64(long, int)}
     *     Activation probability: 0.20500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMI16ToR64#doI64(long, long)}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI16ToR64.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI16ToR64NodeGen extends LLVMI16ToR64 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode reg_;
        @Child private LLVMExpressionNode from_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI16ToR64#doI64(long, byte)}
         *   2: SpecializationActive {@link LLVMI16ToR64#doI64(long, short)}
         *   3: SpecializationActive {@link LLVMI16ToR64#doI64(long, int)}
         *   4: SpecializationActive {@link LLVMI16ToR64#doI64(long, long)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMI16ToR64NodeGen(LLVMExpressionNode reg, LLVMExpressionNode from) {
            this.reg_ = reg;
            this.from_ = from;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long regValue_;
            try {
                regValue_ = this.reg_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object fromValue = this.from_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), fromValue);
            }
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */)) {
                return executeGeneric_byte0(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */)) {
                return executeGeneric_short1(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */)) {
                return executeGeneric_int2(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */)) {
                return executeGeneric_long3(state_0, frameValue, regValue_);
            } else {
                return executeGeneric_generic4(state_0, frameValue, regValue_);
            }
        }

        private Object executeGeneric_byte0(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] */;
            return doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_short1(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] */;
            return doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_int2(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] */;
            return doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_long3(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */;
            return doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] */ && fromValue_ instanceof Byte) {
                    byte fromValue__ = (byte) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] */ && fromValue_ instanceof Short) {
                    short fromValue__ = (short) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] */ && fromValue_ instanceof Integer) {
                    int fromValue__ = (int) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */ && fromValue_ instanceof Long) {
                    long fromValue__ = (long) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(regValue_, fromValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            long regValue_;
            try {
                regValue_ = this.reg_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object fromValue = this.from_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), fromValue);
            }
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */)) {
                return executeI64_byte5(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */)) {
                return executeI64_short6(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */)) {
                return executeI64_int7(state_0, frameValue, regValue_);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */)) {
                return executeI64_long8(state_0, frameValue, regValue_);
            } else {
                return executeI64_generic9(state_0, frameValue, regValue_);
            }
        }

        private long executeI64_byte5(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] */;
            return doI64(regValue_, fromValue_);
        }

        private long executeI64_short6(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] */;
            return doI64(regValue_, fromValue_);
        }

        private long executeI64_int7(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] */;
            return doI64(regValue_, fromValue_);
        }

        private long executeI64_long8(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(regValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */;
            return doI64(regValue_, fromValue_);
        }

        private long executeI64_generic9(int state_0__, VirtualFrame frameValue, long regValue_) {
            int state_0 = state_0__;
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(regValue_, fromValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] */ && fromValue_ instanceof Byte) {
                    byte fromValue__ = (byte) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] */ && fromValue_ instanceof Short) {
                    short fromValue__ = (short) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] */ && fromValue_ instanceof Integer) {
                    int fromValue__ = (int) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */ && fromValue_ instanceof Long) {
                    long fromValue__ = (long) fromValue_;
                    return doI64(regValue_, fromValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(regValue_, fromValue_);
        }

        private long executeAndSpecialize(Object regValue, Object fromValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (regValue instanceof Long) {
                long regValue_ = (long) regValue;
                if (fromValue instanceof Byte) {
                    byte fromValue_ = (byte) fromValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] */;
                    this.state_0_ = state_0;
                    return doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Short) {
                    short fromValue_ = (short) fromValue;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] */;
                    this.state_0_ = state_0;
                    return doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Integer) {
                    int fromValue_ = (int) fromValue;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] */;
                    this.state_0_ = state_0;
                    return doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Long) {
                    long fromValue_ = (long) fromValue;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */;
                    this.state_0_ = state_0;
                    return doI64(regValue_, fromValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.reg_, this.from_}, regValue, fromValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI16ToR64.doI64(long, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMI16ToR64 create(LLVMExpressionNode reg, LLVMExpressionNode from) {
            return new LLVMI16ToR64NodeGen(reg, from);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI32ToR64#doI64(byte)}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMI32ToR64#doI64(short)}
     *     Activation probability: 0.29500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LLVMI32ToR64#doI64(int)}
     *     Activation probability: 0.20500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMI32ToR64#doI64(long)}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI32ToR64.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI32ToR64NodeGen extends LLVMI32ToR64 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode from_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI32ToR64#doI64(byte)}
         *   2: SpecializationActive {@link LLVMI32ToR64#doI64(short)}
         *   3: SpecializationActive {@link LLVMI32ToR64#doI64(int)}
         *   4: SpecializationActive {@link LLVMI32ToR64#doI64(long)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMI32ToR64NodeGen(LLVMExpressionNode from) {
            this.from_ = from;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */)) {
                return executeGeneric_byte0(state_0, frameValue);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */)) {
                return executeGeneric_short1(state_0, frameValue);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */)) {
                return executeGeneric_int2(state_0, frameValue);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */)) {
                return executeGeneric_long3(state_0, frameValue);
            } else {
                return executeGeneric_generic4(state_0, frameValue);
            }
        }

        private Object executeGeneric_byte0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] */;
            return doI64(fromValue_);
        }

        private Object executeGeneric_short1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] */;
            return doI64(fromValue_);
        }

        private Object executeGeneric_int2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] */;
            return doI64(fromValue_);
        }

        private Object executeGeneric_long3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */;
            return doI64(fromValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] */ && fromValue_ instanceof Byte) {
                    byte fromValue__ = (byte) fromValue_;
                    return doI64(fromValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] */ && fromValue_ instanceof Short) {
                    short fromValue__ = (short) fromValue_;
                    return doI64(fromValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] */ && fromValue_ instanceof Integer) {
                    int fromValue__ = (int) fromValue_;
                    return doI64(fromValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */ && fromValue_ instanceof Long) {
                    long fromValue__ = (long) fromValue_;
                    return doI64(fromValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */)) {
                return executeI64_byte5(state_0, frameValue);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */)) {
                return executeI64_short6(state_0, frameValue);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */)) {
                return executeI64_int7(state_0, frameValue);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] && SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */)) {
                return executeI64_long8(state_0, frameValue);
            } else {
                return executeI64_generic9(state_0, frameValue);
            }
        }

        private long executeI64_byte5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] */;
            return doI64(fromValue_);
        }

        private long executeI64_short6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] */;
            return doI64(fromValue_);
        }

        private long executeI64_int7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] */;
            return doI64(fromValue_);
        }

        private long executeI64_long8(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */;
            return doI64(fromValue_);
        }

        private long executeI64_generic9(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] || SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] */ && fromValue_ instanceof Byte) {
                    byte fromValue__ = (byte) fromValue_;
                    return doI64(fromValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] */ && fromValue_ instanceof Short) {
                    short fromValue__ = (short) fromValue_;
                    return doI64(fromValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] */ && fromValue_ instanceof Integer) {
                    int fromValue__ = (int) fromValue_;
                    return doI64(fromValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */ && fromValue_ instanceof Long) {
                    long fromValue__ = (long) fromValue_;
                    return doI64(fromValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromValue_);
        }

        private long executeAndSpecialize(Object fromValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromValue instanceof Byte) {
                byte fromValue_ = (byte) fromValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] */;
                this.state_0_ = state_0;
                return doI64(fromValue_);
            }
            if (fromValue instanceof Short) {
                short fromValue_ = (short) fromValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] */;
                this.state_0_ = state_0;
                return doI64(fromValue_);
            }
            if (fromValue instanceof Integer) {
                int fromValue_ = (int) fromValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] */;
                this.state_0_ = state_0;
                return doI64(fromValue_);
            }
            if (fromValue instanceof Long) {
                long fromValue_ = (long) fromValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */;
                this.state_0_ = state_0;
                return doI64(fromValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.from_}, fromValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMAMD64ToRegisterNode.LLVMI32ToR64.doI64(long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMI32ToR64 create(LLVMExpressionNode from) {
            return new LLVMI32ToR64NodeGen(from);
        }

    }
}
