// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMSyscallNode#cachedSyscall}
 *     Activation probability: 0.48333
 *     With/without class size: 19/12 bytes
 *   Specialization {@link LLVMSyscallNode#cachedSyscallGeneric}
 *     Activation probability: 0.33333
 *     With/without class size: 14/12 bytes
 *   Specialization {@link LLVMSyscallNode#doGeneric}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMSyscallNode.class)
@SuppressWarnings("javadoc")
public final class LLVMSyscallNodeGen extends LLVMSyscallNode implements GenerateAOT.Provider {

    static final ReferenceField<CachedSyscallData> CACHED_SYSCALL_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedSyscall_cache", CachedSyscallData.class);
    static final ReferenceField<CachedSyscallGenericData> CACHED_SYSCALL_GENERIC_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedSyscallGeneric_cache", CachedSyscallGenericData.class);

    @Child private LLVMExpressionNode syscallNum_;
    @Child private LLVMExpressionNode arg1_;
    @Child private LLVMExpressionNode arg2_;
    @Child private LLVMExpressionNode arg3_;
    @Child private LLVMExpressionNode arg4_;
    @Child private LLVMExpressionNode arg5_;
    @Child private LLVMExpressionNode arg6_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMSyscallNode#cachedSyscall}
     *   2: SpecializationExcluded {@link LLVMSyscallNode#cachedSyscall}
     *   3: SpecializationActive {@link LLVMSyscallNode#cachedSyscallGeneric}
     *   4: SpecializationActive {@link LLVMSyscallNode#doGeneric}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private CachedSyscallData cachedSyscall_cache;
    @UnsafeAccessedField @Child private CachedSyscallGenericData cachedSyscallGeneric_cache;

    private LLVMSyscallNodeGen(LLVMExpressionNode syscallNum, LLVMExpressionNode arg1, LLVMExpressionNode arg2, LLVMExpressionNode arg3, LLVMExpressionNode arg4, LLVMExpressionNode arg5, LLVMExpressionNode arg6) {
        this.syscallNum_ = syscallNum;
        this.arg1_ = arg1;
        this.arg2_ = arg2;
        this.arg3_ = arg3;
        this.arg4_ = arg4;
        this.arg5_ = arg5;
        this.arg6_ = arg6;
    }

    @ExplodeLoop
    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        long syscallNumValue_;
        try {
            syscallNumValue_ = this.syscallNum_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object arg1Value = this.arg1_.executeGeneric(frameValue);
            Object arg2Value = this.arg2_.executeGeneric(frameValue);
            Object arg3Value = this.arg3_.executeGeneric(frameValue);
            Object arg4Value = this.arg4_.executeGeneric(frameValue);
            Object arg5Value = this.arg5_.executeGeneric(frameValue);
            Object arg6Value = this.arg6_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }
        Object arg1Value_ = this.arg1_.executeGeneric(frameValue);
        Object arg2Value_ = this.arg2_.executeGeneric(frameValue);
        Object arg3Value_ = this.arg3_.executeGeneric(frameValue);
        Object arg4Value_ = this.arg4_.executeGeneric(frameValue);
        Object arg5Value_ = this.arg5_.executeGeneric(frameValue);
        Object arg6Value_ = this.arg6_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_);
        }
        if ((state_0 & 0b11010) != 0 /* is SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] || SpecializationActive[LLVMSyscallNode.cachedSyscallGeneric(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] || SpecializationActive[LLVMSyscallNode.doGeneric(long, Object, Object, Object, Object, Object, Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */) {
                CachedSyscallData s0_ = this.cachedSyscall_cache;
                while (s0_ != null) {
                    if ((syscallNumValue_ == s0_.cachedSyscallNum_)) {
                        try {
                            return cachedSyscall(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_, s0_.cachedSyscallNum_, s0_.node_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */;
                            state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.cachedSyscall_cache = null;
                            return ex.getResult();
                        }
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMSyscallNode.cachedSyscallGeneric(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */) {
                CachedSyscallGenericData s1_ = this.cachedSyscallGeneric_cache;
                while (s1_ != null) {
                    if ((syscallNumValue_ == s1_.cachedSyscallNum_)) {
                        return cachedSyscallGeneric(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_, s1_.cachedSyscallNum_, s1_.node_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMSyscallNode.doGeneric(long, Object, Object, Object, Object, Object, Object)] */) {
                return doGeneric(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_);
    }

    @ExplodeLoop
    @Override
    public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMSyscallNode.cachedSyscallGeneric(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] || SpecializationActive[LLVMSyscallNode.doGeneric(long, Object, Object, Object, Object, Object, Object)] */) {
            return LLVMTypesGen.expectLong(executeGeneric(frameValue));
        }
        long syscallNumValue_;
        try {
            syscallNumValue_ = this.syscallNum_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object arg1Value = this.arg1_.executeGeneric(frameValue);
            Object arg2Value = this.arg2_.executeGeneric(frameValue);
            Object arg3Value = this.arg3_.executeGeneric(frameValue);
            Object arg4Value = this.arg4_.executeGeneric(frameValue);
            Object arg5Value = this.arg5_.executeGeneric(frameValue);
            Object arg6Value = this.arg6_.executeGeneric(frameValue);
            return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult(), arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value));
        }
        Object arg1Value_ = this.arg1_.executeGeneric(frameValue);
        Object arg2Value_ = this.arg2_.executeGeneric(frameValue);
        Object arg3Value_ = this.arg3_.executeGeneric(frameValue);
        Object arg4Value_ = this.arg4_.executeGeneric(frameValue);
        Object arg5Value_ = this.arg5_.executeGeneric(frameValue);
        Object arg6Value_ = this.arg6_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectLong(executeAndSpecialize(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_));
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */) {
            CachedSyscallData s0_ = this.cachedSyscall_cache;
            while (s0_ != null) {
                if ((syscallNumValue_ == s0_.cachedSyscallNum_)) {
                    try {
                        return cachedSyscall(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_, s0_.cachedSyscallNum_, s0_.node_);
                    } catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.cachedSyscall_cache = null;
                        return LLVMTypesGen.expectLong(ex.getResult());
                    }
                }
                s0_ = s0_.next_;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(executeAndSpecialize(syscallNumValue_, arg1Value_, arg2Value_, arg3Value_, arg4Value_, arg5Value_, arg6Value_));
    }

    private Object executeAndSpecialize(Object syscallNumValue, Object arg1Value, Object arg2Value, Object arg3Value, Object arg4Value, Object arg5Value, Object arg6Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (syscallNumValue instanceof Long) {
            long syscallNumValue_ = (long) syscallNumValue;
            if (((state_0 & 0b11000)) == 0 /* is-not SpecializationActive[LLVMSyscallNode.cachedSyscallGeneric(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] && SpecializationActive[LLVMSyscallNode.doGeneric(long, Object, Object, Object, Object, Object, Object)] */ && ((state_0 & 0b100)) == 0 /* is-not SpecializationExcluded  */) {
                while (true) {
                    int count0_ = 0;
                    CachedSyscallData s0_ = CACHED_SYSCALL_CACHE_UPDATER.getVolatile(this);
                    CachedSyscallData s0_original = s0_;
                    while (s0_ != null) {
                        if ((syscallNumValue_ == s0_.cachedSyscallNum_)) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        // assert (syscallNumValue_ == s0_.cachedSyscallNum_);
                        if (count0_ < (LLVMSyscallNode.NUM_SYSCALLS)) {
                            s0_ = this.insert(new CachedSyscallData(s0_original));
                            s0_.cachedSyscallNum_ = (syscallNumValue_);
                            s0_.node_ = s0_.insert((createNode(syscallNumValue_)));
                            if (!CACHED_SYSCALL_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s0_ != null) {
                        try {
                            return cachedSyscall(syscallNumValue_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedSyscallNum_, s0_.node_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */;
                            state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.cachedSyscall_cache = null;
                            return ex.getResult();
                        }
                    }
                    break;
                }
            }
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMSyscallNode.doGeneric(long, Object, Object, Object, Object, Object, Object)] */) {
                while (true) {
                    int count1_ = 0;
                    CachedSyscallGenericData s1_ = CACHED_SYSCALL_GENERIC_CACHE_UPDATER.getVolatile(this);
                    CachedSyscallGenericData s1_original = s1_;
                    while (s1_ != null) {
                        if ((syscallNumValue_ == s1_.cachedSyscallNum_)) {
                            break;
                        }
                        count1_++;
                        s1_ = s1_.next_;
                    }
                    if (s1_ == null) {
                        // assert (syscallNumValue_ == s1_.cachedSyscallNum_);
                        if (count1_ < (LLVMSyscallNode.NUM_SYSCALLS)) {
                            s1_ = this.insert(new CachedSyscallGenericData(s1_original));
                            s1_.cachedSyscallNum_ = (syscallNumValue_);
                            s1_.node_ = s1_.insert((createNode(syscallNumValue_)));
                            if (!CACHED_SYSCALL_GENERIC_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                continue;
                            }
                            this.cachedSyscall_cache = null;
                            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMSyscallNode.cachedSyscallGeneric(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s1_ != null) {
                        return cachedSyscallGeneric(syscallNumValue_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedSyscallNum_, s1_.node_);
                    }
                    break;
                }
            }
            this.cachedSyscall_cache = null;
            this.cachedSyscallGeneric_cache = null;
            state_0 = state_0 & 0xfffffff5 /* remove SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)], SpecializationActive[LLVMSyscallNode.cachedSyscallGeneric(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMSyscallNode.doGeneric(long, Object, Object, Object, Object, Object, Object)] */;
            this.state_0_ = state_0;
            return doGeneric(syscallNumValue_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.syscallNum_, this.arg1_, this.arg2_, this.arg3_, this.arg4_, this.arg5_, this.arg6_}, syscallNumValue, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11010) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11010) & ((state_0 & 0b11010) - 1)) == 0 /* is-single  */) {
                CachedSyscallData s0_ = this.cachedSyscall_cache;
                CachedSyscallGenericData s1_ = this.cachedSyscallGeneric_cache;
                if ((s0_ == null || s0_.next_ == null) && (s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.cachedSyscall_cache = null;
            this.cachedSyscallGeneric_cache = null;
            this.state_0_ = state_0_ & 0xfffffff5 /* remove SpecializationActive[LLVMSyscallNode.cachedSyscall(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)], SpecializationActive[LLVMSyscallNode.cachedSyscallGeneric(long, Object, Object, Object, Object, Object, Object, long, LLVMSyscallOperationNode)] */;
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMSyscallNode.doGeneric(long, Object, Object, Object, Object, Object, Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMSyscallNode create(LLVMExpressionNode syscallNum, LLVMExpressionNode arg1, LLVMExpressionNode arg2, LLVMExpressionNode arg3, LLVMExpressionNode arg4, LLVMExpressionNode arg5, LLVMExpressionNode arg6) {
        return new LLVMSyscallNodeGen(syscallNum, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @GeneratedBy(LLVMSyscallNode.class)
    @DenyReplace
    private static final class CachedSyscallData extends Node implements SpecializationDataNode {

        @Child CachedSyscallData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMSyscallNode#cachedSyscall}
         *   Parameter: long cachedSyscallNum</pre>
         */
        @CompilationFinal long cachedSyscallNum_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMSyscallNode#cachedSyscall}
         *   Parameter: {@link LLVMSyscallOperationNode} node</pre>
         */
        @Child LLVMSyscallOperationNode node_;

        CachedSyscallData(CachedSyscallData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMSyscallNode.class)
    @DenyReplace
    private static final class CachedSyscallGenericData extends Node implements SpecializationDataNode {

        @Child CachedSyscallGenericData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMSyscallNode#cachedSyscallGeneric}
         *   Parameter: long cachedSyscallNum</pre>
         */
        @CompilationFinal long cachedSyscallNum_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMSyscallNode#cachedSyscallGeneric}
         *   Parameter: {@link LLVMSyscallOperationNode} node</pre>
         */
        @Child LLVMSyscallOperationNode node_;

        CachedSyscallGenericData(CachedSyscallGenericData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
