// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.base;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;

@GeneratedBy(LLVMBasicBlockNode.class)
final class LLVMBasicBlockNodeWrapper extends LLVMBasicBlockNode implements WrapperNode {

    @Child private LLVMBasicBlockNode delegateNode;
    @Child private ProbeNode probeNode;

    LLVMBasicBlockNodeWrapper(LLVMBasicBlockNode other, LLVMBasicBlockNode delegateNode, ProbeNode probeNode) {
        super(other);
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public LLVMBasicBlockNode getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public void execute(VirtualFrame frame) {
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, null);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    break;
                }
                throw t;
            }
        }
    }

    @Override
    public LLVMStatementNode[] getStatements() {
        return this.delegateNode.getStatements();
    }

    @Override
    public LLVMControlFlowNode getTerminatingInstruction() {
        return this.delegateNode.getTerminatingInstruction();
    }

    @Override
    public double getBranchProbability(int successorIndex) {
        return this.delegateNode.getBranchProbability(successorIndex);
    }

    @Override
    public void enterSuccessor(int trueSuccessor) {
        this.delegateNode.enterSuccessor(trueSuccessor);
    }

}
