// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.except.LLVMException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValueNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToI1Node#doManagedPointer}
 *     Activation probability: 0.48333
 *     With/without class size: 17/12 bytes
 *   Specialization {@link LLVMToI1Node#doPointer}
 *     Activation probability: 0.33333
 *     With/without class size: 10/4 bytes
 *   Specialization {@link LLVMToI1Node#doFallbackPointerAsComparable}
 *     Activation probability: 0.18333
 *     With/without class size: 7/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMToI1Node.class)
@SuppressWarnings("javadoc")
public final class LLVMToI1NodeGen extends LLVMToI1Node implements GenerateAOT.Provider {

    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @Child private LLVMExpressionNode fromNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToI1Node#doManagedPointer}
     *   2: SpecializationActive {@link LLVMToI1Node#doPointer}
     *   3: SpecializationExcluded {@link LLVMToI1Node#doPointer}
     *   4: SpecializationActive {@link LLVMToI1Node#doFallbackPointerAsComparable}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private ManagedPointerData managedPointer_cache;
    @Child private PointerData pointer_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMToI1Node#doFallbackPointerAsComparable}
     *   Parameter: {@link ToComparableValue} toComparableValue</pre>
     */
    @Child private ToComparableValue fallbackPointerAsComparable_toComparableValue_;

    private LLVMToI1NodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b10110) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null) {
                    if ((LLVMToI1Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                        return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                PointerData s1_ = this.pointer_cache;
                if (s1_ != null) {
                    try {
                        return doPointer(fromNodeValue__, s1_.toNative_);
                    } catch (LLVMException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.pointer_cache = null;
                        return executeAndSpecialize(fromNodeValue__);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                {
                    ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                    if (toComparableValue__ != null) {
                        return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b10110) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null) {
                    if ((LLVMToI1Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                        return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                PointerData s1_ = this.pointer_cache;
                if (s1_ != null) {
                    try {
                        return doPointer(fromNodeValue__, s1_.toNative_);
                    } catch (LLVMException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.pointer_cache = null;
                        return executeAndSpecialize(fromNodeValue__);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                {
                    ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                    if (toComparableValue__ != null) {
                        return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    @SuppressWarnings("unused")
    private boolean executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(fromNodeValue)) {
            LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
            {
                LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                if ((LLVMToI1Node.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                    ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                    s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                    Objects.requireNonNull(s0_.insert(foreigns__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.foreigns_ = foreigns__;
                    Objects.requireNonNull(s0_.insert(interop__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.interop_ = interop__;
                    VarHandle.storeStoreFence();
                    this.managedPointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return doManagedPointer(fromNodeValue_, s0_.toLLVM_, foreigns__, interop__);
                }
            }
        }
        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */ && LLVMTypes.isNativePointer(fromNodeValue)) {
            LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
            PointerData s1_ = this.insert(new PointerData());
            s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            VarHandle.storeStoreFence();
            this.pointer_cache = s1_;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
            this.state_0_ = state_0;
            try {
                return doPointer(fromNodeValue_, s1_.toNative_);
            } catch (LLVMException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                this.state_0_ = state_0;
                this.pointer_cache = null;
                return executeAndSpecialize(fromNodeValue_);
            }
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
            Objects.requireNonNull(toComparableValue__, "Specialization 'doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)' cache 'toComparableValue' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
            this.state_0_ = state_0;
            return doFallbackPointerAsComparable(fromNodeValue_, toComparableValue__);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b10110) & ((state_0 & 0b10110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            PointerData s1_ = this.insert(new PointerData());
            s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            VarHandle.storeStoreFence();
            this.pointer_cache = s1_;
            assert NodeUtil.assertRecursion(s1_.toNative_, 1);
            ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
        }
        {
            ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
            Objects.requireNonNull(toComparableValue__, "Specialization 'doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)' cache 'toComparableValue' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
            assert NodeUtil.assertRecursion(this.fallbackPointerAsComparable_toComparableValue_, 1);
            ((GenerateAOT.Provider) this.fallbackPointerAsComparable_toComparableValue_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
        this.fallbackPointerAsComparable_toComparableValue_ = null;
    }

    @NeverDefault
    public static LLVMToI1Node create(LLVMExpressionNode fromNode) {
        return new LLVMToI1NodeGen(fromNode);
    }

    @GeneratedBy(LLVMToI1Node.class)
    @DenyReplace
    private static final class ManagedPointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI1Node#doManagedPointer}
         *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
         */
        @Child ForeignToLLVM toLLVM_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI1Node#doManagedPointer}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI1Node#doManagedPointer}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;

        ManagedPointerData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMToI1Node.class)
    @DenyReplace
    private static final class PointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI1Node#doPointer}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;

        PointerData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToI1Node#doManagedPointer}
     *     Activation probability: 0.14679
     *     With/without class size: 8/12 bytes
     *   Specialization {@link LLVMToI1Node#doPointer}
     *     Activation probability: 0.13526
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMToI1Node#doFallbackPointerAsComparable}
     *     Activation probability: 0.12372
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMSignedCastToI1Node#doBoolean}
     *     Activation probability: 0.11218
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI1Node#doByte}
     *     Activation probability: 0.10064
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI1Node#doShort}
     *     Activation probability: 0.08910
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToI1Node#doInt}
     *     Activation probability: 0.07756
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI1Node#doLong}
     *     Activation probability: 0.06603
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI1Node#doLLVMIVarBit}
     *     Activation probability: 0.05449
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI1Node#doFloat}
     *     Activation probability: 0.04295
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI1Node#doDouble}
     *     Activation probability: 0.03141
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToI1Node#doLLVM80BitFloat}
     *     Activation probability: 0.01987
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMSignedCastToI1Node.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMSignedCastToI1NodeGen extends LLVMSignedCastToI1Node implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToI1Node#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToI1Node#doPointer}
         *   3: SpecializationExcluded {@link LLVMToI1Node#doPointer}
         *   4: SpecializationActive {@link LLVMToI1Node#doFallbackPointerAsComparable}
         *   5: SpecializationActive {@link LLVMSignedCastToI1Node#doBoolean}
         *   6: SpecializationActive {@link LLVMSignedCastToI1Node#doByte}
         *   7: SpecializationActive {@link LLVMSignedCastToI1Node#doShort}
         *   8: SpecializationActive {@link LLVMSignedCastToI1Node#doInt}
         *   9: SpecializationActive {@link LLVMSignedCastToI1Node#doLong}
         *   10: SpecializationActive {@link LLVMSignedCastToI1Node#doLLVMIVarBit}
         *   11: SpecializationActive {@link LLVMSignedCastToI1Node#doFloat}
         *   12: SpecializationActive {@link LLVMSignedCastToI1Node#doDouble}
         *   13: SpecializationActive {@link LLVMSignedCastToI1Node#doLLVM80BitFloat}
         *   14-16: ImplicitCast[type=LLVMIVarBit, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI1Node#doFallbackPointerAsComparable}
         *   Parameter: {@link ToComparableValue} toComparableValue</pre>
         */
        @Child private ToComparableValue fallbackPointerAsComparable_toComparableValue_;

        private LLVMSignedCastToI1NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111111010110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b11111110110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b11111101110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b11111011110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b11110111110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b11011111110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else if ((state_0 & 0b10111111110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeGeneric_double6(state_0, frameValue);
            } else {
                return executeGeneric_generic7(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] */;
            return doBoolean(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] */;
            return doByte(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] */;
            return doShort(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] */;
            return doInt(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] */;
            return doLong(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111111110110) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI1Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        try {
                            return doPointer(fromNodeValue__, s1_.toNative_);
                        } catch (LLVMException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.pointer_cache = null;
                            return executeAndSpecialize(fromNodeValue__);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    {
                        ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                        if (toComparableValue__ != null) {
                            return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doBoolean(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doByte(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doShort(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doInt(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doLong(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doLLVMIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doLLVM80BitFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111111010110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI1_boolean8(state_0, frameValue);
            } else if ((state_0 & 0b11111110110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI1_byte9(state_0, frameValue);
            } else if ((state_0 & 0b11111101110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI1_short10(state_0, frameValue);
            } else if ((state_0 & 0b11111011110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI1_int11(state_0, frameValue);
            } else if ((state_0 & 0b11110111110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI1_long12(state_0, frameValue);
            } else if ((state_0 & 0b11011111110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI1_float13(state_0, frameValue);
            } else if ((state_0 & 0b10111111110110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] */ && ((state_0 & 0b11111111110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] && SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */)) {
                return executeI1_double14(state_0, frameValue);
            } else {
                return executeI1_generic15(state_0, frameValue);
            }
        }

        private boolean executeI1_boolean8(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] */;
            return doBoolean(fromNodeValue_);
        }

        private boolean executeI1_byte9(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] */;
            return doByte(fromNodeValue_);
        }

        private boolean executeI1_short10(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] */;
            return doShort(fromNodeValue_);
        }

        private boolean executeI1_int11(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] */;
            return doInt(fromNodeValue_);
        }

        private boolean executeI1_long12(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] */;
            return doLong(fromNodeValue_);
        }

        private boolean executeI1_float13(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private boolean executeI1_double14(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private boolean executeI1_generic15(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111111110110) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] || SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI1Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        try {
                            return doPointer(fromNodeValue__, s1_.toNative_);
                        } catch (LLVMException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.pointer_cache = null;
                            return executeAndSpecialize(fromNodeValue__);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    {
                        ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                        if (toComparableValue__ != null) {
                            return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doBoolean(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doByte(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doShort(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doInt(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doLong(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doLLVMIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doLLVM80BitFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private boolean executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToI1Node.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, foreigns__, interop__);
                    }
                }
            }
            if (((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */ && LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                this.state_0_ = state_0;
                try {
                    return doPointer(fromNodeValue_, s1_.toNative_);
                } catch (LLVMException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                    state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    this.pointer_cache = null;
                    return executeAndSpecialize(fromNodeValue_);
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "Specialization 'doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)' cache 'toComparableValue' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
                this.state_0_ = state_0;
                return doFallbackPointerAsComparable(fromNodeValue_, toComparableValue__);
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] */;
                this.state_0_ = state_0;
                return doBoolean(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] */;
                this.state_0_ = state_0;
                return doByte(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] */;
                this.state_0_ = state_0;
                return doShort(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] */;
                this.state_0_ = state_0;
                return doInt(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] */;
                this.state_0_ = state_0;
                return doLong(fromNodeValue_);
            }
            {
                int lLVMIVarBitCast0;
                if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue)) != 0) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state_0 = (state_0 | (lLVMIVarBitCast0 << 14) /* set-int ImplicitCast[type=LLVMIVarBit, index=0] */);
                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] */;
                    this.state_0_ = state_0;
                    return doLLVMIVarBit(fromNodeValue_);
                }
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doLLVM80BitFloat(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111111110110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11111111110110) & ((state_0 & 0b11111111110110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
            }
            {
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "Specialization 'doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)' cache 'toComparableValue' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                assert NodeUtil.assertRecursion(this.fallbackPointerAsComparable_toComparableValue_, 1);
                ((GenerateAOT.Provider) this.fallbackPointerAsComparable_toComparableValue_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doBoolean(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doByte(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doShort(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doInt(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLong(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVMIVarBit(LLVMIVarBit)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doFloat(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doDouble(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000000 /* add SpecializationActive[LLVMToI1Node.LLVMSignedCastToI1Node.doLLVM80BitFloat(LLVM80BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            state_0 = state_0 | 0x1c000 /* add ImplicitCast[type=LLVMIVarBit, index=0] */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
            this.fallbackPointerAsComparable_toComparableValue_ = null;
        }

        @NeverDefault
        public static LLVMSignedCastToI1Node create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToI1NodeGen(fromNode);
        }

        @GeneratedBy(LLVMSignedCastToI1Node.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI1Node#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI1Node#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI1Node#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMSignedCastToI1Node.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI1Node#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;

            PointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToI1Node#doManagedPointer}
     *     Activation probability: 0.32000
     *     With/without class size: 12/12 bytes
     *   Specialization {@link LLVMToI1Node#doPointer}
     *     Activation probability: 0.26000
     *     With/without class size: 9/4 bytes
     *   Specialization {@link LLVMToI1Node#doFallbackPointerAsComparable}
     *     Activation probability: 0.20000
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMBitcastToI1Node#doI1}
     *     Activation probability: 0.14000
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToI1Node#doI1Vector}
     *     Activation probability: 0.08000
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMBitcastToI1Node.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMBitcastToI1NodeGen extends LLVMBitcastToI1Node implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToI1Node#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToI1Node#doPointer}
         *   3: SpecializationExcluded {@link LLVMToI1Node#doPointer}
         *   4: SpecializationActive {@link LLVMToI1Node#doFallbackPointerAsComparable}
         *   5: SpecializationActive {@link LLVMBitcastToI1Node#doI1}
         *   6: SpecializationActive {@link LLVMBitcastToI1Node#doI1Vector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToI1Node#doFallbackPointerAsComparable}
         *   Parameter: {@link ToComparableValue} toComparableValue</pre>
         */
        @Child private ToComparableValue fallbackPointerAsComparable_toComparableValue_;

        private LLVMBitcastToI1NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1010110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] */ && ((state_0 & 0b1110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] && SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1Vector(LLVMI1Vector)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] */;
            return doI1(fromNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b1110110) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] || SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1Vector(LLVMI1Vector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI1Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        try {
                            return doPointer(fromNodeValue__, s1_.toNative_);
                        } catch (LLVMException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.pointer_cache = null;
                            return executeAndSpecialize(fromNodeValue__);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    {
                        ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                        if (toComparableValue__ != null) {
                            return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI1(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1010110) == 0 /* only-active SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] */ && ((state_0 & 0b1110110) != 0  /* is-not SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] && SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] && SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] && SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1Vector(LLVMI1Vector)] */)) {
                return executeI1_boolean2(state_0, frameValue);
            } else {
                return executeI1_generic3(state_0, frameValue);
            }
        }

        private boolean executeI1_boolean2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] */;
            return doI1(fromNodeValue_);
        }

        private boolean executeI1_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b1110110) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] || SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] || SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] || SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1Vector(LLVMI1Vector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToI1Node.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        try {
                            return doPointer(fromNodeValue__, s1_.toNative_);
                        } catch (LLVMException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.pointer_cache = null;
                            return executeAndSpecialize(fromNodeValue__);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    {
                        ToComparableValue toComparableValue__ = this.fallbackPointerAsComparable_toComparableValue_;
                        if (toComparableValue__ != null) {
                            return doFallbackPointerAsComparable(fromNodeValue__, toComparableValue__);
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doI1(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private boolean executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToI1Node.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)' cache 'foreigns' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "Specialization 'doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToI1Node.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, foreigns__, interop__);
                    }
                }
            }
            if (((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */ && LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                this.state_0_ = state_0;
                try {
                    return doPointer(fromNodeValue_, s1_.toNative_);
                } catch (LLVMException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
                    state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    this.pointer_cache = null;
                    return executeAndSpecialize(fromNodeValue_);
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "Specialization 'doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)' cache 'toComparableValue' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
                this.state_0_ = state_0;
                return doFallbackPointerAsComparable(fromNodeValue_, toComparableValue__);
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] */;
                this.state_0_ = state_0;
                return doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1Vector(LLVMI1Vector)] */;
                this.state_0_ = state_0;
                return doI1Vector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1110110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1110110) & ((state_0 & 0b1110110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToI1Node.doPointer(LLVMNativePointer, LLVMToNativeNode)] */;
            }
            {
                ToComparableValue toComparableValue__ = this.insert((ToComparableValueNodeGen.create()));
                Objects.requireNonNull(toComparableValue__, "Specialization 'doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)' cache 'toComparableValue' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallbackPointerAsComparable_toComparableValue_ = toComparableValue__;
                assert NodeUtil.assertRecursion(this.fallbackPointerAsComparable_toComparableValue_, 1);
                ((GenerateAOT.Provider) this.fallbackPointerAsComparable_toComparableValue_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToI1Node.doFallbackPointerAsComparable(LLVMPointer, ToComparableValue)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToI1Node.LLVMBitcastToI1Node.doI1Vector(LLVMI1Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
            this.fallbackPointerAsComparable_toComparableValue_ = null;
        }

        @NeverDefault
        public static LLVMBitcastToI1Node create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToI1NodeGen(fromNode);
        }

        @GeneratedBy(LLVMBitcastToI1Node.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI1Node#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI1Node#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI1Node#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMBitcastToI1Node.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToI1Node#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;

            PointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
