// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVM128BitFloatRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVM80BitFloatRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMAddressRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMDoubleRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMFloatRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMI16RetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMI1RetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMI32RetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMI64RetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMI8RetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMIVarBitRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMStructRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMVectorRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode.LLVMVoidReturnNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMRetNode.class)
@SuppressWarnings("javadoc")
public final class LLVMRetNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI1RetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI1RetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI1RetNodeGen extends LLVMI1RetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI1RetNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMI1RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            boolean retResultValue_;
            try {
                retResultValue_ = this.retResult_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMI1RetNode.doOp(boolean)] */) {
                return doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof Boolean) {
                boolean retResultValue_ = (boolean) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI1RetNode.doOp(boolean)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI1RetNode.doOp(boolean)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMI1RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI1RetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI8RetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI8RetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI8RetNodeGen extends LLVMI8RetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI8RetNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMI8RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            byte retResultValue_;
            try {
                retResultValue_ = this.retResult_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMI8RetNode.doOp(byte)] */) {
                return doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof Byte) {
                byte retResultValue_ = (byte) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI8RetNode.doOp(byte)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI8RetNode.doOp(byte)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMI8RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI8RetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI16RetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI16RetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI16RetNodeGen extends LLVMI16RetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI16RetNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMI16RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            short retResultValue_;
            try {
                retResultValue_ = this.retResult_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMI16RetNode.doOp(short)] */) {
                return doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof Short) {
                short retResultValue_ = (short) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI16RetNode.doOp(short)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI16RetNode.doOp(short)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMI16RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI16RetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI32RetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI32RetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI32RetNodeGen extends LLVMI32RetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI32RetNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMI32RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int retResultValue_;
            try {
                retResultValue_ = this.retResult_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMI32RetNode.doOp(int)] */) {
                return doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof Integer) {
                int retResultValue_ = (int) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI32RetNode.doOp(int)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI32RetNode.doOp(int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMI32RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI32RetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI64RetNode#doOp(long)}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link LLVMI64RetNode#doOp(LLVMPointer)}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI64RetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI64RetNodeGen extends LLVMI64RetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI64RetNode#doOp(long)}
         *   2: SpecializationActive {@link LLVMI64RetNode#doOp(LLVMPointer)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMI64RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(long)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(long)] && SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(LLVMPointer)] */)) {
                return execute_long0(state_0, frameValue);
            } else {
                return execute_generic1(state_0, frameValue);
            }
        }

        private Object execute_long0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long retResultValue_;
            try {
                retResultValue_ = this.retResult_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(long)] */;
            return doOp(retResultValue_);
        }

        private Object execute_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(long)] || SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(LLVMPointer)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(long)] */ && retResultValue_ instanceof Long) {
                    long retResultValue__ = (long) retResultValue_;
                    return doOp(retResultValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(LLVMPointer)] */ && LLVMTypes.isPointer(retResultValue_)) {
                    LLVMPointer retResultValue__ = LLVMTypes.asPointer(retResultValue_);
                    return doOp(retResultValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof Long) {
                long retResultValue_ = (long) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(long)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            if (LLVMTypes.isPointer(retResultValue)) {
                LLVMPointer retResultValue_ = LLVMTypes.asPointer(retResultValue);
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(LLVMPointer)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMRetNode.LLVMI64RetNode.doOp(LLVMPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMI64RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI64RetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMIVarBitRetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMIVarBitRetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMIVarBitRetNodeGen extends LLVMIVarBitRetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMIVarBitRetNode#doOp}
         *   2-4: ImplicitCast[type=LLVMIVarBit, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMIVarBitRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMIVarBitRetNode.doOp(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, retResultValue_)) {
                LLVMIVarBit retResultValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, retResultValue_);
                return doOp(retResultValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            {
                int lLVMIVarBitCast0;
                if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(retResultValue)) != 0) {
                    LLVMIVarBit retResultValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, retResultValue);
                    state_0 = (state_0 | (lLVMIVarBitCast0 << 2) /* set-int ImplicitCast[type=LLVMIVarBit, index=0] */);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMIVarBitRetNode.doOp(LLVMIVarBit)] */;
                    this.state_0_ = state_0;
                    return doOp(retResultValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMIVarBitRetNode.doOp(LLVMIVarBit)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            state_0 = state_0 | 0b11100 /* add ImplicitCast[type=LLVMIVarBit, index=0] */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMIVarBitRetNode create(LLVMExpressionNode retResult) {
            return new LLVMIVarBitRetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMFloatRetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMFloatRetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMFloatRetNodeGen extends LLVMFloatRetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMFloatRetNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMFloatRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            float retResultValue_;
            try {
                retResultValue_ = this.retResult_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMFloatRetNode.doOp(float)] */) {
                return doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof Float) {
                float retResultValue_ = (float) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMFloatRetNode.doOp(float)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMFloatRetNode.doOp(float)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFloatRetNode create(LLVMExpressionNode retResult) {
            return new LLVMFloatRetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMDoubleRetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMDoubleRetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMDoubleRetNodeGen extends LLVMDoubleRetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMDoubleRetNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMDoubleRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            double retResultValue_;
            try {
                retResultValue_ = this.retResult_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMDoubleRetNode.doOp(double)] */) {
                return doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof Double) {
                double retResultValue_ = (double) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMDoubleRetNode.doOp(double)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMDoubleRetNode.doOp(double)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMDoubleRetNode create(LLVMExpressionNode retResult) {
            return new LLVMDoubleRetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVM80BitFloatRetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVM80BitFloatRetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVM80BitFloatRetNodeGen extends LLVM80BitFloatRetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVM80BitFloatRetNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVM80BitFloatRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVM80BitFloatRetNode.doOp(LLVM80BitFloat)] */ && retResultValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat retResultValue__ = (LLVM80BitFloat) retResultValue_;
                return doOp(retResultValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat retResultValue_ = (LLVM80BitFloat) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVM80BitFloatRetNode.doOp(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVM80BitFloatRetNode.doOp(LLVM80BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVM80BitFloatRetNode create(LLVMExpressionNode retResult) {
            return new LLVM80BitFloatRetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVM128BitFloatRetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVM128BitFloatRetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVM128BitFloatRetNodeGen extends LLVM128BitFloatRetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVM128BitFloatRetNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVM128BitFloatRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVM128BitFloatRetNode.doOp(LLVM128BitFloat)] */ && retResultValue_ instanceof LLVM128BitFloat) {
                LLVM128BitFloat retResultValue__ = (LLVM128BitFloat) retResultValue_;
                return doOp(retResultValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat retResultValue_ = (LLVM128BitFloat) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVM128BitFloatRetNode.doOp(LLVM128BitFloat)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVM128BitFloatRetNode.doOp(LLVM128BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVM128BitFloatRetNode create(LLVMExpressionNode retResult) {
            return new LLVM128BitFloatRetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAddressRetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAddressRetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMAddressRetNodeGen extends LLVMAddressRetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;

        private LLVMAddressRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            return doOp(retResultValue_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static LLVMAddressRetNode create(LLVMExpressionNode retResult) {
            return new LLVMAddressRetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMVectorRetNode#doOp(LLVMDoubleVector)}
     *     Activation probability: 0.23929
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMVectorRetNode#doOp(LLVMFloatVector)}
     *     Activation probability: 0.20714
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMVectorRetNode#doOp(LLVMI16Vector)}
     *     Activation probability: 0.17500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMVectorRetNode#doOp(LLVMI1Vector)}
     *     Activation probability: 0.14286
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMVectorRetNode#doOp(LLVMI32Vector)}
     *     Activation probability: 0.11071
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMVectorRetNode#doOp(LLVMI64Vector)}
     *     Activation probability: 0.07857
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMVectorRetNode#doOp(LLVMI8Vector)}
     *     Activation probability: 0.04643
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMVectorRetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMVectorRetNodeGen extends LLVMVectorRetNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMVectorRetNode#doOp(LLVMDoubleVector)}
         *   2: SpecializationActive {@link LLVMVectorRetNode#doOp(LLVMFloatVector)}
         *   3: SpecializationActive {@link LLVMVectorRetNode#doOp(LLVMI16Vector)}
         *   4: SpecializationActive {@link LLVMVectorRetNode#doOp(LLVMI1Vector)}
         *   5: SpecializationActive {@link LLVMVectorRetNode#doOp(LLVMI32Vector)}
         *   6: SpecializationActive {@link LLVMVectorRetNode#doOp(LLVMI64Vector)}
         *   7: SpecializationActive {@link LLVMVectorRetNode#doOp(LLVMI8Vector)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMVectorRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(retResultValue_);
            }
            if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMDoubleVector)] || SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMFloatVector)] || SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI16Vector)] || SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI1Vector)] || SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI32Vector)] || SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI64Vector)] || SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI8Vector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMDoubleVector)] */ && retResultValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector retResultValue__ = (LLVMDoubleVector) retResultValue_;
                    return doOp(retResultValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMFloatVector)] */ && retResultValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector retResultValue__ = (LLVMFloatVector) retResultValue_;
                    return doOp(retResultValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI16Vector)] */ && retResultValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector retResultValue__ = (LLVMI16Vector) retResultValue_;
                    return doOp(retResultValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI1Vector)] */ && retResultValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector retResultValue__ = (LLVMI1Vector) retResultValue_;
                    return doOp(retResultValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI32Vector)] */ && retResultValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector retResultValue__ = (LLVMI32Vector) retResultValue_;
                    return doOp(retResultValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI64Vector)] */ && retResultValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector retResultValue__ = (LLVMI64Vector) retResultValue_;
                    return doOp(retResultValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI8Vector)] */ && retResultValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector retResultValue__ = (LLVMI8Vector) retResultValue_;
                    return doOp(retResultValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (retResultValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector retResultValue_ = (LLVMDoubleVector) retResultValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMDoubleVector)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMFloatVector) {
                LLVMFloatVector retResultValue_ = (LLVMFloatVector) retResultValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMFloatVector)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI16Vector) {
                LLVMI16Vector retResultValue_ = (LLVMI16Vector) retResultValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI16Vector)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI1Vector) {
                LLVMI1Vector retResultValue_ = (LLVMI1Vector) retResultValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI1Vector)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI32Vector) {
                LLVMI32Vector retResultValue_ = (LLVMI32Vector) retResultValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI32Vector)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI64Vector) {
                LLVMI64Vector retResultValue_ = (LLVMI64Vector) retResultValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI64Vector)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI8Vector) {
                LLVMI8Vector retResultValue_ = (LLVMI8Vector) retResultValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI8Vector)] */;
                this.state_0_ = state_0;
                return doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11111110) & ((state_0 & 0b11111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMDoubleVector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMFloatVector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI16Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI1Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI32Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI64Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMRetNode.LLVMVectorRetNode.doOp(LLVMI8Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMVectorRetNode create(LLVMExpressionNode retResult) {
            return new LLVMVectorRetNodeGen(retResult);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMStructRetNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMStructRetNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMStructRetNodeGen extends LLVMStructRetNode implements GenerateAOT.Provider {

        private final long structSize;
        @Child private LLVMExpressionNode retResult_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMStructRetNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMStructRetNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode retResult, long structSize) {
            super(memMove);
            this.structSize = structSize;
            this.retResult_ = retResult;
        }

        @Override
        public long getStructSize() {
            return this.structSize;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(frameValue, retResultValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMRetNode.LLVMStructRetNode.doOp(VirtualFrame, LLVMPointer)] */ && LLVMTypes.isPointer(retResultValue_)) {
                LLVMPointer retResultValue__ = LLVMTypes.asPointer(retResultValue_);
                return doOp(frameValue, retResultValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, retResultValue_);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object retResultValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(retResultValue)) {
                LLVMPointer retResultValue_ = LLVMTypes.asPointer(retResultValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMStructRetNode.doOp(VirtualFrame, LLVMPointer)] */;
                this.state_0_ = state_0;
                return doOp(frameValue, retResultValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.retResult_}, retResultValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMRetNode.LLVMStructRetNode.doOp(VirtualFrame, LLVMPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMStructRetNode create(LLVMMemMoveNode memMove, LLVMExpressionNode retResult, long structSize) {
            return new LLVMStructRetNodeGen(memMove, retResult, structSize);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMVoidReturnNode#doOp}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMVoidReturnNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMVoidReturnNodeGen extends LLVMVoidReturnNode implements GenerateAOT.Provider {

        private LLVMVoidReturnNodeGen() {
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return doOp();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static LLVMVoidReturnNode create() {
            return new LLVMVoidReturnNodeGen();
        }

    }
}
