// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLandingpadNode.LandingpadEntryNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(LandingpadEntryNode.class)
final class LandingpadEntryNodeWrapper extends LandingpadEntryNode implements WrapperNode {

    @Child private LandingpadEntryNode delegateNode;
    @Child private ProbeNode probeNode;

    LandingpadEntryNodeWrapper(LandingpadEntryNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public LandingpadEntryNode getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public int execute(VirtualFrame frame, LLVMStack stack, LLVMPointer unwindHeader) {
        int returnValue;
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                returnValue = delegateNode.execute(frame, stack, unwindHeader);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, returnValue);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    returnValue = (int) result;
                    break;
                }
                throw t;
            }
        }
        return returnValue;
    }

}
