// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMSignal#doSignal}
 *     Activation probability: 1.00000
 *     With/without class size: 24/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMSignal.class)
@SuppressWarnings("javadoc")
public final class LLVMSignalNodeGen extends LLVMSignal implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode signal_;
    @Child private LLVMExpressionNode handler_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMSignal#doSignal}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private SignalData signal_cache;

    private LLVMSignalNodeGen(LLVMExpressionNode signal, LLVMExpressionNode handler) {
        this.signal_ = signal;
        this.handler_ = handler;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        int signalValue_;
        try {
            signalValue_ = this.signal_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object handlerValue = this.handler_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), handlerValue);
        }
        Object handlerValue_ = this.handler_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(signalValue_, handlerValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMSignal.doSignal(int, LLVMPointer, LLVMToNativeNode)] */ && LLVMTypes.isPointer(handlerValue_)) {
            LLVMPointer handlerValue__ = LLVMTypes.asPointer(handlerValue_);
            SignalData s0_ = this.signal_cache;
            if (s0_ != null) {
                return doSignal(signalValue_, handlerValue__, s0_.toNative_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(signalValue_, handlerValue_);
    }

    private LLVMPointer executeAndSpecialize(Object signalValue, Object handlerValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (signalValue instanceof Integer) {
            int signalValue_ = (int) signalValue;
            if (LLVMTypes.isPointer(handlerValue)) {
                LLVMPointer handlerValue_ = LLVMTypes.asPointer(handlerValue);
                SignalData s0_ = this.insert(new SignalData());
                s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.signal_cache = s0_;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMSignal.doSignal(int, LLVMPointer, LLVMToNativeNode)] */;
                this.state_0_ = state_0;
                return doSignal(signalValue_, handlerValue_, s0_.toNative_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.signal_, this.handler_}, signalValue, handlerValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            SignalData s0_ = this.insert(new SignalData());
            s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            VarHandle.storeStoreFence();
            this.signal_cache = s0_;
            assert NodeUtil.assertRecursion(s0_.toNative_, 1);
            ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMSignal.doSignal(int, LLVMPointer, LLVMToNativeNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.signal_cache = null;
    }

    @NeverDefault
    public static LLVMSignal create(LLVMExpressionNode signal, LLVMExpressionNode handler) {
        return new LLVMSignalNodeGen(signal, handler);
    }

    @GeneratedBy(LLVMSignal.class)
    @DenyReplace
    private static final class SignalData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMSignal#doSignal}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;

        SignalData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
