// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPolyglotExport#doExport}
 *     Activation probability: 1.00000
 *     With/without class size: 28/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMPolyglotExport.class)
@SuppressWarnings("javadoc")
public final class LLVMPolyglotExportNodeGen extends LLVMPolyglotExport implements GenerateAOT.Provider {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @Child private LLVMExpressionNode name_;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPolyglotExport#doExport}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPolyglotExport#doExport}
     *   Parameter: {@link InteropLibrary} interop</pre>
     */
    @Child private InteropLibrary interop_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPolyglotExport#doExport}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile exception_;

    private LLVMPolyglotExportNodeGen(LLVMExpressionNode name, LLVMExpressionNode value) {
        this.name_ = name;
        this.value_ = value;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object nameValue_ = this.name_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(nameValue_, valueValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPolyglotExport.doExport(Object, Object, InteropLibrary, BranchProfile)] */) {
            {
                InteropLibrary interop__ = this.interop_;
                if (interop__ != null) {
                    BranchProfile exception__ = this.exception_;
                    if (exception__ != null) {
                        return doExport(nameValue_, valueValue_, interop__, exception__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(nameValue_, valueValue_);
    }

    private Object executeAndSpecialize(Object nameValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
        Objects.requireNonNull(interop__, "Specialization 'doExport(Object, Object, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.interop_ = interop__;
        BranchProfile exception__ = (BranchProfile.create());
        Objects.requireNonNull(exception__, "Specialization 'doExport(Object, Object, InteropLibrary, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.exception_ = exception__;
        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPolyglotExport.doExport(Object, Object, InteropLibrary, BranchProfile)] */;
        this.state_0_ = state_0;
        return doExport(nameValue, valueValue, interop__, exception__);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPolyglotExport create(LLVMExpressionNode name, LLVMExpressionNode value) {
        return new LLVMPolyglotExportNodeGen(name, value);
    }

}
