// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMReadCharsetNode#doCachedPointer}
 *     Activation probability: 0.48333
 *     With/without class size: 15/8 bytes
 *   Specialization {@link LLVMReadCharsetNode#doCachedOther}
 *     Activation probability: 0.33333
 *     With/without class size: 12/8 bytes
 *   Specialization {@link LLVMReadCharsetNode#doGeneric}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMReadCharsetNode.class)
@SuppressWarnings("javadoc")
public final class LLVMReadCharsetNodeGen extends LLVMReadCharsetNode implements GenerateAOT.Provider {

    static final ReferenceField<CachedPointerData> CACHED_POINTER_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedPointer_cache", CachedPointerData.class);
    static final ReferenceField<CachedOtherData> CACHED_OTHER_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cachedOther_cache", CachedOtherData.class);

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMReadCharsetNode#doCachedPointer}
     *   2: SpecializationActive {@link LLVMReadCharsetNode#doGeneric}
     *   3: SpecializationActive {@link LLVMReadCharsetNode#doCachedOther}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @CompilationFinal private CachedPointerData cachedPointer_cache;
    @UnsafeAccessedField @CompilationFinal private CachedOtherData cachedOther_cache;

    private LLVMReadCharsetNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @ExplodeLoop
    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMReadCharsetNode.doCachedPointer(LLVMPointer, LLVMPointer, LLVMCharset)] || SpecializationActive[LLVMReadCharsetNode.doCachedOther(Object, Object, LLVMCharset)] || SpecializationActive[LLVMReadCharsetNode.doGeneric(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReadCharsetNode.doCachedPointer(LLVMPointer, LLVMPointer, LLVMCharset)] */ && LLVMTypes.isPointer(child0Value_)) {
                LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
                CachedPointerData s0_ = this.cachedPointer_cache;
                while (s0_ != null) {
                    if ((s0_.cachedPointer_.isSame(child0Value__))) {
                        return doCachedPointer(child0Value__, s0_.cachedPointer_, s0_.cachedCharset_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMReadCharsetNode.doCachedOther(Object, Object, LLVMCharset)] || SpecializationActive[LLVMReadCharsetNode.doGeneric(Object)] */) {
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMReadCharsetNode.doCachedOther(Object, Object, LLVMCharset)] */) {
                    CachedOtherData s1_ = this.cachedOther_cache;
                    while (s1_ != null) {
                        if ((child0Value_ == s1_.cachedAddress_)) {
                            return doCachedOther(child0Value_, s1_.cachedAddress_, s1_.cachedCharset_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMReadCharsetNode.doGeneric(Object)] */) {
                    return doGeneric(child0Value_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    private LLVMCharset executeAndSpecialize(Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMReadCharsetNode.doGeneric(Object)] */ && LLVMTypes.isPointer(child0Value)) {
            LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
            while (true) {
                int count0_ = 0;
                CachedPointerData s0_ = CACHED_POINTER_CACHE_UPDATER.getVolatile(this);
                CachedPointerData s0_original = s0_;
                while (s0_ != null) {
                    if ((s0_.cachedPointer_.isSame(child0Value_))) {
                        break;
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    {
                        LLVMPointer cachedPointer__ = (child0Value_);
                        if ((cachedPointer__.isSame(child0Value_)) && count0_ < (3)) {
                            s0_ = new CachedPointerData(s0_original);
                            s0_.cachedPointer_ = cachedPointer__;
                            s0_.cachedCharset_ = (doGeneric(cachedPointer__));
                            if (!CACHED_POINTER_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReadCharsetNode.doCachedPointer(LLVMPointer, LLVMPointer, LLVMCharset)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s0_ != null) {
                    return doCachedPointer(child0Value_, s0_.cachedPointer_, s0_.cachedCharset_);
                }
                break;
            }
        }
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LLVMReadCharsetNode.doGeneric(Object)] */) {
            while (true) {
                int count1_ = 0;
                CachedOtherData s1_ = CACHED_OTHER_CACHE_UPDATER.getVolatile(this);
                CachedOtherData s1_original = s1_;
                while (s1_ != null) {
                    if ((child0Value == s1_.cachedAddress_)) {
                        break;
                    }
                    count1_++;
                    s1_ = s1_.next_;
                }
                if (s1_ == null) {
                    // assert (child0Value == s1_.cachedAddress_);
                    if (count1_ < (3)) {
                        s1_ = new CachedOtherData(s1_original);
                        s1_.cachedAddress_ = (child0Value);
                        s1_.cachedCharset_ = (doGeneric(s1_.cachedAddress_));
                        if (!CACHED_OTHER_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMReadCharsetNode.doCachedOther(Object, Object, LLVMCharset)] */;
                        this.state_0_ = state_0;
                    }
                }
                if (s1_ != null) {
                    return doCachedOther(child0Value, s1_.cachedAddress_, s1_.cachedCharset_);
                }
                break;
            }
        }
        this.cachedPointer_cache = null;
        this.cachedOther_cache = null;
        state_0 = state_0 & 0xfffffff5 /* remove SpecializationActive[LLVMReadCharsetNode.doCachedPointer(LLVMPointer, LLVMPointer, LLVMCharset)], SpecializationActive[LLVMReadCharsetNode.doCachedOther(Object, Object, LLVMCharset)] */;
        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMReadCharsetNode.doGeneric(Object)] */;
        this.state_0_ = state_0;
        return doGeneric(child0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                CachedPointerData s0_ = this.cachedPointer_cache;
                CachedOtherData s1_ = this.cachedOther_cache;
                if ((s0_ == null || s0_.next_ == null) && (s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.cachedPointer_cache = null;
            this.cachedOther_cache = null;
            this.state_0_ = state_0_ & 0xfffffff5 /* remove SpecializationActive[LLVMReadCharsetNode.doCachedPointer(LLVMPointer, LLVMPointer, LLVMCharset)], SpecializationActive[LLVMReadCharsetNode.doCachedOther(Object, Object, LLVMCharset)] */;
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMReadCharsetNode.doGeneric(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMReadCharsetNode create(LLVMExpressionNode child0) {
        return new LLVMReadCharsetNodeGen(child0);
    }

    @GeneratedBy(LLVMReadCharsetNode.class)
    @DenyReplace
    private static final class CachedPointerData implements SpecializationDataNode {

        @CompilationFinal final CachedPointerData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMReadCharsetNode#doCachedPointer}
         *   Parameter: {@link LLVMPointer} cachedPointer</pre>
         */
        @CompilationFinal LLVMPointer cachedPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMReadCharsetNode#doCachedPointer}
         *   Parameter: {@link LLVMCharset} cachedCharset</pre>
         */
        @CompilationFinal LLVMCharset cachedCharset_;

        CachedPointerData(CachedPointerData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMReadCharsetNode.class)
    @DenyReplace
    private static final class CachedOtherData implements SpecializationDataNode {

        @CompilationFinal final CachedOtherData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMReadCharsetNode#doCachedOther}
         *   Parameter: {@link Object} cachedAddress</pre>
         */
        @CompilationFinal Object cachedAddress_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMReadCharsetNode#doCachedOther}
         *   Parameter: {@link LLVMCharset} cachedCharset</pre>
         */
        @CompilationFinal LLVMCharset cachedCharset_;

        CachedOtherData(CachedOtherData next_) {
            this.next_ = next_;
        }

    }
}
