// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemMove.LLVMMemMoveI64;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMMemMove.class)
@SuppressWarnings("javadoc")
public final class LLVMMemMoveFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMMemMoveI64#doVoid}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMMemMoveI64.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMMemMoveI64NodeGen extends LLVMMemMoveI64 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode dest_;
        @Child private LLVMExpressionNode src_;
        @Child private LLVMExpressionNode length_;
        @Child private LLVMExpressionNode isVolatile_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMMemMoveI64#doVoid}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMMemMoveI64NodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode dest, LLVMExpressionNode src, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
            super(memMove);
            this.dest_ = dest;
            this.src_ = src;
            this.length_ = length;
            this.isVolatile_ = isVolatile;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object destValue_ = this.dest_.executeGeneric(frameValue);
            Object srcValue_ = this.src_.executeGeneric(frameValue);
            long lengthValue_;
            try {
                lengthValue_ = this.length_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
                return executeAndSpecialize(destValue_, srcValue_, ex.getResult(), isVolatileValue);
            }
            boolean isVolatileValue_;
            try {
                isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(destValue_, srcValue_, lengthValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(destValue_, srcValue_, lengthValue_, isVolatileValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMMemMove.LLVMMemMoveI64.doVoid(LLVMPointer, LLVMPointer, long, boolean)] */ && LLVMTypes.isPointer(destValue_)) {
                LLVMPointer destValue__ = LLVMTypes.asPointer(destValue_);
                if (LLVMTypes.isPointer(srcValue_)) {
                    LLVMPointer srcValue__ = LLVMTypes.asPointer(srcValue_);
                    return doVoid(destValue__, srcValue__, lengthValue_, isVolatileValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(destValue_, srcValue_, lengthValue_, isVolatileValue_);
        }

        private Object executeAndSpecialize(Object destValue, Object srcValue, Object lengthValue, Object isVolatileValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(destValue)) {
                LLVMPointer destValue_ = LLVMTypes.asPointer(destValue);
                if (LLVMTypes.isPointer(srcValue)) {
                    LLVMPointer srcValue_ = LLVMTypes.asPointer(srcValue);
                    if (lengthValue instanceof Long) {
                        long lengthValue_ = (long) lengthValue;
                        if (isVolatileValue instanceof Boolean) {
                            boolean isVolatileValue_ = (boolean) isVolatileValue;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMMemMove.LLVMMemMoveI64.doVoid(LLVMPointer, LLVMPointer, long, boolean)] */;
                            this.state_0_ = state_0;
                            return doVoid(destValue_, srcValue_, lengthValue_, isVolatileValue_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.dest_, this.src_, this.length_, this.isVolatile_}, destValue, srcValue, lengthValue, isVolatileValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMMemMove.LLVMMemMoveI64.doVoid(LLVMPointer, LLVMPointer, long, boolean)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMMemMoveI64 create(LLVMMemMoveNode memMove, LLVMExpressionNode dest, LLVMExpressionNode src, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
            return new LLVMMemMoveI64NodeGen(memMove, dest, src, length, isVolatile);
        }

    }
}
