// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary.NoUncachedAssert;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMVaListLibrary.class)
final class LLVMVaListLibraryGen extends LibraryFactory<LLVMVaListLibrary> {

    private static final Class<LLVMVaListLibrary> LIBRARY_CLASS = LLVMVaListLibraryGen.lazyLibraryClass();
    private static final Message INITIALIZE = new MessageImpl("initialize", 0, false, void.class, Object.class, Object[].class, int.class, Frame.class);
    private static final Message CLEANUP = new MessageImpl("cleanup", 1, false, void.class, Object.class, Frame.class);
    private static final Message COPY = new MessageImpl("copy", 2, false, void.class, Object.class, Object.class, Frame.class);
    private static final Message COPY_WITHOUT_FRAME = new MessageImpl("copyWithoutFrame", 3, false, void.class, Object.class, Object.class);
    private static final Message SHIFT = new MessageImpl("shift", 4, false, Object.class, Object.class, Type.class, Frame.class);
    private static final LLVMVaListLibraryGen INSTANCE = new LLVMVaListLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LLVMVaListLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(LLVMVaListLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private LLVMVaListLibraryGen() {
        super(LLVMVaListLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(LLVMVaListLibraryGen.INITIALIZE, LLVMVaListLibraryGen.CLEANUP, LLVMVaListLibraryGen.COPY, LLVMVaListLibraryGen.COPY_WITHOUT_FRAME, LLVMVaListLibraryGen.SHIFT)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return LLVMVaListLibrary.class;
    }

    @Override
    protected LLVMVaListLibrary createAssertions(LLVMVaListLibrary delegate) {
        return new NoUncachedAssert(delegate);
    }

    @Override
    protected LLVMVaListLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected LLVMVaListLibrary createDelegate(LLVMVaListLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMVaListLibrary lib = (LLVMVaListLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                lib.initialize(receiver, (Object[]) args[offset], (int) args[offset + 1], (Frame) args[offset + 2]);
                return null;
            case 1 :
                lib.cleanup(receiver, (Frame) args[offset]);
                return null;
            case 2 :
                lib.copy(receiver, args[offset], (Frame) args[offset + 1]);
                return null;
            case 3 :
                lib.copyWithoutFrame(receiver, args[offset]);
                return null;
            case 4 :
                return lib.shift(receiver, (Type) args[offset], (Frame) args[offset + 1]);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected LLVMVaListLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected LLVMVaListLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<LLVMVaListLibrary> lazyLibraryClass() {
        try {
            return (Class<LLVMVaListLibrary>) Class.forName("com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary", false, LLVMVaListLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(LLVMVaListLibrary.class)
    private static final class Default extends LibraryExport<LLVMVaListLibrary> {

        private Default() {
            super(LLVMVaListLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected LLVMVaListLibrary createUncached(Object receiver) {
            LLVMVaListLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected LLVMVaListLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(LLVMVaListLibrary.class)
        private static final class Cached extends LLVMVaListLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public void initialize(Object receiver, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public void cleanup(Object receiver, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public void copy(Object receiver, Object destVaList, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public void copyWithoutFrame(Object receiver, Object destVaList) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.copyWithoutFrame((dynamicDispatch_.cast(receiver)), destVaList);
                return;
            }

            @Override
            public Object shift(Object receiver, Type type, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

        }
        @GeneratedBy(LLVMVaListLibrary.class)
        @DenyReplace
        private static final class Uncached extends LLVMVaListLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public void initialize(Object receiver, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public void cleanup(Object receiver, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public void copy(Object receiver, Object destVaList, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public void copyWithoutFrame(Object receiver, Object destVaList) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.copyWithoutFrame(receiver, destVaList);
                return;
            }

            @Override
            public Object shift(Object receiver, Type type, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

        }
    }
    @GeneratedBy(LLVMVaListLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(LLVMVaListLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(LLVMVaListLibrary.class)
    private static final class Proxy extends LLVMVaListLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            try {
                lib.send(receiver_, LLVMVaListLibraryGen.INITIALIZE, arguments, numberOfExplicitArguments, frame);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void cleanup(Object receiver_, Frame frame) {
            try {
                lib.send(receiver_, LLVMVaListLibraryGen.CLEANUP, frame);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            try {
                lib.send(receiver_, LLVMVaListLibraryGen.COPY, destVaList, frame);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void copyWithoutFrame(Object receiver_, Object destVaList) {
            try {
                lib.send(receiver_, LLVMVaListLibraryGen.COPY_WITHOUT_FRAME, destVaList);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object shift(Object receiver_, Type type, Frame frame) {
            try {
                return lib.send(receiver_, LLVMVaListLibraryGen.SHIFT, type, frame);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(LLVMVaListLibrary.class)
    private static final class Delegate extends LLVMVaListLibrary {

        @Child private LLVMVaListLibrary delegateLibrary;

        Delegate(LLVMVaListLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).initialize(delegate, arguments, numberOfExplicitArguments, frame);
                return;
            } else {
                this.delegateLibrary.initialize(receiver_, arguments, numberOfExplicitArguments, frame);
                return;
            }
        }

        @Override
        public void cleanup(Object receiver_, Frame frame) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).cleanup(delegate, frame);
                return;
            } else {
                this.delegateLibrary.cleanup(receiver_, frame);
                return;
            }
        }

        @Override
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).copy(delegate, destVaList, frame);
                return;
            } else {
                this.delegateLibrary.copy(receiver_, destVaList, frame);
                return;
            }
        }

        @Override
        public void copyWithoutFrame(Object receiver_, Object destVaList) {
            if (LibraryFactory.isDelegated(delegateLibrary, 3)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).copyWithoutFrame(delegate, destVaList);
                return;
            } else {
                this.delegateLibrary.copyWithoutFrame(receiver_, destVaList);
                return;
            }
        }

        @Override
        public Object shift(Object receiver_, Type type, Frame frame) {
            if (LibraryFactory.isDelegated(delegateLibrary, 4)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).shift(delegate, type, frame);
            } else {
                return this.delegateLibrary.shift(receiver_, type, frame);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(LLVMVaListLibrary.class)
    private static final class CachedToUncachedDispatch extends LLVMVaListLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            assert assertAdopted(this);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).initialize(receiver_, arguments, numberOfExplicitArguments, frame);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void cleanup(Object receiver_, Frame frame) {
            assert assertAdopted(this);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).cleanup(receiver_, frame);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            assert assertAdopted(this);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).copy(receiver_, destVaList, frame);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void copyWithoutFrame(Object receiver_, Object destVaList) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).copyWithoutFrame(receiver_, destVaList);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public Object shift(Object receiver_, Type type, Frame frame) {
            assert assertAdopted(this);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).shift(receiver_, type, frame);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(LLVMVaListLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends LLVMVaListLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            INSTANCE.getUncached(receiver_).initialize(receiver_, arguments, numberOfExplicitArguments, frame);
            return;
        }

        @Override
        public void cleanup(Object receiver_, Frame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            INSTANCE.getUncached(receiver_).cleanup(receiver_, frame);
            return;
        }

        @Override
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            INSTANCE.getUncached(receiver_).copy(receiver_, destVaList, frame);
            return;
        }

        @TruffleBoundary
        @Override
        public void copyWithoutFrame(Object receiver_, Object destVaList) {
            INSTANCE.getUncached(receiver_).copyWithoutFrame(receiver_, destVaList);
            return;
        }

        @Override
        public Object shift(Object receiver_, Type type, Frame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return INSTANCE.getUncached(receiver_).shift(receiver_, type, frame);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(LLVMVaListLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(LLVMVaListLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMVaListLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch implements GenerateAOT.Provider {

        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMVaListLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport<LLVMVaListLibrary> export : INSTANCE.getAOTExports()) {
                LLVMVaListLibrary exportLibrary = INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = insert(exportLibrary);
                } else {
                    this.next = insert(new CachedDispatchNext(exportLibrary, this.next));
                }
            }
            this.aot_ = true;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(LLVMVaListLibrary.class)
    private abstract static class CachedDispatch extends LLVMVaListLibrary {

        @Child LLVMVaListLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(LLVMVaListLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean value);

        @ExplodeLoop
        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.initialize(receiver_, arguments, numberOfExplicitArguments, frame);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void cleanup(Object receiver_, Frame frame) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.cleanup(receiver_, frame);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.copy(receiver_, destVaList, frame);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void copyWithoutFrame(Object receiver_, Object destVaList) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.copyWithoutFrame(receiver_, destVaList);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object shift(Object receiver_, Type type, Frame frame) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.shift(receiver_, type, frame);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                if (isAOT()) {
                    this.library = null;
                    this.next = null;
                    setAOT(false);
                }
                CachedDispatch current = this;
                LLVMVaListLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        LLVMVaListLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
