// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadKeyIntrinsics.LLVMThreadGetSpecific;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadKeyIntrinsics.LLVMThreadKeyCreate;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadKeyIntrinsics.LLVMThreadKeyDelete;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadKeyIntrinsics.LLVMThreadSetSpecific;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMThreadKeyIntrinsics.class)
@SuppressWarnings("javadoc")
public final class LLVMThreadKeyIntrinsicsFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadKeyCreate#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadKeyCreate.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadKeyCreateNodeGen extends LLVMThreadKeyCreate implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode destructor_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMThreadKeyCreate#doIntrinsic}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMThreadKeyCreateNodeGen(LLVMExpressionNode destructor) {
            this.destructor_ = destructor;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object destructorValue_ = this.destructor_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(destructorValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadKeyCreate.doIntrinsic(LLVMPointer)] */ && LLVMTypes.isPointer(destructorValue_)) {
                LLVMPointer destructorValue__ = LLVMTypes.asPointer(destructorValue_);
                return doIntrinsic(destructorValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(destructorValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object destructorValue_ = this.destructor_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(destructorValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadKeyCreate.doIntrinsic(LLVMPointer)] */ && LLVMTypes.isPointer(destructorValue_)) {
                LLVMPointer destructorValue__ = LLVMTypes.asPointer(destructorValue_);
                return doIntrinsic(destructorValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(destructorValue_);
        }

        private int executeAndSpecialize(Object destructorValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(destructorValue)) {
                LLVMPointer destructorValue_ = LLVMTypes.asPointer(destructorValue);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadKeyCreate.doIntrinsic(LLVMPointer)] */;
                this.state_0_ = state_0;
                return doIntrinsic(destructorValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.destructor_}, destructorValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadKeyCreate.doIntrinsic(LLVMPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadKeyCreate create(LLVMExpressionNode destructor) {
            return new LLVMThreadKeyCreateNodeGen(destructor);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadKeyDelete#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadKeyDelete.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadKeyDeleteNodeGen extends LLVMThreadKeyDelete implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode key_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMThreadKeyDelete#doIntrinsic}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMThreadKeyDeleteNodeGen(LLVMExpressionNode key) {
            this.key_ = key;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int keyValue_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(keyValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadKeyDelete.doIntrinsic(int)] */) {
                return doIntrinsic(keyValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(keyValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int keyValue_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(keyValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadKeyDelete.doIntrinsic(int)] */) {
                return doIntrinsic(keyValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(keyValue_);
        }

        private int executeAndSpecialize(Object keyValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (keyValue instanceof Integer) {
                int keyValue_ = (int) keyValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadKeyDelete.doIntrinsic(int)] */;
                this.state_0_ = state_0;
                return doIntrinsic(keyValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.key_}, keyValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadKeyDelete.doIntrinsic(int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadKeyDelete create(LLVMExpressionNode key) {
            return new LLVMThreadKeyDeleteNodeGen(key);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadGetSpecific#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadGetSpecific.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadGetSpecificNodeGen extends LLVMThreadGetSpecific implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode key_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMThreadGetSpecific#doIntrinsic}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMThreadGetSpecificNodeGen(LLVMExpressionNode key) {
            this.key_ = key;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int keyValue_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(keyValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadGetSpecific.doIntrinsic(int)] */) {
                return doIntrinsic(keyValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(keyValue_);
        }

        private LLVMPointer executeAndSpecialize(Object keyValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (keyValue instanceof Integer) {
                int keyValue_ = (int) keyValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadGetSpecific.doIntrinsic(int)] */;
                this.state_0_ = state_0;
                return doIntrinsic(keyValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.key_}, keyValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadGetSpecific.doIntrinsic(int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadGetSpecific create(LLVMExpressionNode key) {
            return new LLVMThreadGetSpecificNodeGen(key);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMThreadSetSpecific#doIntrinsic}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMThreadSetSpecific.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMThreadSetSpecificNodeGen extends LLVMThreadSetSpecific implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode key_;
        @Child private LLVMExpressionNode value_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMThreadSetSpecific#doIntrinsic}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMThreadSetSpecificNodeGen(LLVMExpressionNode key, LLVMExpressionNode value) {
            this.key_ = key;
            this.value_ = value;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int keyValue_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object valueValue = this.value_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), valueValue);
            }
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(keyValue_, valueValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadSetSpecific.doIntrinsic(int, LLVMPointer)] */ && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                return doIntrinsic(keyValue_, valueValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(keyValue_, valueValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            int keyValue_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object valueValue = this.value_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), valueValue);
            }
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(keyValue_, valueValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadSetSpecific.doIntrinsic(int, LLVMPointer)] */ && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                return doIntrinsic(keyValue_, valueValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(keyValue_, valueValue_);
        }

        private int executeAndSpecialize(Object keyValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (keyValue instanceof Integer) {
                int keyValue_ = (int) keyValue;
                if (LLVMTypes.isPointer(valueValue)) {
                    LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadSetSpecific.doIntrinsic(int, LLVMPointer)] */;
                    this.state_0_ = state_0;
                    return doIntrinsic(keyValue_, valueValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.key_, this.value_}, keyValue, valueValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b10) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMThreadKeyIntrinsics.LLVMThreadSetSpecific.doIntrinsic(int, LLVMPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadSetSpecific create(LLVMExpressionNode key, LLVMExpressionNode value) {
            return new LLVMThreadSetSpecificNodeGen(key, value);
        }

    }
}
