// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.AsPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.IsPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.ToNativePointerNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMNativePointerSupport.class)
@SuppressWarnings("javadoc")
public final class LLVMNativePointerSupportFactory {

    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link IsPointerNode#doNativePointer}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link IsPointerNode#doManagedPointer}
     *     Activation probability: 0.33333
     *     With/without class size: 10/4 bytes
     *   Specialization {@link IsPointerNode#doOther}
     *     Activation probability: 0.18333
     *     With/without class size: 7/4 bytes
     * </pre>
     */
    @GeneratedBy(IsPointerNode.class)
    @SuppressWarnings("javadoc")
    public static final class IsPointerNodeGen extends IsPointerNode implements GenerateAOT.Provider {

        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link IsPointerNode#doNativePointer}
         *   2: SpecializationActive {@link IsPointerNode#doManagedPointer}
         *   3: SpecializationActive {@link IsPointerNode#doOther}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link IsPointerNode#doManagedPointer}
         *   Parameter: {@link IsPointerHelper} isPointerHelper</pre>
         */
        @Child private IsPointerHelper managedPointer_isPointerHelper_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link IsPointerNode#doOther}
         *   Parameter: {@link IsPointerHelper} isPointerHelper</pre>
         */
        @Child private IsPointerHelper fallback_isPointerHelper_;

        private IsPointerNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arg0Value) {
            if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doNativePointer(LLVMNativePointer)] */) && LLVMTypes.isNativePointer(arg0Value)) {
                return false;
            }
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doManagedPointer(LLVMManagedPointer, IsPointerHelper)] */) && LLVMTypes.isManagedPointer(arg0Value)) {
                return false;
            }
            return true;
        }

        @Override
        public boolean execute(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doManagedPointer(LLVMManagedPointer, IsPointerHelper)] || SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doOther(Object, IsPointerHelper)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doNativePointer(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return doNativePointer(arg0Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doManagedPointer(LLVMManagedPointer, IsPointerHelper)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    {
                        IsPointerHelper isPointerHelper__ = this.managedPointer_isPointerHelper_;
                        if (isPointerHelper__ != null) {
                            return doManagedPointer(arg0Value_, isPointerHelper__);
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doOther(Object, IsPointerHelper)] */) {
                    {
                        IsPointerHelper isPointerHelper__1 = this.fallback_isPointerHelper_;
                        if (isPointerHelper__1 != null) {
                            if (fallbackGuard_(state_0, arg0Value)) {
                                return doOther(arg0Value, isPointerHelper__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private boolean executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doNativePointer(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doNativePointer(arg0Value_);
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                IsPointerHelper isPointerHelper__ = this.insert((IsPointerHelperNodeGen.create()));
                Objects.requireNonNull(isPointerHelper__, "Specialization 'doManagedPointer(LLVMManagedPointer, IsPointerHelper)' cache 'isPointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.managedPointer_isPointerHelper_ = isPointerHelper__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doManagedPointer(LLVMManagedPointer, IsPointerHelper)] */;
                this.state_0_ = state_0;
                return doManagedPointer(arg0Value_, isPointerHelper__);
            }
            IsPointerHelper isPointerHelper__1 = this.insert((IsPointerHelperNodeGen.create()));
            Objects.requireNonNull(isPointerHelper__1, "Specialization 'doOther(Object, IsPointerHelper)' cache 'isPointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fallback_isPointerHelper_ = isPointerHelper__1;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doOther(Object, IsPointerHelper)] */;
            this.state_0_ = state_0;
            return doOther(arg0Value, isPointerHelper__1);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doNativePointer(LLVMNativePointer)] */;
            }
            {
                IsPointerHelper isPointerHelper__ = this.insert((IsPointerHelperNodeGen.create()));
                Objects.requireNonNull(isPointerHelper__, "Specialization 'doManagedPointer(LLVMManagedPointer, IsPointerHelper)' cache 'isPointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.managedPointer_isPointerHelper_ = isPointerHelper__;
                assert NodeUtil.assertRecursion(this.managedPointer_isPointerHelper_, 1);
                ((GenerateAOT.Provider) this.managedPointer_isPointerHelper_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doManagedPointer(LLVMManagedPointer, IsPointerHelper)] */;
            }
            {
                IsPointerHelper isPointerHelper__1 = this.insert((IsPointerHelperNodeGen.create()));
                Objects.requireNonNull(isPointerHelper__1, "Specialization 'doOther(Object, IsPointerHelper)' cache 'isPointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallback_isPointerHelper_ = isPointerHelper__1;
                assert NodeUtil.assertRecursion(this.fallback_isPointerHelper_, 1);
                ((GenerateAOT.Provider) this.fallback_isPointerHelper_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMNativePointerSupport.IsPointerNode.doOther(Object, IsPointerHelper)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.managedPointer_isPointerHelper_ = null;
            this.fallback_isPointerHelper_ = null;
        }

        @NeverDefault
        public static IsPointerNode create() {
            return new IsPointerNodeGen();
        }

        @NeverDefault
        public static IsPointerNode getUncached() {
            return IsPointerNodeGen.UNCACHED;
        }

        @GeneratedBy(IsPointerNode.class)
        @DenyReplace
        private static final class Uncached extends IsPointerNode {

            @TruffleBoundary
            @Override
            public boolean execute(Object arg0Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return doNativePointer(arg0Value_);
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doManagedPointer(arg0Value_, (IsPointerHelperNodeGen.getUncached()));
                }
                return doOther(arg0Value, (IsPointerHelperNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        /**
         * Debug Info: <pre>
         *   Specialization {@link IsPointerHelper#doLong}
         *     Activation probability: 0.38500
         *     With/without class size: 8/0 bytes
         *   Specialization {@link IsPointerHelper#doByteArray}
         *     Activation probability: 0.29500
         *     With/without class size: 7/0 bytes
         *   Specialization {@link IsPointerHelper#doFunctionDescriptor}
         *     Activation probability: 0.20500
         *     With/without class size: 6/0 bytes
         *   Specialization {@link IsPointerHelper#doOther}
         *     Activation probability: 0.11500
         *     With/without class size: 6/4 bytes
         * </pre>
         */
        @GeneratedBy(IsPointerHelper.class)
        @SuppressWarnings("javadoc")
        static final class IsPointerHelperNodeGen extends IsPointerHelper implements GenerateAOT.Provider {

            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link IsPointerHelper#doLong}
             *   2: SpecializationActive {@link IsPointerHelper#doByteArray}
             *   3: SpecializationActive {@link IsPointerHelper#doFunctionDescriptor}
             *   4: SpecializationActive {@link IsPointerHelper#doOther}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IsPointerHelper#doOther}
             *   Parameter: {@link LLVMNativeLibrary} natives</pre>
             */
            @Child private LLVMNativeLibrary fallback_natives_;

            private IsPointerHelperNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value) {
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[IsPointerNode.IsPointerHelper.doLong(long)] */) && arg0Value instanceof Long) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[IsPointerNode.IsPointerHelper.doByteArray(byte[])] */) && arg0Value instanceof byte[]) {
                    return false;
                }
                if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[IsPointerNode.IsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor)] */) && arg0Value instanceof LLVMFunctionDescriptor) {
                    return false;
                }
                return true;
            }

            @Override
            boolean execute(Object arg0Value) {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value);
                }
                if ((state_0 & 0b11110) != 0 /* is SpecializationActive[IsPointerNode.IsPointerHelper.doLong(long)] || SpecializationActive[IsPointerNode.IsPointerHelper.doByteArray(byte[])] || SpecializationActive[IsPointerNode.IsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor)] || SpecializationActive[IsPointerNode.IsPointerHelper.doOther(Object, LLVMNativeLibrary)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IsPointerNode.IsPointerHelper.doLong(long)] */ && arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        return doLong(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IsPointerNode.IsPointerHelper.doByteArray(byte[])] */ && arg0Value instanceof byte[]) {
                        byte[] arg0Value_ = (byte[]) arg0Value;
                        return doByteArray(arg0Value_);
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IsPointerNode.IsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor)] */ && arg0Value instanceof LLVMFunctionDescriptor) {
                        LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                        return doFunctionDescriptor(arg0Value_);
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IsPointerNode.IsPointerHelper.doOther(Object, LLVMNativeLibrary)] */) {
                        {
                            LLVMNativeLibrary natives__ = this.fallback_natives_;
                            if (natives__ != null) {
                                if (fallbackGuard_(state_0, arg0Value)) {
                                    return doOther(arg0Value, natives__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private boolean executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[IsPointerNode.IsPointerHelper.doLong(long)] */;
                    this.state_0_ = state_0;
                    return doLong(arg0Value_);
                }
                if (arg0Value instanceof byte[]) {
                    byte[] arg0Value_ = (byte[]) arg0Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[IsPointerNode.IsPointerHelper.doByteArray(byte[])] */;
                    this.state_0_ = state_0;
                    return doByteArray(arg0Value_);
                }
                if (arg0Value instanceof LLVMFunctionDescriptor) {
                    LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IsPointerNode.IsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor)] */;
                    this.state_0_ = state_0;
                    return doFunctionDescriptor(arg0Value_);
                }
                LLVMNativeLibrary natives__ = this.insert((L_L_V_M_NATIVE_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(natives__, "Specialization 'doOther(Object, LLVMNativeLibrary)' cache 'natives' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallback_natives_ = natives__;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[IsPointerNode.IsPointerHelper.doOther(Object, LLVMNativeLibrary)] */;
                this.state_0_ = state_0;
                return doOther(arg0Value, natives__);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11110) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[IsPointerNode.IsPointerHelper.doLong(long)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[IsPointerNode.IsPointerHelper.doByteArray(byte[])] */;
                }
                {
                    this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[IsPointerNode.IsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @NeverDefault
            public static IsPointerHelper create() {
                return new IsPointerHelperNodeGen();
            }

            @NeverDefault
            public static IsPointerHelper getUncached() {
                return IsPointerHelperNodeGen.UNCACHED;
            }

            @GeneratedBy(IsPointerHelper.class)
            @DenyReplace
            private static final class Uncached extends IsPointerHelper {

                @TruffleBoundary
                @Override
                boolean execute(Object arg0Value) {
                    if (arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        return doLong(arg0Value_);
                    }
                    if (arg0Value instanceof byte[]) {
                        byte[] arg0Value_ = (byte[]) arg0Value;
                        return doByteArray(arg0Value_);
                    }
                    if (arg0Value instanceof LLVMFunctionDescriptor) {
                        LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                        return doFunctionDescriptor(arg0Value_);
                    }
                    return doOther(arg0Value, (L_L_V_M_NATIVE_LIBRARY_.getUncached()));
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.MEGAMORPHIC;
                }

                @Override
                public boolean isAdoptable() {
                    return false;
                }

            }
        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AsPointerNode#doNativePointer}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link AsPointerNode#doManagedPointer}
     *     Activation probability: 0.33333
     *     With/without class size: 10/4 bytes
     *   Specialization {@link AsPointerNode#doOther}
     *     Activation probability: 0.18333
     *     With/without class size: 7/4 bytes
     * </pre>
     */
    @GeneratedBy(AsPointerNode.class)
    @SuppressWarnings("javadoc")
    public static final class AsPointerNodeGen extends AsPointerNode implements GenerateAOT.Provider {

        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link AsPointerNode#doNativePointer}
         *   2: SpecializationActive {@link AsPointerNode#doManagedPointer}
         *   3: SpecializationActive {@link AsPointerNode#doOther}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AsPointerNode#doManagedPointer}
         *   Parameter: {@link AsPointerHelper} asPointerHelper</pre>
         */
        @Child private AsPointerHelper managedPointer_asPointerHelper_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AsPointerNode#doOther}
         *   Parameter: {@link AsPointerHelper} asPointerHelper</pre>
         */
        @Child private AsPointerHelper fallback_asPointerHelper_;

        private AsPointerNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arg0Value) {
            if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doNativePointer(LLVMNativePointer)] */) && LLVMTypes.isNativePointer(arg0Value)) {
                return false;
            }
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doManagedPointer(LLVMManagedPointer, AsPointerHelper)] */) && LLVMTypes.isManagedPointer(arg0Value)) {
                return false;
            }
            return true;
        }

        @Override
        public long execute(Object arg0Value) throws UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doManagedPointer(LLVMManagedPointer, AsPointerHelper)] || SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doOther(Object, AsPointerHelper)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doNativePointer(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return doNativePointer(arg0Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doManagedPointer(LLVMManagedPointer, AsPointerHelper)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    {
                        AsPointerHelper asPointerHelper__ = this.managedPointer_asPointerHelper_;
                        if (asPointerHelper__ != null) {
                            return doManagedPointer(arg0Value_, asPointerHelper__);
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doOther(Object, AsPointerHelper)] */) {
                    {
                        AsPointerHelper asPointerHelper__1 = this.fallback_asPointerHelper_;
                        if (asPointerHelper__1 != null) {
                            if (fallbackGuard_(state_0, arg0Value)) {
                                return doOther(arg0Value, asPointerHelper__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private long executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doNativePointer(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doNativePointer(arg0Value_);
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                AsPointerHelper asPointerHelper__ = this.insert((AsPointerHelperNodeGen.create()));
                Objects.requireNonNull(asPointerHelper__, "Specialization 'doManagedPointer(LLVMManagedPointer, AsPointerHelper)' cache 'asPointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.managedPointer_asPointerHelper_ = asPointerHelper__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doManagedPointer(LLVMManagedPointer, AsPointerHelper)] */;
                this.state_0_ = state_0;
                return doManagedPointer(arg0Value_, asPointerHelper__);
            }
            AsPointerHelper asPointerHelper__1 = this.insert((AsPointerHelperNodeGen.create()));
            Objects.requireNonNull(asPointerHelper__1, "Specialization 'doOther(Object, AsPointerHelper)' cache 'asPointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fallback_asPointerHelper_ = asPointerHelper__1;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doOther(Object, AsPointerHelper)] */;
            this.state_0_ = state_0;
            return doOther(arg0Value, asPointerHelper__1);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doNativePointer(LLVMNativePointer)] */;
            }
            {
                AsPointerHelper asPointerHelper__ = this.insert((AsPointerHelperNodeGen.create()));
                Objects.requireNonNull(asPointerHelper__, "Specialization 'doManagedPointer(LLVMManagedPointer, AsPointerHelper)' cache 'asPointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.managedPointer_asPointerHelper_ = asPointerHelper__;
                assert NodeUtil.assertRecursion(this.managedPointer_asPointerHelper_, 1);
                ((GenerateAOT.Provider) this.managedPointer_asPointerHelper_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doManagedPointer(LLVMManagedPointer, AsPointerHelper)] */;
            }
            {
                AsPointerHelper asPointerHelper__1 = this.insert((AsPointerHelperNodeGen.create()));
                Objects.requireNonNull(asPointerHelper__1, "Specialization 'doOther(Object, AsPointerHelper)' cache 'asPointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallback_asPointerHelper_ = asPointerHelper__1;
                assert NodeUtil.assertRecursion(this.fallback_asPointerHelper_, 1);
                ((GenerateAOT.Provider) this.fallback_asPointerHelper_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMNativePointerSupport.AsPointerNode.doOther(Object, AsPointerHelper)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.managedPointer_asPointerHelper_ = null;
            this.fallback_asPointerHelper_ = null;
        }

        @NeverDefault
        public static AsPointerNode create() {
            return new AsPointerNodeGen();
        }

        @NeverDefault
        public static AsPointerNode getUncached() {
            return AsPointerNodeGen.UNCACHED;
        }

        @GeneratedBy(AsPointerNode.class)
        @DenyReplace
        private static final class Uncached extends AsPointerNode {

            @TruffleBoundary
            @Override
            public long execute(Object arg0Value) throws UnsupportedMessageException {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return doNativePointer(arg0Value_);
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doManagedPointer(arg0Value_, (AsPointerHelperNodeGen.getUncached()));
                }
                return doOther(arg0Value, (AsPointerHelperNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        /**
         * Debug Info: <pre>
         *   Specialization {@link AsPointerHelper#doLong}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link AsPointerHelper#doFunctionDescriptor}
         *     Activation probability: 0.33333
         *     With/without class size: 9/4 bytes
         *   Specialization {@link AsPointerHelper#doOther}
         *     Activation probability: 0.18333
         *     With/without class size: 7/4 bytes
         * </pre>
         */
        @GeneratedBy(AsPointerHelper.class)
        @SuppressWarnings("javadoc")
        static final class AsPointerHelperNodeGen extends AsPointerHelper implements GenerateAOT.Provider {

            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link AsPointerHelper#doLong}
             *   2: SpecializationActive {@link AsPointerHelper#doFunctionDescriptor}
             *   3: SpecializationActive {@link AsPointerHelper#doOther}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AsPointerHelper#doFunctionDescriptor}
             *   Parameter: {@link BranchProfile} exception</pre>
             */
            @CompilationFinal private BranchProfile functionDescriptor_exception_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AsPointerHelper#doOther}
             *   Parameter: {@link LLVMNativeLibrary} natives</pre>
             */
            @Child private LLVMNativeLibrary fallback_natives_;

            private AsPointerHelperNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value) {
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[AsPointerNode.AsPointerHelper.doLong(long)] */) && arg0Value instanceof Long) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[AsPointerNode.AsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] */) && arg0Value instanceof LLVMFunctionDescriptor) {
                    return false;
                }
                return true;
            }

            @Override
            long execute(Object arg0Value) {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value);
                }
                if ((state_0 & 0b1110) != 0 /* is SpecializationActive[AsPointerNode.AsPointerHelper.doLong(long)] || SpecializationActive[AsPointerNode.AsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] || SpecializationActive[AsPointerNode.AsPointerHelper.doOther(Object, LLVMNativeLibrary)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[AsPointerNode.AsPointerHelper.doLong(long)] */ && arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        return doLong(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[AsPointerNode.AsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] */ && arg0Value instanceof LLVMFunctionDescriptor) {
                        LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                        {
                            BranchProfile exception__ = this.functionDescriptor_exception_;
                            if (exception__ != null) {
                                return doFunctionDescriptor(arg0Value_, exception__);
                            }
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[AsPointerNode.AsPointerHelper.doOther(Object, LLVMNativeLibrary)] */) {
                        {
                            LLVMNativeLibrary natives__ = this.fallback_natives_;
                            if (natives__ != null) {
                                if (fallbackGuard_(state_0, arg0Value)) {
                                    return doOther(arg0Value, natives__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private long executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[AsPointerNode.AsPointerHelper.doLong(long)] */;
                    this.state_0_ = state_0;
                    return doLong(arg0Value_);
                }
                if (arg0Value instanceof LLVMFunctionDescriptor) {
                    LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                    BranchProfile exception__ = (BranchProfile.create());
                    Objects.requireNonNull(exception__, "Specialization 'doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.functionDescriptor_exception_ = exception__;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[AsPointerNode.AsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return doFunctionDescriptor(arg0Value_, exception__);
                }
                LLVMNativeLibrary natives__ = this.insert((L_L_V_M_NATIVE_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(natives__, "Specialization 'doOther(Object, LLVMNativeLibrary)' cache 'natives' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallback_natives_ = natives__;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[AsPointerNode.AsPointerHelper.doOther(Object, LLVMNativeLibrary)] */;
                this.state_0_ = state_0;
                return doOther(arg0Value, natives__);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1110) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[AsPointerNode.AsPointerHelper.doLong(long)] */;
                }
                {
                    BranchProfile exception__ = (BranchProfile.create());
                    Objects.requireNonNull(exception__, "Specialization 'doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.functionDescriptor_exception_ = exception__;
                    this.functionDescriptor_exception_.disable();
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[AsPointerNode.AsPointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.functionDescriptor_exception_.reset();
            }

            @NeverDefault
            public static AsPointerHelper create() {
                return new AsPointerHelperNodeGen();
            }

            @NeverDefault
            public static AsPointerHelper getUncached() {
                return AsPointerHelperNodeGen.UNCACHED;
            }

            @GeneratedBy(AsPointerHelper.class)
            @DenyReplace
            private static final class Uncached extends AsPointerHelper {

                @TruffleBoundary
                @Override
                long execute(Object arg0Value) {
                    if (arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        return doLong(arg0Value_);
                    }
                    if (arg0Value instanceof LLVMFunctionDescriptor) {
                        LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                        return doFunctionDescriptor(arg0Value_, (BranchProfile.getUncached()));
                    }
                    return doOther(arg0Value, (L_L_V_M_NATIVE_LIBRARY_.getUncached()));
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.MEGAMORPHIC;
                }

                @Override
                public boolean isAdoptable() {
                    return false;
                }

            }
        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ToNativePointerNode#doNativePointer}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link ToNativePointerNode#doManagedPointer}
     *     Activation probability: 0.33333
     *     With/without class size: 10/4 bytes
     *   Specialization {@link ToNativePointerNode#doOther}
     *     Activation probability: 0.18333
     *     With/without class size: 7/4 bytes
     * </pre>
     */
    @GeneratedBy(ToNativePointerNode.class)
    @SuppressWarnings("javadoc")
    public static final class ToNativePointerNodeGen extends ToNativePointerNode implements GenerateAOT.Provider {

        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ToNativePointerNode#doNativePointer}
         *   2: SpecializationActive {@link ToNativePointerNode#doManagedPointer}
         *   3: SpecializationActive {@link ToNativePointerNode#doOther}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToNativePointerNode#doManagedPointer}
         *   Parameter: {@link ToNativePointerHelper} toNativePointerHelper</pre>
         */
        @Child private ToNativePointerHelper managedPointer_toNativePointerHelper_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToNativePointerNode#doOther}
         *   Parameter: {@link ToNativePointerHelper} toNativePointerHelper</pre>
         */
        @Child private ToNativePointerHelper fallback_toNativePointerHelper_;

        private ToNativePointerNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arg0Value) {
            if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doNativePointer(LLVMNativePointer)] */) && LLVMTypes.isNativePointer(arg0Value)) {
                return false;
            }
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doManagedPointer(LLVMManagedPointer, ToNativePointerHelper)] */) && LLVMTypes.isManagedPointer(arg0Value)) {
                return false;
            }
            return true;
        }

        @Override
        public LLVMNativePointer execute(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doManagedPointer(LLVMManagedPointer, ToNativePointerHelper)] || SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doOther(Object, ToNativePointerHelper)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doNativePointer(LLVMNativePointer)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return doNativePointer(arg0Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doManagedPointer(LLVMManagedPointer, ToNativePointerHelper)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    {
                        ToNativePointerHelper toNativePointerHelper__ = this.managedPointer_toNativePointerHelper_;
                        if (toNativePointerHelper__ != null) {
                            return doManagedPointer(arg0Value_, toNativePointerHelper__);
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doOther(Object, ToNativePointerHelper)] */) {
                    {
                        ToNativePointerHelper toNativePointerHelper__1 = this.fallback_toNativePointerHelper_;
                        if (toNativePointerHelper__1 != null) {
                            if (fallbackGuard_(state_0, arg0Value)) {
                                return doOther(arg0Value, toNativePointerHelper__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private LLVMNativePointer executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doNativePointer(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doNativePointer(arg0Value_);
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                ToNativePointerHelper toNativePointerHelper__ = this.insert((ToNativePointerHelperNodeGen.create()));
                Objects.requireNonNull(toNativePointerHelper__, "Specialization 'doManagedPointer(LLVMManagedPointer, ToNativePointerHelper)' cache 'toNativePointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.managedPointer_toNativePointerHelper_ = toNativePointerHelper__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doManagedPointer(LLVMManagedPointer, ToNativePointerHelper)] */;
                this.state_0_ = state_0;
                return doManagedPointer(arg0Value_, toNativePointerHelper__);
            }
            ToNativePointerHelper toNativePointerHelper__1 = this.insert((ToNativePointerHelperNodeGen.create()));
            Objects.requireNonNull(toNativePointerHelper__1, "Specialization 'doOther(Object, ToNativePointerHelper)' cache 'toNativePointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fallback_toNativePointerHelper_ = toNativePointerHelper__1;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doOther(Object, ToNativePointerHelper)] */;
            this.state_0_ = state_0;
            return doOther(arg0Value, toNativePointerHelper__1);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1110) & ((state_0 & 0b1110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doNativePointer(LLVMNativePointer)] */;
            }
            {
                ToNativePointerHelper toNativePointerHelper__ = this.insert((ToNativePointerHelperNodeGen.create()));
                Objects.requireNonNull(toNativePointerHelper__, "Specialization 'doManagedPointer(LLVMManagedPointer, ToNativePointerHelper)' cache 'toNativePointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.managedPointer_toNativePointerHelper_ = toNativePointerHelper__;
                assert NodeUtil.assertRecursion(this.managedPointer_toNativePointerHelper_, 1);
                ((GenerateAOT.Provider) this.managedPointer_toNativePointerHelper_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doManagedPointer(LLVMManagedPointer, ToNativePointerHelper)] */;
            }
            {
                ToNativePointerHelper toNativePointerHelper__1 = this.insert((ToNativePointerHelperNodeGen.create()));
                Objects.requireNonNull(toNativePointerHelper__1, "Specialization 'doOther(Object, ToNativePointerHelper)' cache 'toNativePointerHelper' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallback_toNativePointerHelper_ = toNativePointerHelper__1;
                assert NodeUtil.assertRecursion(this.fallback_toNativePointerHelper_, 1);
                ((GenerateAOT.Provider) this.fallback_toNativePointerHelper_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMNativePointerSupport.ToNativePointerNode.doOther(Object, ToNativePointerHelper)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.managedPointer_toNativePointerHelper_ = null;
            this.fallback_toNativePointerHelper_ = null;
        }

        @NeverDefault
        public static ToNativePointerNode create() {
            return new ToNativePointerNodeGen();
        }

        @NeverDefault
        public static ToNativePointerNode getUncached() {
            return ToNativePointerNodeGen.UNCACHED;
        }

        @GeneratedBy(ToNativePointerNode.class)
        @DenyReplace
        private static final class Uncached extends ToNativePointerNode {

            @TruffleBoundary
            @Override
            public LLVMNativePointer execute(Object arg0Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return doNativePointer(arg0Value_);
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doManagedPointer(arg0Value_, (ToNativePointerHelperNodeGen.getUncached()));
                }
                return doOther(arg0Value, (ToNativePointerHelperNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        /**
         * Debug Info: <pre>
         *   Specialization {@link ToNativePointerHelper#doLong}
         *     Activation probability: 0.38500
         *     With/without class size: 8/0 bytes
         *   Specialization {@link ToNativePointerHelper#doByteArray}
         *     Activation probability: 0.29500
         *     With/without class size: 7/0 bytes
         *   Specialization {@link ToNativePointerHelper#doFunctionDescriptor}
         *     Activation probability: 0.20500
         *     With/without class size: 7/4 bytes
         *   Specialization {@link ToNativePointerHelper#doOther}
         *     Activation probability: 0.11500
         *     With/without class size: 6/4 bytes
         * </pre>
         */
        @GeneratedBy(ToNativePointerHelper.class)
        @SuppressWarnings("javadoc")
        static final class ToNativePointerHelperNodeGen extends ToNativePointerHelper implements GenerateAOT.Provider {

            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ToNativePointerHelper#doLong}
             *   2: SpecializationActive {@link ToNativePointerHelper#doByteArray}
             *   3: SpecializationActive {@link ToNativePointerHelper#doFunctionDescriptor}
             *   4: SpecializationActive {@link ToNativePointerHelper#doOther}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToNativePointerHelper#doFunctionDescriptor}
             *   Parameter: {@link BranchProfile} exceptionProfile</pre>
             */
            @CompilationFinal private BranchProfile functionDescriptor_exceptionProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToNativePointerHelper#doOther}
             *   Parameter: {@link LLVMNativeLibrary} natives</pre>
             */
            @Child private LLVMNativeLibrary fallback_natives_;

            private ToNativePointerHelperNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value) {
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doLong(long)] */) && arg0Value instanceof Long) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doByteArray(byte[])] */) && arg0Value instanceof byte[]) {
                    return false;
                }
                if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] */) && arg0Value instanceof LLVMFunctionDescriptor) {
                    return false;
                }
                return true;
            }

            @Override
            LLVMNativePointer execute(Object arg0Value) {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value);
                }
                if ((state_0 & 0b11110) != 0 /* is SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doLong(long)] || SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doByteArray(byte[])] || SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] || SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doOther(Object, LLVMNativeLibrary)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doLong(long)] */ && arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        return doLong(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doByteArray(byte[])] */ && arg0Value instanceof byte[]) {
                        byte[] arg0Value_ = (byte[]) arg0Value;
                        return doByteArray(arg0Value_);
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] */ && arg0Value instanceof LLVMFunctionDescriptor) {
                        LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                        {
                            BranchProfile exceptionProfile__ = this.functionDescriptor_exceptionProfile_;
                            if (exceptionProfile__ != null) {
                                return doFunctionDescriptor(arg0Value_, exceptionProfile__);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doOther(Object, LLVMNativeLibrary)] */) {
                        {
                            LLVMNativeLibrary natives__ = this.fallback_natives_;
                            if (natives__ != null) {
                                if (fallbackGuard_(state_0, arg0Value)) {
                                    return doOther(arg0Value, natives__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private LLVMNativePointer executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doLong(long)] */;
                    this.state_0_ = state_0;
                    return doLong(arg0Value_);
                }
                if (arg0Value instanceof byte[]) {
                    byte[] arg0Value_ = (byte[]) arg0Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doByteArray(byte[])] */;
                    this.state_0_ = state_0;
                    return doByteArray(arg0Value_);
                }
                if (arg0Value instanceof LLVMFunctionDescriptor) {
                    LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                    BranchProfile exceptionProfile__ = (BranchProfile.create());
                    Objects.requireNonNull(exceptionProfile__, "Specialization 'doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)' cache 'exceptionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.functionDescriptor_exceptionProfile_ = exceptionProfile__;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] */;
                    this.state_0_ = state_0;
                    return doFunctionDescriptor(arg0Value_, exceptionProfile__);
                }
                LLVMNativeLibrary natives__ = this.insert((L_L_V_M_NATIVE_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(natives__, "Specialization 'doOther(Object, LLVMNativeLibrary)' cache 'natives' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.fallback_natives_ = natives__;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doOther(Object, LLVMNativeLibrary)] */;
                this.state_0_ = state_0;
                return doOther(arg0Value, natives__);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11110) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doLong(long)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doByteArray(byte[])] */;
                }
                {
                    BranchProfile exceptionProfile__ = (BranchProfile.create());
                    Objects.requireNonNull(exceptionProfile__, "Specialization 'doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)' cache 'exceptionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.functionDescriptor_exceptionProfile_ = exceptionProfile__;
                    this.functionDescriptor_exceptionProfile_.disable();
                    this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToNativePointerNode.ToNativePointerHelper.doFunctionDescriptor(LLVMFunctionDescriptor, BranchProfile)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.functionDescriptor_exceptionProfile_.reset();
            }

            @NeverDefault
            public static ToNativePointerHelper create() {
                return new ToNativePointerHelperNodeGen();
            }

            @NeverDefault
            public static ToNativePointerHelper getUncached() {
                return ToNativePointerHelperNodeGen.UNCACHED;
            }

            @GeneratedBy(ToNativePointerHelper.class)
            @DenyReplace
            private static final class Uncached extends ToNativePointerHelper {

                @TruffleBoundary
                @Override
                LLVMNativePointer execute(Object arg0Value) {
                    if (arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        return doLong(arg0Value_);
                    }
                    if (arg0Value instanceof byte[]) {
                        byte[] arg0Value_ = (byte[]) arg0Value;
                        return doByteArray(arg0Value_);
                    }
                    if (arg0Value instanceof LLVMFunctionDescriptor) {
                        LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor) arg0Value;
                        return doFunctionDescriptor(arg0Value_, (BranchProfile.getUncached()));
                    }
                    return doOther(arg0Value, (L_L_V_M_NATIVE_LIBRARY_.getUncached()));
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.MEGAMORPHIC;
                }

                @Override
                public boolean isAdoptable() {
                    return false;
                }

            }
        }
    }
}
