// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link NativeMemSetNode#memsetManagedI8}
 *     Activation probability: 0.27381
 *     With/without class size: 10/8 bytes
 *   Specialization {@link NativeMemSetNode#memsetManagedI16}
 *     Activation probability: 0.23095
 *     With/without class size: 9/8 bytes
 *   Specialization {@link NativeMemSetNode#memsetManagedI32}
 *     Activation probability: 0.18810
 *     With/without class size: 8/8 bytes
 *   Specialization {@link NativeMemSetNode#memsetManagedI64}
 *     Activation probability: 0.14524
 *     With/without class size: 7/8 bytes
 *   Specialization {@link NativeMemSetNode#nativeInJavaMemset}
 *     Activation probability: 0.10238
 *     With/without class size: 6/4 bytes
 *   Specialization {@link NativeMemSetNode#nativeMemset}
 *     Activation probability: 0.05952
 *     With/without class size: 5/4 bytes
 * </pre>
 */
@GeneratedBy(NativeMemSetNode.class)
@SuppressWarnings("javadoc")
public final class NativeMemSetNodeGen extends NativeMemSetNode implements GenerateAOT.Provider {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link NativeMemSetNode#memsetManagedI8}
     *   2: SpecializationActive {@link NativeMemSetNode#memsetManagedI16}
     *   3: SpecializationActive {@link NativeMemSetNode#memsetManagedI32}
     *   4: SpecializationActive {@link NativeMemSetNode#memsetManagedI64}
     *   5: SpecializationActive {@link NativeMemSetNode#nativeInJavaMemset}
     *   6: SpecializationActive {@link NativeMemSetNode#nativeMemset}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link NativeMemSetNode#memsetManagedI8}
     *   Parameter: {@link NativeTypeLibrary} nativeTypes</pre>
     */
    @Child private NativeTypeLibrary memsetManagedI8_nativeTypes_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link NativeMemSetNode#memsetManagedI8}
     *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
     */
    @Child private LLVMManagedWriteLibrary memsetManagedI8_nativeWrite_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link NativeMemSetNode#memsetManagedI16}
     *   Parameter: {@link NativeTypeLibrary} nativeTypes</pre>
     */
    @Child private NativeTypeLibrary memsetManagedI16_nativeTypes_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link NativeMemSetNode#memsetManagedI16}
     *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
     */
    @Child private LLVMManagedWriteLibrary memsetManagedI16_nativeWrite_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link NativeMemSetNode#memsetManagedI32}
     *   Parameter: {@link NativeTypeLibrary} nativeTypes</pre>
     */
    @Child private NativeTypeLibrary memsetManagedI32_nativeTypes_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link NativeMemSetNode#memsetManagedI32}
     *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
     */
    @Child private LLVMManagedWriteLibrary memsetManagedI32_nativeWrite_;
    @Child private MemsetManagedI64Data memsetManagedI64_cache;
    @Child private NativeInJavaMemsetData nativeInJavaMemset_cache;
    @Child private NativeMemsetData nativeMemset_cache;

    private NativeMemSetNodeGen() {
    }

    @Override
    public void executeWithTarget(Object arg0Value, byte arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            return;
        }
        if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[NativeMemSetNode.memsetManagedI8(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] || SpecializationActive[NativeMemSetNode.memsetManagedI16(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] || SpecializationActive[NativeMemSetNode.memsetManagedI32(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] || SpecializationActive[NativeMemSetNode.memsetManagedI64(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] || SpecializationActive[NativeMemSetNode.nativeInJavaMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] || SpecializationActive[NativeMemSetNode.nativeMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */) {
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[NativeMemSetNode.memsetManagedI8(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] || SpecializationActive[NativeMemSetNode.memsetManagedI16(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] || SpecializationActive[NativeMemSetNode.memsetManagedI32(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] || SpecializationActive[NativeMemSetNode.memsetManagedI64(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NativeMemSetNode.memsetManagedI8(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */) {
                    {
                        NativeTypeLibrary nativeTypes__ = this.memsetManagedI8_nativeTypes_;
                        if (nativeTypes__ != null) {
                            LLVMManagedWriteLibrary nativeWrite__ = this.memsetManagedI8_nativeWrite_;
                            if (nativeWrite__ != null) {
                                if ((nativeWrite__.isWritable(arg0Value_.getObject())) && (NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, nativeTypes__) == 1)) {
                                    memsetManagedI8(arg0Value_, arg1Value, arg2Value, nativeTypes__, nativeWrite__);
                                    return;
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[NativeMemSetNode.memsetManagedI16(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */) {
                    {
                        NativeTypeLibrary nativeTypes__1 = this.memsetManagedI16_nativeTypes_;
                        if (nativeTypes__1 != null) {
                            LLVMManagedWriteLibrary nativeWrite__1 = this.memsetManagedI16_nativeWrite_;
                            if (nativeWrite__1 != null) {
                                if ((nativeWrite__1.isWritable(arg0Value_.getObject())) && (NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, nativeTypes__1) == 2)) {
                                    memsetManagedI16(arg0Value_, arg1Value, arg2Value, nativeTypes__1, nativeWrite__1);
                                    return;
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NativeMemSetNode.memsetManagedI32(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */) {
                    {
                        NativeTypeLibrary nativeTypes__2 = this.memsetManagedI32_nativeTypes_;
                        if (nativeTypes__2 != null) {
                            LLVMManagedWriteLibrary nativeWrite__2 = this.memsetManagedI32_nativeWrite_;
                            if (nativeWrite__2 != null) {
                                if ((nativeWrite__2.isWritable(arg0Value_.getObject())) && (NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, nativeTypes__2) == 4)) {
                                    memsetManagedI32(arg0Value_, arg1Value, arg2Value, nativeTypes__2, nativeWrite__2);
                                    return;
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[NativeMemSetNode.memsetManagedI64(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */) {
                    MemsetManagedI64Data s3_ = this.memsetManagedI64_cache;
                    if (s3_ != null) {
                        if ((s3_.nativeWrite_.isWritable(arg0Value_.getObject())) && (NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, s3_.nativeTypes_) == 8)) {
                            memsetManagedI64(arg0Value_, arg1Value, arg2Value, s3_.nativeTypes_, s3_.nativeWrite_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[NativeMemSetNode.nativeInJavaMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] || SpecializationActive[NativeMemSetNode.nativeMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[NativeMemSetNode.nativeInJavaMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */) {
                    NativeInJavaMemsetData s4_ = this.nativeInJavaMemset_cache;
                    if (s4_ != null) {
                        if ((arg2Value <= NativeMemSetNode.MAX_JAVA_LEN)) {
                            nativeInJavaMemset(arg0Value_, arg1Value, arg2Value, s4_.globalAccess_);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[NativeMemSetNode.nativeMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */) {
                    NativeMemsetData s5_ = this.nativeMemset_cache;
                    if (s5_ != null) {
                        nativeMemset(arg0Value_, arg1Value, arg2Value, s5_.globalAccess_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        return;
    }

    @SuppressWarnings("unused")
    private void executeAndSpecialize(Object arg0Value, byte arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            {
                LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                if ((nativeWrite__.isWritable(arg0Value_.getObject()))) {
                    NativeTypeLibrary nativeTypes__ = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
                    if ((NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, nativeTypes__) == 1)) {
                        Objects.requireNonNull(this.insert(nativeTypes__), "Specialization 'memsetManagedI8(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.memsetManagedI8_nativeTypes_ = nativeTypes__;
                        Objects.requireNonNull(this.insert(nativeWrite__), "Specialization 'memsetManagedI8(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.memsetManagedI8_nativeWrite_ = nativeWrite__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[NativeMemSetNode.memsetManagedI8(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        memsetManagedI8(arg0Value_, arg1Value, arg2Value, nativeTypes__, nativeWrite__);
                        return;
                    }
                }
            }
            {
                LLVMManagedWriteLibrary nativeWrite__1 = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                if ((nativeWrite__1.isWritable(arg0Value_.getObject()))) {
                    NativeTypeLibrary nativeTypes__1 = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
                    if ((NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, nativeTypes__1) == 2)) {
                        Objects.requireNonNull(this.insert(nativeTypes__1), "Specialization 'memsetManagedI16(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.memsetManagedI16_nativeTypes_ = nativeTypes__1;
                        Objects.requireNonNull(this.insert(nativeWrite__1), "Specialization 'memsetManagedI16(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.memsetManagedI16_nativeWrite_ = nativeWrite__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[NativeMemSetNode.memsetManagedI16(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        memsetManagedI16(arg0Value_, arg1Value, arg2Value, nativeTypes__1, nativeWrite__1);
                        return;
                    }
                }
            }
            {
                LLVMManagedWriteLibrary nativeWrite__2 = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                if ((nativeWrite__2.isWritable(arg0Value_.getObject()))) {
                    NativeTypeLibrary nativeTypes__2 = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
                    if ((NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, nativeTypes__2) == 4)) {
                        Objects.requireNonNull(this.insert(nativeTypes__2), "Specialization 'memsetManagedI32(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.memsetManagedI32_nativeTypes_ = nativeTypes__2;
                        Objects.requireNonNull(this.insert(nativeWrite__2), "Specialization 'memsetManagedI32(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.memsetManagedI32_nativeWrite_ = nativeWrite__2;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[NativeMemSetNode.memsetManagedI32(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        memsetManagedI32(arg0Value_, arg1Value, arg2Value, nativeTypes__2, nativeWrite__2);
                        return;
                    }
                }
            }
            {
                LLVMManagedWriteLibrary nativeWrite__3 = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                if ((nativeWrite__3.isWritable(arg0Value_.getObject()))) {
                    NativeTypeLibrary nativeTypes__3 = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
                    if ((NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, nativeTypes__3) == 8)) {
                        MemsetManagedI64Data s3_ = this.insert(new MemsetManagedI64Data());
                        Objects.requireNonNull(s3_.insert(nativeTypes__3), "Specialization 'memsetManagedI64(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s3_.nativeTypes_ = nativeTypes__3;
                        Objects.requireNonNull(s3_.insert(nativeWrite__3), "Specialization 'memsetManagedI64(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s3_.nativeWrite_ = nativeWrite__3;
                        VarHandle.storeStoreFence();
                        this.memsetManagedI64_cache = s3_;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[NativeMemSetNode.memsetManagedI64(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        memsetManagedI64(arg0Value_, arg1Value, arg2Value, nativeTypes__3, nativeWrite__3);
                        return;
                    }
                }
            }
        }
        if (LLVMTypes.isNativePointer(arg0Value)) {
            LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
            if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[NativeMemSetNode.nativeMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */) {
                if ((arg2Value <= NativeMemSetNode.MAX_JAVA_LEN)) {
                    NativeInJavaMemsetData s4_ = this.insert(new NativeInJavaMemsetData());
                    s4_.globalAccess_ = s4_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    VarHandle.storeStoreFence();
                    this.nativeInJavaMemset_cache = s4_;
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[NativeMemSetNode.nativeInJavaMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */;
                    this.state_0_ = state_0;
                    nativeInJavaMemset(arg0Value_, arg1Value, arg2Value, s4_.globalAccess_);
                    return;
                }
            }
            NativeMemsetData s5_ = this.insert(new NativeMemsetData());
            s5_.globalAccess_ = s5_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            VarHandle.storeStoreFence();
            this.nativeMemset_cache = s5_;
            this.nativeInJavaMemset_cache = null;
            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[NativeMemSetNode.nativeInJavaMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[NativeMemSetNode.nativeMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */;
            this.state_0_ = state_0;
            nativeMemset(arg0Value_, arg1Value, arg2Value, s5_.globalAccess_);
            return;
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            NativeTypeLibrary nativeTypes__ = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeTypes__, "Specialization 'memsetManagedI8(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.memsetManagedI8_nativeTypes_ = nativeTypes__;
            LLVMManagedWriteLibrary nativeWrite__ = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__, "Specialization 'memsetManagedI8(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.memsetManagedI8_nativeWrite_ = nativeWrite__;
            if (this.memsetManagedI8_nativeTypes_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.memsetManagedI8_nativeTypes_, 1);
                ((GenerateAOT.Provider) this.memsetManagedI8_nativeTypes_).prepareForAOT(language, root);
            }
            if (this.memsetManagedI8_nativeWrite_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.memsetManagedI8_nativeWrite_, 1);
                ((GenerateAOT.Provider) this.memsetManagedI8_nativeWrite_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[NativeMemSetNode.memsetManagedI8(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */;
        }
        {
            NativeTypeLibrary nativeTypes__1 = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeTypes__1, "Specialization 'memsetManagedI16(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.memsetManagedI16_nativeTypes_ = nativeTypes__1;
            LLVMManagedWriteLibrary nativeWrite__1 = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__1, "Specialization 'memsetManagedI16(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.memsetManagedI16_nativeWrite_ = nativeWrite__1;
            if (this.memsetManagedI16_nativeTypes_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.memsetManagedI16_nativeTypes_, 1);
                ((GenerateAOT.Provider) this.memsetManagedI16_nativeTypes_).prepareForAOT(language, root);
            }
            if (this.memsetManagedI16_nativeWrite_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.memsetManagedI16_nativeWrite_, 1);
                ((GenerateAOT.Provider) this.memsetManagedI16_nativeWrite_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[NativeMemSetNode.memsetManagedI16(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */;
        }
        {
            NativeTypeLibrary nativeTypes__2 = this.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeTypes__2, "Specialization 'memsetManagedI32(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.memsetManagedI32_nativeTypes_ = nativeTypes__2;
            LLVMManagedWriteLibrary nativeWrite__2 = this.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__2, "Specialization 'memsetManagedI32(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.memsetManagedI32_nativeWrite_ = nativeWrite__2;
            if (this.memsetManagedI32_nativeTypes_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.memsetManagedI32_nativeTypes_, 1);
                ((GenerateAOT.Provider) this.memsetManagedI32_nativeTypes_).prepareForAOT(language, root);
            }
            if (this.memsetManagedI32_nativeWrite_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.memsetManagedI32_nativeWrite_, 1);
                ((GenerateAOT.Provider) this.memsetManagedI32_nativeWrite_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[NativeMemSetNode.memsetManagedI32(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */;
        }
        {
            MemsetManagedI64Data s3_ = this.insert(new MemsetManagedI64Data());
            NativeTypeLibrary nativeTypes__3 = s3_.insert((NATIVE_TYPE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeTypes__3, "Specialization 'memsetManagedI64(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeTypes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s3_.nativeTypes_ = nativeTypes__3;
            LLVMManagedWriteLibrary nativeWrite__3 = s3_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__3, "Specialization 'memsetManagedI64(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s3_.nativeWrite_ = nativeWrite__3;
            VarHandle.storeStoreFence();
            this.memsetManagedI64_cache = s3_;
            if (s3_.nativeTypes_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(s3_.nativeTypes_, 1);
                ((GenerateAOT.Provider) s3_.nativeTypes_).prepareForAOT(language, root);
            }
            if (s3_.nativeWrite_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(s3_.nativeWrite_, 1);
                ((GenerateAOT.Provider) s3_.nativeWrite_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[NativeMemSetNode.memsetManagedI64(LLVMManagedPointer, byte, long, NativeTypeLibrary, LLVMManagedWriteLibrary)] */;
        }
        {
            NativeMemsetData s5_ = this.insert(new NativeMemsetData());
            s5_.globalAccess_ = s5_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            VarHandle.storeStoreFence();
            this.nativeMemset_cache = s5_;
            this.nativeInJavaMemset_cache = null;
            this.state_0_ = state_0_ & 0xffffffdf /* remove SpecializationActive[NativeMemSetNode.nativeInJavaMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */;
            assert NodeUtil.assertRecursion(s5_.globalAccess_, 1);
            ((GenerateAOT.Provider) s5_.globalAccess_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[NativeMemSetNode.nativeMemset(LLVMNativePointer, byte, long, LLVMToNativeNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.memsetManagedI8_nativeTypes_ = null;
        this.memsetManagedI8_nativeWrite_ = null;
        this.memsetManagedI16_nativeTypes_ = null;
        this.memsetManagedI16_nativeWrite_ = null;
        this.memsetManagedI32_nativeTypes_ = null;
        this.memsetManagedI32_nativeWrite_ = null;
        this.memsetManagedI64_cache = null;
        this.nativeMemset_cache = null;
    }

    @NeverDefault
    public static NativeMemSetNode create() {
        return new NativeMemSetNodeGen();
    }

    @NeverDefault
    public static NativeMemSetNode getUncached() {
        return NativeMemSetNodeGen.UNCACHED;
    }

    @GeneratedBy(NativeMemSetNode.class)
    @DenyReplace
    private static final class MemsetManagedI64Data extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link NativeMemSetNode#memsetManagedI64}
         *   Parameter: {@link NativeTypeLibrary} nativeTypes</pre>
         */
        @Child NativeTypeLibrary nativeTypes_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link NativeMemSetNode#memsetManagedI64}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        MemsetManagedI64Data() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(NativeMemSetNode.class)
    @DenyReplace
    private static final class NativeInJavaMemsetData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link NativeMemSetNode#nativeInJavaMemset}
         *   Parameter: {@link LLVMToNativeNode} globalAccess</pre>
         */
        @Child LLVMToNativeNode globalAccess_;

        NativeInJavaMemsetData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(NativeMemSetNode.class)
    @DenyReplace
    private static final class NativeMemsetData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link NativeMemSetNode#nativeMemset}
         *   Parameter: {@link LLVMToNativeNode} globalAccess</pre>
         */
        @Child LLVMToNativeNode globalAccess_;

        NativeMemsetData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(NativeMemSetNode.class)
    @DenyReplace
    private static final class Uncached extends NativeMemSetNode {

        @TruffleBoundary
        @Override
        public void executeWithTarget(Object arg0Value, byte arg1Value, long arg2Value) {
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (((L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()).isWritable(arg0Value_.getObject())) && (NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, (NATIVE_TYPE_LIBRARY_.getUncached())) == 1)) {
                    memsetManagedI8(arg0Value_, arg1Value, arg2Value, (NATIVE_TYPE_LIBRARY_.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                    return;
                }
                if (((L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()).isWritable(arg0Value_.getObject())) && (NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, (NATIVE_TYPE_LIBRARY_.getUncached())) == 2)) {
                    memsetManagedI16(arg0Value_, arg1Value, arg2Value, (NATIVE_TYPE_LIBRARY_.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                    return;
                }
                if (((L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()).isWritable(arg0Value_.getObject())) && (NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, (NATIVE_TYPE_LIBRARY_.getUncached())) == 4)) {
                    memsetManagedI32(arg0Value_, arg1Value, arg2Value, (NATIVE_TYPE_LIBRARY_.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                    return;
                }
                if (((L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()).isWritable(arg0Value_.getObject())) && (NativeMemSetNode.getAccessLength(arg0Value_, arg2Value, (NATIVE_TYPE_LIBRARY_.getUncached())) == 8)) {
                    memsetManagedI64(arg0Value_, arg1Value, arg2Value, (NATIVE_TYPE_LIBRARY_.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                    return;
                }
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                nativeMemset(arg0Value_, arg1Value, arg2Value, (LLVMToNativeNodeGen.getUncached()));
                return;
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
