// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMI64LoadNode#doI64Native}
 *     Activation probability: 0.27381
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMI64LoadNode#doI64DerefHandle}
 *     Activation probability: 0.23095
 *     With/without class size: 9/8 bytes
 *   Specialization {@link LLVMI64LoadNode#doGenericI64DerefHandle}
 *     Activation probability: 0.18810
 *     With/without class size: 8/8 bytes
 *   Specialization {@link LLVMI64LoadNode#doI64Managed}
 *     Activation probability: 0.14524
 *     With/without class size: 7/4 bytes
 *   Specialization {@link LLVMI64LoadNode#doGenericI64Managed}
 *     Activation probability: 0.10238
 *     With/without class size: 6/4 bytes
 *   Specialization {@link LLVMI64LoadNode#doGenericI64Managed}
 *     Activation probability: 0.05952
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMI64LoadNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMI64LoadNodeGen extends LLVMI64LoadNode implements GenerateAOT.Provider {

    static final ReferenceField<I64ManagedData> I64_MANAGED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i64Managed_cache", I64ManagedData.class);
    static final ReferenceField<GenericI64Managed0Data> GENERIC_I64_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "genericI64Managed0_cache", GenericI64Managed0Data.class);
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMI64LoadNode#doI64Native}
     *   2: SpecializationActive {@link LLVMI64LoadNode#doI64DerefHandle}
     *   3: SpecializationExcluded {@link LLVMI64LoadNode#doI64DerefHandle}
     *   4: SpecializationActive {@link LLVMI64LoadNode#doGenericI64DerefHandle}
     *   5: SpecializationActive {@link LLVMI64LoadNode#doI64Managed}
     *   6: SpecializationExcluded {@link LLVMI64LoadNode#doI64Managed}
     *   7: SpecializationActive {@link LLVMI64LoadNode#doGenericI64Managed}
     *   8: SpecializationActive {@link LLVMI64LoadNode#doGenericI64Managed}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI64LoadNode#doI64DerefHandle}
     *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
     */
    @Child private LLVMDerefHandleGetReceiverNode i64DerefHandle_getReceiver_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI64LoadNode#doI64DerefHandle}
     *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
     */
    @Child private LLVMManagedReadLibrary i64DerefHandle_nativeRead_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI64LoadNode#doGenericI64DerefHandle}
     *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
     */
    @Child private LLVMDerefHandleGetReceiverNode genericI64DerefHandle_getReceiver_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI64LoadNode#doGenericI64DerefHandle}
     *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
     */
    @Child private LLVMManagedReadLibrary genericI64DerefHandle_nativeRead_;
    @UnsafeAccessedField @Child private I64ManagedData i64Managed_cache;
    @UnsafeAccessedField @Child private GenericI64Managed0Data genericI64Managed0_cache;

    private LLVMI64LoadNodeGen(LLVMExpressionNode address) {
        this.address_ = address;
    }

    @ExplodeLoop
    @Override
    public Object executeWithTargetGeneric(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b110110110) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] || SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b10110) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] || SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doI64Native(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i64DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i64DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    try {
                                        return doI64DerefHandle(addressValue_, getReceiver__, nativeRead__);
                                    } catch (UnexpectedResultException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return ex.getResult();
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__1 = this.genericI64DerefHandle_getReceiver_;
                        if (getReceiver__1 != null) {
                            LLVMManagedReadLibrary nativeRead__1 = this.genericI64DerefHandle_nativeRead_;
                            if (nativeRead__1 != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    return doGenericI64DerefHandle(addressValue_, getReceiver__1, nativeRead__1);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b110100000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I64ManagedData s3_ = this.i64Managed_cache;
                    while (s3_ != null) {
                        if ((s3_.nativeRead_.accepts(addressValue_.getObject()))) {
                            try {
                                return doI64Managed(addressValue_, s3_.nativeRead_);
                            } catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.i64Managed_cache = null;
                                return ex.getResult();
                            }
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    GenericI64Managed0Data s4_ = this.genericI64Managed0_cache;
                    while (s4_ != null) {
                        if ((s4_.nativeRead_.accepts(addressValue_.getObject()))) {
                            return doGenericI64Managed(addressValue_, s4_.nativeRead_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.genericI64Managed1Boundary(state_0, addressValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object genericI64Managed1Boundary(int state_0, LLVMManagedPointer addressValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__2 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return doGenericI64Managed(addressValue_, nativeRead__2);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b110110110) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] || SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b10110) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] || SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        return doI64Native(addressValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i64DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i64DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    try {
                                        return doI64DerefHandle(addressValue__, getReceiver__, nativeRead__);
                                    } catch (UnexpectedResultException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return ex.getResult();
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__1 = this.genericI64DerefHandle_getReceiver_;
                        if (getReceiver__1 != null) {
                            LLVMManagedReadLibrary nativeRead__1 = this.genericI64DerefHandle_nativeRead_;
                            if (nativeRead__1 != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    return doGenericI64DerefHandle(addressValue__, getReceiver__1, nativeRead__1);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b110100000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I64ManagedData s3_ = this.i64Managed_cache;
                    while (s3_ != null) {
                        if ((s3_.nativeRead_.accepts(addressValue__.getObject()))) {
                            try {
                                return doI64Managed(addressValue__, s3_.nativeRead_);
                            } catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.i64Managed_cache = null;
                                return ex.getResult();
                            }
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    GenericI64Managed0Data s4_ = this.genericI64Managed0_cache;
                    while (s4_ != null) {
                        if ((s4_.nativeRead_.accepts(addressValue__.getObject()))) {
                            return doGenericI64Managed(addressValue__, s4_.nativeRead_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.genericI64Managed1Boundary0(state_0, addressValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object genericI64Managed1Boundary0(int state_0, LLVMManagedPointer addressValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__2 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return doGenericI64Managed(addressValue__, nativeRead__2);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public long executeWithTarget(Object addressValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110010000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            return LLVMTypesGen.expectLong(executeWithTargetGeneric(addressValue));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectLong(executeAndSpecialize(addressValue));
        }
        if ((state_0 & 0b100110) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] || SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] || SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doI64Native(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i64DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i64DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    try {
                                        return doI64DerefHandle(addressValue_, getReceiver__, nativeRead__);
                                    } catch (UnexpectedResultException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return LLVMTypesGen.expectLong(ex.getResult());
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                I64ManagedData s3_ = this.i64Managed_cache;
                while (s3_ != null) {
                    if ((s3_.nativeRead_.accepts(addressValue_.getObject()))) {
                        try {
                            return doI64Managed(addressValue_, s3_.nativeRead_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.i64Managed_cache = null;
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                    s3_ = s3_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(executeAndSpecialize(addressValue));
    }

    @ExplodeLoop
    @Override
    public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110010000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            return LLVMTypesGen.expectLong(executeGeneric(frameValue));
        }
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectLong(executeAndSpecialize(addressValue_));
        }
        if ((state_0 & 0b100110) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] || SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] || SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        return doI64Native(addressValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i64DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i64DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    try {
                                        return doI64DerefHandle(addressValue__, getReceiver__, nativeRead__);
                                    } catch (UnexpectedResultException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return LLVMTypesGen.expectLong(ex.getResult());
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                I64ManagedData s3_ = this.i64Managed_cache;
                while (s3_ != null) {
                    if ((s3_.nativeRead_.accepts(addressValue__.getObject()))) {
                        try {
                            return doI64Managed(addressValue__, s3_.nativeRead_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.i64Managed_cache = null;
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                    s3_ = s3_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(executeAndSpecialize(addressValue_));
    }

    private Object executeAndSpecialize(Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((!(isAutoDerefHandle(addressValue_)))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doI64Native(addressValue_);
            }
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                if ((isAutoDerefHandle(addressValue_))) {
                    LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.i64DerefHandle_getReceiver_ = getReceiver__;
                    LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(nativeRead__, "Specialization 'doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.i64DerefHandle_nativeRead_ = nativeRead__;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    try {
                        return doI64DerefHandle(addressValue_, getReceiver__, nativeRead__);
                    } catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return ex.getResult();
                    }
                }
            }
            if ((isAutoDerefHandle(addressValue_))) {
                LLVMDerefHandleGetReceiverNode getReceiver__1 = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__1, "Specialization 'doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.genericI64DerefHandle_getReceiver_ = getReceiver__1;
                LLVMManagedReadLibrary nativeRead__1 = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__1, "Specialization 'doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.genericI64DerefHandle_nativeRead_ = nativeRead__1;
                this.i64DerefHandle_getReceiver_ = null;
                this.i64DerefHandle_nativeRead_ = null;
                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                this.state_0_ = state_0;
                return doGenericI64DerefHandle(addressValue_, getReceiver__1, nativeRead__1);
            }
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (((state_0 & 0b110000000)) == 0 /* is-not SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] && SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && ((state_0 & 0b1000000)) == 0 /* is-not SpecializationExcluded  */) {
                while (true) {
                    int count3_ = 0;
                    I64ManagedData s3_ = I64_MANAGED_CACHE_UPDATER.getVolatile(this);
                    I64ManagedData s3_original = s3_;
                    while (s3_ != null) {
                        if ((s3_.nativeRead_.accepts(addressValue_.getObject()))) {
                            break;
                        }
                        count3_++;
                        s3_ = s3_.next_;
                    }
                    if (s3_ == null) {
                        // assert (s3_.nativeRead_.accepts(addressValue_.getObject()));
                        if (count3_ < (3)) {
                            s3_ = this.insert(new I64ManagedData(s3_original));
                            LLVMManagedReadLibrary nativeRead__3 = s3_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                            Objects.requireNonNull(nativeRead__3, "Specialization 'doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s3_.nativeRead_ = nativeRead__3;
                            if (!I64_MANAGED_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s3_ != null) {
                        try {
                            return doI64Managed(addressValue_, s3_.nativeRead_);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.i64Managed_cache = null;
                            return ex.getResult();
                        }
                    }
                    break;
                }
            }
            if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                while (true) {
                    int count4_ = 0;
                    GenericI64Managed0Data s4_ = GENERIC_I64_MANAGED0_CACHE_UPDATER.getVolatile(this);
                    GenericI64Managed0Data s4_original = s4_;
                    while (s4_ != null) {
                        if ((s4_.nativeRead_.accepts(addressValue_.getObject()))) {
                            break;
                        }
                        count4_++;
                        s4_ = s4_.next_;
                    }
                    if (s4_ == null) {
                        // assert (s4_.nativeRead_.accepts(addressValue_.getObject()));
                        if (count4_ < (3)) {
                            s4_ = this.insert(new GenericI64Managed0Data(s4_original));
                            LLVMManagedReadLibrary nativeRead__2 = s4_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                            Objects.requireNonNull(nativeRead__2, "Specialization 'doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s4_.nativeRead_ = nativeRead__2;
                            if (!GENERIC_I64_MANAGED0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                continue;
                            }
                            this.i64Managed_cache = null;
                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s4_ != null) {
                        return doGenericI64Managed(addressValue_, s4_.nativeRead_);
                    }
                    break;
                }
            }
            {
                LLVMManagedReadLibrary nativeRead__2 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        nativeRead__2 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        this.i64Managed_cache = null;
                        this.genericI64Managed0_cache = null;
                        state_0 = state_0 & 0xffffff5f /* remove SpecializationActive[LLVMI64LoadNode.doI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)], SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                        state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMI64LoadNode.doGenericI64Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                        this.state_0_ = state_0;
                        return doGenericI64Managed(addressValue_, nativeRead__2);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110110110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110110110) & ((state_0 & 0b110110110) - 1)) == 0 /* is-single  */) {
                I64ManagedData s3_ = this.i64Managed_cache;
                GenericI64Managed0Data s4_ = this.genericI64Managed0_cache;
                if ((s3_ == null || s3_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI64LoadNode.doI64Native(LLVMNativePointer)] */;
        }
        {
            LLVMDerefHandleGetReceiverNode getReceiver__1 = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
            Objects.requireNonNull(getReceiver__1, "Specialization 'doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.genericI64DerefHandle_getReceiver_ = getReceiver__1;
            LLVMManagedReadLibrary nativeRead__1 = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeRead__1, "Specialization 'doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.genericI64DerefHandle_nativeRead_ = nativeRead__1;
            this.i64DerefHandle_getReceiver_ = null;
            this.i64DerefHandle_nativeRead_ = null;
            this.state_0_ = state_0_ & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.doI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
            assert NodeUtil.assertRecursion(this.genericI64DerefHandle_getReceiver_, 1);
            ((GenerateAOT.Provider) this.genericI64DerefHandle_getReceiver_).prepareForAOT(language, root);
            if (this.genericI64DerefHandle_nativeRead_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.genericI64DerefHandle_nativeRead_, 1);
                ((GenerateAOT.Provider) this.genericI64DerefHandle_nativeRead_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMI64LoadNode.doGenericI64DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.genericI64DerefHandle_getReceiver_ = null;
        this.genericI64DerefHandle_nativeRead_ = null;
    }

    @NeverDefault
    public static LLVMI64LoadNode create(LLVMExpressionNode address) {
        return new LLVMI64LoadNodeGen(address);
    }

    @GeneratedBy(LLVMI64LoadNode.class)
    @DenyReplace
    private static final class I64ManagedData extends Node implements SpecializationDataNode {

        @Child I64ManagedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64LoadNode#doI64Managed}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child LLVMManagedReadLibrary nativeRead_;

        I64ManagedData(I64ManagedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMI64LoadNode.class)
    @DenyReplace
    private static final class GenericI64Managed0Data extends Node implements SpecializationDataNode {

        @Child GenericI64Managed0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64LoadNode#doGenericI64Managed}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child LLVMManagedReadLibrary nativeRead_;

        GenericI64Managed0Data(GenericI64Managed0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI64OffsetLoadNode#doI64Native}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LLVMI64OffsetLoadNode#doI64DerefHandle}
     *     Activation probability: 0.23095
     *     With/without class size: 9/8 bytes
     *   Specialization {@link LLVMI64OffsetLoadNode#doGenericI64DerefHandle}
     *     Activation probability: 0.18810
     *     With/without class size: 8/8 bytes
     *   Specialization {@link LLVMI64OffsetLoadNode#doI64Managed}
     *     Activation probability: 0.14524
     *     With/without class size: 7/4 bytes
     *   Specialization {@link LLVMI64OffsetLoadNode#doGenericI64Managed}
     *     Activation probability: 0.10238
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMI64OffsetLoadNode#doGenericI64Managed}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI64OffsetLoadNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI64OffsetLoadNodeGen extends LLVMI64OffsetLoadNode implements GenerateAOT.Provider {

        static final ReferenceField<I64ManagedData> I64_MANAGED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i64Managed_cache", I64ManagedData.class);
        static final ReferenceField<GenericI64Managed0Data> GENERIC_I64_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "genericI64Managed0_cache", GenericI64Managed0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI64OffsetLoadNode#doI64Native}
         *   2: SpecializationActive {@link LLVMI64OffsetLoadNode#doI64DerefHandle}
         *   3: SpecializationExcluded {@link LLVMI64OffsetLoadNode#doI64DerefHandle}
         *   4: SpecializationActive {@link LLVMI64OffsetLoadNode#doGenericI64DerefHandle}
         *   5: SpecializationActive {@link LLVMI64OffsetLoadNode#doI64Managed}
         *   6: SpecializationExcluded {@link LLVMI64OffsetLoadNode#doI64Managed}
         *   7: SpecializationActive {@link LLVMI64OffsetLoadNode#doGenericI64Managed}
         *   8: SpecializationActive {@link LLVMI64OffsetLoadNode#doGenericI64Managed}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64OffsetLoadNode#doI64DerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode i64DerefHandle_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64OffsetLoadNode#doI64DerefHandle}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child private LLVMManagedReadLibrary i64DerefHandle_nativeRead_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64OffsetLoadNode#doGenericI64DerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode genericI64DerefHandle_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64OffsetLoadNode#doGenericI64DerefHandle}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child private LLVMManagedReadLibrary genericI64DerefHandle_nativeRead_;
        @UnsafeAccessedField @Child private I64ManagedData i64Managed_cache;
        @UnsafeAccessedField @Child private GenericI64Managed0Data genericI64Managed0_cache;

        private LLVMI64OffsetLoadNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b110110110) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b10110) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Native(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doI64Native(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.i64DerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.i64DerefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        try {
                                            return doI64DerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                        } catch (UnexpectedResultException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return ex.getResult();
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__1 = this.genericI64DerefHandle_getReceiver_;
                            if (getReceiver__1 != null) {
                                LLVMManagedReadLibrary nativeRead__1 = this.genericI64DerefHandle_nativeRead_;
                                if (nativeRead__1 != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        return doGenericI64DerefHandle(arg0Value_, arg1Value, getReceiver__1, nativeRead__1);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b110100000) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        I64ManagedData s3_ = this.i64Managed_cache;
                        while (s3_ != null) {
                            if ((s3_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                try {
                                    return doI64Managed(arg0Value_, arg1Value, s3_.nativeRead_);
                                } catch (UnexpectedResultException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    this.i64Managed_cache = null;
                                    return ex.getResult();
                                }
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        GenericI64Managed0Data s4_ = this.genericI64Managed0_cache;
                        while (s4_ != null) {
                            if ((s4_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                return doGenericI64Managed(arg0Value_, arg1Value, s4_.nativeRead_);
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        return this.genericI64Managed1Boundary(state_0, arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object genericI64Managed1Boundary(int state_0, LLVMManagedPointer arg0Value_, long arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__2 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                    return doGenericI64Managed(arg0Value_, arg1Value, nativeRead__2);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public long executeWithTarget(LLVMPointer arg0Value, long arg1Value) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110010000) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                return LLVMTypesGen.expectLong(executeWithTargetGeneric(arg0Value, arg1Value));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(arg0Value, arg1Value));
            }
            if ((state_0 & 0b100110) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Native(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doI64Native(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.i64DerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.i64DerefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        try {
                                            return doI64DerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                        } catch (UnexpectedResultException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return LLVMTypesGen.expectLong(ex.getResult());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    I64ManagedData s3_ = this.i64Managed_cache;
                    while (s3_ != null) {
                        if ((s3_.nativeRead_.accepts(arg0Value_.getObject()))) {
                            try {
                                return doI64Managed(arg0Value_, arg1Value, s3_.nativeRead_);
                            } catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.i64Managed_cache = null;
                                return LLVMTypesGen.expectLong(ex.getResult());
                            }
                        }
                        s3_ = s3_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(arg0Value, arg1Value));
        }

        private Object executeAndSpecialize(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((!(isAutoDerefHandle(arg0Value_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Native(LLVMNativePointer, long)] */;
                    this.state_0_ = state_0;
                    return doI64Native(arg0Value_, arg1Value);
                }
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    if ((isAutoDerefHandle(arg0Value_))) {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                        Objects.requireNonNull(getReceiver__, "Specialization 'doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.i64DerefHandle_getReceiver_ = getReceiver__;
                        LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                        Objects.requireNonNull(nativeRead__, "Specialization 'doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.i64DerefHandle_nativeRead_ = nativeRead__;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                        this.state_0_ = state_0;
                        try {
                            return doI64DerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                        } catch (UnexpectedResultException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return ex.getResult();
                        }
                    }
                }
                if ((isAutoDerefHandle(arg0Value_))) {
                    LLVMDerefHandleGetReceiverNode getReceiver__1 = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__1, "Specialization 'doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.genericI64DerefHandle_getReceiver_ = getReceiver__1;
                    LLVMManagedReadLibrary nativeRead__1 = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(nativeRead__1, "Specialization 'doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.genericI64DerefHandle_nativeRead_ = nativeRead__1;
                    this.i64DerefHandle_getReceiver_ = null;
                    this.i64DerefHandle_nativeRead_ = null;
                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return doGenericI64DerefHandle(arg0Value_, arg1Value, getReceiver__1, nativeRead__1);
                }
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (((state_0 & 0b110000000)) == 0 /* is-not SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] && SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && ((state_0 & 0b1000000)) == 0 /* is-not SpecializationExcluded  */) {
                    while (true) {
                        int count3_ = 0;
                        I64ManagedData s3_ = I64_MANAGED_CACHE_UPDATER.getVolatile(this);
                        I64ManagedData s3_original = s3_;
                        while (s3_ != null) {
                            if ((s3_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                break;
                            }
                            count3_++;
                            s3_ = s3_.next_;
                        }
                        if (s3_ == null) {
                            // assert (s3_.nativeRead_.accepts(arg0Value_.getObject()));
                            if (count3_ < (3)) {
                                s3_ = this.insert(new I64ManagedData(s3_original));
                                LLVMManagedReadLibrary nativeRead__3 = s3_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(arg0Value_.getObject())));
                                Objects.requireNonNull(nativeRead__3, "Specialization 'doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s3_.nativeRead_ = nativeRead__3;
                                if (!I64_MANAGED_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s3_ != null) {
                            try {
                                return doI64Managed(arg0Value_, arg1Value, s3_.nativeRead_);
                            } catch (UnexpectedResultException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.i64Managed_cache = null;
                                return ex.getResult();
                            }
                        }
                        break;
                    }
                }
                if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count4_ = 0;
                        GenericI64Managed0Data s4_ = GENERIC_I64_MANAGED0_CACHE_UPDATER.getVolatile(this);
                        GenericI64Managed0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            // assert (s4_.nativeRead_.accepts(arg0Value_.getObject()));
                            if (count4_ < (3)) {
                                s4_ = this.insert(new GenericI64Managed0Data(s4_original));
                                LLVMManagedReadLibrary nativeRead__2 = s4_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(arg0Value_.getObject())));
                                Objects.requireNonNull(nativeRead__2, "Specialization 'doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.nativeRead_ = nativeRead__2;
                                if (!GENERIC_I64_MANAGED0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                    continue;
                                }
                                this.i64Managed_cache = null;
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s4_ != null) {
                            return doGenericI64Managed(arg0Value_, arg1Value, s4_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__2 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__2 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                            this.i64Managed_cache = null;
                            this.genericI64Managed0_cache = null;
                            state_0 = state_0 & 0xffffff5f /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)], SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doGenericI64Managed(arg0Value_, arg1Value, nativeRead__2);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110110110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110110110) & ((state_0 & 0b110110110) - 1)) == 0 /* is-single  */) {
                    I64ManagedData s3_ = this.i64Managed_cache;
                    GenericI64Managed0Data s4_ = this.genericI64Managed0_cache;
                    if ((s3_ == null || s3_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64Native(LLVMNativePointer, long)] */;
            }
            {
                LLVMDerefHandleGetReceiverNode getReceiver__1 = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__1, "Specialization 'doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.genericI64DerefHandle_getReceiver_ = getReceiver__1;
                LLVMManagedReadLibrary nativeRead__1 = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__1, "Specialization 'doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.genericI64DerefHandle_nativeRead_ = nativeRead__1;
                this.i64DerefHandle_getReceiver_ = null;
                this.i64DerefHandle_nativeRead_ = null;
                this.state_0_ = state_0_ & 0xfffffffb /* remove SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                assert NodeUtil.assertRecursion(this.genericI64DerefHandle_getReceiver_, 1);
                ((GenerateAOT.Provider) this.genericI64DerefHandle_getReceiver_).prepareForAOT(language, root);
                if (this.genericI64DerefHandle_nativeRead_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.genericI64DerefHandle_nativeRead_, 1);
                    ((GenerateAOT.Provider) this.genericI64DerefHandle_nativeRead_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMI64LoadNode.LLVMI64OffsetLoadNode.doGenericI64DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.genericI64DerefHandle_getReceiver_ = null;
            this.genericI64DerefHandle_nativeRead_ = null;
        }

        @NeverDefault
        public static LLVMI64OffsetLoadNode create() {
            return new LLVMI64OffsetLoadNodeGen();
        }

        @NeverDefault
        public static LLVMI64OffsetLoadNode getUncached() {
            return LLVMI64OffsetLoadNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVMI64OffsetLoadNode.class)
        @DenyReplace
        private static final class I64ManagedData extends Node implements SpecializationDataNode {

            @Child I64ManagedData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI64OffsetLoadNode#doI64Managed}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            I64ManagedData(I64ManagedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMI64OffsetLoadNode.class)
        @DenyReplace
        private static final class GenericI64Managed0Data extends Node implements SpecializationDataNode {

            @Child GenericI64Managed0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI64OffsetLoadNode#doGenericI64Managed}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            GenericI64Managed0Data(GenericI64Managed0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMI64OffsetLoadNode.class)
        @DenyReplace
        private static final class Uncached extends LLVMI64OffsetLoadNode {

            @TruffleBoundary
            @Override
            public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doI64Native(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return doGenericI64DerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doGenericI64Managed(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject())));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public long executeWithTarget(LLVMPointer arg0Value, long arg1Value) throws UnexpectedResultException {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doI64Native(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return LLVMTypesGen.expectLong(doGenericI64DerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached())));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return LLVMTypesGen.expectLong(doGenericI64Managed(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()))));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
