// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPointerLoadNode#doNativePointer}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMPointerLoadNode#doDerefHandle}
 *     Activation probability: 0.29500
 *     With/without class size: 11/8 bytes
 *   Specialization {@link LLVMPointerLoadNode#doIndirectedForeign}
 *     Activation probability: 0.20500
 *     With/without class size: 8/4 bytes
 *   Specialization {@link LLVMPointerLoadNode#doIndirectedForeignAOT}
 *     Activation probability: 0.11500
 *     With/without class size: 6/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMPointerLoadNode.class)
@SuppressWarnings("javadoc")
public final class LLVMPointerLoadNodeGen extends LLVMPointerLoadNode implements GenerateAOT.Provider {

    static final ReferenceField<IndirectedForeignData> INDIRECTED_FOREIGN_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "indirectedForeign_cache", IndirectedForeignData.class);
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPointerLoadNode#doNativePointer}
     *   2: SpecializationActive {@link LLVMPointerLoadNode#doDerefHandle}
     *   3: SpecializationActive {@link LLVMPointerLoadNode#doIndirectedForeign}
     *   4: SpecializationActive {@link LLVMPointerLoadNode#doIndirectedForeignAOT}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPointerLoadNode#doDerefHandle}
     *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
     */
    @Child private LLVMDerefHandleGetReceiverNode derefHandle_getReceiver_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPointerLoadNode#doDerefHandle}
     *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
     */
    @Child private LLVMManagedReadLibrary derefHandle_nativeRead_;
    @UnsafeAccessedField @Child private IndirectedForeignData indirectedForeign_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMPointerLoadNode#doIndirectedForeignAOT}
     *   Parameter: {@link LLVMManagedReadLibrary} read</pre>
     */
    @Child private LLVMManagedReadLibrary indirectedForeignAOT_read_;

    private LLVMPointerLoadNodeGen(LLVMExpressionNode address) {
        this.address_ = address;
    }

    @ExplodeLoop
    @Override
    public Object executeWithTargetGeneric(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doNativePointer(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.derefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.derefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    return doDerefHandle(addressValue_, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    IndirectedForeignData s2_ = this.indirectedForeign_cache;
                    while (s2_ != null) {
                        if ((s2_.read_.accepts(addressValue_.getObject()))) {
                            return doIndirectedForeign(addressValue_, s2_.read_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMManagedReadLibrary read__ = this.indirectedForeignAOT_read_;
                        if (read__ != null) {
                            return doIndirectedForeignAOT(addressValue_, read__);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @ExplodeLoop
    @Override
    public LLVMPointer executeWithTarget(LLVMPointer addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doNativePointer(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.derefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.derefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    return doDerefHandle(addressValue_, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    IndirectedForeignData s2_ = this.indirectedForeign_cache;
                    while (s2_ != null) {
                        if ((s2_.read_.accepts(addressValue_.getObject()))) {
                            return doIndirectedForeign(addressValue_, s2_.read_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMManagedReadLibrary read__ = this.indirectedForeignAOT_read_;
                        if (read__ != null) {
                            return doIndirectedForeignAOT(addressValue_, read__);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @ExplodeLoop
    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] || SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        return doNativePointer(addressValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.derefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.derefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    return doDerefHandle(addressValue__, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    IndirectedForeignData s2_ = this.indirectedForeign_cache;
                    while (s2_ != null) {
                        if ((s2_.read_.accepts(addressValue__.getObject()))) {
                            return doIndirectedForeign(addressValue__, s2_.read_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMManagedReadLibrary read__ = this.indirectedForeignAOT_read_;
                        if (read__ != null) {
                            return doIndirectedForeignAOT(addressValue__, read__);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    private LLVMPointer executeAndSpecialize(Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((!(isAutoDerefHandle(addressValue_)))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doNativePointer(addressValue_);
            }
            if ((isAutoDerefHandle(addressValue_))) {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.derefHandle_getReceiver_ = getReceiver__;
                LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__, "Specialization 'doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.derefHandle_nativeRead_ = nativeRead__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                this.state_0_ = state_0;
                return doDerefHandle(addressValue_, getReceiver__, nativeRead__);
            }
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                while (true) {
                    int count2_ = 0;
                    IndirectedForeignData s2_ = INDIRECTED_FOREIGN_CACHE_UPDATER.getVolatile(this);
                    IndirectedForeignData s2_original = s2_;
                    while (s2_ != null) {
                        if ((s2_.read_.accepts(addressValue_.getObject()))) {
                            break;
                        }
                        count2_++;
                        s2_ = s2_.next_;
                    }
                    if (s2_ == null) {
                        // assert (s2_.read_.accepts(addressValue_.getObject()));
                        if (count2_ < (3)) {
                            s2_ = this.insert(new IndirectedForeignData(s2_original));
                            LLVMManagedReadLibrary read__1 = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                            Objects.requireNonNull(read__1, "Specialization 'doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s2_.read_ = read__1;
                            if (!INDIRECTED_FOREIGN_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s2_ != null) {
                        return doIndirectedForeign(addressValue_, s2_.read_);
                    }
                    break;
                }
            }
            LLVMManagedReadLibrary read__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(read__, "Specialization 'doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.indirectedForeignAOT_read_ = read__;
            this.indirectedForeign_cache = null;
            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
            this.state_0_ = state_0;
            return doIndirectedForeignAOT(addressValue_, read__);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                IndirectedForeignData s2_ = this.indirectedForeign_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPointerLoadNode.doNativePointer(LLVMNativePointer)] */;
        }
        {
            LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
            Objects.requireNonNull(getReceiver__, "Specialization 'doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.derefHandle_getReceiver_ = getReceiver__;
            LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeRead__, "Specialization 'doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.derefHandle_nativeRead_ = nativeRead__;
            assert NodeUtil.assertRecursion(this.derefHandle_getReceiver_, 1);
            ((GenerateAOT.Provider) this.derefHandle_getReceiver_).prepareForAOT(language, root);
            if (this.derefHandle_nativeRead_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.derefHandle_nativeRead_, 1);
                ((GenerateAOT.Provider) this.derefHandle_nativeRead_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPointerLoadNode.doDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
        }
        {
            LLVMManagedReadLibrary read__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(read__, "Specialization 'doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.indirectedForeignAOT_read_ = read__;
            this.indirectedForeign_cache = null;
            this.state_0_ = state_0_ & 0xfffffff7 /* remove SpecializationActive[LLVMPointerLoadNode.doIndirectedForeign(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
            if (this.indirectedForeignAOT_read_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.indirectedForeignAOT_read_, 1);
                ((GenerateAOT.Provider) this.indirectedForeignAOT_read_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMPointerLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.derefHandle_getReceiver_ = null;
        this.derefHandle_nativeRead_ = null;
        this.indirectedForeignAOT_read_ = null;
    }

    @NeverDefault
    public static LLVMPointerLoadNode create(LLVMExpressionNode address) {
        return new LLVMPointerLoadNodeGen(address);
    }

    @GeneratedBy(LLVMPointerLoadNode.class)
    @DenyReplace
    private static final class IndirectedForeignData extends Node implements SpecializationDataNode {

        @Child IndirectedForeignData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerLoadNode#doIndirectedForeign}
         *   Parameter: {@link LLVMManagedReadLibrary} read</pre>
         */
        @Child LLVMManagedReadLibrary read_;

        IndirectedForeignData(IndirectedForeignData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMPointerOffsetLoadNode#doNativePointer}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMPointerOffsetLoadNode#doDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMPointerOffsetLoadNode#doIndirectedForeign}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMPointerOffsetLoadNode#doIndirectedForeignAOT}
     *     Activation probability: 0.11500
     *     With/without class size: 6/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMPointerOffsetLoadNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMPointerOffsetLoadNodeGen extends LLVMPointerOffsetLoadNode implements GenerateAOT.Provider {

        static final ReferenceField<IndirectedForeignData> INDIRECTED_FOREIGN_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "indirectedForeign_cache", IndirectedForeignData.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMPointerOffsetLoadNode#doNativePointer}
         *   2: SpecializationActive {@link LLVMPointerOffsetLoadNode#doDerefHandle}
         *   3: SpecializationActive {@link LLVMPointerOffsetLoadNode#doIndirectedForeign}
         *   4: SpecializationActive {@link LLVMPointerOffsetLoadNode#doIndirectedForeignAOT}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerOffsetLoadNode#doDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode derefHandle_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerOffsetLoadNode#doDerefHandle}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child private LLVMManagedReadLibrary derefHandle_nativeRead_;
        @UnsafeAccessedField @Child private IndirectedForeignData indirectedForeign_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerOffsetLoadNode#doIndirectedForeignAOT}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child private LLVMManagedReadLibrary indirectedForeignAOT_nativeRead_;

        private LLVMPointerOffsetLoadNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doNativePointer(LLVMNativePointer, long)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doNativePointer(LLVMNativePointer, long)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doNativePointer(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doNativePointer(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.derefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.derefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        return doDerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        IndirectedForeignData s2_ = this.indirectedForeign_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                return doIndirectedForeign(arg0Value_, arg1Value, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMManagedReadLibrary nativeRead__1 = this.indirectedForeignAOT_nativeRead_;
                            if (nativeRead__1 != null) {
                                return doIndirectedForeignAOT(arg0Value_, arg1Value, nativeRead__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @ExplodeLoop
        @Override
        public LLVMPointer executeWithTarget(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doNativePointer(LLVMNativePointer, long)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doNativePointer(LLVMNativePointer, long)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doNativePointer(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doNativePointer(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.derefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.derefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        return doDerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        IndirectedForeignData s2_ = this.indirectedForeign_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                return doIndirectedForeign(arg0Value_, arg1Value, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMManagedReadLibrary nativeRead__1 = this.indirectedForeignAOT_nativeRead_;
                            if (nativeRead__1 != null) {
                                return doIndirectedForeignAOT(arg0Value_, arg1Value, nativeRead__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMPointer executeAndSpecialize(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((!(isAutoDerefHandle(arg0Value_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doNativePointer(LLVMNativePointer, long)] */;
                    this.state_0_ = state_0;
                    return doNativePointer(arg0Value_, arg1Value);
                }
                if ((isAutoDerefHandle(arg0Value_))) {
                    LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "Specialization 'doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.derefHandle_getReceiver_ = getReceiver__;
                    LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(nativeRead__, "Specialization 'doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.derefHandle_nativeRead_ = nativeRead__;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return doDerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                }
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        IndirectedForeignData s2_ = INDIRECTED_FOREIGN_CACHE_UPDATER.getVolatile(this);
                        IndirectedForeignData s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(arg0Value_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new IndirectedForeignData(s2_original));
                                LLVMManagedReadLibrary nativeRead__2 = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(arg0Value_.getObject())));
                                Objects.requireNonNull(nativeRead__2, "Specialization 'doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s2_.nativeRead_ = nativeRead__2;
                                if (!INDIRECTED_FOREIGN_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doIndirectedForeign(arg0Value_, arg1Value, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                LLVMManagedReadLibrary nativeRead__1 = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__1, "Specialization 'doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.indirectedForeignAOT_nativeRead_ = nativeRead__1;
                this.indirectedForeign_cache = null;
                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                this.state_0_ = state_0;
                return doIndirectedForeignAOT(arg0Value_, arg1Value, nativeRead__1);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11110) & ((state_0 & 0b11110) - 1)) == 0 /* is-single  */) {
                    IndirectedForeignData s2_ = this.indirectedForeign_cache;
                    if ((s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doNativePointer(LLVMNativePointer, long)] */;
            }
            {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.derefHandle_getReceiver_ = getReceiver__;
                LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__, "Specialization 'doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.derefHandle_nativeRead_ = nativeRead__;
                assert NodeUtil.assertRecursion(this.derefHandle_getReceiver_, 1);
                ((GenerateAOT.Provider) this.derefHandle_getReceiver_).prepareForAOT(language, root);
                if (this.derefHandle_nativeRead_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.derefHandle_nativeRead_, 1);
                    ((GenerateAOT.Provider) this.derefHandle_nativeRead_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
            }
            {
                LLVMManagedReadLibrary nativeRead__1 = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__1, "Specialization 'doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)' cache 'nativeRead' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.indirectedForeignAOT_nativeRead_ = nativeRead__1;
                this.indirectedForeign_cache = null;
                this.state_0_ = state_0_ & 0xfffffff7 /* remove SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeign(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                if (this.indirectedForeignAOT_nativeRead_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.indirectedForeignAOT_nativeRead_, 1);
                    ((GenerateAOT.Provider) this.indirectedForeignAOT_nativeRead_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMPointerLoadNode.LLVMPointerOffsetLoadNode.doIndirectedForeignAOT(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.derefHandle_getReceiver_ = null;
            this.derefHandle_nativeRead_ = null;
            this.indirectedForeignAOT_nativeRead_ = null;
        }

        @NeverDefault
        public static LLVMPointerOffsetLoadNode create() {
            return new LLVMPointerOffsetLoadNodeGen();
        }

        @NeverDefault
        public static LLVMPointerOffsetLoadNode getUncached() {
            return LLVMPointerOffsetLoadNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVMPointerOffsetLoadNode.class)
        @DenyReplace
        private static final class IndirectedForeignData extends Node implements SpecializationDataNode {

            @Child IndirectedForeignData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetLoadNode#doIndirectedForeign}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            IndirectedForeignData(IndirectedForeignData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMPointerOffsetLoadNode.class)
        @DenyReplace
        private static final class Uncached extends LLVMPointerOffsetLoadNode {

            @TruffleBoundary
            @Override
            public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doNativePointer(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return doDerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doIndirectedForeignAOT(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public LLVMPointer executeWithTarget(LLVMPointer arg0Value, long arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doNativePointer(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return doDerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doIndirectedForeignAOT(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
