// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.move;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMCopyTargetLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPrimitiveMoveNode#moveNormalDir}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMPrimitiveMoveNode#moveReverseDir}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMPrimitiveMoveNode.class)
@SuppressWarnings("javadoc")
public final class LLVMPrimitiveMoveNodeGen extends LLVMPrimitiveMoveNode implements GenerateAOT.Provider {

    private static final LibraryFactory<LLVMCopyTargetLibrary> L_L_V_M_COPY_TARGET_LIBRARY_ = LibraryFactory.resolve(LLVMCopyTargetLibrary.class);
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPrimitiveMoveNode#moveNormalDir}
     *   2: SpecializationActive {@link LLVMPrimitiveMoveNode#moveReverseDir}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMPrimitiveMoveNodeGen(LLVMLoadNode loadNode, LLVMStoreNode storeNode, LLVMPrimitiveMoveNode nextPrimitiveMoveNode, long step) {
        super(loadNode, storeNode, nextPrimitiveMoveNode, step);
    }

    @Override
    public void executeWithTarget(LLVMPointer arg0Value, LLVMPointer arg1Value, boolean arg2Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            return;
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.moveNormalDir(LLVMPointer, LLVMPointer, boolean)] || SpecializationActive[LLVMPrimitiveMoveNode.moveReverseDir(LLVMPointer, LLVMPointer, boolean)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.moveNormalDir(LLVMPointer, LLVMPointer, boolean)] */) {
                if ((arg2Value)) {
                    moveNormalDir(arg0Value, arg1Value, arg2Value);
                    return;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.moveReverseDir(LLVMPointer, LLVMPointer, boolean)] */) {
                if ((!(arg2Value))) {
                    moveReverseDir(arg0Value, arg1Value, arg2Value);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        return;
    }

    private void executeAndSpecialize(LLVMPointer arg0Value, LLVMPointer arg1Value, boolean arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((arg2Value)) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPrimitiveMoveNode.moveNormalDir(LLVMPointer, LLVMPointer, boolean)] */;
            this.state_0_ = state_0;
            moveNormalDir(arg0Value, arg1Value, arg2Value);
            return;
        }
        if ((!(arg2Value))) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPrimitiveMoveNode.moveReverseDir(LLVMPointer, LLVMPointer, boolean)] */;
            this.state_0_ = state_0;
            moveReverseDir(arg0Value, arg1Value, arg2Value);
            return;
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPrimitiveMoveNode.moveNormalDir(LLVMPointer, LLVMPointer, boolean)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPrimitiveMoveNode.moveReverseDir(LLVMPointer, LLVMPointer, boolean)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPrimitiveMoveNode create(LLVMLoadNode loadNode, LLVMStoreNode storeNode, LLVMPrimitiveMoveNode nextPrimitiveMoveNode, long step) {
        return new LLVMPrimitiveMoveNodeGen(loadNode, storeNode, nextPrimitiveMoveNode, step);
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link HeadNode#customCopy}
     *     Activation probability: 0.32000
     *     With/without class size: 10/4 bytes
     *   Specialization {@link HeadNode#delegateToMemMove}
     *     Activation probability: 0.26000
     *     With/without class size: 10/8 bytes
     *   Specialization {@link HeadNode#primitiveMoveInForwardDir}
     *     Activation probability: 0.20000
     *     With/without class size: 8/8 bytes
     *   Specialization {@link HeadNode#primitiveMoveInBackwardDir}
     *     Activation probability: 0.14000
     *     With/without class size: 7/8 bytes
     *   Specialization {@link HeadNode#noOp}
     *     Activation probability: 0.08000
     *     With/without class size: 5/8 bytes
     * </pre>
     */
    @GeneratedBy(HeadNode.class)
    @SuppressWarnings("javadoc")
    public static final class HeadNodeGen extends HeadNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode source_;
        @Child private LLVMExpressionNode destination_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link HeadNode#customCopy}
         *   2: SpecializationActive {@link HeadNode#delegateToMemMove}
         *   3: SpecializationActive {@link HeadNode#primitiveMoveInForwardDir}
         *   4: SpecializationActive {@link HeadNode#primitiveMoveInBackwardDir}
         *   5: SpecializationActive {@link HeadNode#noOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HeadNode#customCopy}
         *   Parameter: {@link LLVMCopyTargetLibrary} copyTargetLib</pre>
         */
        @Child private LLVMCopyTargetLibrary customCopy_copyTargetLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HeadNode#delegateToMemMove}
         *   Parameter: {@link LLVMCopyTargetLibrary} copyTargetLib</pre>
         */
        @Child private LLVMCopyTargetLibrary delegateToMemMove_copyTargetLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HeadNode#delegateToMemMove}
         *   Parameter: {@link LLVMAsForeignLibrary} asForeignLib</pre>
         */
        @Child private LLVMAsForeignLibrary delegateToMemMove_asForeignLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HeadNode#primitiveMoveInForwardDir}
         *   Parameter: {@link LLVMCopyTargetLibrary} copyTargetLib</pre>
         */
        @Child private LLVMCopyTargetLibrary primitiveMoveInForwardDir_copyTargetLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HeadNode#primitiveMoveInForwardDir}
         *   Parameter: {@link LLVMAsForeignLibrary} asForeignLib</pre>
         */
        @Child private LLVMAsForeignLibrary primitiveMoveInForwardDir_asForeignLib_;
        @Child private PrimitiveMoveInBackwardDirData primitiveMoveInBackwardDir_cache;
        @Child private NoOpData noOp_cache;

        private HeadNodeGen(long length, LLVMPrimitiveMoveNode primitiveMoveNode, LLVMMemMoveNode memMoveNode, LLVMExpressionNode source, LLVMExpressionNode destination) {
            super(length, primitiveMoveNode, memMoveNode);
            this.source_ = source;
            this.destination_ = destination;
        }

        @Override
        public Object executeWithTarget(LLVMPointer sourceValue, LLVMPointer destinationValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(sourceValue, destinationValue);
            }
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.customCopy(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary)] || SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] || SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] || SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] || SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.customCopy(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary)] */) {
                    {
                        LLVMCopyTargetLibrary copyTargetLib__ = this.customCopy_copyTargetLib_;
                        if (copyTargetLib__ != null) {
                            if ((doCustomCopy(sourceValue, destinationValue, copyTargetLib__))) {
                                return customCopy(sourceValue, destinationValue, copyTargetLib__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */) {
                    {
                        LLVMCopyTargetLibrary copyTargetLib__1 = this.delegateToMemMove_copyTargetLib_;
                        if (copyTargetLib__1 != null) {
                            LLVMAsForeignLibrary asForeignLib__ = this.delegateToMemMove_asForeignLib_;
                            if (asForeignLib__ != null) {
                                if ((!(doCustomCopy(sourceValue, destinationValue, copyTargetLib__1))) && (useMemMoveIntrinsic(sourceValue, destinationValue, asForeignLib__))) {
                                    return delegateToMemMove(sourceValue, destinationValue, copyTargetLib__1, asForeignLib__);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */) {
                    {
                        LLVMCopyTargetLibrary copyTargetLib__2 = this.primitiveMoveInForwardDir_copyTargetLib_;
                        if (copyTargetLib__2 != null) {
                            LLVMAsForeignLibrary asForeignLib__1 = this.primitiveMoveInForwardDir_asForeignLib_;
                            if (asForeignLib__1 != null) {
                                if ((!(doCustomCopy(sourceValue, destinationValue, copyTargetLib__2))) && (!(useMemMoveIntrinsic(sourceValue, destinationValue, asForeignLib__1))) && (copyDirection(sourceValue, destinationValue) > 0)) {
                                    return primitiveMoveInForwardDir(sourceValue, destinationValue, copyTargetLib__2, asForeignLib__1);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */) {
                    PrimitiveMoveInBackwardDirData s3_ = this.primitiveMoveInBackwardDir_cache;
                    if (s3_ != null) {
                        if ((!(doCustomCopy(sourceValue, destinationValue, s3_.copyTargetLib_))) && (!(useMemMoveIntrinsic(sourceValue, destinationValue, s3_.asForeignLib_))) && (copyDirection(sourceValue, destinationValue) < 0)) {
                            return primitiveMoveInBackwardDir(sourceValue, destinationValue, s3_.copyTargetLib_, s3_.asForeignLib_);
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */) {
                    NoOpData s4_ = this.noOp_cache;
                    if (s4_ != null) {
                        if ((!(doCustomCopy(sourceValue, destinationValue, s4_.copyTargetLib_))) && (!(useMemMoveIntrinsic(sourceValue, destinationValue, s4_.asForeignLib_))) && (copyDirection(sourceValue, destinationValue) == 0)) {
                            return noOp(sourceValue, destinationValue, s4_.copyTargetLib_, s4_.asForeignLib_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(sourceValue, destinationValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object sourceValue_ = this.source_.executeGeneric(frameValue);
            Object destinationValue_ = this.destination_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(sourceValue_, destinationValue_);
            }
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.customCopy(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary)] || SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] || SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] || SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] || SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */ && LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                if (LLVMTypes.isPointer(destinationValue_)) {
                    LLVMPointer destinationValue__ = LLVMTypes.asPointer(destinationValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.customCopy(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary)] */) {
                        {
                            LLVMCopyTargetLibrary copyTargetLib__ = this.customCopy_copyTargetLib_;
                            if (copyTargetLib__ != null) {
                                if ((doCustomCopy(sourceValue__, destinationValue__, copyTargetLib__))) {
                                    return customCopy(sourceValue__, destinationValue__, copyTargetLib__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */) {
                        {
                            LLVMCopyTargetLibrary copyTargetLib__1 = this.delegateToMemMove_copyTargetLib_;
                            if (copyTargetLib__1 != null) {
                                LLVMAsForeignLibrary asForeignLib__ = this.delegateToMemMove_asForeignLib_;
                                if (asForeignLib__ != null) {
                                    if ((!(doCustomCopy(sourceValue__, destinationValue__, copyTargetLib__1))) && (useMemMoveIntrinsic(sourceValue__, destinationValue__, asForeignLib__))) {
                                        return delegateToMemMove(sourceValue__, destinationValue__, copyTargetLib__1, asForeignLib__);
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */) {
                        {
                            LLVMCopyTargetLibrary copyTargetLib__2 = this.primitiveMoveInForwardDir_copyTargetLib_;
                            if (copyTargetLib__2 != null) {
                                LLVMAsForeignLibrary asForeignLib__1 = this.primitiveMoveInForwardDir_asForeignLib_;
                                if (asForeignLib__1 != null) {
                                    if ((!(doCustomCopy(sourceValue__, destinationValue__, copyTargetLib__2))) && (!(useMemMoveIntrinsic(sourceValue__, destinationValue__, asForeignLib__1))) && (copyDirection(sourceValue__, destinationValue__) > 0)) {
                                        return primitiveMoveInForwardDir(sourceValue__, destinationValue__, copyTargetLib__2, asForeignLib__1);
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */) {
                        PrimitiveMoveInBackwardDirData s3_ = this.primitiveMoveInBackwardDir_cache;
                        if (s3_ != null) {
                            if ((!(doCustomCopy(sourceValue__, destinationValue__, s3_.copyTargetLib_))) && (!(useMemMoveIntrinsic(sourceValue__, destinationValue__, s3_.asForeignLib_))) && (copyDirection(sourceValue__, destinationValue__) < 0)) {
                                return primitiveMoveInBackwardDir(sourceValue__, destinationValue__, s3_.copyTargetLib_, s3_.asForeignLib_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */) {
                        NoOpData s4_ = this.noOp_cache;
                        if (s4_ != null) {
                            if ((!(doCustomCopy(sourceValue__, destinationValue__, s4_.copyTargetLib_))) && (!(useMemMoveIntrinsic(sourceValue__, destinationValue__, s4_.asForeignLib_))) && (copyDirection(sourceValue__, destinationValue__) == 0)) {
                                return noOp(sourceValue__, destinationValue__, s4_.copyTargetLib_, s4_.asForeignLib_);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(sourceValue_, destinationValue_);
        }

        @SuppressWarnings("unused")
        private Object executeAndSpecialize(Object sourceValue, Object destinationValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(sourceValue)) {
                LLVMPointer sourceValue_ = LLVMTypes.asPointer(sourceValue);
                if (LLVMTypes.isPointer(destinationValue)) {
                    LLVMPointer destinationValue_ = LLVMTypes.asPointer(destinationValue);
                    {
                        LLVMCopyTargetLibrary copyTargetLib__ = this.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                        if ((doCustomCopy(sourceValue_, destinationValue_, copyTargetLib__))) {
                            Objects.requireNonNull(this.insert(copyTargetLib__), "Specialization 'customCopy(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.customCopy_copyTargetLib_ = copyTargetLib__;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.customCopy(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary)] */;
                            this.state_0_ = state_0;
                            return customCopy(sourceValue_, destinationValue_, copyTargetLib__);
                        }
                    }
                    {
                        LLVMCopyTargetLibrary copyTargetLib__1 = this.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                        if ((!(doCustomCopy(sourceValue_, destinationValue_, copyTargetLib__1)))) {
                            LLVMAsForeignLibrary asForeignLib__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                            if ((useMemMoveIntrinsic(sourceValue_, destinationValue_, asForeignLib__))) {
                                Objects.requireNonNull(this.insert(copyTargetLib__1), "Specialization 'delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.delegateToMemMove_copyTargetLib_ = copyTargetLib__1;
                                Objects.requireNonNull(this.insert(asForeignLib__), "Specialization 'delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'asForeignLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.delegateToMemMove_asForeignLib_ = asForeignLib__;
                                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */;
                                this.state_0_ = state_0;
                                return delegateToMemMove(sourceValue_, destinationValue_, copyTargetLib__1, asForeignLib__);
                            }
                        }
                    }
                    {
                        LLVMCopyTargetLibrary copyTargetLib__2 = this.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                        if ((!(doCustomCopy(sourceValue_, destinationValue_, copyTargetLib__2)))) {
                            LLVMAsForeignLibrary asForeignLib__1 = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                            if ((!(useMemMoveIntrinsic(sourceValue_, destinationValue_, asForeignLib__1))) && (copyDirection(sourceValue_, destinationValue_) > 0)) {
                                Objects.requireNonNull(this.insert(copyTargetLib__2), "Specialization 'primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.primitiveMoveInForwardDir_copyTargetLib_ = copyTargetLib__2;
                                Objects.requireNonNull(this.insert(asForeignLib__1), "Specialization 'primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'asForeignLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.primitiveMoveInForwardDir_asForeignLib_ = asForeignLib__1;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */;
                                this.state_0_ = state_0;
                                return primitiveMoveInForwardDir(sourceValue_, destinationValue_, copyTargetLib__2, asForeignLib__1);
                            }
                        }
                    }
                    {
                        LLVMCopyTargetLibrary copyTargetLib__3 = this.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                        if ((!(doCustomCopy(sourceValue_, destinationValue_, copyTargetLib__3)))) {
                            LLVMAsForeignLibrary asForeignLib__2 = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                            if ((!(useMemMoveIntrinsic(sourceValue_, destinationValue_, asForeignLib__2))) && (copyDirection(sourceValue_, destinationValue_) < 0)) {
                                PrimitiveMoveInBackwardDirData s3_ = this.insert(new PrimitiveMoveInBackwardDirData());
                                Objects.requireNonNull(s3_.insert(copyTargetLib__3), "Specialization 'primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s3_.copyTargetLib_ = copyTargetLib__3;
                                Objects.requireNonNull(s3_.insert(asForeignLib__2), "Specialization 'primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'asForeignLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s3_.asForeignLib_ = asForeignLib__2;
                                VarHandle.storeStoreFence();
                                this.primitiveMoveInBackwardDir_cache = s3_;
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */;
                                this.state_0_ = state_0;
                                return primitiveMoveInBackwardDir(sourceValue_, destinationValue_, copyTargetLib__3, asForeignLib__2);
                            }
                        }
                    }
                    {
                        LLVMCopyTargetLibrary copyTargetLib__4 = this.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                        if ((!(doCustomCopy(sourceValue_, destinationValue_, copyTargetLib__4)))) {
                            LLVMAsForeignLibrary asForeignLib__3 = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                            if ((!(useMemMoveIntrinsic(sourceValue_, destinationValue_, asForeignLib__3))) && (copyDirection(sourceValue_, destinationValue_) == 0)) {
                                NoOpData s4_ = this.insert(new NoOpData());
                                Objects.requireNonNull(s4_.insert(copyTargetLib__4), "Specialization 'noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.copyTargetLib_ = copyTargetLib__4;
                                Objects.requireNonNull(s4_.insert(asForeignLib__3), "Specialization 'noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'asForeignLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s4_.asForeignLib_ = asForeignLib__3;
                                VarHandle.storeStoreFence();
                                this.noOp_cache = s4_;
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */;
                                this.state_0_ = state_0;
                                return noOp(sourceValue_, destinationValue_, copyTargetLib__4, asForeignLib__3);
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.source_, this.destination_}, sourceValue, destinationValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b111110) & ((state_0 & 0b111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                LLVMCopyTargetLibrary copyTargetLib__ = this.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(copyTargetLib__, "Specialization 'customCopy(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.customCopy_copyTargetLib_ = copyTargetLib__;
                if (this.customCopy_copyTargetLib_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.customCopy_copyTargetLib_, 1);
                    ((GenerateAOT.Provider) this.customCopy_copyTargetLib_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.customCopy(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary)] */;
            }
            {
                LLVMCopyTargetLibrary copyTargetLib__1 = this.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(copyTargetLib__1, "Specialization 'delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.delegateToMemMove_copyTargetLib_ = copyTargetLib__1;
                LLVMAsForeignLibrary asForeignLib__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(asForeignLib__, "Specialization 'delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'asForeignLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.delegateToMemMove_asForeignLib_ = asForeignLib__;
                if (this.delegateToMemMove_copyTargetLib_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.delegateToMemMove_copyTargetLib_, 1);
                    ((GenerateAOT.Provider) this.delegateToMemMove_copyTargetLib_).prepareForAOT(language, root);
                }
                if (this.delegateToMemMove_asForeignLib_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.delegateToMemMove_asForeignLib_, 1);
                    ((GenerateAOT.Provider) this.delegateToMemMove_asForeignLib_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.delegateToMemMove(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */;
            }
            {
                LLVMCopyTargetLibrary copyTargetLib__2 = this.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(copyTargetLib__2, "Specialization 'primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.primitiveMoveInForwardDir_copyTargetLib_ = copyTargetLib__2;
                LLVMAsForeignLibrary asForeignLib__1 = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(asForeignLib__1, "Specialization 'primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'asForeignLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.primitiveMoveInForwardDir_asForeignLib_ = asForeignLib__1;
                if (this.primitiveMoveInForwardDir_copyTargetLib_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.primitiveMoveInForwardDir_copyTargetLib_, 1);
                    ((GenerateAOT.Provider) this.primitiveMoveInForwardDir_copyTargetLib_).prepareForAOT(language, root);
                }
                if (this.primitiveMoveInForwardDir_asForeignLib_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.primitiveMoveInForwardDir_asForeignLib_, 1);
                    ((GenerateAOT.Provider) this.primitiveMoveInForwardDir_asForeignLib_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInForwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */;
            }
            {
                PrimitiveMoveInBackwardDirData s3_ = this.insert(new PrimitiveMoveInBackwardDirData());
                LLVMCopyTargetLibrary copyTargetLib__3 = s3_.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(copyTargetLib__3, "Specialization 'primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s3_.copyTargetLib_ = copyTargetLib__3;
                LLVMAsForeignLibrary asForeignLib__2 = s3_.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(asForeignLib__2, "Specialization 'primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'asForeignLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s3_.asForeignLib_ = asForeignLib__2;
                VarHandle.storeStoreFence();
                this.primitiveMoveInBackwardDir_cache = s3_;
                if (s3_.copyTargetLib_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(s3_.copyTargetLib_, 1);
                    ((GenerateAOT.Provider) s3_.copyTargetLib_).prepareForAOT(language, root);
                }
                if (s3_.asForeignLib_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(s3_.asForeignLib_, 1);
                    ((GenerateAOT.Provider) s3_.asForeignLib_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.primitiveMoveInBackwardDir(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */;
            }
            {
                NoOpData s4_ = this.insert(new NoOpData());
                LLVMCopyTargetLibrary copyTargetLib__4 = s4_.insert((L_L_V_M_COPY_TARGET_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(copyTargetLib__4, "Specialization 'noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'copyTargetLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s4_.copyTargetLib_ = copyTargetLib__4;
                LLVMAsForeignLibrary asForeignLib__3 = s4_.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(asForeignLib__3, "Specialization 'noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)' cache 'asForeignLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s4_.asForeignLib_ = asForeignLib__3;
                VarHandle.storeStoreFence();
                this.noOp_cache = s4_;
                if (s4_.copyTargetLib_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(s4_.copyTargetLib_, 1);
                    ((GenerateAOT.Provider) s4_.copyTargetLib_).prepareForAOT(language, root);
                }
                if (s4_.asForeignLib_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(s4_.asForeignLib_, 1);
                    ((GenerateAOT.Provider) s4_.asForeignLib_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMPrimitiveMoveNode.HeadNode.noOp(LLVMPointer, LLVMPointer, LLVMCopyTargetLibrary, LLVMAsForeignLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.customCopy_copyTargetLib_ = null;
            this.delegateToMemMove_copyTargetLib_ = null;
            this.delegateToMemMove_asForeignLib_ = null;
            this.primitiveMoveInForwardDir_copyTargetLib_ = null;
            this.primitiveMoveInForwardDir_asForeignLib_ = null;
            this.primitiveMoveInBackwardDir_cache = null;
            this.noOp_cache = null;
        }

        @NeverDefault
        public static HeadNode create(long length, LLVMPrimitiveMoveNode primitiveMoveNode, LLVMMemMoveNode memMoveNode, LLVMExpressionNode source, LLVMExpressionNode destination) {
            return new HeadNodeGen(length, primitiveMoveNode, memMoveNode, source, destination);
        }

        @GeneratedBy(HeadNode.class)
        @DenyReplace
        private static final class PrimitiveMoveInBackwardDirData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link HeadNode#primitiveMoveInBackwardDir}
             *   Parameter: {@link LLVMCopyTargetLibrary} copyTargetLib</pre>
             */
            @Child LLVMCopyTargetLibrary copyTargetLib_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HeadNode#primitiveMoveInBackwardDir}
             *   Parameter: {@link LLVMAsForeignLibrary} asForeignLib</pre>
             */
            @Child LLVMAsForeignLibrary asForeignLib_;

            PrimitiveMoveInBackwardDirData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(HeadNode.class)
        @DenyReplace
        private static final class NoOpData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link HeadNode#noOp}
             *   Parameter: {@link LLVMCopyTargetLibrary} copyTargetLib</pre>
             */
            @Child LLVMCopyTargetLibrary copyTargetLib_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HeadNode#noOp}
             *   Parameter: {@link LLVMAsForeignLibrary} asForeignLib</pre>
             */
            @Child LLVMAsForeignLibrary asForeignLib_;

            NoOpData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
