// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPointerStoreNode#doAddress(LLVMNativePointer, Object, LLVMToNativeNode)}
 *     Activation probability: 0.27381
 *     With/without class size: 9/4 bytes
 *   Specialization {@link LLVMPointerStoreNode#doAddress(long, Object, LLVMToNativeNode)}
 *     Activation probability: 0.23095
 *     With/without class size: 8/4 bytes
 *   Specialization {@link LLVMPointerStoreNode#doOpDerefHandle}
 *     Activation probability: 0.18810
 *     With/without class size: 9/12 bytes
 *   Specialization {@link LLVMPointerStoreNode#doDerefAddress}
 *     Activation probability: 0.14524
 *     With/without class size: 8/12 bytes
 *   Specialization {@link LLVMPointerStoreNode#doManaged}
 *     Activation probability: 0.10238
 *     With/without class size: 6/8 bytes
 *   Specialization {@link LLVMPointerStoreNode#doManagedAOT}
 *     Activation probability: 0.05952
 *     With/without class size: 5/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMPointerStoreNode.class)
@SuppressWarnings("javadoc")
public final class LLVMPointerStoreNodeGen extends LLVMPointerStoreNode implements GenerateAOT.Provider {

    static final ReferenceField<ManagedData> MANAGED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "managed_cache", ManagedData.class);
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPointerStoreNode#doAddress(LLVMNativePointer, Object, LLVMToNativeNode)}
     *   2: SpecializationActive {@link LLVMPointerStoreNode#doAddress(long, Object, LLVMToNativeNode)}
     *   3: SpecializationActive {@link LLVMPointerStoreNode#doOpDerefHandle}
     *   4: SpecializationActive {@link LLVMPointerStoreNode#doDerefAddress}
     *   5: SpecializationActive {@link LLVMPointerStoreNode#doManaged}
     *   6: SpecializationActive {@link LLVMPointerStoreNode#doManagedAOT}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private Address0Data address0_cache;
    @Child private Address1Data address1_cache;
    @Child private OpDerefHandleData opDerefHandle_cache;
    @Child private DerefAddressData derefAddress_cache;
    @UnsafeAccessedField @Child private ManagedData managed_cache;
    @Child private ManagedAOTData managedAOT_cache;

    private LLVMPointerStoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    @ExplodeLoop
    @Override
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                Address0Data s0_ = this.address0_cache;
                if (s0_ != null) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doAddress(addressValue_, valueValue, s0_.toNative_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] */ && addressValue instanceof Long) {
                long addressValue_ = (long) addressValue;
                Address1Data s1_ = this.address1_cache;
                if (s1_ != null) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doAddress(addressValue_, valueValue, s1_.toNative_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                OpDerefHandleData s2_ = this.opDerefHandle_cache;
                if (s2_ != null) {
                    if ((isAutoDerefHandle(addressValue_))) {
                        LLVMPointerStoreNode.doOpDerefHandle(addressValue_, valueValue, s2_.toPointer_, s2_.getReceiver_, s2_.nativeWrite_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && addressValue instanceof Long) {
                long addressValue_ = (long) addressValue;
                DerefAddressData s3_ = this.derefAddress_cache;
                if (s3_ != null) {
                    if ((isAutoDerefHandle(addressValue_))) {
                        LLVMPointerStoreNode.doDerefAddress(addressValue_, valueValue, s3_.toPointer_, s3_.getReceiver_, s3_.nativeWrite_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                    ManagedData s4_ = this.managed_cache;
                    while (s4_ != null) {
                        if ((s4_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            LLVMPointerStoreNode.doManaged(addressValue_, valueValue, s4_.toPointer_, s4_.nativeWrite_);
                            return;
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                    ManagedAOTData s5_ = this.managedAOT_cache;
                    if (s5_ != null) {
                        LLVMPointerStoreNode.doManagedAOT(addressValue_, valueValue, s5_.toPointer_, s5_.nativeWrite_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @ExplodeLoop
    @Override
    public void executeWithTarget(LLVMPointer addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0b1101010) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b1010) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] */) {
                    Address0Data s0_ = this.address0_cache;
                    if (s0_ != null) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            doAddress(addressValue_, valueValue, s0_.toNative_);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                    OpDerefHandleData s2_ = this.opDerefHandle_cache;
                    if (s2_ != null) {
                        if ((isAutoDerefHandle(addressValue_))) {
                            LLVMPointerStoreNode.doOpDerefHandle(addressValue_, valueValue, s2_.toPointer_, s2_.getReceiver_, s2_.nativeWrite_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                    ManagedData s4_ = this.managed_cache;
                    while (s4_ != null) {
                        if ((s4_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            LLVMPointerStoreNode.doManaged(addressValue_, valueValue, s4_.toPointer_, s4_.nativeWrite_);
                            return;
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                    ManagedAOTData s5_ = this.managedAOT_cache;
                    if (s5_ != null) {
                        LLVMPointerStoreNode.doManagedAOT(addressValue_, valueValue, s5_.toPointer_, s5_.nativeWrite_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1101010) == 0 /* only-active SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] && SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] && SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] && SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] && SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */)) {
            execute_long0(state_0, frameValue);
            return;
        } else {
            execute_generic1(state_0, frameValue);
            return;
        }
    }

    private void execute_long0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long addressValue_;
        try {
            addressValue_ = this.address_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object valueValue = this.value_.executeGeneric(frameValue);
            executeAndSpecialize(ex.getResult(), valueValue);
            return;
        }
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0b10100) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] */) {
                Address1Data s1_ = this.address1_cache;
                if (s1_ != null) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        doAddress(addressValue_, valueValue_, s1_.toNative_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                DerefAddressData s3_ = this.derefAddress_cache;
                if (s3_ != null) {
                    if ((isAutoDerefHandle(addressValue_))) {
                        LLVMPointerStoreNode.doDerefAddress(addressValue_, valueValue_, s3_.toPointer_, s3_.getReceiver_, s3_.nativeWrite_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue_, valueValue_);
        return;
    }

    @ExplodeLoop
    private void execute_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                Address0Data s0_ = this.address0_cache;
                if (s0_ != null) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        doAddress(addressValue__, valueValue_, s0_.toNative_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] */ && addressValue_ instanceof Long) {
                long addressValue__ = (long) addressValue_;
                Address1Data s1_ = this.address1_cache;
                if (s1_ != null) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        doAddress(addressValue__, valueValue_, s1_.toNative_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                OpDerefHandleData s2_ = this.opDerefHandle_cache;
                if (s2_ != null) {
                    if ((isAutoDerefHandle(addressValue__))) {
                        LLVMPointerStoreNode.doOpDerefHandle(addressValue__, valueValue_, s2_.toPointer_, s2_.getReceiver_, s2_.nativeWrite_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && addressValue_ instanceof Long) {
                long addressValue__ = (long) addressValue_;
                DerefAddressData s3_ = this.derefAddress_cache;
                if (s3_ != null) {
                    if ((isAutoDerefHandle(addressValue__))) {
                        LLVMPointerStoreNode.doDerefAddress(addressValue__, valueValue_, s3_.toPointer_, s3_.getReceiver_, s3_.nativeWrite_);
                        return;
                    }
                }
            }
            if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                    ManagedData s4_ = this.managed_cache;
                    while (s4_ != null) {
                        if ((s4_.nativeWrite_.accepts(addressValue__.getObject()))) {
                            LLVMPointerStoreNode.doManaged(addressValue__, valueValue_, s4_.toPointer_, s4_.nativeWrite_);
                            return;
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                    ManagedAOTData s5_ = this.managedAOT_cache;
                    if (s5_ != null) {
                        LLVMPointerStoreNode.doManagedAOT(addressValue__, valueValue_, s5_.toPointer_, s5_.nativeWrite_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue_, valueValue_);
        return;
    }

    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((!(isAutoDerefHandle(addressValue_)))) {
                Address0Data s0_ = this.insert(new Address0Data());
                s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.address0_cache = s0_;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] */;
                this.state_0_ = state_0;
                doAddress(addressValue_, valueValue, s0_.toNative_);
                return;
            }
        }
        if (addressValue instanceof Long) {
            long addressValue_ = (long) addressValue;
            if ((!(isAutoDerefHandle(addressValue_)))) {
                Address1Data s1_ = this.insert(new Address1Data());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.address1_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] */;
                this.state_0_ = state_0;
                doAddress(addressValue_, valueValue, s1_.toNative_);
                return;
            }
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((isAutoDerefHandle(addressValue_))) {
                OpDerefHandleData s2_ = this.insert(new OpDerefHandleData());
                LLVMToPointerNode toPointer__ = s2_.insert((LLVMToPointerNodeGen.create()));
                Objects.requireNonNull(toPointer__, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.toPointer_ = toPointer__;
                LLVMDerefHandleGetReceiverNode getReceiver__ = s2_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.getReceiver_ = getReceiver__;
                LLVMManagedWriteLibrary nativeWrite__ = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.nativeWrite_ = nativeWrite__;
                VarHandle.storeStoreFence();
                this.opDerefHandle_cache = s2_;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                this.state_0_ = state_0;
                LLVMPointerStoreNode.doOpDerefHandle(addressValue_, valueValue, toPointer__, getReceiver__, nativeWrite__);
                return;
            }
        }
        if (addressValue instanceof Long) {
            long addressValue_ = (long) addressValue;
            if ((isAutoDerefHandle(addressValue_))) {
                DerefAddressData s3_ = this.insert(new DerefAddressData());
                LLVMToPointerNode toPointer__1 = s3_.insert((LLVMToPointerNodeGen.create()));
                Objects.requireNonNull(toPointer__1, "Specialization 'doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s3_.toPointer_ = toPointer__1;
                LLVMDerefHandleGetReceiverNode getReceiver__1 = s3_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__1, "Specialization 'doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s3_.getReceiver_ = getReceiver__1;
                LLVMManagedWriteLibrary nativeWrite__1 = s3_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__1, "Specialization 'doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s3_.nativeWrite_ = nativeWrite__1;
                VarHandle.storeStoreFence();
                this.derefAddress_cache = s3_;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                this.state_0_ = state_0;
                LLVMPointerStoreNode.doDerefAddress(addressValue_, valueValue, toPointer__1, getReceiver__1, nativeWrite__1);
                return;
            }
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                while (true) {
                    int count4_ = 0;
                    ManagedData s4_ = MANAGED_CACHE_UPDATER.getVolatile(this);
                    ManagedData s4_original = s4_;
                    while (s4_ != null) {
                        if ((s4_.nativeWrite_.accepts(addressValue_.getObject()))) {
                            break;
                        }
                        count4_++;
                        s4_ = s4_.next_;
                    }
                    if (s4_ == null) {
                        // assert (s4_.nativeWrite_.accepts(addressValue_.getObject()));
                        if (count4_ < (3)) {
                            s4_ = this.insert(new ManagedData(s4_original));
                            LLVMToPointerNode toPointer__2 = s4_.insert((LLVMToPointerNodeGen.create()));
                            Objects.requireNonNull(toPointer__2, "Specialization 'doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s4_.toPointer_ = toPointer__2;
                            LLVMManagedWriteLibrary nativeWrite__2 = s4_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                            Objects.requireNonNull(nativeWrite__2, "Specialization 'doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s4_.nativeWrite_ = nativeWrite__2;
                            if (!MANAGED_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s4_ != null) {
                        LLVMPointerStoreNode.doManaged(addressValue_, valueValue, s4_.toPointer_, s4_.nativeWrite_);
                        return;
                    }
                    break;
                }
            }
            ManagedAOTData s5_ = this.insert(new ManagedAOTData());
            LLVMToPointerNode toPointer__3 = s5_.insert((LLVMToPointerNodeGen.create()));
            Objects.requireNonNull(toPointer__3, "Specialization 'doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s5_.toPointer_ = toPointer__3;
            LLVMManagedWriteLibrary nativeWrite__3 = s5_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__3, "Specialization 'doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s5_.nativeWrite_ = nativeWrite__3;
            VarHandle.storeStoreFence();
            this.managedAOT_cache = s5_;
            this.managed_cache = null;
            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
            this.state_0_ = state_0;
            LLVMPointerStoreNode.doManagedAOT(addressValue_, valueValue, toPointer__3, nativeWrite__3);
            return;
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.value_}, addressValue, valueValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111110) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b1111110) & ((state_0 & 0b1111110) - 1)) == 0 /* is-single  */) {
                ManagedData s4_ = this.managed_cache;
                if ((s4_ == null || s4_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            Address0Data s0_ = this.insert(new Address0Data());
            s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            VarHandle.storeStoreFence();
            this.address0_cache = s0_;
            assert NodeUtil.assertRecursion(s0_.toNative_, 1);
            ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPointerStoreNode.doAddress(LLVMNativePointer, Object, LLVMToNativeNode)] */;
        }
        {
            Address1Data s1_ = this.insert(new Address1Data());
            s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
            VarHandle.storeStoreFence();
            this.address1_cache = s1_;
            assert NodeUtil.assertRecursion(s1_.toNative_, 1);
            ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPointerStoreNode.doAddress(long, Object, LLVMToNativeNode)] */;
        }
        {
            OpDerefHandleData s2_ = this.insert(new OpDerefHandleData());
            LLVMToPointerNode toPointer__ = s2_.insert((LLVMToPointerNodeGen.create()));
            Objects.requireNonNull(toPointer__, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s2_.toPointer_ = toPointer__;
            LLVMDerefHandleGetReceiverNode getReceiver__ = s2_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
            Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s2_.getReceiver_ = getReceiver__;
            LLVMManagedWriteLibrary nativeWrite__ = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s2_.nativeWrite_ = nativeWrite__;
            VarHandle.storeStoreFence();
            this.opDerefHandle_cache = s2_;
            assert NodeUtil.assertRecursion(s2_.toPointer_, 1);
            ((GenerateAOT.Provider) s2_.toPointer_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s2_.getReceiver_, 1);
            ((GenerateAOT.Provider) s2_.getReceiver_).prepareForAOT(language, root);
            if (s2_.nativeWrite_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(s2_.nativeWrite_, 1);
                ((GenerateAOT.Provider) s2_.nativeWrite_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMPointerStoreNode.doOpDerefHandle(LLVMNativePointer, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
        }
        {
            DerefAddressData s3_ = this.insert(new DerefAddressData());
            LLVMToPointerNode toPointer__1 = s3_.insert((LLVMToPointerNodeGen.create()));
            Objects.requireNonNull(toPointer__1, "Specialization 'doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s3_.toPointer_ = toPointer__1;
            LLVMDerefHandleGetReceiverNode getReceiver__1 = s3_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
            Objects.requireNonNull(getReceiver__1, "Specialization 'doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s3_.getReceiver_ = getReceiver__1;
            LLVMManagedWriteLibrary nativeWrite__1 = s3_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__1, "Specialization 'doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s3_.nativeWrite_ = nativeWrite__1;
            VarHandle.storeStoreFence();
            this.derefAddress_cache = s3_;
            assert NodeUtil.assertRecursion(s3_.toPointer_, 1);
            ((GenerateAOT.Provider) s3_.toPointer_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s3_.getReceiver_, 1);
            ((GenerateAOT.Provider) s3_.getReceiver_).prepareForAOT(language, root);
            if (s3_.nativeWrite_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(s3_.nativeWrite_, 1);
                ((GenerateAOT.Provider) s3_.nativeWrite_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMPointerStoreNode.doDerefAddress(long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
        }
        {
            ManagedAOTData s5_ = this.insert(new ManagedAOTData());
            LLVMToPointerNode toPointer__3 = s5_.insert((LLVMToPointerNodeGen.create()));
            Objects.requireNonNull(toPointer__3, "Specialization 'doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s5_.toPointer_ = toPointer__3;
            LLVMManagedWriteLibrary nativeWrite__3 = s5_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeWrite__3, "Specialization 'doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s5_.nativeWrite_ = nativeWrite__3;
            VarHandle.storeStoreFence();
            this.managedAOT_cache = s5_;
            this.managed_cache = null;
            this.state_0_ = state_0_ & 0xffffffdf /* remove SpecializationActive[LLVMPointerStoreNode.doManaged(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
            assert NodeUtil.assertRecursion(s5_.toPointer_, 1);
            ((GenerateAOT.Provider) s5_.toPointer_).prepareForAOT(language, root);
            if (s5_.nativeWrite_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(s5_.nativeWrite_, 1);
                ((GenerateAOT.Provider) s5_.nativeWrite_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMPointerStoreNode.doManagedAOT(LLVMManagedPointer, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.address0_cache = null;
        this.address1_cache = null;
        this.opDerefHandle_cache = null;
        this.derefAddress_cache = null;
        this.managedAOT_cache = null;
    }

    @NeverDefault
    public static LLVMPointerStoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMPointerStoreNodeGen(address, value);
    }

    @GeneratedBy(LLVMPointerStoreNode.class)
    @DenyReplace
    private static final class Address0Data extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doAddress(LLVMNativePointer, Object, LLVMToNativeNode)}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;

        Address0Data() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMPointerStoreNode.class)
    @DenyReplace
    private static final class Address1Data extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doAddress(long, Object, LLVMToNativeNode)}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;

        Address1Data() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMPointerStoreNode.class)
    @DenyReplace
    private static final class OpDerefHandleData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMToPointerNode} toPointer</pre>
         */
        @Child LLVMToPointerNode toPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child LLVMDerefHandleGetReceiverNode getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doOpDerefHandle}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        OpDerefHandleData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMPointerStoreNode.class)
    @DenyReplace
    private static final class DerefAddressData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doDerefAddress}
         *   Parameter: {@link LLVMToPointerNode} toPointer</pre>
         */
        @Child LLVMToPointerNode toPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doDerefAddress}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child LLVMDerefHandleGetReceiverNode getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doDerefAddress}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        DerefAddressData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMPointerStoreNode.class)
    @DenyReplace
    private static final class ManagedData extends Node implements SpecializationDataNode {

        @Child ManagedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doManaged}
         *   Parameter: {@link LLVMToPointerNode} toPointer</pre>
         */
        @Child LLVMToPointerNode toPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doManaged}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        ManagedData(ManagedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(LLVMPointerStoreNode.class)
    @DenyReplace
    private static final class ManagedAOTData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doManagedAOT}
         *   Parameter: {@link LLVMToPointerNode} toPointer</pre>
         */
        @Child LLVMToPointerNode toPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMPointerStoreNode#doManagedAOT}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        ManagedAOTData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMPointerOffsetStoreNode#doAddress}
     *     Activation probability: 0.32000
     *     With/without class size: 10/4 bytes
     *   Specialization {@link LLVMPointerOffsetStoreNode#doOpDerefHandle}
     *     Activation probability: 0.26000
     *     With/without class size: 11/12 bytes
     *   Specialization {@link LLVMPointerOffsetStoreNode#doDerefAddress}
     *     Activation probability: 0.20000
     *     With/without class size: 9/12 bytes
     *   Specialization {@link LLVMPointerOffsetStoreNode#doManaged}
     *     Activation probability: 0.14000
     *     With/without class size: 7/8 bytes
     *   Specialization {@link LLVMPointerOffsetStoreNode#doManagedAOT}
     *     Activation probability: 0.08000
     *     With/without class size: 5/8 bytes
     * </pre>
     */
    @GeneratedBy(LLVMPointerOffsetStoreNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMPointerOffsetStoreNodeGen extends LLVMPointerOffsetStoreNode implements GenerateAOT.Provider {

        static final ReferenceField<ManagedData> MANAGED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "managed_cache", ManagedData.class);
        private static final Uncached UNCACHED = new Uncached();

        @Child private LLVMExpressionNode target_;
        @Child private LLVMExpressionNode offset_;
        @Child private LLVMExpressionNode value_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMPointerOffsetStoreNode#doAddress}
         *   2: SpecializationActive {@link LLVMPointerOffsetStoreNode#doOpDerefHandle}
         *   3: SpecializationActive {@link LLVMPointerOffsetStoreNode#doDerefAddress}
         *   4: SpecializationActive {@link LLVMPointerOffsetStoreNode#doManaged}
         *   5: SpecializationActive {@link LLVMPointerOffsetStoreNode#doManagedAOT}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private AddressData address_cache;
        @Child private OpDerefHandleData opDerefHandle_cache;
        @Child private DerefAddressData derefAddress_cache;
        @UnsafeAccessedField @Child private ManagedData managed_cache;
        @Child private ManagedAOTData managedAOT_cache;

        private LLVMPointerOffsetStoreNodeGen(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        @ExplodeLoop
        @Override
        public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b110110) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] */) {
                        AddressData s0_ = this.address_cache;
                        if (s0_ != null) {
                            if ((!(isAutoDerefHandle(targetValue_)))) {
                                doAddress(targetValue_, offsetValue, valueValue, s0_.toNative_);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        OpDerefHandleData s1_ = this.opDerefHandle_cache;
                        if (s1_ != null) {
                            if ((isAutoDerefHandle(targetValue_))) {
                                LLVMPointerOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, s1_.toPointer_, s1_.getReceiver_, s1_.nativeWrite_);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b110000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                        ManagedData s3_ = this.managed_cache;
                        while (s3_ != null) {
                            if ((s3_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMPointerOffsetStoreNode.doManaged(targetValue_, offsetValue, valueValue, s3_.toPointer_, s3_.nativeWrite_);
                                return;
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                        ManagedAOTData s4_ = this.managedAOT_cache;
                        if (s4_ != null) {
                            LLVMPointerOffsetStoreNode.doManagedAOT(targetValue_, offsetValue, valueValue, s4_.toPointer_, s4_.nativeWrite_);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @ExplodeLoop
        @Override
        public void executeWithTarget(LLVMPointer targetValue, long offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue);
                return;
            }
            if ((state_0 & 0b110110) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] */) {
                        AddressData s0_ = this.address_cache;
                        if (s0_ != null) {
                            if ((!(isAutoDerefHandle(targetValue_)))) {
                                doAddress(targetValue_, offsetValue, valueValue, s0_.toNative_);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        OpDerefHandleData s1_ = this.opDerefHandle_cache;
                        if (s1_ != null) {
                            if ((isAutoDerefHandle(targetValue_))) {
                                LLVMPointerOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, s1_.toPointer_, s1_.getReceiver_, s1_.nativeWrite_);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b110000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                        ManagedData s3_ = this.managed_cache;
                        while (s3_ != null) {
                            if ((s3_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMPointerOffsetStoreNode.doManaged(targetValue_, offsetValue, valueValue, s3_.toPointer_, s3_.nativeWrite_);
                                return;
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                        ManagedAOTData s4_ = this.managedAOT_cache;
                        if (s4_ != null) {
                            LLVMPointerOffsetStoreNode.doManagedAOT(targetValue_, offsetValue, valueValue, s4_.toPointer_, s4_.nativeWrite_);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue);
            return;
        }

        @ExplodeLoop
        @Override
        public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = this.state_0_;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(targetValue, offsetValue, valueValue_);
                return;
            }
            if ((state_0 & 0b110110) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] */) {
                        AddressData s0_ = this.address_cache;
                        if (s0_ != null) {
                            if ((!(isAutoDerefHandle(targetValue_)))) {
                                doAddress(targetValue_, offsetValue, valueValue_, s0_.toNative_);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */) {
                        OpDerefHandleData s1_ = this.opDerefHandle_cache;
                        if (s1_ != null) {
                            if ((isAutoDerefHandle(targetValue_))) {
                                LLVMPointerOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue_, s1_.toPointer_, s1_.getReceiver_, s1_.nativeWrite_);
                                return;
                            }
                        }
                    }
                }
                if ((state_0 & 0b110000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                        ManagedData s3_ = this.managed_cache;
                        while (s3_ != null) {
                            if ((s3_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                LLVMPointerOffsetStoreNode.doManaged(targetValue_, offsetValue, valueValue_, s3_.toPointer_, s3_.nativeWrite_);
                                return;
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                        ManagedAOTData s4_ = this.managedAOT_cache;
                        if (s4_ != null) {
                            LLVMPointerOffsetStoreNode.doManagedAOT(targetValue_, offsetValue, valueValue_, s4_.toPointer_, s4_.nativeWrite_);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(targetValue, offsetValue, valueValue_);
            return;
        }

        private void executeAndSpecialize(Object targetValue, Object offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (long) offsetValue;
                if (LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        AddressData s0_ = this.insert(new AddressData());
                        s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                        VarHandle.storeStoreFence();
                        this.address_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] */;
                        this.state_0_ = state_0;
                        doAddress(targetValue_, offsetValue_, valueValue, s0_.toNative_);
                        return;
                    }
                    if ((isAutoDerefHandle(targetValue_))) {
                        OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                        LLVMToPointerNode toPointer__ = s1_.insert((LLVMToPointerNodeGen.create()));
                        Objects.requireNonNull(toPointer__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s1_.toPointer_ = toPointer__;
                        LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                        Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s1_.getReceiver_ = getReceiver__;
                        LLVMManagedWriteLibrary nativeWrite__ = s1_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                        Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s1_.nativeWrite_ = nativeWrite__;
                        VarHandle.storeStoreFence();
                        this.opDerefHandle_cache = s1_;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        LLVMPointerOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue_, valueValue, toPointer__, getReceiver__, nativeWrite__);
                        return;
                    }
                }
                if (targetValue instanceof Long) {
                    long targetValue_ = (long) targetValue;
                    if ((isAutoDerefHandle(targetValue_))) {
                        DerefAddressData s2_ = this.insert(new DerefAddressData());
                        LLVMToPointerNode toPointer__1 = s2_.insert((LLVMToPointerNodeGen.create()));
                        Objects.requireNonNull(toPointer__1, "Specialization 'doDerefAddress(long, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.toPointer_ = toPointer__1;
                        LLVMDerefHandleGetReceiverNode getReceiver__1 = s2_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                        Objects.requireNonNull(getReceiver__1, "Specialization 'doDerefAddress(long, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.getReceiver_ = getReceiver__1;
                        LLVMManagedWriteLibrary nativeWrite__1 = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                        Objects.requireNonNull(nativeWrite__1, "Specialization 'doDerefAddress(long, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.nativeWrite_ = nativeWrite__1;
                        VarHandle.storeStoreFence();
                        this.derefAddress_cache = s2_;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doDerefAddress(long, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
                        this.state_0_ = state_0;
                        LLVMPointerOffsetStoreNode.doDerefAddress(targetValue_, offsetValue_, valueValue, toPointer__1, getReceiver__1, nativeWrite__1);
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */) {
                        while (true) {
                            int count3_ = 0;
                            ManagedData s3_ = MANAGED_CACHE_UPDATER.getVolatile(this);
                            ManagedData s3_original = s3_;
                            while (s3_ != null) {
                                if ((s3_.nativeWrite_.accepts(targetValue_.getObject()))) {
                                    break;
                                }
                                count3_++;
                                s3_ = s3_.next_;
                            }
                            if (s3_ == null) {
                                // assert (s3_.nativeWrite_.accepts(targetValue_.getObject()));
                                if (count3_ < (3)) {
                                    s3_ = this.insert(new ManagedData(s3_original));
                                    LLVMToPointerNode toPointer__2 = s3_.insert((LLVMToPointerNodeGen.create()));
                                    Objects.requireNonNull(toPointer__2, "Specialization 'doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s3_.toPointer_ = toPointer__2;
                                    LLVMManagedWriteLibrary nativeWrite__2 = s3_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(targetValue_.getObject())));
                                    Objects.requireNonNull(nativeWrite__2, "Specialization 'doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s3_.nativeWrite_ = nativeWrite__2;
                                    if (!MANAGED_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s3_ != null) {
                                LLVMPointerOffsetStoreNode.doManaged(targetValue_, offsetValue_, valueValue, s3_.toPointer_, s3_.nativeWrite_);
                                return;
                            }
                            break;
                        }
                    }
                    ManagedAOTData s4_ = this.insert(new ManagedAOTData());
                    LLVMToPointerNode toPointer__3 = s4_.insert((LLVMToPointerNodeGen.create()));
                    Objects.requireNonNull(toPointer__3, "Specialization 'doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s4_.toPointer_ = toPointer__3;
                    LLVMManagedWriteLibrary nativeWrite__3 = s4_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(nativeWrite__3, "Specialization 'doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s4_.nativeWrite_ = nativeWrite__3;
                    VarHandle.storeStoreFence();
                    this.managedAOT_cache = s4_;
                    this.managed_cache = null;
                    state_0 = state_0 & 0xffffffef /* remove SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
                    this.state_0_ = state_0;
                    LLVMPointerOffsetStoreNode.doManagedAOT(targetValue_, offsetValue_, valueValue, toPointer__3, nativeWrite__3);
                    return;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.target_, this.offset_, this.value_}, targetValue, offsetValue, valueValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b111110) & ((state_0 & 0b111110) - 1)) == 0 /* is-single  */) {
                    ManagedData s3_ = this.managed_cache;
                    if ((s3_ == null || s3_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                AddressData s0_ = this.insert(new AddressData());
                s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                VarHandle.storeStoreFence();
                this.address_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doAddress(LLVMNativePointer, long, Object, LLVMToNativeNode)] */;
            }
            {
                OpDerefHandleData s1_ = this.insert(new OpDerefHandleData());
                LLVMToPointerNode toPointer__ = s1_.insert((LLVMToPointerNodeGen.create()));
                Objects.requireNonNull(toPointer__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.toPointer_ = toPointer__;
                LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.getReceiver_ = getReceiver__;
                LLVMManagedWriteLibrary nativeWrite__ = s1_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__, "Specialization 'doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.nativeWrite_ = nativeWrite__;
                VarHandle.storeStoreFence();
                this.opDerefHandle_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.toPointer_, 1);
                ((GenerateAOT.Provider) s1_.toPointer_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                if (s1_.nativeWrite_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(s1_.nativeWrite_, 1);
                    ((GenerateAOT.Provider) s1_.nativeWrite_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doOpDerefHandle(LLVMNativePointer, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
            }
            {
                DerefAddressData s2_ = this.insert(new DerefAddressData());
                LLVMToPointerNode toPointer__1 = s2_.insert((LLVMToPointerNodeGen.create()));
                Objects.requireNonNull(toPointer__1, "Specialization 'doDerefAddress(long, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.toPointer_ = toPointer__1;
                LLVMDerefHandleGetReceiverNode getReceiver__1 = s2_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__1, "Specialization 'doDerefAddress(long, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.getReceiver_ = getReceiver__1;
                LLVMManagedWriteLibrary nativeWrite__1 = s2_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__1, "Specialization 'doDerefAddress(long, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s2_.nativeWrite_ = nativeWrite__1;
                VarHandle.storeStoreFence();
                this.derefAddress_cache = s2_;
                assert NodeUtil.assertRecursion(s2_.toPointer_, 1);
                ((GenerateAOT.Provider) s2_.toPointer_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s2_.getReceiver_, 1);
                ((GenerateAOT.Provider) s2_.getReceiver_).prepareForAOT(language, root);
                if (s2_.nativeWrite_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(s2_.nativeWrite_, 1);
                    ((GenerateAOT.Provider) s2_.nativeWrite_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doDerefAddress(long, long, Object, LLVMToPointerNode, LLVMDerefHandleGetReceiverNode, LLVMManagedWriteLibrary)] */;
            }
            {
                ManagedAOTData s4_ = this.insert(new ManagedAOTData());
                LLVMToPointerNode toPointer__3 = s4_.insert((LLVMToPointerNodeGen.create()));
                Objects.requireNonNull(toPointer__3, "Specialization 'doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'toPointer' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s4_.toPointer_ = toPointer__3;
                LLVMManagedWriteLibrary nativeWrite__3 = s4_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeWrite__3, "Specialization 'doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)' cache 'nativeWrite' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s4_.nativeWrite_ = nativeWrite__3;
                VarHandle.storeStoreFence();
                this.managedAOT_cache = s4_;
                this.managed_cache = null;
                this.state_0_ = state_0_ & 0xffffffef /* remove SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManaged(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
                assert NodeUtil.assertRecursion(s4_.toPointer_, 1);
                ((GenerateAOT.Provider) s4_.toPointer_).prepareForAOT(language, root);
                if (s4_.nativeWrite_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(s4_.nativeWrite_, 1);
                    ((GenerateAOT.Provider) s4_.nativeWrite_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMPointerStoreNode.LLVMPointerOffsetStoreNode.doManagedAOT(LLVMManagedPointer, long, Object, LLVMToPointerNode, LLVMManagedWriteLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.address_cache = null;
            this.opDerefHandle_cache = null;
            this.derefAddress_cache = null;
            this.managedAOT_cache = null;
        }

        @NeverDefault
        public static LLVMPointerOffsetStoreNode create(LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVMPointerOffsetStoreNodeGen(target, offset, value);
        }

        @NeverDefault
        public static LLVMPointerOffsetStoreNode getUncached() {
            return LLVMPointerOffsetStoreNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVMPointerOffsetStoreNode.class)
        @DenyReplace
        private static final class AddressData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doAddress}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;

            AddressData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMPointerOffsetStoreNode.class)
        @DenyReplace
        private static final class OpDerefHandleData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doOpDerefHandle}
             *   Parameter: {@link LLVMToPointerNode} toPointer</pre>
             */
            @Child LLVMToPointerNode toPointer_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doOpDerefHandle}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doOpDerefHandle}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            OpDerefHandleData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMPointerOffsetStoreNode.class)
        @DenyReplace
        private static final class DerefAddressData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doDerefAddress}
             *   Parameter: {@link LLVMToPointerNode} toPointer</pre>
             */
            @Child LLVMToPointerNode toPointer_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doDerefAddress}
             *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
             */
            @Child LLVMDerefHandleGetReceiverNode getReceiver_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doDerefAddress}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            DerefAddressData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMPointerOffsetStoreNode.class)
        @DenyReplace
        private static final class ManagedData extends Node implements SpecializationDataNode {

            @Child ManagedData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doManaged}
             *   Parameter: {@link LLVMToPointerNode} toPointer</pre>
             */
            @Child LLVMToPointerNode toPointer_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doManaged}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            ManagedData(ManagedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMPointerOffsetStoreNode.class)
        @DenyReplace
        private static final class ManagedAOTData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doManagedAOT}
             *   Parameter: {@link LLVMToPointerNode} toPointer</pre>
             */
            @Child LLVMToPointerNode toPointer_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMPointerOffsetStoreNode#doManagedAOT}
             *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
             */
            @Child LLVMManagedWriteLibrary nativeWrite_;

            ManagedAOTData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(LLVMPointerOffsetStoreNode.class)
        @DenyReplace
        private static final class Uncached extends LLVMPointerOffsetStoreNode {

            @TruffleBoundary
            @Override
            public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
                if (LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        doAddress(targetValue_, offsetValue, valueValue, (LLVMToNativeNodeGen.getUncached()));
                        return;
                    }
                    if ((isAutoDerefHandle(targetValue_))) {
                        LLVMPointerOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, (LLVMToPointerNodeGen.getUncached()), (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    LLVMPointerOffsetStoreNode.doManagedAOT(targetValue_, offsetValue, valueValue, (LLVMToPointerNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, targetValue, offsetValue, valueValue);
            }

            @TruffleBoundary
            @Override
            public void executeWithTarget(LLVMPointer targetValue, long offsetValue, Object valueValue) {
                if (LLVMTypes.isNativePointer(targetValue)) {
                    LLVMNativePointer targetValue_ = LLVMTypes.asNativePointer(targetValue);
                    if ((!(isAutoDerefHandle(targetValue_)))) {
                        doAddress(targetValue_, offsetValue, valueValue, (LLVMToNativeNodeGen.getUncached()));
                        return;
                    }
                    if ((isAutoDerefHandle(targetValue_))) {
                        LLVMPointerOffsetStoreNode.doOpDerefHandle(targetValue_, offsetValue, valueValue, (LLVMToPointerNodeGen.getUncached()), (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(targetValue)) {
                    LLVMManagedPointer targetValue_ = LLVMTypes.asManagedPointer(targetValue);
                    LLVMPointerOffsetStoreNode.doManagedAOT(targetValue_, offsetValue, valueValue, (LLVMToPointerNodeGen.getUncached()), (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, targetValue, offsetValue, valueValue);
            }

            @Override
            public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
                throw CompilerDirectives.shouldNotReachHere("This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
