// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMVectorSelectNode#doOp}
 *     Activation probability: 1.00000
 *     With/without class size: 20/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMVectorSelectNode.class)
@SuppressWarnings("javadoc")
public final class LLVMVectorSelectNodeGen extends LLVMVectorSelectNode implements GenerateAOT.Provider {

    private final int vectorLength;
    @Child private LLVMExpressionNode conditionNode_;
    @Child private LLVMExpressionNode trueNode_;
    @Child private LLVMExpressionNode elseNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMVectorSelectNode#doOp}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMVectorSelectNode#doOp}
     *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
     */
    @CompilationFinal private CountingConditionProfile conditionProfile_;

    private LLVMVectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
        this.vectorLength = vectorLength;
        this.conditionNode_ = conditionNode;
        this.trueNode_ = trueNode;
        this.elseNode_ = elseNode;
    }

    @Override
    protected int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        boolean conditionNodeValue_;
        try {
            conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
        }
        Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
        Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */) {
            {
                CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                if (conditionProfile__ != null) {
                    return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
    }

    private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (conditionNodeValue instanceof Boolean) {
            boolean conditionNodeValue_ = (boolean) conditionNodeValue;
            CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
            Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.conditionProfile_ = conditionProfile__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            this.state_0_ = state_0;
            return doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.conditionNode_, this.trueNode_, this.elseNode_}, conditionNodeValue, trueNodeValue, elseNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
            Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.conditionProfile_ = conditionProfile__;
            this.conditionProfile_.disable();
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.conditionProfile_.reset();
    }

    @NeverDefault
    public static LLVMVectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
        return new LLVMVectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMVectorSelectNode#doOp}
     *     Activation probability: 0.65000
     *     With/without class size: 14/4 bytes
     *   Specialization {@link LLVMI1VectorSelectNode#doOp}
     *     Activation probability: 0.35000
     *     With/without class size: 9/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI1VectorSelectNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI1VectorSelectNodeGen extends LLVMI1VectorSelectNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode conditionNode_;
        @Child private LLVMExpressionNode trueNode_;
        @Child private LLVMExpressionNode elseNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMVectorSelectNode#doOp}
         *   2: SpecializationActive {@link LLVMI1VectorSelectNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMVectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op0_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI1VectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op1_conditionProfile_;

        private LLVMI1VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMI1VectorSelectNode.doOp(LLVMI1Vector, LLVMI1Vector, LLVMI1Vector, CountingConditionProfile)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean conditionNodeValue_;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            {
                CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                if (conditionProfile__ != null) {
                    return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI1VectorSelectNode.doOp(LLVMI1Vector, LLVMI1Vector, LLVMI1Vector, CountingConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (boolean) conditionNodeValue_;
                    {
                        CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                        if (conditionProfile__ != null) {
                            return doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI1VectorSelectNode.doOp(LLVMI1Vector, LLVMI1Vector, LLVMI1Vector, CountingConditionProfile)] */ && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector) conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMI1Vector) {
                        LLVMI1Vector trueNodeValue__ = (LLVMI1Vector) trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMI1Vector) {
                            LLVMI1Vector elseNodeValue__ = (LLVMI1Vector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                                if (conditionProfile__1 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (boolean) conditionNodeValue;
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
                this.state_0_ = state_0;
                return doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector) conditionNodeValue;
                if (trueNodeValue instanceof LLVMI1Vector) {
                    LLVMI1Vector trueNodeValue_ = (LLVMI1Vector) trueNodeValue;
                    if (elseNodeValue instanceof LLVMI1Vector) {
                        LLVMI1Vector elseNodeValue_ = (LLVMI1Vector) elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI1Vector, LLVMI1Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI1VectorSelectNode.doOp(LLVMI1Vector, LLVMI1Vector, LLVMI1Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.conditionNode_, this.trueNode_, this.elseNode_}, conditionNodeValue, trueNodeValue, elseNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.op0_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI1Vector, LLVMI1Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op1_conditionProfile_ = conditionProfile__1;
                this.op1_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI1VectorSelectNode.doOp(LLVMI1Vector, LLVMI1Vector, LLVMI1Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMI1VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI1VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMVectorSelectNode#doOp}
     *     Activation probability: 0.65000
     *     With/without class size: 14/4 bytes
     *   Specialization {@link LLVMI8VectorSelectNode#doOp}
     *     Activation probability: 0.35000
     *     With/without class size: 9/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI8VectorSelectNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI8VectorSelectNodeGen extends LLVMI8VectorSelectNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode conditionNode_;
        @Child private LLVMExpressionNode trueNode_;
        @Child private LLVMExpressionNode elseNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMVectorSelectNode#doOp}
         *   2: SpecializationActive {@link LLVMI8VectorSelectNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMVectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op0_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI8VectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op1_conditionProfile_;

        private LLVMI8VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMI8VectorSelectNode.doOp(LLVMI1Vector, LLVMI8Vector, LLVMI8Vector, CountingConditionProfile)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean conditionNodeValue_;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            {
                CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                if (conditionProfile__ != null) {
                    return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI8VectorSelectNode.doOp(LLVMI1Vector, LLVMI8Vector, LLVMI8Vector, CountingConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (boolean) conditionNodeValue_;
                    {
                        CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                        if (conditionProfile__ != null) {
                            return doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI8VectorSelectNode.doOp(LLVMI1Vector, LLVMI8Vector, LLVMI8Vector, CountingConditionProfile)] */ && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector) conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMI8Vector) {
                        LLVMI8Vector trueNodeValue__ = (LLVMI8Vector) trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMI8Vector) {
                            LLVMI8Vector elseNodeValue__ = (LLVMI8Vector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                                if (conditionProfile__1 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (boolean) conditionNodeValue;
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
                this.state_0_ = state_0;
                return doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector) conditionNodeValue;
                if (trueNodeValue instanceof LLVMI8Vector) {
                    LLVMI8Vector trueNodeValue_ = (LLVMI8Vector) trueNodeValue;
                    if (elseNodeValue instanceof LLVMI8Vector) {
                        LLVMI8Vector elseNodeValue_ = (LLVMI8Vector) elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI8Vector, LLVMI8Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI8VectorSelectNode.doOp(LLVMI1Vector, LLVMI8Vector, LLVMI8Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.conditionNode_, this.trueNode_, this.elseNode_}, conditionNodeValue, trueNodeValue, elseNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.op0_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI8Vector, LLVMI8Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op1_conditionProfile_ = conditionProfile__1;
                this.op1_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI8VectorSelectNode.doOp(LLVMI1Vector, LLVMI8Vector, LLVMI8Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMI8VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI8VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMVectorSelectNode#doOp}
     *     Activation probability: 0.65000
     *     With/without class size: 14/4 bytes
     *   Specialization {@link LLVMI16VectorSelectNode#doOp}
     *     Activation probability: 0.35000
     *     With/without class size: 9/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI16VectorSelectNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI16VectorSelectNodeGen extends LLVMI16VectorSelectNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode conditionNode_;
        @Child private LLVMExpressionNode trueNode_;
        @Child private LLVMExpressionNode elseNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMVectorSelectNode#doOp}
         *   2: SpecializationActive {@link LLVMI16VectorSelectNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMVectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op0_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI16VectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op1_conditionProfile_;

        private LLVMI16VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMI16VectorSelectNode.doOp(LLVMI1Vector, LLVMI16Vector, LLVMI16Vector, CountingConditionProfile)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean conditionNodeValue_;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            {
                CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                if (conditionProfile__ != null) {
                    return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI16VectorSelectNode.doOp(LLVMI1Vector, LLVMI16Vector, LLVMI16Vector, CountingConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (boolean) conditionNodeValue_;
                    {
                        CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                        if (conditionProfile__ != null) {
                            return doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI16VectorSelectNode.doOp(LLVMI1Vector, LLVMI16Vector, LLVMI16Vector, CountingConditionProfile)] */ && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector) conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMI16Vector) {
                        LLVMI16Vector trueNodeValue__ = (LLVMI16Vector) trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMI16Vector) {
                            LLVMI16Vector elseNodeValue__ = (LLVMI16Vector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                                if (conditionProfile__1 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (boolean) conditionNodeValue;
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
                this.state_0_ = state_0;
                return doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector) conditionNodeValue;
                if (trueNodeValue instanceof LLVMI16Vector) {
                    LLVMI16Vector trueNodeValue_ = (LLVMI16Vector) trueNodeValue;
                    if (elseNodeValue instanceof LLVMI16Vector) {
                        LLVMI16Vector elseNodeValue_ = (LLVMI16Vector) elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI16Vector, LLVMI16Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI16VectorSelectNode.doOp(LLVMI1Vector, LLVMI16Vector, LLVMI16Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.conditionNode_, this.trueNode_, this.elseNode_}, conditionNodeValue, trueNodeValue, elseNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.op0_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI16Vector, LLVMI16Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op1_conditionProfile_ = conditionProfile__1;
                this.op1_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI16VectorSelectNode.doOp(LLVMI1Vector, LLVMI16Vector, LLVMI16Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMI16VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI16VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMVectorSelectNode#doOp}
     *     Activation probability: 0.65000
     *     With/without class size: 14/4 bytes
     *   Specialization {@link LLVMI32VectorSelectNode#doOp}
     *     Activation probability: 0.35000
     *     With/without class size: 9/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI32VectorSelectNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI32VectorSelectNodeGen extends LLVMI32VectorSelectNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode conditionNode_;
        @Child private LLVMExpressionNode trueNode_;
        @Child private LLVMExpressionNode elseNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMVectorSelectNode#doOp}
         *   2: SpecializationActive {@link LLVMI32VectorSelectNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMVectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op0_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI32VectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op1_conditionProfile_;

        private LLVMI32VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMI32VectorSelectNode.doOp(LLVMI1Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean conditionNodeValue_;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            {
                CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                if (conditionProfile__ != null) {
                    return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI32VectorSelectNode.doOp(LLVMI1Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (boolean) conditionNodeValue_;
                    {
                        CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                        if (conditionProfile__ != null) {
                            return doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI32VectorSelectNode.doOp(LLVMI1Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)] */ && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector) conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector trueNodeValue__ = (LLVMI32Vector) trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMI32Vector) {
                            LLVMI32Vector elseNodeValue__ = (LLVMI32Vector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                                if (conditionProfile__1 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (boolean) conditionNodeValue;
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
                this.state_0_ = state_0;
                return doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector) conditionNodeValue;
                if (trueNodeValue instanceof LLVMI32Vector) {
                    LLVMI32Vector trueNodeValue_ = (LLVMI32Vector) trueNodeValue;
                    if (elseNodeValue instanceof LLVMI32Vector) {
                        LLVMI32Vector elseNodeValue_ = (LLVMI32Vector) elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI32VectorSelectNode.doOp(LLVMI1Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.conditionNode_, this.trueNode_, this.elseNode_}, conditionNodeValue, trueNodeValue, elseNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.op0_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op1_conditionProfile_ = conditionProfile__1;
                this.op1_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI32VectorSelectNode.doOp(LLVMI1Vector, LLVMI32Vector, LLVMI32Vector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMI32VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI32VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMVectorSelectNode#doOp}
     *     Activation probability: 0.32000
     *     With/without class size: 9/4 bytes
     *   Specialization {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)}
     *     Activation probability: 0.26000
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)}
     *     Activation probability: 0.20000
     *     With/without class size: 7/4 bytes
     *   Specialization {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)}
     *     Activation probability: 0.14000
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)}
     *     Activation probability: 0.08000
     *     With/without class size: 5/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI64VectorSelectNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI64VectorSelectNodeGen extends LLVMI64VectorSelectNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode conditionNode_;
        @Child private LLVMExpressionNode trueNode_;
        @Child private LLVMExpressionNode elseNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMVectorSelectNode#doOp}
         *   2: SpecializationActive {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)}
         *   3: SpecializationActive {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)}
         *   4: SpecializationActive {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)}
         *   5: SpecializationActive {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMVectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op0_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op1_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op2_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op3_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI64VectorSelectNode#doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op4_conditionProfile_;

        private LLVMI64VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111100) == 0 /* only-active SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean conditionNodeValue_;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            {
                CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                if (conditionProfile__ != null) {
                    return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (boolean) conditionNodeValue_;
                    {
                        CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                        if (conditionProfile__ != null) {
                            return doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                        }
                    }
                }
                if ((state_0 & 0b111100) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)] */ && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector) conditionNodeValue_;
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)] */ && trueNodeValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector trueNodeValue__ = (LLVMI64Vector) trueNodeValue_;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)] */ && elseNodeValue_ instanceof LLVMI64Vector) {
                            LLVMI64Vector elseNodeValue__ = (LLVMI64Vector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                                if (conditionProfile__1 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)] */ && elseNodeValue_ instanceof LLVMPointerVector) {
                            LLVMPointerVector elseNodeValue__ = (LLVMPointerVector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__2 = this.op2_conditionProfile_;
                                if (conditionProfile__2 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__2);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b110000) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)] */ && trueNodeValue_ instanceof LLVMPointerVector) {
                        LLVMPointerVector trueNodeValue__ = (LLVMPointerVector) trueNodeValue_;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)] */ && elseNodeValue_ instanceof LLVMI64Vector) {
                            LLVMI64Vector elseNodeValue__ = (LLVMI64Vector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__3 = this.op3_conditionProfile_;
                                if (conditionProfile__3 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__3);
                                }
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)] */ && elseNodeValue_ instanceof LLVMPointerVector) {
                            LLVMPointerVector elseNodeValue__ = (LLVMPointerVector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__4 = this.op4_conditionProfile_;
                                if (conditionProfile__4 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__4);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (boolean) conditionNodeValue;
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
                this.state_0_ = state_0;
                return doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector) conditionNodeValue;
                if (trueNodeValue instanceof LLVMI64Vector) {
                    LLVMI64Vector trueNodeValue_ = (LLVMI64Vector) trueNodeValue;
                    if (elseNodeValue instanceof LLVMI64Vector) {
                        LLVMI64Vector elseNodeValue_ = (LLVMI64Vector) elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                    if (elseNodeValue instanceof LLVMPointerVector) {
                        LLVMPointerVector elseNodeValue_ = (LLVMPointerVector) elseNodeValue;
                        CountingConditionProfile conditionProfile__2 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__2, "Specialization 'doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op2_conditionProfile_ = conditionProfile__2;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__2);
                    }
                }
                if (trueNodeValue instanceof LLVMPointerVector) {
                    LLVMPointerVector trueNodeValue_ = (LLVMPointerVector) trueNodeValue;
                    if (elseNodeValue instanceof LLVMI64Vector) {
                        LLVMI64Vector elseNodeValue_ = (LLVMI64Vector) elseNodeValue;
                        CountingConditionProfile conditionProfile__3 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__3, "Specialization 'doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op3_conditionProfile_ = conditionProfile__3;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__3);
                    }
                    if (elseNodeValue instanceof LLVMPointerVector) {
                        LLVMPointerVector elseNodeValue_ = (LLVMPointerVector) elseNodeValue;
                        CountingConditionProfile conditionProfile__4 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__4, "Specialization 'doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op4_conditionProfile_ = conditionProfile__4;
                        state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__4);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.conditionNode_, this.trueNode_, this.elseNode_}, conditionNodeValue, trueNodeValue, elseNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b111110) & ((state_0 & 0b111110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.op0_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op1_conditionProfile_ = conditionProfile__1;
                this.op1_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMI64Vector, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__2 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__2, "Specialization 'doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op2_conditionProfile_ = conditionProfile__2;
                this.op2_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMI64Vector, LLVMPointerVector, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__3 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__3, "Specialization 'doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op3_conditionProfile_ = conditionProfile__3;
                this.op3_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMI64Vector, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__4 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__4, "Specialization 'doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op4_conditionProfile_ = conditionProfile__4;
                this.op4_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMVectorSelectNode.LLVMI64VectorSelectNode.doOp(LLVMI1Vector, LLVMPointerVector, LLVMPointerVector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
            this.op2_conditionProfile_.reset();
            this.op3_conditionProfile_.reset();
            this.op4_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMI64VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI64VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMVectorSelectNode#doOp}
     *     Activation probability: 0.65000
     *     With/without class size: 14/4 bytes
     *   Specialization {@link LLVMFloatVectorSelectNode#doOp}
     *     Activation probability: 0.35000
     *     With/without class size: 9/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMFloatVectorSelectNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMFloatVectorSelectNodeGen extends LLVMFloatVectorSelectNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode conditionNode_;
        @Child private LLVMExpressionNode trueNode_;
        @Child private LLVMExpressionNode elseNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMVectorSelectNode#doOp}
         *   2: SpecializationActive {@link LLVMFloatVectorSelectNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMVectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op0_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMFloatVectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op1_conditionProfile_;

        private LLVMFloatVectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMFloatVectorSelectNode.doOp(LLVMI1Vector, LLVMFloatVector, LLVMFloatVector, CountingConditionProfile)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean conditionNodeValue_;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            {
                CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                if (conditionProfile__ != null) {
                    return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMFloatVectorSelectNode.doOp(LLVMI1Vector, LLVMFloatVector, LLVMFloatVector, CountingConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (boolean) conditionNodeValue_;
                    {
                        CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                        if (conditionProfile__ != null) {
                            return doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMFloatVectorSelectNode.doOp(LLVMI1Vector, LLVMFloatVector, LLVMFloatVector, CountingConditionProfile)] */ && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector) conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMFloatVector) {
                        LLVMFloatVector trueNodeValue__ = (LLVMFloatVector) trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMFloatVector) {
                            LLVMFloatVector elseNodeValue__ = (LLVMFloatVector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                                if (conditionProfile__1 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (boolean) conditionNodeValue;
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
                this.state_0_ = state_0;
                return doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector) conditionNodeValue;
                if (trueNodeValue instanceof LLVMFloatVector) {
                    LLVMFloatVector trueNodeValue_ = (LLVMFloatVector) trueNodeValue;
                    if (elseNodeValue instanceof LLVMFloatVector) {
                        LLVMFloatVector elseNodeValue_ = (LLVMFloatVector) elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMFloatVector, LLVMFloatVector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMFloatVectorSelectNode.doOp(LLVMI1Vector, LLVMFloatVector, LLVMFloatVector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.conditionNode_, this.trueNode_, this.elseNode_}, conditionNodeValue, trueNodeValue, elseNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.op0_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMFloatVector, LLVMFloatVector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op1_conditionProfile_ = conditionProfile__1;
                this.op1_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMFloatVectorSelectNode.doOp(LLVMI1Vector, LLVMFloatVector, LLVMFloatVector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMFloatVectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMFloatVectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMVectorSelectNode#doOp}
     *     Activation probability: 0.65000
     *     With/without class size: 14/4 bytes
     *   Specialization {@link LLVMDoubleVectorSelectNode#doOp}
     *     Activation probability: 0.35000
     *     With/without class size: 9/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMDoubleVectorSelectNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMDoubleVectorSelectNodeGen extends LLVMDoubleVectorSelectNode implements GenerateAOT.Provider {

        private final int vectorLength;
        @Child private LLVMExpressionNode conditionNode_;
        @Child private LLVMExpressionNode trueNode_;
        @Child private LLVMExpressionNode elseNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMVectorSelectNode#doOp}
         *   2: SpecializationActive {@link LLVMDoubleVectorSelectNode#doOp}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMVectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op0_conditionProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMDoubleVectorSelectNode#doOp}
         *   Parameter: {@link CountingConditionProfile} conditionProfile</pre>
         */
        @CompilationFinal private CountingConditionProfile op1_conditionProfile_;

        private LLVMDoubleVectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] && SpecializationActive[LLVMVectorSelectNode.LLVMDoubleVectorSelectNode.doOp(LLVMI1Vector, LLVMDoubleVector, LLVMDoubleVector, CountingConditionProfile)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else {
                return executeGeneric_generic1(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean conditionNodeValue_;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            {
                CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                if (conditionProfile__ != null) {
                    return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] || SpecializationActive[LLVMVectorSelectNode.LLVMDoubleVectorSelectNode.doOp(LLVMI1Vector, LLVMDoubleVector, LLVMDoubleVector, CountingConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */ && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (boolean) conditionNodeValue_;
                    {
                        CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                        if (conditionProfile__ != null) {
                            return doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMVectorSelectNode.LLVMDoubleVectorSelectNode.doOp(LLVMI1Vector, LLVMDoubleVector, LLVMDoubleVector, CountingConditionProfile)] */ && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector) conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMDoubleVector) {
                        LLVMDoubleVector trueNodeValue__ = (LLVMDoubleVector) trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMDoubleVector) {
                            LLVMDoubleVector elseNodeValue__ = (LLVMDoubleVector) elseNodeValue_;
                            {
                                CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                                if (conditionProfile__1 != null) {
                                    return doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (boolean) conditionNodeValue;
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
                this.state_0_ = state_0;
                return doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector) conditionNodeValue;
                if (trueNodeValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector trueNodeValue_ = (LLVMDoubleVector) trueNodeValue;
                    if (elseNodeValue instanceof LLVMDoubleVector) {
                        LLVMDoubleVector elseNodeValue_ = (LLVMDoubleVector) elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                        Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMDoubleVector, LLVMDoubleVector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMDoubleVectorSelectNode.doOp(LLVMI1Vector, LLVMDoubleVector, LLVMDoubleVector, CountingConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.conditionNode_, this.trueNode_, this.elseNode_}, conditionNodeValue, trueNodeValue, elseNodeValue);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b110) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                CountingConditionProfile conditionProfile__ = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__, "Specialization 'doOp(boolean, Object, Object, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.op0_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMVectorSelectNode.doOp(boolean, Object, Object, CountingConditionProfile)] */;
            }
            {
                CountingConditionProfile conditionProfile__1 = (CountingConditionProfile.create());
                Objects.requireNonNull(conditionProfile__1, "Specialization 'doOp(LLVMI1Vector, LLVMDoubleVector, LLVMDoubleVector, CountingConditionProfile)' cache 'conditionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.op1_conditionProfile_ = conditionProfile__1;
                this.op1_conditionProfile_.disable();
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMVectorSelectNode.LLVMDoubleVectorSelectNode.doOp(LLVMI1Vector, LLVMDoubleVector, LLVMDoubleVector, CountingConditionProfile)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMDoubleVectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMDoubleVectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }

    }
}
